import Session from '../store/session.js';
import store from '../npm/hybrids/src/store.js';

{
  const GHOSTERY_SEARCH_EXTENSION_IDS = [
    "nomidcdbhopffbhbpfnnlgnfimhgdman",
    // Chrome
    "search@ghostery.com"
    // Firefox
  ];
  chrome.runtime.onMessageExternal.addListener(
    (message, sender, sendResponse) => {
      if (GHOSTERY_SEARCH_EXTENSION_IDS.includes(sender.id)) {
        switch (message) {
          case "refreshToken":
            store.resolve(Session).then(({ user }) => sendResponse({ success: !!user }));
            return true;
          default:
            console.error(
              `[external] Unknown message type from "${sender.id}"`,
              message
            );
        }
      }
      return false;
    }
  );
}
