import { isUndefined } from './type-guards.js';

/*
 * AGTree v3.2.2 (build date: Tue, 08 Jul 2025 13:39:47 GMT)
 * (c) 2025 Adguard Software Ltd.
 * Released under the MIT license
 * https://github.com/AdguardTeam/tsurlfilter/tree/master/packages/agtree#readme
 */

/**
 * A very simple map extension that allows to store multiple values for the same key
 * by storing them in an array.
 *
 * @todo Add more methods if needed
 */
class MultiValueMap extends Map {
    /**
     * Adds a value to the map. If the key already exists, the value will be appended to the existing array,
     * otherwise a new array will be created for the key.
     *
     * @param key Key to add
     * @param values Value(s) to add
     */
    add(key, ...values) {
        let currentValues = super.get(key);
        if (isUndefined(currentValues)) {
            currentValues = [];
            super.set(key, values);
        }
        currentValues.push(...values);
    }
}

export { MultiValueMap };
