// lib/eval-snippets.ts
var snippets = {
  // code-based rules
  EVAL_0: () => console.log(1),
  EVAL_CONSENTMANAGER_1: () => window.__cmp && typeof __cmp("getCMPData") === "object",
  EVAL_CONSENTMANAGER_2: () => !__cmp("consentStatus").userChoiceExists,
  EVAL_CONSENTMANAGER_3: () => __cmp("setConsent", 0),
  EVAL_CONSENTMANAGER_4: () => __cmp("setConsent", 1),
  EVAL_CONSENTMANAGER_5: () => __cmp("consentStatus").userChoiceExists,
  EVAL_COOKIEBOT_1: () => !!window.Cookiebot,
  EVAL_COOKIEBOT_2: () => !window.Cookiebot.hasResponse && window.Cookiebot.dialog?.visible === true,
  EVAL_COOKIEBOT_3: () => window.Cookiebot.withdraw() || true,
  EVAL_COOKIEBOT_4: () => window.Cookiebot.hide() || true,
  EVAL_COOKIEBOT_5: () => window.Cookiebot.declined === true,
  EVAL_KLARO_1: () => {
    const config = globalThis.klaroConfig || globalThis.klaro?.getManager && globalThis.klaro.getManager().config;
    if (!config) {
      return true;
    }
    const optionalServices = (config.services || config.apps).filter((s) => !s.required).map((s) => s.name);
    if (klaro && klaro.getManager) {
      const manager = klaro.getManager();
      return optionalServices.every((name) => !manager.consents[name]);
    } else if (klaroConfig && klaroConfig.storageMethod === "cookie") {
      const cookieName = klaroConfig.cookieName || klaroConfig.storageName;
      const consents = JSON.parse(
        decodeURIComponent(
          document.cookie.split(";").find((c) => c.trim().startsWith(cookieName)).split("=")[1]
        )
      );
      return Object.keys(consents).filter((k) => optionalServices.includes(k)).every((k) => consents[k] === false);
    }
  },
  EVAL_KLARO_OPEN_POPUP: () => {
    klaro.show(void 0, true);
  },
  EVAL_KLARO_TRY_API_OPT_OUT: () => {
    if (window.klaro && typeof klaro.show === "function" && typeof klaro.getManager === "function") {
      try {
        klaro.getManager().changeAll(false);
        klaro.getManager().saveAndApplyConsents();
        return true;
      } catch (e) {
        console.warn(e);
        return false;
      }
    }
    return false;
  },
  EVAL_ONETRUST_1: () => window.OnetrustActiveGroups.split(",").filter((s) => s.length > 0).length <= 1,
  EVAL_TRUSTARC_TOP: () => window && window.truste && window.truste.eu.bindMap.prefCookie === "0",
  EVAL_TRUSTARC_FRAME_TEST: () => window && window.QueryString && window.QueryString.preferences === "0",
  EVAL_TRUSTARC_FRAME_GTM: () => window && window.QueryString && window.QueryString.gtm === "1",
  // declarative rules
  EVAL_ADOPT_TEST: () => !!localStorage.getItem("adoptConsentMode"),
  EVAL_ADULTFRIENDFINDER_TEST: () => !!localStorage.getItem("cookieConsent"),
  EVAL_BAHN_TEST: () => utag.gdpr.getSelectedCategories().length === 1,
  EVAL_BIGCOMMERCE_CONSENT_MANAGER_DETECT: () => !!(window.consentManager && window.consentManager.version),
  EVAL_BORLABS_0: () => !JSON.parse(
    decodeURIComponent(
      document.cookie.split(";").find((c) => c.indexOf("borlabs-cookie") !== -1).split("=", 2)[1]
    )
  ).consents.statistics,
  EVAL_CC_BANNER2_0: () => !!document.cookie.match(/sncc=[^;]+D%3Dtrue/),
  EVAL_COINBASE_0: () => JSON.parse(decodeURIComponent(document.cookie.match(/cm_(eu|default)_preferences=([0-9a-zA-Z\\{\\}\\[\\]%:]*);?/)[2])).consent.length <= 1,
  EVAL_COOKIE_LAW_INFO_0: () => {
    if (CLI.disableAllCookies) CLI.disableAllCookies();
    if (CLI.reject_close) CLI.reject_close();
    document.body.classList.remove("cli-barmodal-open");
    return true;
  },
  EVAL_COOKIE_LAW_INFO_DETECT: () => !!window.CLI,
  EVAL_COOKIE_MANAGER_POPUP_0: () => JSON.parse(
    document.cookie.split(";").find((c) => c.trim().startsWith("CookieLevel")).split("=")[1]
  ).social === false,
  EVAL_COOKIEALERT_0: () => document.querySelector("body").removeAttribute("style") || true,
  EVAL_COOKIEALERT_1: () => document.querySelector("body").removeAttribute("style") || true,
  EVAL_COOKIEALERT_2: () => window.CookieConsent.declined === true,
  EVAL_COOKIEFIRST_0: () => ((o) => o.performance === false && o.functional === false && o.advertising === false)(
    JSON.parse(
      decodeURIComponent(
        document.cookie.split(";").find((c) => c.indexOf("cookiefirst") !== -1).trim()
      ).split("=")[1]
    )
  ),
  EVAL_COOKIEFIRST_1: () => document.querySelectorAll("button[data-cookiefirst-accent-color=true][role=checkbox]:not([disabled])").forEach((i) => i.getAttribute("aria-checked") === "true" && i.click()) || true,
  EVAL_COOKIEINFORMATION_0: () => CookieInformation.declineAllCategories() || true,
  EVAL_COOKIEINFORMATION_1: () => CookieInformation.submitAllCategories() || true,
  EVAL_ETSY_0: () => document.querySelectorAll(".gdpr-overlay-body input").forEach((toggle) => {
    toggle.checked = false;
  }) || true,
  EVAL_ETSY_1: () => document.querySelector(".gdpr-overlay-view button[data-wt-overlay-close]").click() || true,
  EVAL_EZOIC_0: () => ezCMP.handleAcceptAllClick(),
  EVAL_FIDES_DETECT_POPUP: () => window.Fides?.initialized,
  EVAL_GDPR_LEGAL_COOKIE_DETECT_CMP: () => !!window.GDPR_LC,
  EVAL_GDPR_LEGAL_COOKIE_TEST: () => !!window.GDPR_LC?.userConsentSetting,
  EVAL_IUBENDA_0: () => document.querySelectorAll(".purposes-item input[type=checkbox]:not([disabled])").forEach((x) => {
    if (x.checked) x.click();
  }) || true,
  EVAL_IUBENDA_1: () => !!document.cookie.match(/_iub_cs-\d+=/),
  EVAL_MEDIAVINE_0: () => document.querySelectorAll('[data-name="mediavine-gdpr-cmp"] input[type=checkbox]').forEach((x) => x.checked && x.click()) || true,
  EVAL_MICROSOFT_0: () => Array.from(document.querySelectorAll("div > button")).filter((el) => el.innerText.match("Reject|Ablehnen"))[0].click() || true,
  EVAL_MICROSOFT_1: () => Array.from(document.querySelectorAll("div > button")).filter((el) => el.innerText.match("Accept|Annehmen"))[0].click() || true,
  EVAL_MICROSOFT_2: () => !!document.cookie.match("MSCC|GHCC"),
  EVAL_MOOVE_0: () => document.querySelectorAll("#moove_gdpr_cookie_modal input").forEach((i) => {
    if (!i.disabled) i.checked = i.name === "moove_gdpr_strict_cookies" || i.id === "moove_gdpr_strict_cookies";
  }) || true,
  EVAL_NHNIEUWS_TEST: () => !!localStorage.getItem("psh:cookies-seen"),
  EVAL_OSANO_DETECT: () => !!window.Osano?.cm?.dialogOpen,
  EVAL_PANDECTES_TEST: () => document.cookie.includes("_pandectes_gdpr=") && JSON.parse(
    atob(
      document.cookie.split(";").find((s) => s.trim().startsWith("_pandectes_gdpr")).split("=")[1]
    )
  ).status === "deny",
  EVAL_POVR_GOBACK: () => window.history.back() || true,
  EVAL_PUBTECH_0: () => document.cookie.includes("euconsent-v2") && (document.cookie.match(/.YAAAAAAAAAAA/) || document.cookie.match(/.aAAAAAAAAAAA/) || document.cookie.match(/.YAAACFgAAAAA/)),
  EVAL_REMARKABLE_TEST: () => !!localStorage.getItem("rmCookieConsent"),
  EVAL_SHOPIFY_TEST: () => document.cookie.includes("gdpr_cookie_consent=0") || document.cookie.includes("_tracking_consent=") && JSON.parse(
    decodeURIComponent(
      document.cookie.split(";").find((s) => s.trim().startsWith("_tracking_consent")).split("=")[1]
    )
  ).purposes.a === false,
  EVAL_SKYSCANNER_TEST: () => document.cookie.match(/gdpr=[^;]*adverts:::false/) && !document.cookie.match(/gdpr=[^;]*init:::true/),
  EVAL_SIRDATA_UNBLOCK_SCROLL: () => {
    document.documentElement.classList.forEach((cls) => {
      if (cls.startsWith("sd-cmp-")) document.documentElement.classList.remove(cls);
    });
    return true;
  },
  EVAL_STEAMPOWERED_0: () => JSON.parse(
    decodeURIComponent(
      document.cookie.split(";").find((s) => s.trim().startsWith("cookieSettings")).split("=")[1]
    )
  ).preference_state === 2,
  EVAL_TAKEALOT_0: () => document.body.classList.remove("freeze") || (document.body.style = "") || true,
  EVAL_TARTEAUCITRON_0: () => tarteaucitron.userInterface.respondAll(false) || true,
  EVAL_TARTEAUCITRON_1: () => tarteaucitron.userInterface.respondAll(true) || true,
  EVAL_TARTEAUCITRON_2: () => document.cookie.match(/tarteaucitron=[^;]*/)?.[0].includes("false"),
  EVAL_TEALIUM_0: () => typeof window.utag !== "undefined" && typeof utag.gdpr === "object",
  EVAL_TEALIUM_1: () => utag.gdpr.setConsentValue(false) || true,
  EVAL_TEALIUM_DONOTSELL: () => utag.gdpr.dns?.setDnsState(false) || true,
  EVAL_TEALIUM_2: () => utag.gdpr.setConsentValue(true) || true,
  EVAL_TEALIUM_3: () => utag.gdpr.getConsentState() !== 1,
  EVAL_TEALIUM_DONOTSELL_CHECK: () => utag.gdpr.dns?.getDnsState() !== 1,
  EVAL_TESTCMP_STEP: () => !!document.querySelector("#reject-all"),
  EVAL_TESTCMP_0: () => window.results.results[0] === "button_clicked",
  EVAL_TESTCMP_COSMETIC_0: () => window.results.results[0] === "banner_hidden",
  EVAL_THEFREEDICTIONARY_0: () => cmpUi.showPurposes() || cmpUi.rejectAll() || true,
  EVAL_THEFREEDICTIONARY_1: () => cmpUi.allowAll() || true,
  EVAL_USERCENTRICS_API_0: () => typeof UC_UI === "object",
  EVAL_USERCENTRICS_API_1: () => !!UC_UI.closeCMP(),
  EVAL_USERCENTRICS_API_2: () => !!UC_UI.denyAllConsents(),
  EVAL_USERCENTRICS_API_3: () => !!UC_UI.acceptAllConsents(),
  EVAL_USERCENTRICS_API_4: () => !!UC_UI.closeCMP(),
  EVAL_USERCENTRICS_API_5: () => UC_UI.areAllConsentsAccepted() === true,
  EVAL_USERCENTRICS_API_6: () => UC_UI.areAllConsentsAccepted() === false,
  EVAL_USERCENTRICS_BUTTON_0: () => JSON.parse(localStorage.getItem("usercentrics")).consents.every((c) => c.isEssential || !c.consentStatus),
  EVAL_WAITROSE_0: () => Array.from(document.querySelectorAll("label[id$=cookies-deny-label]")).forEach((e) => e.click()) || true
};

// node_modules/@ghostery/adblocker/dist/esm/crc32.js
(() => {
  let c = 0;
  const table = new Int32Array(256);
  for (let n = 0; n !== 256; n += 1) {
    c = n;
    c = c & 1 ? -306674912 ^ c >>> 1 : c >>> 1;
    c = c & 1 ? -306674912 ^ c >>> 1 : c >>> 1;
    c = c & 1 ? -306674912 ^ c >>> 1 : c >>> 1;
    c = c & 1 ? -306674912 ^ c >>> 1 : c >>> 1;
    c = c & 1 ? -306674912 ^ c >>> 1 : c >>> 1;
    c = c & 1 ? -306674912 ^ c >>> 1 : c >>> 1;
    c = c & 1 ? -306674912 ^ c >>> 1 : c >>> 1;
    c = c & 1 ? -306674912 ^ c >>> 1 : c >>> 1;
    table[n] = c;
  }
  return table;
})();
new Int8Array(new Int16Array([1]).buffer)[0] === 1;
new TextEncoder();

// node_modules/@ghostery/adblocker-extended-selectors/dist/esm/parse.js
var TOKENS = {
  attribute: /\[\s*(?:(?<namespace>\*|[-\w]*)\|)?(?<name>[-\w\u{0080}-\u{FFFF}]+)\s*(?:(?<operator>\W?=)\s*(?<value>.+?)\s*(?<caseSensitive>[iIsS])?\s*)?\]/gu,
  id: /#(?<name>(?:[-\w\u{0080}-\u{FFFF}]|\\.)+)/gu,
  class: /\.(?<name>(?:[-\w\u{0080}-\u{FFFF}]|\\.)+)/gu,
  comma: /\s*,\s*/g,
  // must be before combinator
  combinator: /\s*[\s>+~]\s*/g,
  // this must be after attribute
  "pseudo-element": /::(?<name>[-\w\u{0080}-\u{FFFF}]+)(?:\((?:¶*)\))?/gu,
  // this must be before pseudo-class
  "pseudo-class": /:(?<name>[-\w\u{0080}-\u{FFFF}]+)(?:\((?<argument>¶*)\))?/gu,
  type: /(?:(?<namespace>\*|[-\w]*)\|)?(?<name>[-\w\u{0080}-\u{FFFF}]+)|\*/gu
  // this must be last
};
var TOKENS_WITH_PARENS = /* @__PURE__ */ new Set(["pseudo-class", "pseudo-element"]);
/* @__PURE__ */ new Set([...TOKENS_WITH_PARENS, "attribute"]);
var TOKENS_FOR_RESTORE = Object.assign({}, TOKENS);
TOKENS_FOR_RESTORE["pseudo-element"] = RegExp(TOKENS["pseudo-element"].source.replace("(?<argument>\xB6*)", "(?<argument>.*?)"), "gu");
TOKENS_FOR_RESTORE["pseudo-class"] = RegExp(TOKENS["pseudo-class"].source.replace("(?<argument>\xB6*)", "(?<argument>.*)"), "gu");

// node_modules/@ghostery/adblocker-extended-selectors/dist/esm/extended.js
var SelectorType;
(function(SelectorType2) {
  SelectorType2[SelectorType2["Normal"] = 0] = "Normal";
  SelectorType2[SelectorType2["Extended"] = 1] = "Extended";
  SelectorType2[SelectorType2["Invalid"] = 2] = "Invalid";
})(SelectorType || (SelectorType = {}));

// node_modules/@ghostery/adblocker/dist/esm/utils.js
var HASH_INTERNAL_MULT = 37;
var HASH_SEED = 5011;
function fastHashBetween(str, begin, end) {
  let hash = HASH_SEED;
  for (let i = begin; i < end; i += 1) {
    hash = hash * HASH_INTERNAL_MULT ^ str.charCodeAt(i);
  }
  return hash >>> 0;
}
function fastHash(str) {
  if (typeof str !== "string") {
    return HASH_SEED;
  }
  if (str.length === 0) {
    return HASH_SEED;
  }
  return fastHashBetween(str, 0, str.length);
}

// node_modules/@ghostery/adblocker/dist/esm/request.js
({
  beacon: fastHash("type:beacon"),
  cspReport: fastHash("type:csp"),
  csp_report: fastHash("type:csp"),
  cspviolationreport: fastHash("type:cspviolationreport"),
  document: fastHash("type:document"),
  eventsource: fastHash("type:other"),
  fedcm: fastHash("type:script"),
  fetch: fastHash("type:xhr"),
  font: fastHash("type:font"),
  image: fastHash("type:image"),
  imageset: fastHash("type:image"),
  json: fastHash("type:script"),
  mainFrame: fastHash("type:document"),
  main_frame: fastHash("type:document"),
  manifest: fastHash("type:other"),
  media: fastHash("type:media"),
  object: fastHash("type:object"),
  object_subrequest: fastHash("type:object"),
  other: fastHash("type:other"),
  ping: fastHash("type:ping"),
  prefetch: fastHash("type:other"),
  preflight: fastHash("type:preflight"),
  script: fastHash("type:script"),
  signedexchange: fastHash("type:signedexchange"),
  speculative: fastHash("type:other"),
  stylesheet: fastHash("type:stylesheet"),
  subFrame: fastHash("type:subdocument"),
  sub_frame: fastHash("type:subdocument"),
  texttrack: fastHash("type:other"),
  webSocket: fastHash("type:websocket"),
  web_manifest: fastHash("type:other"),
  websocket: fastHash("type:websocket"),
  xhr: fastHash("type:xhr"),
  xml_dtd: fastHash("type:other"),
  xmlhttprequest: fastHash("type:xhr"),
  xslt: fastHash("type:other")
});
(() => {
  const div = typeof document !== "undefined" ? document.createElement("div") : {
    matches: () => {
    }
  };
  const matches3 = (selector) => div.matches(selector);
  const validSelectorRe = /^[#.]?[\w-.]+$/;
  return function isValidCssImpl(selector) {
    if (validSelectorRe.test(selector)) {
      return true;
    }
    try {
      matches3(selector);
    } catch (ex) {
      return false;
    }
    return true;
  };
})();
var COSMETICS_MASK;
(function(COSMETICS_MASK2) {
  COSMETICS_MASK2[COSMETICS_MASK2["unhide"] = 1] = "unhide";
  COSMETICS_MASK2[COSMETICS_MASK2["scriptInject"] = 2] = "scriptInject";
  COSMETICS_MASK2[COSMETICS_MASK2["isUnicode"] = 4] = "isUnicode";
  COSMETICS_MASK2[COSMETICS_MASK2["isClassSelector"] = 8] = "isClassSelector";
  COSMETICS_MASK2[COSMETICS_MASK2["isIdSelector"] = 16] = "isIdSelector";
  COSMETICS_MASK2[COSMETICS_MASK2["isHrefSelector"] = 32] = "isHrefSelector";
  COSMETICS_MASK2[COSMETICS_MASK2["remove"] = 64] = "remove";
  COSMETICS_MASK2[COSMETICS_MASK2["extended"] = 128] = "extended";
})(COSMETICS_MASK || (COSMETICS_MASK = {}));

// node_modules/@ghostery/adblocker/dist/esm/filters/network.js
fastHash("http");
fastHash("https");
var NETWORK_FILTER_MASK;
(function(NETWORK_FILTER_MASK2) {
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["fromDocument"] = 1] = "fromDocument";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["fromFont"] = 2] = "fromFont";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["fromHttp"] = 4] = "fromHttp";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["fromHttps"] = 8] = "fromHttps";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["fromImage"] = 16] = "fromImage";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["fromMedia"] = 32] = "fromMedia";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["fromObject"] = 64] = "fromObject";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["fromOther"] = 128] = "fromOther";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["fromPing"] = 256] = "fromPing";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["fromScript"] = 512] = "fromScript";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["fromStylesheet"] = 1024] = "fromStylesheet";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["fromSubdocument"] = 2048] = "fromSubdocument";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["fromWebsocket"] = 4096] = "fromWebsocket";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["fromXmlHttpRequest"] = 8192] = "fromXmlHttpRequest";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["firstParty"] = 16384] = "firstParty";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["thirdParty"] = 32768] = "thirdParty";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["isReplace"] = 65536] = "isReplace";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["isBadFilter"] = 131072] = "isBadFilter";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["isCSP"] = 262144] = "isCSP";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["isGenericHide"] = 524288] = "isGenericHide";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["isImportant"] = 1048576] = "isImportant";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["isSpecificHide"] = 2097152] = "isSpecificHide";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["isFullRegex"] = 4194304] = "isFullRegex";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["isRegex"] = 8388608] = "isRegex";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["isUnicode"] = 16777216] = "isUnicode";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["isLeftAnchor"] = 33554432] = "isLeftAnchor";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["isRightAnchor"] = 67108864] = "isRightAnchor";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["isException"] = 134217728] = "isException";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["isHostnameAnchor"] = 268435456] = "isHostnameAnchor";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["isRedirectRule"] = 536870912] = "isRedirectRule";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["isRedirect"] = 1073741824] = "isRedirect";
  NETWORK_FILTER_MASK2[NETWORK_FILTER_MASK2["isRemoveParam"] = -2147483648] = "isRemoveParam";
})(NETWORK_FILTER_MASK || (NETWORK_FILTER_MASK = {}));
NETWORK_FILTER_MASK.fromDocument | NETWORK_FILTER_MASK.fromFont | NETWORK_FILTER_MASK.fromImage | NETWORK_FILTER_MASK.fromMedia | NETWORK_FILTER_MASK.fromObject | NETWORK_FILTER_MASK.fromOther | NETWORK_FILTER_MASK.fromPing | NETWORK_FILTER_MASK.fromScript | NETWORK_FILTER_MASK.fromStylesheet | NETWORK_FILTER_MASK.fromSubdocument | NETWORK_FILTER_MASK.fromWebsocket | NETWORK_FILTER_MASK.fromXmlHttpRequest;
({
  beacon: NETWORK_FILTER_MASK.fromPing,
  // fromOther?
  document: NETWORK_FILTER_MASK.fromDocument,
  cspviolationreport: NETWORK_FILTER_MASK.fromOther,
  // https://developer.mozilla.org/en-US/docs/Web/API/FedCM_API/IDP_integration#provide_a_config_file_and_endpoints
  // FedCM configuration file is resolved as a JSON module, which is interpreted as a "script".
  // Some of FedCM related requests are resolved as "xhr/fetch" but we use "script" to add weight to the meaning of "standardised" module behavior in browser-side.
  fedcm: NETWORK_FILTER_MASK.fromScript,
  fetch: NETWORK_FILTER_MASK.fromXmlHttpRequest,
  font: NETWORK_FILTER_MASK.fromFont,
  image: NETWORK_FILTER_MASK.fromImage,
  imageset: NETWORK_FILTER_MASK.fromImage,
  // https://searchfox.org/mozilla-central/rev/fcfb558f8946f3648d962576125af46bf6e2910a/toolkit/components/extensions/schemas/web_request.json
  // This is for JSON modules from import statements.
  // Our `NETWORK_FILTER_MASK` is already full and we can treat this as a script request.
  json: NETWORK_FILTER_MASK.fromScript,
  mainFrame: NETWORK_FILTER_MASK.fromDocument,
  main_frame: NETWORK_FILTER_MASK.fromDocument,
  media: NETWORK_FILTER_MASK.fromMedia,
  object: NETWORK_FILTER_MASK.fromObject,
  object_subrequest: NETWORK_FILTER_MASK.fromObject,
  ping: NETWORK_FILTER_MASK.fromPing,
  // fromOther?
  script: NETWORK_FILTER_MASK.fromScript,
  stylesheet: NETWORK_FILTER_MASK.fromStylesheet,
  subFrame: NETWORK_FILTER_MASK.fromSubdocument,
  sub_frame: NETWORK_FILTER_MASK.fromSubdocument,
  webSocket: NETWORK_FILTER_MASK.fromWebsocket,
  websocket: NETWORK_FILTER_MASK.fromWebsocket,
  xhr: NETWORK_FILTER_MASK.fromXmlHttpRequest,
  xmlhttprequest: NETWORK_FILTER_MASK.fromXmlHttpRequest,
  // Other
  cspReport: NETWORK_FILTER_MASK.fromOther,
  csp_report: NETWORK_FILTER_MASK.fromOther,
  eventsource: NETWORK_FILTER_MASK.fromOther,
  manifest: NETWORK_FILTER_MASK.fromOther,
  other: NETWORK_FILTER_MASK.fromOther,
  prefetch: NETWORK_FILTER_MASK.fromOther,
  preflight: NETWORK_FILTER_MASK.fromOther,
  signedexchange: NETWORK_FILTER_MASK.fromOther,
  speculative: NETWORK_FILTER_MASK.fromOther,
  texttrack: NETWORK_FILTER_MASK.fromOther,
  web_manifest: NETWORK_FILTER_MASK.fromOther,
  xml_dtd: NETWORK_FILTER_MASK.fromOther,
  xslt: NETWORK_FILTER_MASK.fromOther
});

// node_modules/@ghostery/adblocker/dist/esm/preprocessor.js
var PreprocessorTokens;
(function(PreprocessorTokens2) {
  PreprocessorTokens2[PreprocessorTokens2["INVALID"] = 0] = "INVALID";
  PreprocessorTokens2[PreprocessorTokens2["BEGIF"] = 1] = "BEGIF";
  PreprocessorTokens2[PreprocessorTokens2["ELSE"] = 2] = "ELSE";
  PreprocessorTokens2[PreprocessorTokens2["ENDIF"] = 3] = "ENDIF";
})(PreprocessorTokens || (PreprocessorTokens = {}));

// node_modules/@ghostery/adblocker/dist/esm/lists.js
var FilterType;
(function(FilterType2) {
  FilterType2[FilterType2["NOT_SUPPORTED"] = 0] = "NOT_SUPPORTED";
  FilterType2[FilterType2["NETWORK"] = 1] = "NETWORK";
  FilterType2[FilterType2["COSMETIC"] = 2] = "COSMETIC";
  FilterType2[FilterType2["NOT_SUPPORTED_EMPTY"] = 100] = "NOT_SUPPORTED_EMPTY";
  FilterType2[FilterType2["NOT_SUPPORTED_COMMENT"] = 101] = "NOT_SUPPORTED_COMMENT";
  FilterType2[FilterType2["NOT_SUPPORTED_ADGUARD"] = 102] = "NOT_SUPPORTED_ADGUARD";
})(FilterType || (FilterType = {}));

// node_modules/@remusao/small/dist/esm/types.js
var PREFIX2 = "MIME_TYPE_STUB";

// node_modules/@remusao/small/dist/esm/flv.js
var CONTENT_TYPE = "video/flv";
var resource = {
  name: `${PREFIX2}.flv`,
  contentType: `${CONTENT_TYPE};base64`,
  aliases: [CONTENT_TYPE, ".flv", "flv"],
  body: "RkxWAQEAAAAJAAAAABIAALgAAAAAAAAAAgAKb25NZXRhRGF0YQgAAAAIAAhkdXJhdGlvbgAAAAAAAAAAAAAFd2lkdGgAP/AAAAAAAAAABmhlaWdodAA/8AAAAAAAAAANdmlkZW9kYXRhcmF0ZQBAaGoAAAAAAAAJZnJhbWVyYXRlAEBZAAAAAAAAAAx2aWRlb2NvZGVjaWQAQAAAAAAAAAAAB2VuY29kZXICAA1MYXZmNTcuNDEuMTAwAAhmaWxlc2l6ZQBAaoAAAAAAAAAACQAAAMM="
};
var flv_default = resource;

// node_modules/@remusao/small/dist/esm/gif.js
var CONTENT_TYPE2 = "image/gif";
var resource2 = {
  name: `${PREFIX2}.gif`,
  contentType: `${CONTENT_TYPE2};base64`,
  aliases: [CONTENT_TYPE2, ".gif", "gif"],
  body: "R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7"
};
var gif_default = resource2;

// node_modules/@remusao/small/dist/esm/html.js
var CONTENT_TYPE3 = "text/html";
var resource3 = {
  name: `${PREFIX2}.html`,
  contentType: CONTENT_TYPE3,
  aliases: [
    CONTENT_TYPE3,
    ".html",
    "html",
    ".htm",
    "htm",
    "noopframe",
    "noop.html"
  ],
  body: "<!DOCTYPE html>"
};
var html_default = resource3;

// node_modules/@remusao/small/dist/esm/ico.js
var CONTENT_TYPE4 = "image/vnd.microsoft.icon";
var resource4 = {
  name: `${PREFIX2}.ico`,
  contentType: `${CONTENT_TYPE4};base64`,
  aliases: [CONTENT_TYPE4, ".ico", "ico"],
  body: "AAABAAEAAQEAAAEAGAAwAAAAFgAAACgAAAABAAAAAgAAAAEAGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP8AAAAAAA=="
};
var ico_default = resource4;

// node_modules/@remusao/small/dist/esm/jpeg.js
var CONTENT_TYPE5 = "image/jpeg";
var resource5 = {
  name: `${PREFIX2}.jpg`,
  contentType: `${CONTENT_TYPE5};base64`,
  aliases: [CONTENT_TYPE5, ".jpg", "jpg", ".jpeg", "jpeg"],
  body: "/9j/2wBDAAMCAgICAgMCAgIDAwMDBAYEBAQEBAgGBgUGCQgKCgkICQkKDA8MCgsOCwkJDRENDg8QEBEQCgwSExIQEw8QEBD/yQALCAABAAEBAREA/8wABgAQEAX/2gAIAQEAAD8A0s8g/9k="
};
var jpeg_default = resource5;

// node_modules/@remusao/small/dist/esm/javascript.js
var CONTENT_TYPE6 = "application/javascript";
var resource6 = {
  name: `${PREFIX2}.js`,
  contentType: CONTENT_TYPE6,
  aliases: [
    CONTENT_TYPE6,
    ".js",
    "js",
    "javascript",
    ".jsx",
    "jsx",
    "typescript",
    ".ts",
    "ts",
    "noop.js",
    "noopjs"
  ],
  body: ""
};
var javascript_default = resource6;

// node_modules/@remusao/small/dist/esm/json.js
var CONTENT_TYPE7 = "application/json";
var resource7 = {
  name: `${PREFIX2}.json`,
  contentType: CONTENT_TYPE7,
  aliases: [CONTENT_TYPE7, ".json", "json"],
  body: "0"
};
var json_default = resource7;

// node_modules/@remusao/small/dist/esm/mp3.js
var CONTENT_TYPE8 = "audio/mpeg";
var resource8 = {
  name: `${PREFIX2}.mp3`,
  contentType: `${CONTENT_TYPE8};base64`,
  aliases: [CONTENT_TYPE8, ".mp3", "mp3", "noop-0.1s.mp3", "noopmp3-0.1s"],
  body: "/+MYxAAAAANIAAAAAExBTUUzLjk4LjIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
};
var mp3_default = resource8;

// node_modules/@remusao/small/dist/esm/mp4.js
var CONTENT_TYPE9 = "video/mp4";
var resource9 = {
  name: `${PREFIX2}.mp4`,
  contentType: `${CONTENT_TYPE9};base64`,
  aliases: [
    CONTENT_TYPE9,
    ".mp4",
    "mp4",
    ".m4a",
    "m4a",
    ".m4p",
    "m4p",
    ".m4b",
    "m4b",
    ".m4r",
    "m4r",
    ".m4v",
    "m4v",
    "noop-1s.mp4",
    "noopmp4-1s"
  ],
  body: "AAAAHGZ0eXBpc29tAAACAGlzb21pc28ybXA0MQAAAAhmcmVlAAAC721kYXQhEAUgpBv/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA3pwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAcCEQBSCkG//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADengAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAcAAAAsJtb292AAAAbG12aGQAAAAAAAAAAAAAAAAAAAPoAAAALwABAAABAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADAAAB7HRyYWsAAABcdGtoZAAAAAMAAAAAAAAAAAAAAAIAAAAAAAAALwAAAAAAAAAAAAAAAQEAAAAAAQAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAACRlZHRzAAAAHGVsc3QAAAAAAAAAAQAAAC8AAAAAAAEAAAAAAWRtZGlhAAAAIG1kaGQAAAAAAAAAAAAAAAAAAKxEAAAIAFXEAAAAAAAtaGRscgAAAAAAAAAAc291bgAAAAAAAAAAAAAAAFNvdW5kSGFuZGxlcgAAAAEPbWluZgAAABBzbWhkAAAAAAAAAAAAAAAkZGluZgAAABxkcmVmAAAAAAAAAAEAAAAMdXJsIAAAAAEAAADTc3RibAAAAGdzdHNkAAAAAAAAAAEAAABXbXA0YQAAAAAAAAABAAAAAAAAAAAAAgAQAAAAAKxEAAAAAAAzZXNkcwAAAAADgICAIgACAASAgIAUQBUAAAAAAfQAAAHz+QWAgIACEhAGgICAAQIAAAAYc3R0cwAAAAAAAAABAAAAAgAABAAAAAAcc3RzYwAAAAAAAAABAAAAAQAAAAIAAAABAAAAHHN0c3oAAAAAAAAAAAAAAAIAAAFzAAABdAAAABRzdGNvAAAAAAAAAAEAAAAsAAAAYnVkdGEAAABabWV0YQAAAAAAAAAhaGRscgAAAAAAAAAAbWRpcmFwcGwAAAAAAAAAAAAAAAAtaWxzdAAAACWpdG9vAAAAHWRhdGEAAAABAAAAAExhdmY1Ni40MC4xMDE="
};
var mp4_default = resource9;

// node_modules/@remusao/small/dist/esm/pdf.js
var CONTENT_TYPE10 = "application/pdf";
var resource10 = {
  name: `${PREFIX2}.pdf`,
  contentType: `${CONTENT_TYPE10};base64`,
  aliases: [CONTENT_TYPE10, ".pdf", "pdf"],
  body: "JVBERi0xLgoxIDAgb2JqPDwvUGFnZXMgMiAwIFI+PmVuZG9iagoyIDAgb2JqPDwvS2lkc1szIDAgUl0vQ291bnQgMT4+ZW5kb2JqCjMgMCBvYmo8PC9QYXJlbnQgMiAwIFI+PmVuZG9iagp0cmFpbGVyIDw8L1Jvb3QgMSAwIFI+Pg=="
};
var pdf_default = resource10;

// node_modules/@remusao/small/dist/esm/png.js
var CONTENT_TYPE11 = "image/png";
var resource11 = {
  name: `${PREFIX2}.png`,
  contentType: `${CONTENT_TYPE11};base64`,
  aliases: [CONTENT_TYPE11, ".png", "png"],
  body: "iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAACklEQVR4nGMAAQAABQABDQottAAAAABJRU5ErkJggg=="
};
var png_default = resource11;

// node_modules/@remusao/small/dist/esm/svg.js
var CONTENT_TYPE12 = "image/svg+xml";
var resource12 = {
  name: `${PREFIX2}.svg`,
  contentType: CONTENT_TYPE12,
  aliases: [CONTENT_TYPE12, ".svg", "svg"],
  body: "https://raw.githubusercontent.com/mathiasbynens/small/master/svg.svg"
};
var svg_default = resource12;

// node_modules/@remusao/small/dist/esm/txt.js
var CONTENT_TYPE13 = "text/plain";
var resource13 = {
  name: `${PREFIX2}.txt`,
  contentType: CONTENT_TYPE13,
  aliases: [CONTENT_TYPE13, ".txt", "txt", "text", "nooptext", "noop.txt"],
  body: ""
};
var txt_default = resource13;

// node_modules/@remusao/small/dist/esm/wav.js
var CONTENT_TYPE14 = "audio/wav";
var resource14 = {
  name: `${PREFIX2}.wav`,
  contentType: `${CONTENT_TYPE14};base64`,
  aliases: [CONTENT_TYPE14, ".wav", "wav"],
  body: "UklGRiQAAABXQVZFZm10IBAAAAABAAEARKwAAIhYAQACABAAZGF0YQAAAAA="
};
var wav_default = resource14;

// node_modules/@remusao/small/dist/esm/webm.js
var CONTENT_TYPE15 = "video/webm";
var resource15 = {
  name: `${PREFIX2}.webm`,
  contentType: `${CONTENT_TYPE15};base64`,
  aliases: [CONTENT_TYPE15, ".webm", "webm"],
  body: "GkXfo0AgQoaBAUL3gQFC8oEEQvOBCEKCQAR3ZWJtQoeBAkKFgQIYU4BnQI0VSalmQCgq17FAAw9CQE2AQAZ3aGFtbXlXQUAGd2hhbW15RIlACECPQAAAAAAAFlSua0AxrkAu14EBY8WBAZyBACK1nEADdW5khkAFVl9WUDglhohAA1ZQOIOBAeBABrCBCLqBCB9DtnVAIueBAKNAHIEAAIAwAQCdASoIAAgAAUAmJaQAA3AA/vz0AAA="
};
var webm_default = resource15;

// node_modules/@remusao/small/dist/esm/webp.js
var CONTENT_TYPE16 = "image/webp";
var resource16 = {
  name: `${PREFIX2}.webp`,
  contentType: `${CONTENT_TYPE16};base64`,
  aliases: [CONTENT_TYPE16, ".webp", "webp"],
  body: "UklGRhIAAABXRUJQVlA4TAYAAAAvQWxvAGs="
};
var webp_default = resource16;

// node_modules/@remusao/small/dist/esm/wmv.js
var CONTENT_TYPE17 = "video/wmv";
var resource17 = {
  name: `${PREFIX2}.wmv`,
  contentType: `${CONTENT_TYPE17};base64`,
  aliases: [CONTENT_TYPE17, ".wmv", "wmv"],
  body: "MCaydY5mzxGm2QCqAGLObOUBAAAAAAAABQAAAAECodyrjEepzxGO5ADADCBTZWgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABcCAAAAAAAAAIA+1d6xnQEAAAAAAAAAAMAF2QEAAAAAAAAAAAAAAAAcDAAAAAAAAAIAAACADAAAgAwAAEANAwC1A79fLqnPEY7jAMAMIFNlLgAAAAAAAAAR0tOruqnPEY7mAMAMIFNlBgAAAAAAQKTQ0gfj0hGX8ACgyV6oUGQAAAAAAAAAAQAoAFcATQAvAEUAbgBjAG8AZABpAG4AZwBTAGUAdAB0AGkAbgBnAHMAAAAAABwATABhAHYAZgA1ADcALgA0ADEALgAxADAAMAAAAJEH3Le3qc8RjuYAwAwgU2WBAAAAAAAAAMDvGbxNW88RqP0AgF9cRCsAV/sgVVvPEaj9AIBfXEQrAAAAAAAAAAAzAAAAAAAAAAEAAAAAAAEAAAABAAAAAigAKAAAAAEAAAABAAAAAQAYAE1QNDMDAAAAAAAAAAAAAAAAAAAAAAAAAEBS0YYdMdARo6QAoMkDSPZMAAAAAAAAAEFS0YYdMdARo6QAoMkDSPYBAAAAAQAKAG0AcwBtAHAAZQBnADQAdgAzAAAAAAAEAE1QNDM2JrJ1jmbPEabZAKoAYs5sMgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAQ=="
};
var wmv_default = resource17;

// node_modules/@remusao/small/dist/esm/index.js
(() => {
  const resources = {};
  for (const fake of [
    flv_default,
    gif_default,
    html_default,
    ico_default,
    jpeg_default,
    javascript_default,
    json_default,
    mp3_default,
    mp4_default,
    pdf_default,
    png_default,
    svg_default,
    txt_default,
    wav_default,
    webm_default,
    webp_default,
    wmv_default
  ]) {
    for (const alias of fake.aliases) {
      resources[alias] = fake;
    }
  }
  return resources;
})();
/*! Bundled license information:

@ghostery/adblocker/dist/esm/codebooks/cosmetic-selector.js:
@ghostery/adblocker/dist/esm/codebooks/network-csp.js:
@ghostery/adblocker/dist/esm/codebooks/network-filter.js:
@ghostery/adblocker/dist/esm/codebooks/network-hostname.js:
@ghostery/adblocker/dist/esm/codebooks/network-redirect.js:
@ghostery/adblocker/dist/esm/codebooks/raw-network.js:
@ghostery/adblocker/dist/esm/codebooks/raw-cosmetic.js:
@ghostery/adblocker/dist/esm/compression.js:
@ghostery/adblocker/dist/esm/data-view.js:
@ghostery/adblocker/dist/esm/config.js:
@ghostery/adblocker/dist/esm/events.js:
@ghostery/adblocker/dist/esm/fetch.js:
@ghostery/adblocker-extended-selectors/dist/esm/types.js:
@ghostery/adblocker-extended-selectors/dist/esm/eval.js:
@ghostery/adblocker-extended-selectors/dist/esm/extended.js:
@ghostery/adblocker-extended-selectors/dist/esm/index.js:
@ghostery/adblocker/dist/esm/tokens-buffer.js:
@ghostery/adblocker/dist/esm/utils.js:
@ghostery/adblocker/dist/esm/request.js:
@ghostery/adblocker/dist/esm/engine/domains.js:
@ghostery/adblocker/dist/esm/html-filtering.js:
@ghostery/adblocker/dist/esm/filters/cosmetic.js:
@ghostery/adblocker/dist/esm/filters/dsl.js:
@ghostery/adblocker/dist/esm/filters/network.js:
@ghostery/adblocker/dist/esm/lists.js:
@ghostery/adblocker/dist/esm/resources.js:
@ghostery/adblocker/dist/esm/compact-set.js:
@ghostery/adblocker/dist/esm/engine/optimizer.js:
@ghostery/adblocker/dist/esm/engine/reverse-index.js:
@ghostery/adblocker/dist/esm/engine/bucket/filters.js:
@ghostery/adblocker/dist/esm/engine/bucket/cosmetic.js:
@ghostery/adblocker/dist/esm/engine/bucket/network.js:
@ghostery/adblocker/dist/esm/engine/map.js:
@ghostery/adblocker/dist/esm/engine/metadata/categories.js:
@ghostery/adblocker/dist/esm/engine/metadata/organizations.js:
@ghostery/adblocker/dist/esm/engine/metadata/patterns.js:
@ghostery/adblocker/dist/esm/engine/metadata.js:
@ghostery/adblocker/dist/esm/engine/engine.js:
@ghostery/adblocker/dist/esm/index.js:
@ghostery/adblocker-content/dist/esm/index.js:
  (*!
   * Copyright (c) 2017-present Ghostery GmbH. All rights reserved.
   *
   * This Source Code Form is subject to the terms of the Mozilla Public
   * License, v. 2.0. If a copy of the MPL was not distributed with this
   * file, You can obtain one at https://mozilla.org/MPL/2.0/.
   *)

@ghostery/adblocker-extended-selectors/dist/esm/parse.js:
  (*!
   * Based on parsel. Extended by Rémi Berson for Ghostery (2021).
   * https://github.com/LeaVerou/parsel
   *
   * MIT License
   *
   * Copyright (c) 2020 Lea Verou
   *
   * Permission is hereby granted, free of charge, to any person obtaining a copy
   * of this software and associated documentation files (the "Software"), to deal
   * in the Software without restriction, including without limitation the rights
   * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
   * copies of the Software, and to permit persons to whom the Software is
   * furnished to do so, subject to the following conditions:
   *
   * The above copyright notice and this permission notice shall be included in all
   * copies or substantial portions of the Software.
   *
   * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   * SOFTWARE.
   *)

@ghostery/adblocker/dist/esm/punycode.js:
  (*!
   * Copyright Mathias Bynens <https://mathiasbynens.be/>
   *
   * Permission is hereby granted, free of charge, to any person obtaining
   * a copy of this software and associated documentation files (the
   * "Software"), to deal in the Software without restriction, including
   * without limitation the rights to use, copy, modify, merge, publish,
   * distribute, sublicense, and/or sell copies of the Software, and to
   * permit persons to whom the Software is furnished to do so, subject to
   * the following conditions:
   *
   * The above copyright notice and this permission notice shall be
   * included in all copies or substantial portions of the Software.
   *
   * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
   * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
   * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
   * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
   * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
   *)

@ghostery/adblocker/dist/esm/encoding.js:
  (*!
   * Copyright (c) 2017-present Ghostery GmbH. All rights reserved.
   *
   * This Source Code Form is subject to the terms of the Mozilla Public
   * License, v. 2.0. If a copy of the MPL was not distributed with this
   * file, You can obtain one at https://mozilla.org/MPL/2.0/.
   *)
  (*!
   * Copyright (c) 2008-2009 Bjoern Hoehrmann <bjoern@hoehrmann.de>
   *
   * Permission is hereby granted, free of charge, to any person obtaining a copy
   * of this software and associated documentation files (the "Software"), to
   * deal in the Software without restriction, including without limitation the
   * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
   * sell copies of the Software, and to permit persons to whom the Software is
   * furnished to do so, subject to the following conditions:
   *
   * The above copyright notice and this permission notice shall be included in
   * all copies or substantial portions of the Software.
   *
   * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
   * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
   * IN THE SOFTWARE.
   *)
*/

export { snippets as evalSnippets };
