/*!
 * Copyright (c) 2017-present Ghostery GmbH. All rights reserved.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */
/* eslint-disable prettier/prettier */
const networkCSPCodebook = [
    "sandbox allow-forms allow-same-origin allow-scripts allow-modals allow-orientation-lock allow-pointer-lock allow-presentation allow-top-navigation",
    "script-src 'self' data: 'unsafe-inline' 'unsafe-hashes' 'unsafe-eval'",
    "script-src 'self' 'unsafe-inline' 'unsafe-eval' ",
    " *.google.com *.gstatic.com *.googleapis.com",
    " data: blob: mediastream: filesystem:",
    "script-src 'self' '*' 'unsafe-inline'",
    " *.gstatic.com *.google.com *.google",
    "default-src 'unsafe-inline' 'self'",
    " allow-same-origin allow-scripts",
    "script-src 'self' 'unsafe-eval' ",
    " *.google.com *.gstatic.com *.",
    "script-src * 'unsafe-inline'",
    ".com *.googletagmanager.com",
    "default-src 'self'",
    " *.googleapis.com",
    ".bootstrapcdn.com",
    "child-src 'none';",
    "worker-src 'none'",
    ".com *.facebook.",
    "'unsafe-inline'",
    "e-src 'self' *",
    " allow-modals",
    "unsafe-eval'",
    "child-src *",
    "gstatic.com",
    "script-src ",
    "style-src *",
    "cloudflare",
    "google.com",
    " https://",
    "frame-src",
    "data: *.",
    " allow-",
    " https:",
    ".com *.",
    "addthis",
    "captcha",
    "sandbox",
    " blob:",
    "'self'",
    "disqus",
    "google",
    "jquery",
    "ation",
    "data:",
    "http:",
    "-src",
    ".com",
    ".net",
    "apis",
    "n.cc",
    " *.",
    "age",
    "avi",
    "cdn",
    "ent",
    "pic",
    "ram",
    "tag",
    "yti",
    " '",
    " *",
    " f",
    "*.",
    "ad",
    "an",
    "as",
    "ck",
    "co",
    "er",
    "ga",
    "he",
    "im",
    "in",
    "lo",
    "ne",
    "or",
    "re",
    "tu",
    "wi",
    "wp",
    "ww",
    " ",
    "-",
    ";",
    ":",
    ".",
    "'",
    "*",
    "/",
    "1",
    "a",
    "b",
    "c",
    "d",
    "e",
    "f",
    "g",
    "h",
    "i",
    "j",
    "k",
    "l",
    "m",
    "n",
    "o",
    "p",
    "q",
    "r",
    "s",
    "t",
    "u",
    "v",
    "w",
    "x",
    "y"
];

export { networkCSPCodebook as default };
