/*!
 * Copyright (c) 2017-present Ghostery GmbH. All rights reserved.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */
/* eslint-disable prettier/prettier */
const networkFilterCodebook = [
    ",ipaddress=/^(1(72\\.67\\.\\d{3}|04\\.21\\.\\d+)\\.\\d+|188\\.114\\.9[67]\\.[08]|64:ff9b::[a-f0-9]{4}:[a-f0-9]{1,4})$/,replace='/^/<script>(()=>{window.open=new proxy(window.open,{apply:(n,o,w)=>{}});let e=document.queryselector(\"script\");e.innerhtml.includes(\"window.open\")&&e.parentelement.removechild(e)})();<\\/script>/i'",
    ")?[_0-9a-z]{6,16}\\/?[_0-9a-z]{5,120}(?:[-.](?:app|bundle|ma?in|module|prod|index|v\\d|vendor))?(?:\\.js)?$/$script,3p,match-case,to=com|~aswpsdkus.com|~chimpstatic.com|~mojirater.com|~polldaddy.com|~squareoffs.com|~succeedscene.com|~veraviews.com,",
    "/^https:\\/\\/(?:www\\d\\.)?[-a-z]{6,}\\.(?:club|com|info|net|org)\\/(?=[-_a-zA-Z]{0,42}\\d)(?=[-_0-9a-z]{0,42}[A-Z])[-_0-9a-zA-Z]{43}\\/\\?",
    "/^https:\\/\\/[0-9a-z]{7,25}\\.com\\/(?:assets|build|bundles|chunks|dist|files|j|public|scripts|static)?\\/?(?:js\\/",
    "/^https:\\/\\/s[cfntz]y?[ace][acemnu][a-z]{1,4}or?[mn][a-z]{4,8}[iy][a-z]?\\.",
    "[-.][-a-z0-9][-a-z0-9]+\\.[a-z][a-z][a-z]?[a-z]?[a-z]?\\//",
    "/videojs-vast-vpaid@2.0.2/bin/videojs_5.vast.vpaid.min",
    "/etc.clientlibs/logitech-common/clientlibs/onetrust.",
    "*&iu=%2f18190176%2c22509719621%2fadthrive_video_",
    "/(\\d{0,1})?tamilprint(\\d{1,2})?\\.(?:pro|art)/##",
    ".outbound-links.pageview-props.tagged-events",
    "\\/[a-zA-Z0-9]{30,}\\?[a-zA-Z0-9]{25,}$/",
    "/pagead/managed/js/gpt/*/pubads_impl",
    "/wrappermessagingwithoutdetection",
    "/extensions/*/appmeasurement",
    "\\.pussyspace\\.(?:com|net)\\/",
    "/pagead/js/adsbygoogle.js",
    "/js/sdkloader/ima3.js",
    "/js/sdkloader/ima3_d",
    "/videojs-contrib-ads",
    "/wp-content/plugins/",
    "/wp-content/uploads/",
    "/public/widget/data",
    "/wp-content/themes/",
    "/detroitchicago/",
    "*/satellitelib-",
    "/appmeasurement",
    "/cdn-cgi/trace",
    "/^https?:\\/\\/",
    "*.b-cdn.net^",
    "/^https:\\/\\/",
    "fingerprint",
    "/413gkwmt/",
    "/affiliate",
    "/ljub4etb/",
    "impression",
    "[0-9a-f]{",
    "[a-z0-9]{",
    "/plugins/",
    "analytics",
    "telemetry",
    "[a-f0-9]",
    "/assets/",
    "/images/",
    "tracking",
    "/public",
    "300x250",
    "captcha",
    "collect",
    "consent",
    "content",
    "counter",
    "metrics",
    "/media",
    "728x90",
    "banner",
    "bundle",
    "client",
    "cookie",
    "dn-cgi",
    "google",
    "module",
    "prebid",
    "rivacy",
    "script",
    "source",
    "widget",
    ".aspx",
    ".cgi?",
    ".com/",
    ".html",
    "[a-z]",
    "/api/",
    "/beac",
    "/java",
    "/stat",
    "0x600",
    "a-z]{",
    "block",
    "click",
    "count",
    "embed",
    "event",
    "fault",
    "frame",
    "manag",
    "pixel",
    "popup",
    "track",
    "type=",
    "video",
    "visit",
    ".css",
    ".gif",
    ".jpg",
    ".min",
    ".php",
    ".png",
    "[0-9",
    "/img",
    "/jqu",
    "/js/",
    "/lib",
    "/log",
    "/web",
    "/wp-",
    "468x",
    "gi-b",
    "heme",
    "http",
    "mail",
    "tect",
    "uild",
    "view",
    ".js",
    "(?:",
    "/ad",
    "%2f",
    "=*&",
    "age",
    "com",
    "dpr",
    "id=",
    "jax",
    "key",
    "lay",
    "log",
    "sdk",
    "tag",
    "web",
    "*/",
    "/_",
    "/?",
    "/*",
    "/d",
    "/f",
    "/g",
    "/h",
    "/m",
    "/n",
    "/p",
    "/r",
    "/u",
    "/w",
    "\\.",
    "\\/",
    "ac",
    "ad",
    "al",
    "am",
    "an",
    "ap",
    "ar",
    "as",
    "at",
    "ch",
    "co",
    "de",
    "di",
    "e/",
    "ed",
    "el",
    "en",
    "er",
    "es",
    "et",
    "fi",
    "ic",
    "id",
    "im",
    "in",
    "it",
    "js",
    "la",
    "le",
    "li",
    "lo",
    "mp",
    "ol",
    "om",
    "on",
    "op",
    "or",
    "ot",
    "re",
    "ro",
    "s-",
    "s/",
    "si",
    "sp",
    "st",
    "t/",
    "ti",
    "tm",
    "tr",
    "ub",
    "un",
    "ur",
    "us",
    "ut",
    "ve",
    "_",
    "-",
    ",",
    ":",
    "?",
    ".",
    ")",
    "[",
    "{",
    "}",
    "*",
    "/",
    "\\",
    "&",
    "^",
    "=",
    "|",
    "0",
    "1",
    "2",
    "3",
    "4",
    "5",
    "6",
    "7",
    "8",
    "9",
    "a",
    "b",
    "c",
    "d",
    "e",
    "f",
    "g",
    "h",
    "i",
    "j",
    "k",
    "l",
    "m",
    "n",
    "o",
    "p",
    "q",
    "r",
    "s",
    "t",
    "u",
    "v",
    "w",
    "x",
    "y",
    "z"
];

export { networkFilterCodebook as default };
