import resource from './flv.js';
import resource$1 from './gif.js';
import resource$2 from './html.js';
import resource$3 from './ico.js';
import resource$4 from './jpeg.js';
import resource$5 from './javascript.js';
import resource$6 from './json.js';
import resource$7 from './mp3.js';
import resource$8 from './mp4.js';
import resource$9 from './pdf.js';
import resource$a from './png.js';
import resource$b from './svg.js';
import resource$c from './txt.js';
import resource$d from './wav.js';
import resource$e from './webm.js';
import resource$f from './webp.js';
import resource$g from './wmv.js';

// List of mime types:
// - [ ] .aac 	AAC audio 	audio/aac
// - [ ] .abw 	AbiWord document 	application/x-abiword
// - [ ] .arc 	Archive document (multiple files embedded) 	application/x-freearc
// - [ ] .avi 	AVI: Audio Video Interleave 	video/x-msvideo
// - [ ] .azw 	Amazon Kindle eBook format 	application/vnd.amazon.ebook
// - [ ] .bin 	Any kind of binary data 	application/octet-stream
// - [ ] .bmp 	Windows OS/2 Bitmap Graphics 	image/bmp
// - [ ] .bz 	BZip archive 	application/x-bzip
// - [ ] .bz2 	BZip2 archive 	application/x-bzip2
// - [ ] .csh 	C-Shell script 	application/x-csh
// - [ ] .css 	Cascading Style Sheets (CSS) 	text/css
// - [ ] .csv 	Comma-separated values (CSV) 	text/csv
// - [ ] .doc 	Microsoft Word 	application/msword
// - [ ] .docx 	Microsoft Word (OpenXML) 	application/vnd.openxmlformats-officedocument.wordprocessingml.document
// - [ ] .eot 	MS Embedded OpenType fonts 	application/vnd.ms-fontobject
// - [ ] .epub 	Electronic publication (EPUB) 	application/epub+zip
// - [ ] .gz 	GZip Compressed Archive 	application/gzip
// - [x] .gif 	Graphics Interchange Format (GIF) 	image/gif
// - [x] .htm, .html 	HyperText Markup Language (HTML) 	text/html
// - [x] .ico 	Icon format 	image/vnd.microsoft.icon
// - [ ] .ics 	iCalendar format 	text/calendar
// - [ ] .jar 	Java Archive (JAR) 	application/java-archive
// - [x] .jpeg, .jpg 	JPEG images 	image/jpeg
// - [x] .js 	JavaScript 	text/javascript
// - [x] .json 	JSON format 	application/json
// - [ ] .jsonld 	JSON-LD format 	application/ld+json
// - [ ] .mid
// - [ ] .midi 	Musical Instrument Digital Interface (MIDI) 	audio/midi audio/x-midi
// - [ ] .mjs 	JavaScript module 	text/javascript
// - [x] .mp3 	MP3 audio 	audio/mpeg
// - [ ] .mpeg 	MPEG Video 	video/mpeg
// - [ ] .mpkg 	Apple Installer Package 	application/vnd.apple.installer+xml
// - [ ] .odp 	OpenDocument presentation document 	application/vnd.oasis.opendocument.presentation
// - [ ] .ods 	OpenDocument spreadsheet document 	application/vnd.oasis.opendocument.spreadsheet
// - [ ] .odt 	OpenDocument text document 	application/vnd.oasis.opendocument.text
// - [ ] .oga 	OGG audio 	audio/ogg
// - [ ] .ogv 	OGG video 	video/ogg
// - [ ] .ogx 	OGG 	application/ogg
// - [ ] .opus 	Opus audio 	audio/opus
// - [ ] .otf 	OpenType font 	font/otf
// - [x] .png 	Portable Network Graphics 	image/png
// - [x] .pdf 	Adobe Portable Document Format (PDF) 	application/pdf
// - [ ] .php 	Hypertext Preprocessor (Personal Home Page) 	application/php
// - [ ] .ppt 	Microsoft PowerPoint 	application/vnd.ms-powerpoint
// - [ ] .pptx 	Microsoft PowerPoint (OpenXML) 	application/vnd.openxmlformats-officedocument.presentationml.presentation
// - [ ] .rar 	RAR archive 	application/vnd.rar
// - [ ] .rtf 	Rich Text Format (RTF) 	application/rtf
// - [ ] .sh 	Bourne shell script 	application/x-sh
// - [x] .svg 	Scalable Vector Graphics (SVG) 	image/svg+xml
// - [ ] .swf 	Small web format (SWF) or Adobe Flash document 	application/x-shockwave-flash
// - [ ] .tar 	Tape Archive (TAR) 	application/x-tar
// - [ ] .tif
// - [ ] .tiff 	Tagged Image File Format (TIFF) 	image/tiff
// - [ ] .ts 	MPEG transport stream 	video/mp2t
// - [ ] .ttf 	TrueType Font 	font/ttf
// - [ ] .txt 	Text, (generally ASCII or ISO 8859-n) 	text/plain
// - [ ] .vsd 	Microsoft Visio 	application/vnd.visio
// - [x] .wav 	Waveform Audio Format 	audio/wav
// - [ ] .weba 	WEBM audio 	audio/webm
// - [x] .webm 	WEBM video 	video/webm
// - [x] .webp 	WEBP image 	image/webp
// - [ ] .woff 	Web Open Font Format (WOFF) 	font/woff
// - [ ] .woff2 	Web Open Font Format (WOFF) 	font/woff2
// - [ ] .xhtml 	XHTML 	application/xhtml+xml
// - [ ] .xls 	Microsoft Excel 	application/vnd.ms-excel
// - [ ] .xlsx 	Microsoft Excel (OpenXML) 	application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
// - [ ] .xml 	XML 	application/xml if not readable from casual users (RFC 3023, section 3)
// - [ ] text/xml if readable from casual users (RFC 3023, section 3)
// - [ ] .xul 	XUL 	application/vnd.mozilla.xul+xml
// - [ ] .zip 	ZIP archive 	application/zip
// - [ ] .3gp 	3GPP audio/video container 	video/3gpp, audio/3gpp if it doesn't contain video
// - [ ] .3g2 	3GPP2 audio/video container 	video/3gpp2, audio/3gpp2 if it doesn't contain video
// - [ ] .7z 	7-zip archive 	application/x-7z-compressed
const MIME_TO_RESOURCE = (() => {
    const resources = {};
    for (const fake of [
        resource,
        resource$1,
        resource$2,
        resource$3,
        resource$4,
        resource$5,
        resource$6,
        resource$7,
        resource$8,
        resource$9,
        resource$a,
        resource$b,
        resource$c,
        resource$d,
        resource$e,
        resource$f,
        resource$g,
    ]) {
        for (const alias of fake.aliases) {
            resources[alias] = fake;
        }
    }
    return resources;
})();
function getFallbackTextResource() {
    return resource$c;
}
function getResourceForMime(mime) {
    return MIME_TO_RESOURCE[mime] || getFallbackTextResource();
}

export { resource as flv, getFallbackTextResource, getResourceForMime, resource$1 as gif, resource$2 as html, resource$3 as ico, resource$4 as jpg, resource$5 as js, resource$6 as json, resource$7 as mp3, resource$8 as mp4, resource$9 as pdf, resource$a as png, resource$b as svg, resource$c as txt, resource$d as wav, resource$e as webm, resource$f as webp, resource$g as wmv };
