import { SVG } from '../@svgdotjs/svg.js/src/main.js';
import G from '../@svgdotjs/svg.js/src/elements/G.js';
import Path from '../@svgdotjs/svg.js/src/elements/Path.js';
import Rect from '../@svgdotjs/svg.js/src/elements/Rect.js';
import Text from '../@svgdotjs/svg.js/src/elements/Text.js';

class Export {
  constructor(canvas, prefix = "apex") {
    this.canvas = canvas;
    this.prefix = prefix;
  }
  getSvgString() {
    const svgString = this.canvas.svg();
    return svgString.replace(/(<img [\w\W]+?)(>)/g, "$1 />").replace(/(<br)(>)/g, "$1 />").replace(/(<hr)(>)/g, "$1 />");
  }
  svgUrl() {
    const svgData = this.getSvgString();
    const svgBlob = new Blob([svgData], {
      type: "image/svg+xml;charset=utf-8"
    });
    return URL.createObjectURL(svgBlob);
  }
  triggerDownload(href, filename) {
    const downloadLink = document.createElement("a");
    downloadLink.href = href;
    downloadLink.download = filename;
    document.body.appendChild(downloadLink);
    downloadLink.click();
    document.body.removeChild(downloadLink);
  }
  exportToSVG() {
    this.triggerDownload(this.svgUrl(), `${this.prefix}-${(/* @__PURE__ */ new Date()).getTime()}.svg`);
  }
}
function arrayReduce(array, iteratee, accumulator, initAccum) {
  var index = -1, length = array == null ? 0 : array.length;
  while (++index < length) {
    accumulator = iteratee(accumulator, array[index], index, array);
  }
  return accumulator;
}
function basePropertyOf(object) {
  return function(key) {
    return object == null ? void 0 : object[key];
  };
}
var deburredLetters = {
  // Latin-1 Supplement block.
  "À": "A",
  "Á": "A",
  "Â": "A",
  "Ã": "A",
  "Ä": "A",
  "Å": "A",
  "à": "a",
  "á": "a",
  "â": "a",
  "ã": "a",
  "ä": "a",
  "å": "a",
  "Ç": "C",
  "ç": "c",
  "Ð": "D",
  "ð": "d",
  "È": "E",
  "É": "E",
  "Ê": "E",
  "Ë": "E",
  "è": "e",
  "é": "e",
  "ê": "e",
  "ë": "e",
  "Ì": "I",
  "Í": "I",
  "Î": "I",
  "Ï": "I",
  "ì": "i",
  "í": "i",
  "î": "i",
  "ï": "i",
  "Ñ": "N",
  "ñ": "n",
  "Ò": "O",
  "Ó": "O",
  "Ô": "O",
  "Õ": "O",
  "Ö": "O",
  "Ø": "O",
  "ò": "o",
  "ó": "o",
  "ô": "o",
  "õ": "o",
  "ö": "o",
  "ø": "o",
  "Ù": "U",
  "Ú": "U",
  "Û": "U",
  "Ü": "U",
  "ù": "u",
  "ú": "u",
  "û": "u",
  "ü": "u",
  "Ý": "Y",
  "ý": "y",
  "ÿ": "y",
  "Æ": "Ae",
  "æ": "ae",
  "Þ": "Th",
  "þ": "th",
  "ß": "ss",
  // Latin Extended-A block.
  "Ā": "A",
  "Ă": "A",
  "Ą": "A",
  "ā": "a",
  "ă": "a",
  "ą": "a",
  "Ć": "C",
  "Ĉ": "C",
  "Ċ": "C",
  "Č": "C",
  "ć": "c",
  "ĉ": "c",
  "ċ": "c",
  "č": "c",
  "Ď": "D",
  "Đ": "D",
  "ď": "d",
  "đ": "d",
  "Ē": "E",
  "Ĕ": "E",
  "Ė": "E",
  "Ę": "E",
  "Ě": "E",
  "ē": "e",
  "ĕ": "e",
  "ė": "e",
  "ę": "e",
  "ě": "e",
  "Ĝ": "G",
  "Ğ": "G",
  "Ġ": "G",
  "Ģ": "G",
  "ĝ": "g",
  "ğ": "g",
  "ġ": "g",
  "ģ": "g",
  "Ĥ": "H",
  "Ħ": "H",
  "ĥ": "h",
  "ħ": "h",
  "Ĩ": "I",
  "Ī": "I",
  "Ĭ": "I",
  "Į": "I",
  "İ": "I",
  "ĩ": "i",
  "ī": "i",
  "ĭ": "i",
  "į": "i",
  "ı": "i",
  "Ĵ": "J",
  "ĵ": "j",
  "Ķ": "K",
  "ķ": "k",
  "ĸ": "k",
  "Ĺ": "L",
  "Ļ": "L",
  "Ľ": "L",
  "Ŀ": "L",
  "Ł": "L",
  "ĺ": "l",
  "ļ": "l",
  "ľ": "l",
  "ŀ": "l",
  "ł": "l",
  "Ń": "N",
  "Ņ": "N",
  "Ň": "N",
  "Ŋ": "N",
  "ń": "n",
  "ņ": "n",
  "ň": "n",
  "ŋ": "n",
  "Ō": "O",
  "Ŏ": "O",
  "Ő": "O",
  "ō": "o",
  "ŏ": "o",
  "ő": "o",
  "Ŕ": "R",
  "Ŗ": "R",
  "Ř": "R",
  "ŕ": "r",
  "ŗ": "r",
  "ř": "r",
  "Ś": "S",
  "Ŝ": "S",
  "Ş": "S",
  "Š": "S",
  "ś": "s",
  "ŝ": "s",
  "ş": "s",
  "š": "s",
  "Ţ": "T",
  "Ť": "T",
  "Ŧ": "T",
  "ţ": "t",
  "ť": "t",
  "ŧ": "t",
  "Ũ": "U",
  "Ū": "U",
  "Ŭ": "U",
  "Ů": "U",
  "Ű": "U",
  "Ų": "U",
  "ũ": "u",
  "ū": "u",
  "ŭ": "u",
  "ů": "u",
  "ű": "u",
  "ų": "u",
  "Ŵ": "W",
  "ŵ": "w",
  "Ŷ": "Y",
  "ŷ": "y",
  "Ÿ": "Y",
  "Ź": "Z",
  "Ż": "Z",
  "Ž": "Z",
  "ź": "z",
  "ż": "z",
  "ž": "z",
  "Ĳ": "IJ",
  "ĳ": "ij",
  "Œ": "Oe",
  "œ": "oe",
  "ŉ": "'n",
  "ſ": "s"
};
var deburrLetter = basePropertyOf(deburredLetters);
var freeGlobal = typeof global == "object" && global && global.Object === Object && global;
var freeSelf = typeof self == "object" && self && self.Object === Object && self;
var root = freeGlobal || freeSelf || Function("return this")();
var Symbol$1 = root.Symbol;
function arrayMap(array, iteratee) {
  var index = -1, length = array == null ? 0 : array.length, result = Array(length);
  while (++index < length) {
    result[index] = iteratee(array[index], index, array);
  }
  return result;
}
var isArray = Array.isArray;
var objectProto$b = Object.prototype;
var hasOwnProperty$8 = objectProto$b.hasOwnProperty;
var nativeObjectToString$1 = objectProto$b.toString;
var symToStringTag$1 = Symbol$1 ? Symbol$1.toStringTag : void 0;
function getRawTag(value) {
  var isOwn = hasOwnProperty$8.call(value, symToStringTag$1), tag = value[symToStringTag$1];
  try {
    value[symToStringTag$1] = void 0;
    var unmasked = true;
  } catch (e) {
  }
  var result = nativeObjectToString$1.call(value);
  if (unmasked) {
    if (isOwn) {
      value[symToStringTag$1] = tag;
    } else {
      delete value[symToStringTag$1];
    }
  }
  return result;
}
var objectProto$a = Object.prototype;
var nativeObjectToString = objectProto$a.toString;
function objectToString(value) {
  return nativeObjectToString.call(value);
}
var nullTag = "[object Null]", undefinedTag = "[object Undefined]";
var symToStringTag = Symbol$1 ? Symbol$1.toStringTag : void 0;
function baseGetTag(value) {
  if (value == null) {
    return value === void 0 ? undefinedTag : nullTag;
  }
  return symToStringTag && symToStringTag in Object(value) ? getRawTag(value) : objectToString(value);
}
function isObjectLike(value) {
  return value != null && typeof value == "object";
}
var symbolTag$1 = "[object Symbol]";
function isSymbol(value) {
  return typeof value == "symbol" || isObjectLike(value) && baseGetTag(value) == symbolTag$1;
}
var symbolProto$1 = Symbol$1 ? Symbol$1.prototype : void 0, symbolToString = symbolProto$1 ? symbolProto$1.toString : void 0;
function baseToString(value) {
  if (typeof value == "string") {
    return value;
  }
  if (isArray(value)) {
    return arrayMap(value, baseToString) + "";
  }
  if (isSymbol(value)) {
    return symbolToString ? symbolToString.call(value) : "";
  }
  var result = value + "";
  return result == "0" && 1 / value == -Infinity ? "-0" : result;
}
function toString(value) {
  return value == null ? "" : baseToString(value);
}
var reLatin = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g;
var rsComboMarksRange$1 = "\\u0300-\\u036f", reComboHalfMarksRange$1 = "\\ufe20-\\ufe2f", rsComboSymbolsRange$1 = "\\u20d0-\\u20ff", rsComboRange$1 = rsComboMarksRange$1 + reComboHalfMarksRange$1 + rsComboSymbolsRange$1;
var rsCombo$1 = "[" + rsComboRange$1 + "]";
var reComboMark = RegExp(rsCombo$1, "g");
function deburr(string) {
  string = toString(string);
  return string && string.replace(reLatin, deburrLetter).replace(reComboMark, "");
}
var reAsciiWord = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g;
function asciiWords(string) {
  return string.match(reAsciiWord) || [];
}
var reHasUnicodeWord = /[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/;
function hasUnicodeWord(string) {
  return reHasUnicodeWord.test(string);
}
var rsAstralRange = "\\ud800-\\udfff", rsComboMarksRange = "\\u0300-\\u036f", reComboHalfMarksRange = "\\ufe20-\\ufe2f", rsComboSymbolsRange = "\\u20d0-\\u20ff", rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange, rsDingbatRange = "\\u2700-\\u27bf", rsLowerRange = "a-z\\xdf-\\xf6\\xf8-\\xff", rsMathOpRange = "\\xac\\xb1\\xd7\\xf7", rsNonCharRange = "\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf", rsPunctuationRange = "\\u2000-\\u206f", rsSpaceRange = " \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000", rsUpperRange = "A-Z\\xc0-\\xd6\\xd8-\\xde", rsVarRange = "\\ufe0e\\ufe0f", rsBreakRange = rsMathOpRange + rsNonCharRange + rsPunctuationRange + rsSpaceRange;
var rsApos$1 = "['’]", rsBreak = "[" + rsBreakRange + "]", rsCombo = "[" + rsComboRange + "]", rsDigits = "\\d+", rsDingbat = "[" + rsDingbatRange + "]", rsLower = "[" + rsLowerRange + "]", rsMisc = "[^" + rsAstralRange + rsBreakRange + rsDigits + rsDingbatRange + rsLowerRange + rsUpperRange + "]", rsFitz = "\\ud83c[\\udffb-\\udfff]", rsModifier = "(?:" + rsCombo + "|" + rsFitz + ")", rsNonAstral = "[^" + rsAstralRange + "]", rsRegional = "(?:\\ud83c[\\udde6-\\uddff]){2}", rsSurrPair = "[\\ud800-\\udbff][\\udc00-\\udfff]", rsUpper = "[" + rsUpperRange + "]", rsZWJ = "\\u200d";
var rsMiscLower = "(?:" + rsLower + "|" + rsMisc + ")", rsMiscUpper = "(?:" + rsUpper + "|" + rsMisc + ")", rsOptContrLower = "(?:" + rsApos$1 + "(?:d|ll|m|re|s|t|ve))?", rsOptContrUpper = "(?:" + rsApos$1 + "(?:D|LL|M|RE|S|T|VE))?", reOptMod = rsModifier + "?", rsOptVar = "[" + rsVarRange + "]?", rsOptJoin = "(?:" + rsZWJ + "(?:" + [rsNonAstral, rsRegional, rsSurrPair].join("|") + ")" + rsOptVar + reOptMod + ")*", rsOrdLower = "\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])", rsOrdUpper = "\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])", rsSeq = rsOptVar + reOptMod + rsOptJoin, rsEmoji = "(?:" + [rsDingbat, rsRegional, rsSurrPair].join("|") + ")" + rsSeq;
var reUnicodeWord = RegExp([
  rsUpper + "?" + rsLower + "+" + rsOptContrLower + "(?=" + [rsBreak, rsUpper, "$"].join("|") + ")",
  rsMiscUpper + "+" + rsOptContrUpper + "(?=" + [rsBreak, rsUpper + rsMiscLower, "$"].join("|") + ")",
  rsUpper + "?" + rsMiscLower + "+" + rsOptContrLower,
  rsUpper + "+" + rsOptContrUpper,
  rsOrdUpper,
  rsOrdLower,
  rsDigits,
  rsEmoji
].join("|"), "g");
function unicodeWords(string) {
  return string.match(reUnicodeWord) || [];
}
function words(string, pattern, guard) {
  string = toString(string);
  pattern = pattern;
  if (pattern === void 0) {
    return hasUnicodeWord(string) ? unicodeWords(string) : asciiWords(string);
  }
  return string.match(pattern) || [];
}
var rsApos = "['’]";
var reApos = RegExp(rsApos, "g");
function createCompounder(callback) {
  return function(string) {
    return arrayReduce(words(deburr(string).replace(reApos, "")), callback, "");
  };
}
var kebabCase = createCompounder(function(result, word, index) {
  return result + (index ? "-" : "") + word.toLowerCase();
});
const getTooltip = (tooltipId = "apex-tooltip-container") => {
  const tooltipElement = document.getElementById(tooltipId) || document.createElement("div");
  tooltipElement.id = tooltipId;
  return tooltipElement;
};
const updateTooltip = (id = "", styles, content = "") => {
  const tooltipElement = document.getElementById(id);
  if (styles) {
    tooltipElement == null ? void 0 : tooltipElement.setAttribute("style", styles);
  } else {
    tooltipElement == null ? void 0 : tooltipElement.removeAttribute("style");
  }
  if ((tooltipElement == null ? void 0 : tooltipElement.innerHTML.replaceAll("'", '"')) !== content.replaceAll("'", '"')) {
    tooltipElement && (tooltipElement.innerHTML = content);
  }
};
const getTooltipStyles = ({
  bgColor,
  borderColor,
  maxWidth,
  padding,
  x,
  y
}) => {
  const styles = [
    "position: absolute;",
    `left: ${x + 20}px;`,
    `top: ${y + 20}px;`,
    `border: 1px solid ${borderColor};`,
    `border-radius: 5px;`
  ];
  if (bgColor) {
    styles.push(`background-color: ${bgColor};`);
  }
  if (maxWidth) {
    styles.push(`max-width: ${maxWidth}px`);
  }
  if (padding !== void 0) {
    styles.push(`padding: ${padding}px`);
  }
  return styles.join(" ");
};
const generateStyles = (styleObject = {}) => {
  const styles = [];
  for (const styleKey in styleObject) {
    const styleString = `${kebabCase(styleKey)}: ${styleObject[styleKey]};`;
    styles.push(styleString);
  }
  return styles.join(" ");
};
function drawRect({
  borderColor = "#caced0",
  color = "#97cbe6",
  height = 0,
  opacity = 1,
  radius = 0,
  width = 0,
  x = 0,
  y = 0
} = {}) {
  const rect = new Rect();
  rect.attr({
    height,
    opacity,
    rx: radius,
    ry: radius,
    width,
    x,
    y
  });
  rect.fill(color);
  rect.stroke({ color: borderColor, width: 1 });
  return rect;
}
function drawText(text = "", { fontColor = "#666767", pointerEvents = "all", textAnchor = "start", x, y }) {
  const textSvg = new Text();
  textSvg.font({ fill: fontColor });
  textSvg.tspan(text);
  if (x !== void 0 && y !== void 0) {
    textSvg.move(x, y);
  }
  textSvg.attr({ "pointer-events": pointerEvents, "text-anchor": textAnchor });
  return textSvg;
}
function drawGroup(x, y, id, parent) {
  const group = new G();
  group.attr({
    "data-parent": parent,
    "data-self": id,
    transform: x !== void 0 && y !== void 0 ? `translate(${x}, ${y})` : void 0
  });
  return group;
}
function drawPath(pathString, {
  edgeColor,
  id = "",
  opacity = 1
} = {}) {
  const path = new Path({ d: pathString });
  path.id(id);
  path.fill(edgeColor).opacity(opacity);
  return path;
}
function noop() {
}
const ExportIcon = "data:image/svg+xml,%3csvg%20fill='%23000000'%20width='20px'%20height='20px'%20viewBox='0%200%2024%2024'%20id='export-2'%20xmlns='http://www.w3.org/2000/svg'%20class='icon%20line'%3e%3cpolyline%20id='primary'%20points='15%203%2021%203%2021%209'%20style='fill:%20none;%20stroke:%20rgb(0,%200,%200);%20stroke-linecap:%20round;%20stroke-linejoin:%20round;%20stroke-width:%201.5;'%3e%3c/polyline%3e%3cpath%20id='primary-2'%20data-name='primary'%20d='M21,13v7a1,1,0,0,1-1,1H4a1,1,0,0,1-1-1V4A1,1,0,0,1,4,3h7'%20style='fill:%20none;%20stroke:%20rgb(0,%200,%200);%20stroke-linecap:%20round;%20stroke-linejoin:%20round;%20stroke-width:%201.5;'%3e%3c/path%3e%3cline%20id='primary-3'%20data-name='primary'%20x1='11'%20y1='13'%20x2='21'%20y2='3'%20style='fill:%20none;%20stroke:%20rgb(0,%200,%200);%20stroke-linecap:%20round;%20stroke-linejoin:%20round;%20stroke-width:%201.5;'%3e%3c/line%3e%3c/svg%3e";
const FitScreenIcon = "data:image/svg+xml,%3csvg%20width='20px'%20height='20px'%20viewBox='0%200%2032%2032'%20id='icon'%20xmlns='http://www.w3.org/2000/svg'%3e%3cpolygon%20points='8%202%202%202%202%208%204%208%204%204%208%204%208%202'/%3e%3cpolygon%20points='24%202%2030%202%2030%208%2028%208%2028%204%2024%204%2024%202'/%3e%3cpolygon%20points='8%2030%202%2030%202%2024%204%2024%204%2028%208%2028%208%2030'/%3e%3cpolygon%20points='24%2030%2030%2030%2030%2024%2028%2024%2028%2028%2024%2028%2024%2030'/%3e%3cpath%20d='M24,24H8a2.0023,2.0023,0,0,1-2-2V10A2.0023,2.0023,0,0,1,8,8H24a2.0023,2.0023,0,0,1,2,2V22A2.0023,2.0023,0,0,1,24,24ZM8,10V22H24V10Z'/%3e%3crect%20fill='none'%20width='32'%20height='32'/%3e%3c/svg%3e";
const ZoomInIcon = "data:image/svg+xml,%3csvg%20width='20px'%20height='20px'%20viewBox='0%200%2032%2032'%20version='1.1'%20xmlns='http://www.w3.org/2000/svg'%20xmlns:xlink='http://www.w3.org/1999/xlink'%20xmlns:sketch='http://www.bohemiancoding.com/sketch/ns'%3e%3cg%20stroke='none'%20stroke-width='1'%20fill='none'%20fill-rule='evenodd'%3e%3cg%20transform='translate(-308.000000,%20-1139.000000)'%20fill='%23000000'%3e%3cpath%20d='M321.46,1163.45%20C315.17,1163.45%20310.07,1158.44%20310.07,1152.25%20C310.07,1146.06%20315.17,1141.04%20321.46,1141.04%20C327.75,1141.04%20332.85,1146.06%20332.85,1152.25%20C332.85,1158.44%20327.75,1163.45%20321.46,1163.45%20L321.46,1163.45%20Z%20M339.688,1169.25%20L331.429,1161.12%20C333.592,1158.77%20334.92,1155.67%20334.92,1152.25%20C334.92,1144.93%20328.894,1139%20321.46,1139%20C314.026,1139%20308,1144.93%20308,1152.25%20C308,1159.56%20314.026,1165.49%20321.46,1165.49%20C324.672,1165.49%20327.618,1164.38%20329.932,1162.53%20L338.225,1170.69%20C338.629,1171.09%20339.284,1171.09%20339.688,1170.69%20C340.093,1170.3%20340.093,1169.65%20339.688,1169.25%20L339.688,1169.25%20Z%20M326.519,1151.41%20L322.522,1151.41%20L322.522,1147.41%20C322.522,1146.85%20322.075,1146.41%20321.523,1146.41%20C320.972,1146.41%20320.524,1146.85%20320.524,1147.41%20L320.524,1151.41%20L316.529,1151.41%20C315.978,1151.41%20315.53,1151.59%20315.53,1152.14%20C315.53,1152.7%20315.978,1153.41%20316.529,1153.41%20L320.524,1153.41%20L320.524,1157.41%20C320.524,1157.97%20320.972,1158.41%20321.523,1158.41%20C322.075,1158.41%20322.522,1157.97%20322.522,1157.41%20L322.522,1153.41%20L326.519,1153.41%20C327.07,1153.41%20327.518,1152.96%20327.518,1152.41%20C327.518,1151.86%20327.07,1151.41%20326.519,1151.41%20L326.519,1151.41%20Z'%20/%3e%3c/g%3e%3c/g%3e%3c/svg%3e";
const ZoomOutIcon = "data:image/svg+xml,%3csvg%20width='20px'%20height='20px'%20viewBox='0%200%2032%2032'%20version='1.1'%20xmlns='http://www.w3.org/2000/svg'%20xmlns:xlink='http://www.w3.org/1999/xlink'%3e%3cg%20stroke='none'%20stroke-width='1'%20fill='none'%20fill-rule='evenodd'%20%3e%3cg%20transform='translate(-360.000000,%20-1139.000000)'%20fill='%23000000'%3e%3cpath%20d='M373.46,1163.45%20C367.17,1163.45%20362.071,1158.44%20362.071,1152.25%20C362.071,1146.06%20367.17,1141.04%20373.46,1141.04%20C379.75,1141.04%20384.85,1146.06%20384.85,1152.25%20C384.85,1158.44%20379.75,1163.45%20373.46,1163.45%20L373.46,1163.45%20Z%20M391.688,1169.25%20L383.429,1161.12%20C385.592,1158.77%20386.92,1155.67%20386.92,1152.25%20C386.92,1144.93%20380.894,1139%20373.46,1139%20C366.026,1139%20360,1144.93%20360,1152.25%20C360,1159.56%20366.026,1165.49%20373.46,1165.49%20C376.672,1165.49%20379.618,1164.38%20381.932,1162.53%20L390.225,1170.69%20C390.629,1171.09%20391.284,1171.09%20391.688,1170.69%20C392.093,1170.3%20392.093,1169.65%20391.688,1169.25%20L391.688,1169.25%20Z%20M378.689,1151.41%20L368.643,1151.41%20C368.102,1151.41%20367.663,1151.84%20367.663,1152.37%20C367.663,1152.9%20368.102,1153.33%20368.643,1153.33%20L378.689,1153.33%20C379.23,1153.33%20379.669,1152.9%20379.669,1152.37%20C379.669,1151.84%20379.23,1151.41%20378.689,1151.41%20L378.689,1151.41%20Z'%20/%3e%3c/g%3e%3c/g%3e%3c/svg%3e";
const ToolBarIcons = {
  [
    "export"
    /* Export */
  ]: ExportIcon,
  [
    "fit-screen"
    /* FitScreen */
  ]: FitScreenIcon,
  [
    "zoom-in"
    /* ZoomIn */
  ]: ZoomInIcon,
  [
    "zoom-out"
    /* ZoomOut */
  ]: ZoomOutIcon
};
const ZoomChangeFactor = 0.1;
class Toolbar {
  constructor(element, canvas, prefix = "apex") {
    this.element = element;
    this.canvas = canvas;
    this.prefix = prefix;
    this.export = new Export(canvas, prefix);
  }
  createToolbarItem(itemName, icon) {
    const itemContainer = document.createElement("div");
    const image = new Image();
    image.src = icon;
    itemContainer.id = itemName;
    itemContainer.append(image);
    const containerStyles = generateStyles({
      alignItems: "center",
      backgroundColor: "#FFFFFF",
      border: "1px solid #BCBCBC",
      cursor: "pointer",
      display: "flex",
      height: "30px",
      justifyContent: "center",
      width: "30px"
    });
    itemContainer.setAttribute("style", containerStyles);
    return itemContainer;
  }
  render({
    enableExport = false,
    enableFitscreen = false,
    enableZoom = false,
    onFitscreen = noop,
    onZoom = noop
  }) {
    var _a;
    const container = document.createElement("div");
    container.id = "toolbar";
    const containerStyles = generateStyles({
      display: "flex",
      gap: "5px",
      position: "absolute",
      right: "10px",
      top: "10px"
    });
    container.setAttribute("style", containerStyles);
    if (enableExport) {
      const btnExport = this.createToolbarItem("export", ToolBarIcons[
        "export"
        /* Export */
      ]);
      btnExport.addEventListener("click", () => {
        this.export.exportToSVG();
      });
      container.append(btnExport);
    }
    if (enableZoom) {
      const btnZoomIn = this.createToolbarItem("zoom-in", ToolBarIcons[
        "zoom-in"
        /* ZoomIn */
      ]);
      const btnZoomOut = this.createToolbarItem("zoom-out", ToolBarIcons[
        "zoom-out"
        /* ZoomOut */
      ]);
      btnZoomIn.addEventListener("click", () => {
        onZoom(ZoomChangeFactor);
      });
      btnZoomOut.addEventListener("click", () => {
        onZoom(-ZoomChangeFactor);
      });
      container.append(btnZoomIn, btnZoomOut);
    }
    if (enableFitscreen) {
      const btnFitScreen = this.createToolbarItem("fit-screen", ToolBarIcons[
        "fit-screen"
        /* FitScreen */
      ]);
      btnFitScreen.addEventListener("click", () => {
        onFitscreen();
      });
      container.append(btnFitScreen);
    }
    (_a = this.element) == null ? void 0 : _a.append(container);
  }
}
function linkDirection(G2, link) {
  if (link.w === null)
    return 0;
  if (link.v === null)
    return 0;
  if (link.w === link.v) {
    return Math.PI / 2;
  }
  const source = G2.node(link.v);
  const target = G2.node(link.w);
  return Math.atan2(target.y - source.y, target.x - source.x);
}
function listCacheClear() {
  this.__data__ = [];
  this.size = 0;
}
function eq(value, other) {
  return value === other || value !== value && other !== other;
}
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}
var arrayProto = Array.prototype;
var splice = arrayProto.splice;
function listCacheDelete(key) {
  var data = this.__data__, index = assocIndexOf(data, key);
  if (index < 0) {
    return false;
  }
  var lastIndex = data.length - 1;
  if (index == lastIndex) {
    data.pop();
  } else {
    splice.call(data, index, 1);
  }
  --this.size;
  return true;
}
function listCacheGet(key) {
  var data = this.__data__, index = assocIndexOf(data, key);
  return index < 0 ? void 0 : data[index][1];
}
function listCacheHas(key) {
  return assocIndexOf(this.__data__, key) > -1;
}
function listCacheSet(key, value) {
  var data = this.__data__, index = assocIndexOf(data, key);
  if (index < 0) {
    ++this.size;
    data.push([key, value]);
  } else {
    data[index][1] = value;
  }
  return this;
}
function ListCache(entries) {
  var index = -1, length = entries == null ? 0 : entries.length;
  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}
ListCache.prototype.clear = listCacheClear;
ListCache.prototype["delete"] = listCacheDelete;
ListCache.prototype.get = listCacheGet;
ListCache.prototype.has = listCacheHas;
ListCache.prototype.set = listCacheSet;
function stackClear() {
  this.__data__ = new ListCache();
  this.size = 0;
}
function stackDelete(key) {
  var data = this.__data__, result = data["delete"](key);
  this.size = data.size;
  return result;
}
function stackGet(key) {
  return this.__data__.get(key);
}
function stackHas(key) {
  return this.__data__.has(key);
}
function isObject(value) {
  var type = typeof value;
  return value != null && (type == "object" || type == "function");
}
var asyncTag = "[object AsyncFunction]", funcTag$1 = "[object Function]", genTag = "[object GeneratorFunction]", proxyTag = "[object Proxy]";
function isFunction(value) {
  if (!isObject(value)) {
    return false;
  }
  var tag = baseGetTag(value);
  return tag == funcTag$1 || tag == genTag || tag == asyncTag || tag == proxyTag;
}
var coreJsData = root["__core-js_shared__"];
var maskSrcKey = function() {
  var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || "");
  return uid ? "Symbol(src)_1." + uid : "";
}();
function isMasked(func) {
  return !!maskSrcKey && maskSrcKey in func;
}
var funcProto$1 = Function.prototype;
var funcToString$1 = funcProto$1.toString;
function toSource(func) {
  if (func != null) {
    try {
      return funcToString$1.call(func);
    } catch (e) {
    }
    try {
      return func + "";
    } catch (e) {
    }
  }
  return "";
}
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
var reIsHostCtor = /^\[object .+?Constructor\]$/;
var funcProto = Function.prototype, objectProto$9 = Object.prototype;
var funcToString = funcProto.toString;
var hasOwnProperty$7 = objectProto$9.hasOwnProperty;
var reIsNative = RegExp(
  "^" + funcToString.call(hasOwnProperty$7).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
);
function baseIsNative(value) {
  if (!isObject(value) || isMasked(value)) {
    return false;
  }
  var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
  return pattern.test(toSource(value));
}
function getValue(object, key) {
  return object == null ? void 0 : object[key];
}
function getNative(object, key) {
  var value = getValue(object, key);
  return baseIsNative(value) ? value : void 0;
}
var Map$1 = getNative(root, "Map");
var nativeCreate = getNative(Object, "create");
function hashClear() {
  this.__data__ = nativeCreate ? nativeCreate(null) : {};
  this.size = 0;
}
function hashDelete(key) {
  var result = this.has(key) && delete this.__data__[key];
  this.size -= result ? 1 : 0;
  return result;
}
var HASH_UNDEFINED$2 = "__lodash_hash_undefined__";
var objectProto$8 = Object.prototype;
var hasOwnProperty$6 = objectProto$8.hasOwnProperty;
function hashGet(key) {
  var data = this.__data__;
  if (nativeCreate) {
    var result = data[key];
    return result === HASH_UNDEFINED$2 ? void 0 : result;
  }
  return hasOwnProperty$6.call(data, key) ? data[key] : void 0;
}
var objectProto$7 = Object.prototype;
var hasOwnProperty$5 = objectProto$7.hasOwnProperty;
function hashHas(key) {
  var data = this.__data__;
  return nativeCreate ? data[key] !== void 0 : hasOwnProperty$5.call(data, key);
}
var HASH_UNDEFINED$1 = "__lodash_hash_undefined__";
function hashSet(key, value) {
  var data = this.__data__;
  this.size += this.has(key) ? 0 : 1;
  data[key] = nativeCreate && value === void 0 ? HASH_UNDEFINED$1 : value;
  return this;
}
function Hash(entries) {
  var index = -1, length = entries == null ? 0 : entries.length;
  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}
Hash.prototype.clear = hashClear;
Hash.prototype["delete"] = hashDelete;
Hash.prototype.get = hashGet;
Hash.prototype.has = hashHas;
Hash.prototype.set = hashSet;
function mapCacheClear() {
  this.size = 0;
  this.__data__ = {
    "hash": new Hash(),
    "map": new (Map$1 || ListCache)(),
    "string": new Hash()
  };
}
function isKeyable(value) {
  var type = typeof value;
  return type == "string" || type == "number" || type == "symbol" || type == "boolean" ? value !== "__proto__" : value === null;
}
function getMapData(map, key) {
  var data = map.__data__;
  return isKeyable(key) ? data[typeof key == "string" ? "string" : "hash"] : data.map;
}
function mapCacheDelete(key) {
  var result = getMapData(this, key)["delete"](key);
  this.size -= result ? 1 : 0;
  return result;
}
function mapCacheGet(key) {
  return getMapData(this, key).get(key);
}
function mapCacheHas(key) {
  return getMapData(this, key).has(key);
}
function mapCacheSet(key, value) {
  var data = getMapData(this, key), size = data.size;
  data.set(key, value);
  this.size += data.size == size ? 0 : 1;
  return this;
}
function MapCache(entries) {
  var index = -1, length = entries == null ? 0 : entries.length;
  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}
MapCache.prototype.clear = mapCacheClear;
MapCache.prototype["delete"] = mapCacheDelete;
MapCache.prototype.get = mapCacheGet;
MapCache.prototype.has = mapCacheHas;
MapCache.prototype.set = mapCacheSet;
var LARGE_ARRAY_SIZE = 200;
function stackSet(key, value) {
  var data = this.__data__;
  if (data instanceof ListCache) {
    var pairs = data.__data__;
    if (!Map$1 || pairs.length < LARGE_ARRAY_SIZE - 1) {
      pairs.push([key, value]);
      this.size = ++data.size;
      return this;
    }
    data = this.__data__ = new MapCache(pairs);
  }
  data.set(key, value);
  this.size = data.size;
  return this;
}
function Stack(entries) {
  var data = this.__data__ = new ListCache(entries);
  this.size = data.size;
}
Stack.prototype.clear = stackClear;
Stack.prototype["delete"] = stackDelete;
Stack.prototype.get = stackGet;
Stack.prototype.has = stackHas;
Stack.prototype.set = stackSet;
var HASH_UNDEFINED = "__lodash_hash_undefined__";
function setCacheAdd(value) {
  this.__data__.set(value, HASH_UNDEFINED);
  return this;
}
function setCacheHas(value) {
  return this.__data__.has(value);
}
function SetCache(values) {
  var index = -1, length = values == null ? 0 : values.length;
  this.__data__ = new MapCache();
  while (++index < length) {
    this.add(values[index]);
  }
}
SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
SetCache.prototype.has = setCacheHas;
function arraySome(array, predicate) {
  var index = -1, length = array == null ? 0 : array.length;
  while (++index < length) {
    if (predicate(array[index], index, array)) {
      return true;
    }
  }
  return false;
}
function cacheHas(cache, key) {
  return cache.has(key);
}
var COMPARE_PARTIAL_FLAG$5 = 1, COMPARE_UNORDERED_FLAG$3 = 2;
function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG$5, arrLength = array.length, othLength = other.length;
  if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
    return false;
  }
  var arrStacked = stack.get(array);
  var othStacked = stack.get(other);
  if (arrStacked && othStacked) {
    return arrStacked == other && othStacked == array;
  }
  var index = -1, result = true, seen = bitmask & COMPARE_UNORDERED_FLAG$3 ? new SetCache() : void 0;
  stack.set(array, other);
  stack.set(other, array);
  while (++index < arrLength) {
    var arrValue = array[index], othValue = other[index];
    if (customizer) {
      var compared = isPartial ? customizer(othValue, arrValue, index, other, array, stack) : customizer(arrValue, othValue, index, array, other, stack);
    }
    if (compared !== void 0) {
      if (compared) {
        continue;
      }
      result = false;
      break;
    }
    if (seen) {
      if (!arraySome(other, function(othValue2, othIndex) {
        if (!cacheHas(seen, othIndex) && (arrValue === othValue2 || equalFunc(arrValue, othValue2, bitmask, customizer, stack))) {
          return seen.push(othIndex);
        }
      })) {
        result = false;
        break;
      }
    } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
      result = false;
      break;
    }
  }
  stack["delete"](array);
  stack["delete"](other);
  return result;
}
var Uint8Array = root.Uint8Array;
function mapToArray(map) {
  var index = -1, result = Array(map.size);
  map.forEach(function(value, key) {
    result[++index] = [key, value];
  });
  return result;
}
function setToArray(set) {
  var index = -1, result = Array(set.size);
  set.forEach(function(value) {
    result[++index] = value;
  });
  return result;
}
var COMPARE_PARTIAL_FLAG$4 = 1, COMPARE_UNORDERED_FLAG$2 = 2;
var boolTag$1 = "[object Boolean]", dateTag$1 = "[object Date]", errorTag$1 = "[object Error]", mapTag$2 = "[object Map]", numberTag$2 = "[object Number]", regexpTag$1 = "[object RegExp]", setTag$2 = "[object Set]", stringTag$1 = "[object String]", symbolTag = "[object Symbol]";
var arrayBufferTag$1 = "[object ArrayBuffer]", dataViewTag$2 = "[object DataView]";
var symbolProto = Symbol$1 ? Symbol$1.prototype : void 0, symbolValueOf = symbolProto ? symbolProto.valueOf : void 0;
function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
  switch (tag) {
    case dataViewTag$2:
      if (object.byteLength != other.byteLength || object.byteOffset != other.byteOffset) {
        return false;
      }
      object = object.buffer;
      other = other.buffer;
    case arrayBufferTag$1:
      if (object.byteLength != other.byteLength || !equalFunc(new Uint8Array(object), new Uint8Array(other))) {
        return false;
      }
      return true;
    case boolTag$1:
    case dateTag$1:
    case numberTag$2:
      return eq(+object, +other);
    case errorTag$1:
      return object.name == other.name && object.message == other.message;
    case regexpTag$1:
    case stringTag$1:
      return object == other + "";
    case mapTag$2:
      var convert = mapToArray;
    case setTag$2:
      var isPartial = bitmask & COMPARE_PARTIAL_FLAG$4;
      convert || (convert = setToArray);
      if (object.size != other.size && !isPartial) {
        return false;
      }
      var stacked = stack.get(object);
      if (stacked) {
        return stacked == other;
      }
      bitmask |= COMPARE_UNORDERED_FLAG$2;
      stack.set(object, other);
      var result = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
      stack["delete"](object);
      return result;
    case symbolTag:
      if (symbolValueOf) {
        return symbolValueOf.call(object) == symbolValueOf.call(other);
      }
  }
  return false;
}
function arrayPush(array, values) {
  var index = -1, length = values.length, offset = array.length;
  while (++index < length) {
    array[offset + index] = values[index];
  }
  return array;
}
function baseGetAllKeys(object, keysFunc, symbolsFunc) {
  var result = keysFunc(object);
  return isArray(object) ? result : arrayPush(result, symbolsFunc(object));
}
function arrayFilter(array, predicate) {
  var index = -1, length = array == null ? 0 : array.length, resIndex = 0, result = [];
  while (++index < length) {
    var value = array[index];
    if (predicate(value, index, array)) {
      result[resIndex++] = value;
    }
  }
  return result;
}
function stubArray() {
  return [];
}
var objectProto$6 = Object.prototype;
var propertyIsEnumerable$1 = objectProto$6.propertyIsEnumerable;
var nativeGetSymbols = Object.getOwnPropertySymbols;
var getSymbols = !nativeGetSymbols ? stubArray : function(object) {
  if (object == null) {
    return [];
  }
  object = Object(object);
  return arrayFilter(nativeGetSymbols(object), function(symbol) {
    return propertyIsEnumerable$1.call(object, symbol);
  });
};
function baseTimes(n, iteratee) {
  var index = -1, result = Array(n);
  while (++index < n) {
    result[index] = iteratee(index);
  }
  return result;
}
var argsTag$2 = "[object Arguments]";
function baseIsArguments(value) {
  return isObjectLike(value) && baseGetTag(value) == argsTag$2;
}
var objectProto$5 = Object.prototype;
var hasOwnProperty$4 = objectProto$5.hasOwnProperty;
var propertyIsEnumerable = objectProto$5.propertyIsEnumerable;
var isArguments = baseIsArguments(/* @__PURE__ */ function() {
  return arguments;
}()) ? baseIsArguments : function(value) {
  return isObjectLike(value) && hasOwnProperty$4.call(value, "callee") && !propertyIsEnumerable.call(value, "callee");
};
function stubFalse() {
  return false;
}
var freeExports$1 = typeof exports == "object" && exports && !exports.nodeType && exports;
var freeModule$1 = freeExports$1 && typeof module == "object" && module && !module.nodeType && module;
var moduleExports$1 = freeModule$1 && freeModule$1.exports === freeExports$1;
var Buffer = moduleExports$1 ? root.Buffer : void 0;
var nativeIsBuffer = Buffer ? Buffer.isBuffer : void 0;
var isBuffer$1 = nativeIsBuffer || stubFalse;
var MAX_SAFE_INTEGER$1 = 9007199254740991;
var reIsUint = /^(?:0|[1-9]\d*)$/;
function isIndex(value, length) {
  var type = typeof value;
  length = length == null ? MAX_SAFE_INTEGER$1 : length;
  return !!length && (type == "number" || type != "symbol" && reIsUint.test(value)) && (value > -1 && value % 1 == 0 && value < length);
}
var MAX_SAFE_INTEGER = 9007199254740991;
function isLength(value) {
  return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}
var argsTag$1 = "[object Arguments]", arrayTag$1 = "[object Array]", boolTag = "[object Boolean]", dateTag = "[object Date]", errorTag = "[object Error]", funcTag = "[object Function]", mapTag$1 = "[object Map]", numberTag$1 = "[object Number]", objectTag$2 = "[object Object]", regexpTag = "[object RegExp]", setTag$1 = "[object Set]", stringTag = "[object String]", weakMapTag$1 = "[object WeakMap]";
var arrayBufferTag = "[object ArrayBuffer]", dataViewTag$1 = "[object DataView]", float32Tag = "[object Float32Array]", float64Tag = "[object Float64Array]", int8Tag = "[object Int8Array]", int16Tag = "[object Int16Array]", int32Tag = "[object Int32Array]", uint8Tag = "[object Uint8Array]", uint8ClampedTag = "[object Uint8ClampedArray]", uint16Tag = "[object Uint16Array]", uint32Tag = "[object Uint32Array]";
var typedArrayTags = {};
typedArrayTags[float32Tag] = typedArrayTags[float64Tag] = typedArrayTags[int8Tag] = typedArrayTags[int16Tag] = typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] = typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] = typedArrayTags[uint32Tag] = true;
typedArrayTags[argsTag$1] = typedArrayTags[arrayTag$1] = typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] = typedArrayTags[dataViewTag$1] = typedArrayTags[dateTag] = typedArrayTags[errorTag] = typedArrayTags[funcTag] = typedArrayTags[mapTag$1] = typedArrayTags[numberTag$1] = typedArrayTags[objectTag$2] = typedArrayTags[regexpTag] = typedArrayTags[setTag$1] = typedArrayTags[stringTag] = typedArrayTags[weakMapTag$1] = false;
function baseIsTypedArray(value) {
  return isObjectLike(value) && isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
}
function baseUnary(func) {
  return function(value) {
    return func(value);
  };
}
var freeExports = typeof exports == "object" && exports && !exports.nodeType && exports;
var freeModule = freeExports && typeof module == "object" && module && !module.nodeType && module;
var moduleExports = freeModule && freeModule.exports === freeExports;
var freeProcess = moduleExports && freeGlobal.process;
var nodeUtil = function() {
  try {
    var types = freeModule && freeModule.require && freeModule.require("util").types;
    if (types) {
      return types;
    }
    return freeProcess && freeProcess.binding && freeProcess.binding("util");
  } catch (e) {
  }
}();
var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;
var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;
var objectProto$4 = Object.prototype;
var hasOwnProperty$3 = objectProto$4.hasOwnProperty;
function arrayLikeKeys(value, inherited) {
  var isArr = isArray(value), isArg = !isArr && isArguments(value), isBuff = !isArr && !isArg && isBuffer$1(value), isType = !isArr && !isArg && !isBuff && isTypedArray(value), skipIndexes = isArr || isArg || isBuff || isType, result = skipIndexes ? baseTimes(value.length, String) : [], length = result.length;
  for (var key in value) {
    if (hasOwnProperty$3.call(value, key) && !(skipIndexes && // Safari 9 has enumerable `arguments.length` in strict mode.
    (key == "length" || // Node.js 0.10 has enumerable non-index properties on buffers.
    isBuff && (key == "offset" || key == "parent") || // PhantomJS 2 has enumerable non-index properties on typed arrays.
    isType && (key == "buffer" || key == "byteLength" || key == "byteOffset") || // Skip index properties.
    isIndex(key, length)))) {
      result.push(key);
    }
  }
  return result;
}
var objectProto$3 = Object.prototype;
function isPrototype(value) {
  var Ctor = value && value.constructor, proto = typeof Ctor == "function" && Ctor.prototype || objectProto$3;
  return value === proto;
}
function overArg(func, transform) {
  return function(arg) {
    return func(transform(arg));
  };
}
var nativeKeys = overArg(Object.keys, Object);
var objectProto$2 = Object.prototype;
var hasOwnProperty$2 = objectProto$2.hasOwnProperty;
function baseKeys(object) {
  if (!isPrototype(object)) {
    return nativeKeys(object);
  }
  var result = [];
  for (var key in Object(object)) {
    if (hasOwnProperty$2.call(object, key) && key != "constructor") {
      result.push(key);
    }
  }
  return result;
}
function isArrayLike(value) {
  return value != null && isLength(value.length) && !isFunction(value);
}
function keys(object) {
  return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
}
function getAllKeys(object) {
  return baseGetAllKeys(object, keys, getSymbols);
}
var COMPARE_PARTIAL_FLAG$3 = 1;
var objectProto$1 = Object.prototype;
var hasOwnProperty$1 = objectProto$1.hasOwnProperty;
function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG$3, objProps = getAllKeys(object), objLength = objProps.length, othProps = getAllKeys(other), othLength = othProps.length;
  if (objLength != othLength && !isPartial) {
    return false;
  }
  var index = objLength;
  while (index--) {
    var key = objProps[index];
    if (!(isPartial ? key in other : hasOwnProperty$1.call(other, key))) {
      return false;
    }
  }
  var objStacked = stack.get(object);
  var othStacked = stack.get(other);
  if (objStacked && othStacked) {
    return objStacked == other && othStacked == object;
  }
  var result = true;
  stack.set(object, other);
  stack.set(other, object);
  var skipCtor = isPartial;
  while (++index < objLength) {
    key = objProps[index];
    var objValue = object[key], othValue = other[key];
    if (customizer) {
      var compared = isPartial ? customizer(othValue, objValue, key, other, object, stack) : customizer(objValue, othValue, key, object, other, stack);
    }
    if (!(compared === void 0 ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack) : compared)) {
      result = false;
      break;
    }
    skipCtor || (skipCtor = key == "constructor");
  }
  if (result && !skipCtor) {
    var objCtor = object.constructor, othCtor = other.constructor;
    if (objCtor != othCtor && ("constructor" in object && "constructor" in other) && !(typeof objCtor == "function" && objCtor instanceof objCtor && typeof othCtor == "function" && othCtor instanceof othCtor)) {
      result = false;
    }
  }
  stack["delete"](object);
  stack["delete"](other);
  return result;
}
var DataView = getNative(root, "DataView");
var Promise$1 = getNative(root, "Promise");
var Set$1 = getNative(root, "Set");
var WeakMap = getNative(root, "WeakMap");
var mapTag = "[object Map]", objectTag$1 = "[object Object]", promiseTag = "[object Promise]", setTag = "[object Set]", weakMapTag = "[object WeakMap]";
var dataViewTag = "[object DataView]";
var dataViewCtorString = toSource(DataView), mapCtorString = toSource(Map$1), promiseCtorString = toSource(Promise$1), setCtorString = toSource(Set$1), weakMapCtorString = toSource(WeakMap);
var getTag = baseGetTag;
if (DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag || Map$1 && getTag(new Map$1()) != mapTag || Promise$1 && getTag(Promise$1.resolve()) != promiseTag || Set$1 && getTag(new Set$1()) != setTag || WeakMap && getTag(new WeakMap()) != weakMapTag) {
  getTag = function(value) {
    var result = baseGetTag(value), Ctor = result == objectTag$1 ? value.constructor : void 0, ctorString = Ctor ? toSource(Ctor) : "";
    if (ctorString) {
      switch (ctorString) {
        case dataViewCtorString:
          return dataViewTag;
        case mapCtorString:
          return mapTag;
        case promiseCtorString:
          return promiseTag;
        case setCtorString:
          return setTag;
        case weakMapCtorString:
          return weakMapTag;
      }
    }
    return result;
  };
}
var COMPARE_PARTIAL_FLAG$2 = 1;
var argsTag = "[object Arguments]", arrayTag = "[object Array]", objectTag = "[object Object]";
var objectProto = Object.prototype;
var hasOwnProperty = objectProto.hasOwnProperty;
function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
  var objIsArr = isArray(object), othIsArr = isArray(other), objTag = objIsArr ? arrayTag : getTag(object), othTag = othIsArr ? arrayTag : getTag(other);
  objTag = objTag == argsTag ? objectTag : objTag;
  othTag = othTag == argsTag ? objectTag : othTag;
  var objIsObj = objTag == objectTag, othIsObj = othTag == objectTag, isSameTag = objTag == othTag;
  if (isSameTag && isBuffer$1(object)) {
    if (!isBuffer$1(other)) {
      return false;
    }
    objIsArr = true;
    objIsObj = false;
  }
  if (isSameTag && !objIsObj) {
    stack || (stack = new Stack());
    return objIsArr || isTypedArray(object) ? equalArrays(object, other, bitmask, customizer, equalFunc, stack) : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
  }
  if (!(bitmask & COMPARE_PARTIAL_FLAG$2)) {
    var objIsWrapped = objIsObj && hasOwnProperty.call(object, "__wrapped__"), othIsWrapped = othIsObj && hasOwnProperty.call(other, "__wrapped__");
    if (objIsWrapped || othIsWrapped) {
      var objUnwrapped = objIsWrapped ? object.value() : object, othUnwrapped = othIsWrapped ? other.value() : other;
      stack || (stack = new Stack());
      return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
    }
  }
  if (!isSameTag) {
    return false;
  }
  stack || (stack = new Stack());
  return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
}
function baseIsEqual(value, other, bitmask, customizer, stack) {
  if (value === other) {
    return true;
  }
  if (value == null || other == null || !isObjectLike(value) && !isObjectLike(other)) {
    return value !== value && other !== other;
  }
  return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
}
var COMPARE_PARTIAL_FLAG$1 = 1, COMPARE_UNORDERED_FLAG$1 = 2;
function baseIsMatch(object, source, matchData, customizer) {
  var index = matchData.length, length = index;
  if (object == null) {
    return !length;
  }
  object = Object(object);
  while (index--) {
    var data = matchData[index];
    if (data[2] ? data[1] !== object[data[0]] : !(data[0] in object)) {
      return false;
    }
  }
  while (++index < length) {
    data = matchData[index];
    var key = data[0], objValue = object[key], srcValue = data[1];
    if (data[2]) {
      if (objValue === void 0 && !(key in object)) {
        return false;
      }
    } else {
      var stack = new Stack();
      var result;
      if (!(result === void 0 ? baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG$1 | COMPARE_UNORDERED_FLAG$1, customizer, stack) : result)) {
        return false;
      }
    }
  }
  return true;
}
function isStrictComparable(value) {
  return value === value && !isObject(value);
}
function getMatchData(object) {
  var result = keys(object), length = result.length;
  while (length--) {
    var key = result[length], value = object[key];
    result[length] = [key, value, isStrictComparable(value)];
  }
  return result;
}
function matchesStrictComparable(key, srcValue) {
  return function(object) {
    if (object == null) {
      return false;
    }
    return object[key] === srcValue && (srcValue !== void 0 || key in Object(object));
  };
}
function baseMatches(source) {
  var matchData = getMatchData(source);
  if (matchData.length == 1 && matchData[0][2]) {
    return matchesStrictComparable(matchData[0][0], matchData[0][1]);
  }
  return function(object) {
    return object === source || baseIsMatch(object, source, matchData);
  };
}
var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, reIsPlainProp = /^\w*$/;
function isKey(value, object) {
  if (isArray(value)) {
    return false;
  }
  var type = typeof value;
  if (type == "number" || type == "symbol" || type == "boolean" || value == null || isSymbol(value)) {
    return true;
  }
  return reIsPlainProp.test(value) || !reIsDeepProp.test(value) || object != null && value in Object(object);
}
var FUNC_ERROR_TEXT = "Expected a function";
function memoize(func, resolver) {
  if (typeof func != "function" || resolver != null && typeof resolver != "function") {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  var memoized = function() {
    var args = arguments, key = resolver ? resolver.apply(this, args) : args[0], cache = memoized.cache;
    if (cache.has(key)) {
      return cache.get(key);
    }
    var result = func.apply(this, args);
    memoized.cache = cache.set(key, result) || cache;
    return result;
  };
  memoized.cache = new (memoize.Cache || MapCache)();
  return memoized;
}
memoize.Cache = MapCache;
var MAX_MEMOIZE_SIZE = 500;
function memoizeCapped(func) {
  var result = memoize(func, function(key) {
    if (cache.size === MAX_MEMOIZE_SIZE) {
      cache.clear();
    }
    return key;
  });
  var cache = result.cache;
  return result;
}
var rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
var reEscapeChar = /\\(\\)?/g;
var stringToPath = memoizeCapped(function(string) {
  var result = [];
  if (string.charCodeAt(0) === 46) {
    result.push("");
  }
  string.replace(rePropName, function(match, number, quote, subString) {
    result.push(quote ? subString.replace(reEscapeChar, "$1") : number || match);
  });
  return result;
});
function castPath(value, object) {
  if (isArray(value)) {
    return value;
  }
  return isKey(value, object) ? [value] : stringToPath(toString(value));
}
function toKey(value) {
  if (typeof value == "string" || isSymbol(value)) {
    return value;
  }
  var result = value + "";
  return result == "0" && 1 / value == -Infinity ? "-0" : result;
}
function baseGet(object, path) {
  path = castPath(path, object);
  var index = 0, length = path.length;
  while (object != null && index < length) {
    object = object[toKey(path[index++])];
  }
  return index && index == length ? object : void 0;
}
function get(object, path, defaultValue) {
  var result = object == null ? void 0 : baseGet(object, path);
  return result === void 0 ? defaultValue : result;
}
function baseHasIn(object, key) {
  return object != null && key in Object(object);
}
function hasPath(object, path, hasFunc) {
  path = castPath(path, object);
  var index = -1, length = path.length, result = false;
  while (++index < length) {
    var key = toKey(path[index]);
    if (!(result = object != null && hasFunc(object, key))) {
      break;
    }
    object = object[key];
  }
  if (result || ++index != length) {
    return result;
  }
  length = object == null ? 0 : object.length;
  return !!length && isLength(length) && isIndex(key, length) && (isArray(object) || isArguments(object));
}
function hasIn(object, path) {
  return object != null && hasPath(object, path, baseHasIn);
}
var COMPARE_PARTIAL_FLAG = 1, COMPARE_UNORDERED_FLAG = 2;
function baseMatchesProperty(path, srcValue) {
  if (isKey(path) && isStrictComparable(srcValue)) {
    return matchesStrictComparable(toKey(path), srcValue);
  }
  return function(object) {
    var objValue = get(object, path);
    return objValue === void 0 && objValue === srcValue ? hasIn(object, path) : baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG);
  };
}
function identity(value) {
  return value;
}
function baseProperty(key) {
  return function(object) {
    return object == null ? void 0 : object[key];
  };
}
function basePropertyDeep(path) {
  return function(object) {
    return baseGet(object, path);
  };
}
function property(path) {
  return isKey(path) ? baseProperty(toKey(path)) : basePropertyDeep(path);
}
function baseIteratee(value) {
  if (typeof value == "function") {
    return value;
  }
  if (value == null) {
    return identity;
  }
  if (typeof value == "object") {
    return isArray(value) ? baseMatchesProperty(value[0], value[1]) : baseMatches(value);
  }
  return property(value);
}
function baseSum(array, iteratee) {
  var result, index = -1, length = array.length;
  while (++index < length) {
    var current = iteratee(array[index]);
    if (current !== void 0) {
      result = result === void 0 ? current : result + current;
    }
  }
  return result;
}
function sumBy(array, iteratee) {
  return array && array.length ? baseSum(array, baseIteratee(iteratee)) : 0;
}
function linkTypeOrder(G2, u) {
  const incoming = G2.inEdges(u);
  const outgoing = G2.outEdges(u);
  const edgesByType = /* @__PURE__ */ new Map();
  [...incoming, ...outgoing].forEach((e) => {
    if (!edgesByType.has(e.name)) {
      edgesByType.set(e.name, []);
    }
    edgesByType.get(e.name).push(e);
  });
  const dirs = new Map(
    Array.from(edgesByType.entries()).map(([k, v]) => {
      const total = sumBy(v, (e) => G2.edge(e).value);
      const wdirs = sumBy(v, (e) => G2.edge(e).value * otherY(e));
      return [k, wdirs / total];
    })
  );
  const mo = Array.from(dirs.keys());
  mo.sort();
  return mo;
  function otherY(e) {
    if (e.v === u)
      return G2.node(e.w).y;
    if (e.w === u)
      return G2.node(e.v).y;
    throw new Error();
  }
}
function orderEdges(G2, { alignLinkTypes = false } = {}) {
  G2.nodes().forEach((u) => {
    const node = G2.node(u);
    node.incoming = G2.inEdges(u);
    node.outgoing = G2.outEdges(u);
    if (alignLinkTypes) {
      const mo = linkTypeOrder(G2, u);
      node.incoming.sort(compareDirectionGroupingTypes(G2, mo, false));
      node.outgoing.sort(compareDirectionGroupingTypes(G2, mo, true));
    } else {
      node.incoming.sort(compareDirection(G2, false));
      node.outgoing.sort(compareDirection(G2, true));
    }
  });
}
function compareDirection(G2, clockwise = true) {
  return function(a, b) {
    const da = linkDirection(G2, a);
    const db = linkDirection(G2, b);
    const c = clockwise ? 1 : -1;
    if (a.v === b.v && a.w === b.w) {
      if (typeof a.name === "number" && typeof b.name === "number") {
        return a.name - b.name;
      } else if (typeof a.name === "string" && typeof b.name === "string") {
        return a.name.localeCompare(b.name);
      }
      return 0;
    }
    if (Math.abs(da - db) < 1e-3) {
      if (a.v && a.w && b.v && b.w) {
        if (a.w === b.w) {
          return -1 * (G2.node(a.v).y - G2.node(b.v).y);
        } else if (a.v === b.v) {
          return -1 * (G2.node(a.w).y - G2.node(b.w).y);
        }
        return 0;
      }
      return 0;
    }
    return c * (da - db);
  };
}
function compareDirectionGroupingTypes(G2, mo, clockwise = true) {
  return function(a, b) {
    if (a.name !== b.name) {
      return mo.indexOf(a.name) - mo.indexOf(b.name);
    }
    const da = linkDirection(G2, a);
    const db = linkDirection(G2, b);
    const c = clockwise ? 1 : -1;
    if (Math.abs(da - db) < 1e-3) {
      if (a.v && a.w && b.v && b.w) {
        if (a.w === b.w) {
          return c * (da > 0 ? -1 : 1) * (G2.node(a.v).y - G2.node(b.v).y);
        } else if (a.v === b.v) {
          return c * (da > 0 ? -1 : 1) * (G2.node(a.w).y - G2.node(b.w).y);
        }
        return 0;
      }
      return 0;
    }
    return c * (da - db);
  };
}
function findFirst(links, p) {
  let jmid = null;
  for (let j = 0; j < links.length; ++j) {
    if (p(links[j])) {
      jmid = j;
      break;
    }
  }
  return jmid;
}
function sweepCurvatureInwards(links, rr) {
  if (links.length === 0)
    return;
  let h, Rmin = 0;
  for (let i = links.length - 1; i >= 0; --i) {
    h = links[i].dy / 2;
    if (links[i][rr] - h < Rmin) {
      links[i][rr] = Math.min(links[i].Rmax, Rmin + h);
    }
    Rmin = links[i][rr] + h;
  }
  let Rmax = links[0].Rmax + links[0].dy / 2;
  for (let i = 0; i < links.length; ++i) {
    h = links[i].dy / 2;
    if (links[i][rr] + h > Rmax) {
      links[i][rr] = Math.max(h, Rmax - h);
    }
    Rmax = links[i][rr] - h;
  }
}
function addLinkEndpoints(G2) {
  G2.edges().forEach((e) => {
    const edge = G2.edge(e);
    edge.points.unshift({ d: edge.d0, ro: edge.r0, x: edge.x0, y: edge.y0 });
    edge.points.push({ d: edge.d1, ri: edge.r1, x: edge.x1, y: edge.y1 });
  });
}
function linkLayout(options) {
  function layout(G2) {
    setEdgeEndpoints(G2, options);
    setEdgeCurvatures(G2);
    const edges = [];
    G2.edges().forEach((e) => {
      const edge = G2.edge(e);
      edge.id = `${e.v}-${e.w}-${e.name}`;
      edges.push(edge);
    });
    return edges;
  }
  return layout;
}
function setEdgeEndpoints(G2, options) {
  G2.nodes().forEach((u) => {
    const node = G2.node(u);
    let sy = 0;
    let ty = 0;
    node.outgoing.forEach((e) => {
      const edge = G2.edge(e);
      edge.x0 = node.x + options.nodeWidth / 2;
      edge.y0 = node.y + sy + edge.dy / 2;
      edge.d0 = node.direction || "r";
      sy += edge.dy;
    });
    node.incoming.forEach((e) => {
      const edge = G2.edge(e);
      edge.x1 = node.x - options.nodeWidth / 2;
      edge.y1 = node.y + ty + edge.dy / 2;
      edge.d1 = node.direction || "r";
      ty += edge.dy;
    });
  });
}
function setEdgeCurvatures(G2) {
  G2.nodes().forEach((u) => {
    const node = G2.node(u);
    const outgoing = node.outgoing.map((e) => G2.edge(e));
    const incoming = node.incoming.map((e) => G2.edge(e));
    outgoing.sort((a, b) => a.y0 - b.y0);
    incoming.sort((a, b) => a.y1 - b.y1);
    setEdgeEndCurvatures(outgoing, "r0");
    setEdgeEndCurvatures(incoming, "r1");
  });
}
function maximumRadiusOfCurvature(link) {
  const Dx = link.x1 - link.x0;
  const Dy = link.y1 - link.y0;
  if (link.d0 !== link.d1) {
    return Math.abs(Dy) / 2.1;
  }
  return Dy !== 0 ? (Dx * Dx + Dy * Dy) / Math.abs(4 * Dy) : Infinity;
}
function setEdgeEndCurvatures(edges, rr) {
  edges.forEach((edge) => {
    edge.Rmax = maximumRadiusOfCurvature(edge);
    edge[rr] = Math.max(edge.dy / 2, edge.d0 === edge.d1 ? edge.Rmax * 0.6 : 5 + edge.dy / 2);
  });
  let jmid = rr === "r0" ? findFirst(edges, (f) => f.y1 > f.y0) : findFirst(edges, (f) => f.y0 > f.y1);
  if (jmid === null)
    jmid = edges.length;
  sweepCurvatureInwards(edges.slice(jmid), rr);
  if (jmid > 0) {
    const edges2 = [];
    for (let j = jmid - 1; j >= 0; j--)
      edges2.push(edges[j]);
    sweepCurvatureInwards(edges2, rr);
  }
}
function addDummyNodes(G2) {
  G2.edges().forEach((e) => {
    const V = G2.node(e.v);
    const W = G2.node(e.w);
    const edge = G2.edge(e);
    let r = V.rank;
    const dummyRanks = [];
    if (r + 1 <= W.rank) {
      if (V.direction === "l")
        dummyRanks.push(r);
      while (++r < W.rank) {
        dummyRanks.push(r);
      }
      if (W.direction === "l")
        dummyRanks.push(r);
      replaceEdge(G2, e, edge, dummyRanks, "r");
    } else if (r > W.rank) {
      if (V.direction !== "l")
        dummyRanks.push(r);
      while (r-- > W.rank + 1) {
        dummyRanks.push(r);
      }
      if (W.direction !== "l")
        dummyRanks.push(r);
      replaceEdge(G2, e, edge, dummyRanks, "l");
    }
  });
  return G2;
}
function replaceEdge(G2, oldEdge, oldLabel, dummyRanks, direction) {
  if (dummyRanks.length === 0)
    return;
  const dummies = dummyRanks.map((r) => {
    const id = `__${oldEdge.v}_${oldEdge.w}_${r}`;
    G2.setNode(id, { data: null, direction, dummy: true, rank: r });
    return id;
  });
  const nn = [oldEdge.v, ...dummies, oldEdge.w];
  nn.forEach((n, i) => {
    if (i + 1 < nn.length)
      G2.setEdge(
        nn[i],
        nn[i + 1],
        {
          data: G2.edge(oldEdge).data,
          origEdge: oldEdge,
          origLabel: oldLabel,
          source: G2.node(oldEdge.v),
          target: G2.node(oldEdge.w),
          value: G2.edge(oldEdge).value
        },
        oldEdge.name
      );
  });
  G2.removeEdge(oldEdge);
}
function removeDummyNodes(G2) {
  const dummyNodes = G2.nodes().filter((node) => node.startsWith("__"));
  dummyNodes.forEach((dNode) => {
    var _a;
    let node = G2.node(dNode);
    if (!node)
      return;
    let dummyEdges = ((_a = G2.inEdges(dNode)) == null ? void 0 : _a.map((e) => G2.edge(e))) || [];
    dummyEdges.forEach((dummyEdge) => {
      dummyEdge.origLabel.dy = dummyEdge.dy;
      dummyEdge.origLabel.x0 = dummyEdge.x0;
      dummyEdge.origLabel.y0 = dummyEdge.y0;
      dummyEdge.origLabel.r0 = dummyEdge.r0;
      dummyEdge.origLabel.d0 = dummyEdge.d0;
      dummyEdge.origLabel.value = dummyEdge.value;
      G2.setEdge(dummyEdge.origEdge, dummyEdge.origLabel);
    });
    let r1s = dummyEdges.map((dummyEdge) => dummyEdge.r1);
    let w;
    while (node.dummy) {
      dummyEdges = G2.outEdges(dNode).map((e) => G2.edge(e));
      dummyEdges.forEach((dummyEdge, i) => {
        if (!dummyEdge.origLabel.points) {
          dummyEdge.origLabel["points"] = [];
        }
        dummyEdge.origLabel.points.push({
          d: dummyEdge.d0,
          r0: dummyEdge.r0,
          r1: r1s[i],
          // from last edge
          x: node.x,
          y: dummyEdge.y0
        });
      });
      r1s = dummyEdges.map((dummyEdge) => dummyEdge.r1);
      w = G2.successors(dNode)[0];
      G2.removeNode(dNode);
      node = G2.node(dNode = w);
    }
    dummyEdges.forEach((dummyEdge) => {
      dummyEdge.origLabel.x1 = dummyEdge.x1;
      dummyEdge.origLabel.y1 = dummyEdge.y1;
      dummyEdge.origLabel.r1 = dummyEdge.r1;
      dummyEdge.origLabel.d1 = dummyEdge.d1;
    });
  });
}
function countCrossings(G2, orderA, orderB) {
  return countBetweenCrossings(G2, orderA, orderB);
}
function countBetweenCrossings(G2, orderA, orderB) {
  let north, q, south;
  if (orderA.length > orderB.length) {
    north = orderA;
    south = orderB;
  } else {
    north = orderB;
    south = orderA;
  }
  const southSeq = [];
  north.forEach((u) => {
    south.forEach((v, j) => {
      if (G2.hasEdge(u, v) || G2.hasEdge(v, u))
        southSeq.push(j);
    });
  });
  let firstIndex = 1;
  while (firstIndex < q)
    firstIndex *= 2;
  const treeSize = 2 * firstIndex - 1;
  firstIndex -= 1;
  const tree = new Array(treeSize);
  for (let i = 0; i < treeSize; i++)
    tree[i] = 0;
  let count = 0;
  southSeq.forEach((k) => {
    let index = k + firstIndex;
    tree[index]++;
    while (index > 0) {
      if (index % 2)
        count += tree[index + 1];
      index = Math.floor((index - 1) / 2);
      tree[index]++;
    }
  });
  return count;
}
var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
function getDefaultExportFromCjs(x) {
  return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, "default") ? x["default"] : x;
}
function commonjsRequire(path) {
  throw new Error('Could not dynamically require "' + path + '". Please configure the dynamicRequireTargets or/and ignoreDynamicRequires option of @rollup/plugin-commonjs appropriately for this require call to work.');
}
var _listCacheClear;
var hasRequired_listCacheClear;
function require_listCacheClear() {
  if (hasRequired_listCacheClear)
    return _listCacheClear;
  hasRequired_listCacheClear = 1;
  function listCacheClear2() {
    this.__data__ = [];
    this.size = 0;
  }
  _listCacheClear = listCacheClear2;
  return _listCacheClear;
}
var eq_1;
var hasRequiredEq;
function requireEq() {
  if (hasRequiredEq)
    return eq_1;
  hasRequiredEq = 1;
  function eq2(value, other) {
    return value === other || value !== value && other !== other;
  }
  eq_1 = eq2;
  return eq_1;
}
var _assocIndexOf;
var hasRequired_assocIndexOf;
function require_assocIndexOf() {
  if (hasRequired_assocIndexOf)
    return _assocIndexOf;
  hasRequired_assocIndexOf = 1;
  var eq2 = requireEq();
  function assocIndexOf2(array, key) {
    var length = array.length;
    while (length--) {
      if (eq2(array[length][0], key)) {
        return length;
      }
    }
    return -1;
  }
  _assocIndexOf = assocIndexOf2;
  return _assocIndexOf;
}
var _listCacheDelete;
var hasRequired_listCacheDelete;
function require_listCacheDelete() {
  if (hasRequired_listCacheDelete)
    return _listCacheDelete;
  hasRequired_listCacheDelete = 1;
  var assocIndexOf2 = require_assocIndexOf();
  var arrayProto2 = Array.prototype;
  var splice2 = arrayProto2.splice;
  function listCacheDelete2(key) {
    var data = this.__data__, index = assocIndexOf2(data, key);
    if (index < 0) {
      return false;
    }
    var lastIndex = data.length - 1;
    if (index == lastIndex) {
      data.pop();
    } else {
      splice2.call(data, index, 1);
    }
    --this.size;
    return true;
  }
  _listCacheDelete = listCacheDelete2;
  return _listCacheDelete;
}
var _listCacheGet;
var hasRequired_listCacheGet;
function require_listCacheGet() {
  if (hasRequired_listCacheGet)
    return _listCacheGet;
  hasRequired_listCacheGet = 1;
  var assocIndexOf2 = require_assocIndexOf();
  function listCacheGet2(key) {
    var data = this.__data__, index = assocIndexOf2(data, key);
    return index < 0 ? void 0 : data[index][1];
  }
  _listCacheGet = listCacheGet2;
  return _listCacheGet;
}
var _listCacheHas;
var hasRequired_listCacheHas;
function require_listCacheHas() {
  if (hasRequired_listCacheHas)
    return _listCacheHas;
  hasRequired_listCacheHas = 1;
  var assocIndexOf2 = require_assocIndexOf();
  function listCacheHas2(key) {
    return assocIndexOf2(this.__data__, key) > -1;
  }
  _listCacheHas = listCacheHas2;
  return _listCacheHas;
}
var _listCacheSet;
var hasRequired_listCacheSet;
function require_listCacheSet() {
  if (hasRequired_listCacheSet)
    return _listCacheSet;
  hasRequired_listCacheSet = 1;
  var assocIndexOf2 = require_assocIndexOf();
  function listCacheSet2(key, value) {
    var data = this.__data__, index = assocIndexOf2(data, key);
    if (index < 0) {
      ++this.size;
      data.push([key, value]);
    } else {
      data[index][1] = value;
    }
    return this;
  }
  _listCacheSet = listCacheSet2;
  return _listCacheSet;
}
var _ListCache;
var hasRequired_ListCache;
function require_ListCache() {
  if (hasRequired_ListCache)
    return _ListCache;
  hasRequired_ListCache = 1;
  var listCacheClear2 = require_listCacheClear(), listCacheDelete2 = require_listCacheDelete(), listCacheGet2 = require_listCacheGet(), listCacheHas2 = require_listCacheHas(), listCacheSet2 = require_listCacheSet();
  function ListCache2(entries) {
    var index = -1, length = entries == null ? 0 : entries.length;
    this.clear();
    while (++index < length) {
      var entry = entries[index];
      this.set(entry[0], entry[1]);
    }
  }
  ListCache2.prototype.clear = listCacheClear2;
  ListCache2.prototype["delete"] = listCacheDelete2;
  ListCache2.prototype.get = listCacheGet2;
  ListCache2.prototype.has = listCacheHas2;
  ListCache2.prototype.set = listCacheSet2;
  _ListCache = ListCache2;
  return _ListCache;
}
var _stackClear;
var hasRequired_stackClear;
function require_stackClear() {
  if (hasRequired_stackClear)
    return _stackClear;
  hasRequired_stackClear = 1;
  var ListCache2 = require_ListCache();
  function stackClear2() {
    this.__data__ = new ListCache2();
    this.size = 0;
  }
  _stackClear = stackClear2;
  return _stackClear;
}
var _stackDelete;
var hasRequired_stackDelete;
function require_stackDelete() {
  if (hasRequired_stackDelete)
    return _stackDelete;
  hasRequired_stackDelete = 1;
  function stackDelete2(key) {
    var data = this.__data__, result = data["delete"](key);
    this.size = data.size;
    return result;
  }
  _stackDelete = stackDelete2;
  return _stackDelete;
}
var _stackGet;
var hasRequired_stackGet;
function require_stackGet() {
  if (hasRequired_stackGet)
    return _stackGet;
  hasRequired_stackGet = 1;
  function stackGet2(key) {
    return this.__data__.get(key);
  }
  _stackGet = stackGet2;
  return _stackGet;
}
var _stackHas;
var hasRequired_stackHas;
function require_stackHas() {
  if (hasRequired_stackHas)
    return _stackHas;
  hasRequired_stackHas = 1;
  function stackHas2(key) {
    return this.__data__.has(key);
  }
  _stackHas = stackHas2;
  return _stackHas;
}
var _freeGlobal;
var hasRequired_freeGlobal;
function require_freeGlobal() {
  if (hasRequired_freeGlobal)
    return _freeGlobal;
  hasRequired_freeGlobal = 1;
  var freeGlobal2 = typeof commonjsGlobal == "object" && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;
  _freeGlobal = freeGlobal2;
  return _freeGlobal;
}
var _root;
var hasRequired_root;
function require_root() {
  if (hasRequired_root)
    return _root;
  hasRequired_root = 1;
  var freeGlobal2 = require_freeGlobal();
  var freeSelf2 = typeof self == "object" && self && self.Object === Object && self;
  var root2 = freeGlobal2 || freeSelf2 || Function("return this")();
  _root = root2;
  return _root;
}
var _Symbol;
var hasRequired_Symbol;
function require_Symbol() {
  if (hasRequired_Symbol)
    return _Symbol;
  hasRequired_Symbol = 1;
  var root2 = require_root();
  var Symbol = root2.Symbol;
  _Symbol = Symbol;
  return _Symbol;
}
var _getRawTag;
var hasRequired_getRawTag;
function require_getRawTag() {
  if (hasRequired_getRawTag)
    return _getRawTag;
  hasRequired_getRawTag = 1;
  var Symbol = require_Symbol();
  var objectProto2 = Object.prototype;
  var hasOwnProperty2 = objectProto2.hasOwnProperty;
  var nativeObjectToString2 = objectProto2.toString;
  var symToStringTag2 = Symbol ? Symbol.toStringTag : void 0;
  function getRawTag2(value) {
    var isOwn = hasOwnProperty2.call(value, symToStringTag2), tag = value[symToStringTag2];
    try {
      value[symToStringTag2] = void 0;
      var unmasked = true;
    } catch (e) {
    }
    var result = nativeObjectToString2.call(value);
    if (unmasked) {
      if (isOwn) {
        value[symToStringTag2] = tag;
      } else {
        delete value[symToStringTag2];
      }
    }
    return result;
  }
  _getRawTag = getRawTag2;
  return _getRawTag;
}
var _objectToString;
var hasRequired_objectToString;
function require_objectToString() {
  if (hasRequired_objectToString)
    return _objectToString;
  hasRequired_objectToString = 1;
  var objectProto2 = Object.prototype;
  var nativeObjectToString2 = objectProto2.toString;
  function objectToString2(value) {
    return nativeObjectToString2.call(value);
  }
  _objectToString = objectToString2;
  return _objectToString;
}
var _baseGetTag;
var hasRequired_baseGetTag;
function require_baseGetTag() {
  if (hasRequired_baseGetTag)
    return _baseGetTag;
  hasRequired_baseGetTag = 1;
  var Symbol = require_Symbol(), getRawTag2 = require_getRawTag(), objectToString2 = require_objectToString();
  var nullTag2 = "[object Null]", undefinedTag2 = "[object Undefined]";
  var symToStringTag2 = Symbol ? Symbol.toStringTag : void 0;
  function baseGetTag2(value) {
    if (value == null) {
      return value === void 0 ? undefinedTag2 : nullTag2;
    }
    return symToStringTag2 && symToStringTag2 in Object(value) ? getRawTag2(value) : objectToString2(value);
  }
  _baseGetTag = baseGetTag2;
  return _baseGetTag;
}
var isObject_1;
var hasRequiredIsObject;
function requireIsObject() {
  if (hasRequiredIsObject)
    return isObject_1;
  hasRequiredIsObject = 1;
  function isObject2(value) {
    var type = typeof value;
    return value != null && (type == "object" || type == "function");
  }
  isObject_1 = isObject2;
  return isObject_1;
}
var isFunction_1;
var hasRequiredIsFunction;
function requireIsFunction() {
  if (hasRequiredIsFunction)
    return isFunction_1;
  hasRequiredIsFunction = 1;
  var baseGetTag2 = require_baseGetTag(), isObject2 = requireIsObject();
  var asyncTag2 = "[object AsyncFunction]", funcTag2 = "[object Function]", genTag2 = "[object GeneratorFunction]", proxyTag2 = "[object Proxy]";
  function isFunction2(value) {
    if (!isObject2(value)) {
      return false;
    }
    var tag = baseGetTag2(value);
    return tag == funcTag2 || tag == genTag2 || tag == asyncTag2 || tag == proxyTag2;
  }
  isFunction_1 = isFunction2;
  return isFunction_1;
}
var _coreJsData;
var hasRequired_coreJsData;
function require_coreJsData() {
  if (hasRequired_coreJsData)
    return _coreJsData;
  hasRequired_coreJsData = 1;
  var root2 = require_root();
  var coreJsData2 = root2["__core-js_shared__"];
  _coreJsData = coreJsData2;
  return _coreJsData;
}
var _isMasked;
var hasRequired_isMasked;
function require_isMasked() {
  if (hasRequired_isMasked)
    return _isMasked;
  hasRequired_isMasked = 1;
  var coreJsData2 = require_coreJsData();
  var maskSrcKey2 = function() {
    var uid = /[^.]+$/.exec(coreJsData2 && coreJsData2.keys && coreJsData2.keys.IE_PROTO || "");
    return uid ? "Symbol(src)_1." + uid : "";
  }();
  function isMasked2(func) {
    return !!maskSrcKey2 && maskSrcKey2 in func;
  }
  _isMasked = isMasked2;
  return _isMasked;
}
var _toSource;
var hasRequired_toSource;
function require_toSource() {
  if (hasRequired_toSource)
    return _toSource;
  hasRequired_toSource = 1;
  var funcProto2 = Function.prototype;
  var funcToString2 = funcProto2.toString;
  function toSource2(func) {
    if (func != null) {
      try {
        return funcToString2.call(func);
      } catch (e) {
      }
      try {
        return func + "";
      } catch (e) {
      }
    }
    return "";
  }
  _toSource = toSource2;
  return _toSource;
}
var _baseIsNative;
var hasRequired_baseIsNative;
function require_baseIsNative() {
  if (hasRequired_baseIsNative)
    return _baseIsNative;
  hasRequired_baseIsNative = 1;
  var isFunction2 = requireIsFunction(), isMasked2 = require_isMasked(), isObject2 = requireIsObject(), toSource2 = require_toSource();
  var reRegExpChar2 = /[\\^$.*+?()[\]{}|]/g;
  var reIsHostCtor2 = /^\[object .+?Constructor\]$/;
  var funcProto2 = Function.prototype, objectProto2 = Object.prototype;
  var funcToString2 = funcProto2.toString;
  var hasOwnProperty2 = objectProto2.hasOwnProperty;
  var reIsNative2 = RegExp(
    "^" + funcToString2.call(hasOwnProperty2).replace(reRegExpChar2, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
  );
  function baseIsNative2(value) {
    if (!isObject2(value) || isMasked2(value)) {
      return false;
    }
    var pattern = isFunction2(value) ? reIsNative2 : reIsHostCtor2;
    return pattern.test(toSource2(value));
  }
  _baseIsNative = baseIsNative2;
  return _baseIsNative;
}
var _getValue;
var hasRequired_getValue;
function require_getValue() {
  if (hasRequired_getValue)
    return _getValue;
  hasRequired_getValue = 1;
  function getValue2(object, key) {
    return object == null ? void 0 : object[key];
  }
  _getValue = getValue2;
  return _getValue;
}
var _getNative;
var hasRequired_getNative;
function require_getNative() {
  if (hasRequired_getNative)
    return _getNative;
  hasRequired_getNative = 1;
  var baseIsNative2 = require_baseIsNative(), getValue2 = require_getValue();
  function getNative2(object, key) {
    var value = getValue2(object, key);
    return baseIsNative2(value) ? value : void 0;
  }
  _getNative = getNative2;
  return _getNative;
}
var _Map;
var hasRequired_Map;
function require_Map() {
  if (hasRequired_Map)
    return _Map;
  hasRequired_Map = 1;
  var getNative2 = require_getNative(), root2 = require_root();
  var Map2 = getNative2(root2, "Map");
  _Map = Map2;
  return _Map;
}
var _nativeCreate;
var hasRequired_nativeCreate;
function require_nativeCreate() {
  if (hasRequired_nativeCreate)
    return _nativeCreate;
  hasRequired_nativeCreate = 1;
  var getNative2 = require_getNative();
  var nativeCreate2 = getNative2(Object, "create");
  _nativeCreate = nativeCreate2;
  return _nativeCreate;
}
var _hashClear;
var hasRequired_hashClear;
function require_hashClear() {
  if (hasRequired_hashClear)
    return _hashClear;
  hasRequired_hashClear = 1;
  var nativeCreate2 = require_nativeCreate();
  function hashClear2() {
    this.__data__ = nativeCreate2 ? nativeCreate2(null) : {};
    this.size = 0;
  }
  _hashClear = hashClear2;
  return _hashClear;
}
var _hashDelete;
var hasRequired_hashDelete;
function require_hashDelete() {
  if (hasRequired_hashDelete)
    return _hashDelete;
  hasRequired_hashDelete = 1;
  function hashDelete2(key) {
    var result = this.has(key) && delete this.__data__[key];
    this.size -= result ? 1 : 0;
    return result;
  }
  _hashDelete = hashDelete2;
  return _hashDelete;
}
var _hashGet;
var hasRequired_hashGet;
function require_hashGet() {
  if (hasRequired_hashGet)
    return _hashGet;
  hasRequired_hashGet = 1;
  var nativeCreate2 = require_nativeCreate();
  var HASH_UNDEFINED2 = "__lodash_hash_undefined__";
  var objectProto2 = Object.prototype;
  var hasOwnProperty2 = objectProto2.hasOwnProperty;
  function hashGet2(key) {
    var data = this.__data__;
    if (nativeCreate2) {
      var result = data[key];
      return result === HASH_UNDEFINED2 ? void 0 : result;
    }
    return hasOwnProperty2.call(data, key) ? data[key] : void 0;
  }
  _hashGet = hashGet2;
  return _hashGet;
}
var _hashHas;
var hasRequired_hashHas;
function require_hashHas() {
  if (hasRequired_hashHas)
    return _hashHas;
  hasRequired_hashHas = 1;
  var nativeCreate2 = require_nativeCreate();
  var objectProto2 = Object.prototype;
  var hasOwnProperty2 = objectProto2.hasOwnProperty;
  function hashHas2(key) {
    var data = this.__data__;
    return nativeCreate2 ? data[key] !== void 0 : hasOwnProperty2.call(data, key);
  }
  _hashHas = hashHas2;
  return _hashHas;
}
var _hashSet;
var hasRequired_hashSet;
function require_hashSet() {
  if (hasRequired_hashSet)
    return _hashSet;
  hasRequired_hashSet = 1;
  var nativeCreate2 = require_nativeCreate();
  var HASH_UNDEFINED2 = "__lodash_hash_undefined__";
  function hashSet2(key, value) {
    var data = this.__data__;
    this.size += this.has(key) ? 0 : 1;
    data[key] = nativeCreate2 && value === void 0 ? HASH_UNDEFINED2 : value;
    return this;
  }
  _hashSet = hashSet2;
  return _hashSet;
}
var _Hash;
var hasRequired_Hash;
function require_Hash() {
  if (hasRequired_Hash)
    return _Hash;
  hasRequired_Hash = 1;
  var hashClear2 = require_hashClear(), hashDelete2 = require_hashDelete(), hashGet2 = require_hashGet(), hashHas2 = require_hashHas(), hashSet2 = require_hashSet();
  function Hash2(entries) {
    var index = -1, length = entries == null ? 0 : entries.length;
    this.clear();
    while (++index < length) {
      var entry = entries[index];
      this.set(entry[0], entry[1]);
    }
  }
  Hash2.prototype.clear = hashClear2;
  Hash2.prototype["delete"] = hashDelete2;
  Hash2.prototype.get = hashGet2;
  Hash2.prototype.has = hashHas2;
  Hash2.prototype.set = hashSet2;
  _Hash = Hash2;
  return _Hash;
}
var _mapCacheClear;
var hasRequired_mapCacheClear;
function require_mapCacheClear() {
  if (hasRequired_mapCacheClear)
    return _mapCacheClear;
  hasRequired_mapCacheClear = 1;
  var Hash2 = require_Hash(), ListCache2 = require_ListCache(), Map2 = require_Map();
  function mapCacheClear2() {
    this.size = 0;
    this.__data__ = {
      "hash": new Hash2(),
      "map": new (Map2 || ListCache2)(),
      "string": new Hash2()
    };
  }
  _mapCacheClear = mapCacheClear2;
  return _mapCacheClear;
}
var _isKeyable;
var hasRequired_isKeyable;
function require_isKeyable() {
  if (hasRequired_isKeyable)
    return _isKeyable;
  hasRequired_isKeyable = 1;
  function isKeyable2(value) {
    var type = typeof value;
    return type == "string" || type == "number" || type == "symbol" || type == "boolean" ? value !== "__proto__" : value === null;
  }
  _isKeyable = isKeyable2;
  return _isKeyable;
}
var _getMapData;
var hasRequired_getMapData;
function require_getMapData() {
  if (hasRequired_getMapData)
    return _getMapData;
  hasRequired_getMapData = 1;
  var isKeyable2 = require_isKeyable();
  function getMapData2(map, key) {
    var data = map.__data__;
    return isKeyable2(key) ? data[typeof key == "string" ? "string" : "hash"] : data.map;
  }
  _getMapData = getMapData2;
  return _getMapData;
}
var _mapCacheDelete;
var hasRequired_mapCacheDelete;
function require_mapCacheDelete() {
  if (hasRequired_mapCacheDelete)
    return _mapCacheDelete;
  hasRequired_mapCacheDelete = 1;
  var getMapData2 = require_getMapData();
  function mapCacheDelete2(key) {
    var result = getMapData2(this, key)["delete"](key);
    this.size -= result ? 1 : 0;
    return result;
  }
  _mapCacheDelete = mapCacheDelete2;
  return _mapCacheDelete;
}
var _mapCacheGet;
var hasRequired_mapCacheGet;
function require_mapCacheGet() {
  if (hasRequired_mapCacheGet)
    return _mapCacheGet;
  hasRequired_mapCacheGet = 1;
  var getMapData2 = require_getMapData();
  function mapCacheGet2(key) {
    return getMapData2(this, key).get(key);
  }
  _mapCacheGet = mapCacheGet2;
  return _mapCacheGet;
}
var _mapCacheHas;
var hasRequired_mapCacheHas;
function require_mapCacheHas() {
  if (hasRequired_mapCacheHas)
    return _mapCacheHas;
  hasRequired_mapCacheHas = 1;
  var getMapData2 = require_getMapData();
  function mapCacheHas2(key) {
    return getMapData2(this, key).has(key);
  }
  _mapCacheHas = mapCacheHas2;
  return _mapCacheHas;
}
var _mapCacheSet;
var hasRequired_mapCacheSet;
function require_mapCacheSet() {
  if (hasRequired_mapCacheSet)
    return _mapCacheSet;
  hasRequired_mapCacheSet = 1;
  var getMapData2 = require_getMapData();
  function mapCacheSet2(key, value) {
    var data = getMapData2(this, key), size = data.size;
    data.set(key, value);
    this.size += data.size == size ? 0 : 1;
    return this;
  }
  _mapCacheSet = mapCacheSet2;
  return _mapCacheSet;
}
var _MapCache;
var hasRequired_MapCache;
function require_MapCache() {
  if (hasRequired_MapCache)
    return _MapCache;
  hasRequired_MapCache = 1;
  var mapCacheClear2 = require_mapCacheClear(), mapCacheDelete2 = require_mapCacheDelete(), mapCacheGet2 = require_mapCacheGet(), mapCacheHas2 = require_mapCacheHas(), mapCacheSet2 = require_mapCacheSet();
  function MapCache2(entries) {
    var index = -1, length = entries == null ? 0 : entries.length;
    this.clear();
    while (++index < length) {
      var entry = entries[index];
      this.set(entry[0], entry[1]);
    }
  }
  MapCache2.prototype.clear = mapCacheClear2;
  MapCache2.prototype["delete"] = mapCacheDelete2;
  MapCache2.prototype.get = mapCacheGet2;
  MapCache2.prototype.has = mapCacheHas2;
  MapCache2.prototype.set = mapCacheSet2;
  _MapCache = MapCache2;
  return _MapCache;
}
var _stackSet;
var hasRequired_stackSet;
function require_stackSet() {
  if (hasRequired_stackSet)
    return _stackSet;
  hasRequired_stackSet = 1;
  var ListCache2 = require_ListCache(), Map2 = require_Map(), MapCache2 = require_MapCache();
  var LARGE_ARRAY_SIZE2 = 200;
  function stackSet2(key, value) {
    var data = this.__data__;
    if (data instanceof ListCache2) {
      var pairs = data.__data__;
      if (!Map2 || pairs.length < LARGE_ARRAY_SIZE2 - 1) {
        pairs.push([key, value]);
        this.size = ++data.size;
        return this;
      }
      data = this.__data__ = new MapCache2(pairs);
    }
    data.set(key, value);
    this.size = data.size;
    return this;
  }
  _stackSet = stackSet2;
  return _stackSet;
}
var _Stack;
var hasRequired_Stack;
function require_Stack() {
  if (hasRequired_Stack)
    return _Stack;
  hasRequired_Stack = 1;
  var ListCache2 = require_ListCache(), stackClear2 = require_stackClear(), stackDelete2 = require_stackDelete(), stackGet2 = require_stackGet(), stackHas2 = require_stackHas(), stackSet2 = require_stackSet();
  function Stack2(entries) {
    var data = this.__data__ = new ListCache2(entries);
    this.size = data.size;
  }
  Stack2.prototype.clear = stackClear2;
  Stack2.prototype["delete"] = stackDelete2;
  Stack2.prototype.get = stackGet2;
  Stack2.prototype.has = stackHas2;
  Stack2.prototype.set = stackSet2;
  _Stack = Stack2;
  return _Stack;
}
var _arrayEach;
var hasRequired_arrayEach;
function require_arrayEach() {
  if (hasRequired_arrayEach)
    return _arrayEach;
  hasRequired_arrayEach = 1;
  function arrayEach(array, iteratee) {
    var index = -1, length = array == null ? 0 : array.length;
    while (++index < length) {
      if (iteratee(array[index], index, array) === false) {
        break;
      }
    }
    return array;
  }
  _arrayEach = arrayEach;
  return _arrayEach;
}
var _defineProperty;
var hasRequired_defineProperty;
function require_defineProperty() {
  if (hasRequired_defineProperty)
    return _defineProperty;
  hasRequired_defineProperty = 1;
  var getNative2 = require_getNative();
  var defineProperty = function() {
    try {
      var func = getNative2(Object, "defineProperty");
      func({}, "", {});
      return func;
    } catch (e) {
    }
  }();
  _defineProperty = defineProperty;
  return _defineProperty;
}
var _baseAssignValue;
var hasRequired_baseAssignValue;
function require_baseAssignValue() {
  if (hasRequired_baseAssignValue)
    return _baseAssignValue;
  hasRequired_baseAssignValue = 1;
  var defineProperty = require_defineProperty();
  function baseAssignValue(object, key, value) {
    if (key == "__proto__" && defineProperty) {
      defineProperty(object, key, {
        "configurable": true,
        "enumerable": true,
        "value": value,
        "writable": true
      });
    } else {
      object[key] = value;
    }
  }
  _baseAssignValue = baseAssignValue;
  return _baseAssignValue;
}
var _assignValue;
var hasRequired_assignValue;
function require_assignValue() {
  if (hasRequired_assignValue)
    return _assignValue;
  hasRequired_assignValue = 1;
  var baseAssignValue = require_baseAssignValue(), eq2 = requireEq();
  var objectProto2 = Object.prototype;
  var hasOwnProperty2 = objectProto2.hasOwnProperty;
  function assignValue(object, key, value) {
    var objValue = object[key];
    if (!(hasOwnProperty2.call(object, key) && eq2(objValue, value)) || value === void 0 && !(key in object)) {
      baseAssignValue(object, key, value);
    }
  }
  _assignValue = assignValue;
  return _assignValue;
}
var _copyObject;
var hasRequired_copyObject;
function require_copyObject() {
  if (hasRequired_copyObject)
    return _copyObject;
  hasRequired_copyObject = 1;
  var assignValue = require_assignValue(), baseAssignValue = require_baseAssignValue();
  function copyObject(source, props, object, customizer) {
    var isNew = !object;
    object || (object = {});
    var index = -1, length = props.length;
    while (++index < length) {
      var key = props[index];
      var newValue = customizer ? customizer(object[key], source[key], key, object, source) : void 0;
      if (newValue === void 0) {
        newValue = source[key];
      }
      if (isNew) {
        baseAssignValue(object, key, newValue);
      } else {
        assignValue(object, key, newValue);
      }
    }
    return object;
  }
  _copyObject = copyObject;
  return _copyObject;
}
var _baseTimes;
var hasRequired_baseTimes;
function require_baseTimes() {
  if (hasRequired_baseTimes)
    return _baseTimes;
  hasRequired_baseTimes = 1;
  function baseTimes2(n, iteratee) {
    var index = -1, result = Array(n);
    while (++index < n) {
      result[index] = iteratee(index);
    }
    return result;
  }
  _baseTimes = baseTimes2;
  return _baseTimes;
}
var isObjectLike_1;
var hasRequiredIsObjectLike;
function requireIsObjectLike() {
  if (hasRequiredIsObjectLike)
    return isObjectLike_1;
  hasRequiredIsObjectLike = 1;
  function isObjectLike2(value) {
    return value != null && typeof value == "object";
  }
  isObjectLike_1 = isObjectLike2;
  return isObjectLike_1;
}
var _baseIsArguments;
var hasRequired_baseIsArguments;
function require_baseIsArguments() {
  if (hasRequired_baseIsArguments)
    return _baseIsArguments;
  hasRequired_baseIsArguments = 1;
  var baseGetTag2 = require_baseGetTag(), isObjectLike2 = requireIsObjectLike();
  var argsTag2 = "[object Arguments]";
  function baseIsArguments2(value) {
    return isObjectLike2(value) && baseGetTag2(value) == argsTag2;
  }
  _baseIsArguments = baseIsArguments2;
  return _baseIsArguments;
}
var isArguments_1;
var hasRequiredIsArguments;
function requireIsArguments() {
  if (hasRequiredIsArguments)
    return isArguments_1;
  hasRequiredIsArguments = 1;
  var baseIsArguments2 = require_baseIsArguments(), isObjectLike2 = requireIsObjectLike();
  var objectProto2 = Object.prototype;
  var hasOwnProperty2 = objectProto2.hasOwnProperty;
  var propertyIsEnumerable2 = objectProto2.propertyIsEnumerable;
  var isArguments2 = baseIsArguments2(/* @__PURE__ */ function() {
    return arguments;
  }()) ? baseIsArguments2 : function(value) {
    return isObjectLike2(value) && hasOwnProperty2.call(value, "callee") && !propertyIsEnumerable2.call(value, "callee");
  };
  isArguments_1 = isArguments2;
  return isArguments_1;
}
var isArray_1;
var hasRequiredIsArray;
function requireIsArray() {
  if (hasRequiredIsArray)
    return isArray_1;
  hasRequiredIsArray = 1;
  var isArray2 = Array.isArray;
  isArray_1 = isArray2;
  return isArray_1;
}
var isBuffer = { exports: {} };
var stubFalse_1;
var hasRequiredStubFalse;
function requireStubFalse() {
  if (hasRequiredStubFalse)
    return stubFalse_1;
  hasRequiredStubFalse = 1;
  function stubFalse2() {
    return false;
  }
  stubFalse_1 = stubFalse2;
  return stubFalse_1;
}
isBuffer.exports;
var hasRequiredIsBuffer;
function requireIsBuffer() {
  if (hasRequiredIsBuffer)
    return isBuffer.exports;
  hasRequiredIsBuffer = 1;
  (function(module2, exports2) {
    var root2 = require_root(), stubFalse2 = requireStubFalse();
    var freeExports2 = exports2 && !exports2.nodeType && exports2;
    var freeModule2 = freeExports2 && true && module2 && !module2.nodeType && module2;
    var moduleExports2 = freeModule2 && freeModule2.exports === freeExports2;
    var Buffer2 = moduleExports2 ? root2.Buffer : void 0;
    var nativeIsBuffer2 = Buffer2 ? Buffer2.isBuffer : void 0;
    var isBuffer2 = nativeIsBuffer2 || stubFalse2;
    module2.exports = isBuffer2;
  })(isBuffer, isBuffer.exports);
  return isBuffer.exports;
}
var _isIndex;
var hasRequired_isIndex;
function require_isIndex() {
  if (hasRequired_isIndex)
    return _isIndex;
  hasRequired_isIndex = 1;
  var MAX_SAFE_INTEGER2 = 9007199254740991;
  var reIsUint2 = /^(?:0|[1-9]\d*)$/;
  function isIndex2(value, length) {
    var type = typeof value;
    length = length == null ? MAX_SAFE_INTEGER2 : length;
    return !!length && (type == "number" || type != "symbol" && reIsUint2.test(value)) && (value > -1 && value % 1 == 0 && value < length);
  }
  _isIndex = isIndex2;
  return _isIndex;
}
var isLength_1;
var hasRequiredIsLength;
function requireIsLength() {
  if (hasRequiredIsLength)
    return isLength_1;
  hasRequiredIsLength = 1;
  var MAX_SAFE_INTEGER2 = 9007199254740991;
  function isLength2(value) {
    return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER2;
  }
  isLength_1 = isLength2;
  return isLength_1;
}
var _baseIsTypedArray;
var hasRequired_baseIsTypedArray;
function require_baseIsTypedArray() {
  if (hasRequired_baseIsTypedArray)
    return _baseIsTypedArray;
  hasRequired_baseIsTypedArray = 1;
  var baseGetTag2 = require_baseGetTag(), isLength2 = requireIsLength(), isObjectLike2 = requireIsObjectLike();
  var argsTag2 = "[object Arguments]", arrayTag2 = "[object Array]", boolTag2 = "[object Boolean]", dateTag2 = "[object Date]", errorTag2 = "[object Error]", funcTag2 = "[object Function]", mapTag2 = "[object Map]", numberTag2 = "[object Number]", objectTag2 = "[object Object]", regexpTag2 = "[object RegExp]", setTag2 = "[object Set]", stringTag2 = "[object String]", weakMapTag2 = "[object WeakMap]";
  var arrayBufferTag2 = "[object ArrayBuffer]", dataViewTag2 = "[object DataView]", float32Tag2 = "[object Float32Array]", float64Tag2 = "[object Float64Array]", int8Tag2 = "[object Int8Array]", int16Tag2 = "[object Int16Array]", int32Tag2 = "[object Int32Array]", uint8Tag2 = "[object Uint8Array]", uint8ClampedTag2 = "[object Uint8ClampedArray]", uint16Tag2 = "[object Uint16Array]", uint32Tag2 = "[object Uint32Array]";
  var typedArrayTags2 = {};
  typedArrayTags2[float32Tag2] = typedArrayTags2[float64Tag2] = typedArrayTags2[int8Tag2] = typedArrayTags2[int16Tag2] = typedArrayTags2[int32Tag2] = typedArrayTags2[uint8Tag2] = typedArrayTags2[uint8ClampedTag2] = typedArrayTags2[uint16Tag2] = typedArrayTags2[uint32Tag2] = true;
  typedArrayTags2[argsTag2] = typedArrayTags2[arrayTag2] = typedArrayTags2[arrayBufferTag2] = typedArrayTags2[boolTag2] = typedArrayTags2[dataViewTag2] = typedArrayTags2[dateTag2] = typedArrayTags2[errorTag2] = typedArrayTags2[funcTag2] = typedArrayTags2[mapTag2] = typedArrayTags2[numberTag2] = typedArrayTags2[objectTag2] = typedArrayTags2[regexpTag2] = typedArrayTags2[setTag2] = typedArrayTags2[stringTag2] = typedArrayTags2[weakMapTag2] = false;
  function baseIsTypedArray2(value) {
    return isObjectLike2(value) && isLength2(value.length) && !!typedArrayTags2[baseGetTag2(value)];
  }
  _baseIsTypedArray = baseIsTypedArray2;
  return _baseIsTypedArray;
}
var _baseUnary;
var hasRequired_baseUnary;
function require_baseUnary() {
  if (hasRequired_baseUnary)
    return _baseUnary;
  hasRequired_baseUnary = 1;
  function baseUnary2(func) {
    return function(value) {
      return func(value);
    };
  }
  _baseUnary = baseUnary2;
  return _baseUnary;
}
var _nodeUtil = { exports: {} };
_nodeUtil.exports;
var hasRequired_nodeUtil;
function require_nodeUtil() {
  if (hasRequired_nodeUtil)
    return _nodeUtil.exports;
  hasRequired_nodeUtil = 1;
  (function(module2, exports2) {
    var freeGlobal2 = require_freeGlobal();
    var freeExports2 = exports2 && !exports2.nodeType && exports2;
    var freeModule2 = freeExports2 && true && module2 && !module2.nodeType && module2;
    var moduleExports2 = freeModule2 && freeModule2.exports === freeExports2;
    var freeProcess2 = moduleExports2 && freeGlobal2.process;
    var nodeUtil2 = function() {
      try {
        var types = freeModule2 && freeModule2.require && freeModule2.require("util").types;
        if (types) {
          return types;
        }
        return freeProcess2 && freeProcess2.binding && freeProcess2.binding("util");
      } catch (e) {
      }
    }();
    module2.exports = nodeUtil2;
  })(_nodeUtil, _nodeUtil.exports);
  return _nodeUtil.exports;
}
var isTypedArray_1;
var hasRequiredIsTypedArray;
function requireIsTypedArray() {
  if (hasRequiredIsTypedArray)
    return isTypedArray_1;
  hasRequiredIsTypedArray = 1;
  var baseIsTypedArray2 = require_baseIsTypedArray(), baseUnary2 = require_baseUnary(), nodeUtil2 = require_nodeUtil();
  var nodeIsTypedArray2 = nodeUtil2 && nodeUtil2.isTypedArray;
  var isTypedArray2 = nodeIsTypedArray2 ? baseUnary2(nodeIsTypedArray2) : baseIsTypedArray2;
  isTypedArray_1 = isTypedArray2;
  return isTypedArray_1;
}
var _arrayLikeKeys;
var hasRequired_arrayLikeKeys;
function require_arrayLikeKeys() {
  if (hasRequired_arrayLikeKeys)
    return _arrayLikeKeys;
  hasRequired_arrayLikeKeys = 1;
  var baseTimes2 = require_baseTimes(), isArguments2 = requireIsArguments(), isArray2 = requireIsArray(), isBuffer2 = requireIsBuffer(), isIndex2 = require_isIndex(), isTypedArray2 = requireIsTypedArray();
  var objectProto2 = Object.prototype;
  var hasOwnProperty2 = objectProto2.hasOwnProperty;
  function arrayLikeKeys2(value, inherited) {
    var isArr = isArray2(value), isArg = !isArr && isArguments2(value), isBuff = !isArr && !isArg && isBuffer2(value), isType = !isArr && !isArg && !isBuff && isTypedArray2(value), skipIndexes = isArr || isArg || isBuff || isType, result = skipIndexes ? baseTimes2(value.length, String) : [], length = result.length;
    for (var key in value) {
      if ((inherited || hasOwnProperty2.call(value, key)) && !(skipIndexes && // Safari 9 has enumerable `arguments.length` in strict mode.
      (key == "length" || // Node.js 0.10 has enumerable non-index properties on buffers.
      isBuff && (key == "offset" || key == "parent") || // PhantomJS 2 has enumerable non-index properties on typed arrays.
      isType && (key == "buffer" || key == "byteLength" || key == "byteOffset") || // Skip index properties.
      isIndex2(key, length)))) {
        result.push(key);
      }
    }
    return result;
  }
  _arrayLikeKeys = arrayLikeKeys2;
  return _arrayLikeKeys;
}
var _isPrototype;
var hasRequired_isPrototype;
function require_isPrototype() {
  if (hasRequired_isPrototype)
    return _isPrototype;
  hasRequired_isPrototype = 1;
  var objectProto2 = Object.prototype;
  function isPrototype2(value) {
    var Ctor = value && value.constructor, proto = typeof Ctor == "function" && Ctor.prototype || objectProto2;
    return value === proto;
  }
  _isPrototype = isPrototype2;
  return _isPrototype;
}
var _overArg;
var hasRequired_overArg;
function require_overArg() {
  if (hasRequired_overArg)
    return _overArg;
  hasRequired_overArg = 1;
  function overArg2(func, transform) {
    return function(arg) {
      return func(transform(arg));
    };
  }
  _overArg = overArg2;
  return _overArg;
}
var _nativeKeys;
var hasRequired_nativeKeys;
function require_nativeKeys() {
  if (hasRequired_nativeKeys)
    return _nativeKeys;
  hasRequired_nativeKeys = 1;
  var overArg2 = require_overArg();
  var nativeKeys2 = overArg2(Object.keys, Object);
  _nativeKeys = nativeKeys2;
  return _nativeKeys;
}
var _baseKeys;
var hasRequired_baseKeys;
function require_baseKeys() {
  if (hasRequired_baseKeys)
    return _baseKeys;
  hasRequired_baseKeys = 1;
  var isPrototype2 = require_isPrototype(), nativeKeys2 = require_nativeKeys();
  var objectProto2 = Object.prototype;
  var hasOwnProperty2 = objectProto2.hasOwnProperty;
  function baseKeys2(object) {
    if (!isPrototype2(object)) {
      return nativeKeys2(object);
    }
    var result = [];
    for (var key in Object(object)) {
      if (hasOwnProperty2.call(object, key) && key != "constructor") {
        result.push(key);
      }
    }
    return result;
  }
  _baseKeys = baseKeys2;
  return _baseKeys;
}
var isArrayLike_1;
var hasRequiredIsArrayLike;
function requireIsArrayLike() {
  if (hasRequiredIsArrayLike)
    return isArrayLike_1;
  hasRequiredIsArrayLike = 1;
  var isFunction2 = requireIsFunction(), isLength2 = requireIsLength();
  function isArrayLike2(value) {
    return value != null && isLength2(value.length) && !isFunction2(value);
  }
  isArrayLike_1 = isArrayLike2;
  return isArrayLike_1;
}
var keys_1;
var hasRequiredKeys;
function requireKeys() {
  if (hasRequiredKeys)
    return keys_1;
  hasRequiredKeys = 1;
  var arrayLikeKeys2 = require_arrayLikeKeys(), baseKeys2 = require_baseKeys(), isArrayLike2 = requireIsArrayLike();
  function keys2(object) {
    return isArrayLike2(object) ? arrayLikeKeys2(object) : baseKeys2(object);
  }
  keys_1 = keys2;
  return keys_1;
}
var _baseAssign;
var hasRequired_baseAssign;
function require_baseAssign() {
  if (hasRequired_baseAssign)
    return _baseAssign;
  hasRequired_baseAssign = 1;
  var copyObject = require_copyObject(), keys2 = requireKeys();
  function baseAssign(object, source) {
    return object && copyObject(source, keys2(source), object);
  }
  _baseAssign = baseAssign;
  return _baseAssign;
}
var _nativeKeysIn;
var hasRequired_nativeKeysIn;
function require_nativeKeysIn() {
  if (hasRequired_nativeKeysIn)
    return _nativeKeysIn;
  hasRequired_nativeKeysIn = 1;
  function nativeKeysIn(object) {
    var result = [];
    if (object != null) {
      for (var key in Object(object)) {
        result.push(key);
      }
    }
    return result;
  }
  _nativeKeysIn = nativeKeysIn;
  return _nativeKeysIn;
}
var _baseKeysIn;
var hasRequired_baseKeysIn;
function require_baseKeysIn() {
  if (hasRequired_baseKeysIn)
    return _baseKeysIn;
  hasRequired_baseKeysIn = 1;
  var isObject2 = requireIsObject(), isPrototype2 = require_isPrototype(), nativeKeysIn = require_nativeKeysIn();
  var objectProto2 = Object.prototype;
  var hasOwnProperty2 = objectProto2.hasOwnProperty;
  function baseKeysIn(object) {
    if (!isObject2(object)) {
      return nativeKeysIn(object);
    }
    var isProto = isPrototype2(object), result = [];
    for (var key in object) {
      if (!(key == "constructor" && (isProto || !hasOwnProperty2.call(object, key)))) {
        result.push(key);
      }
    }
    return result;
  }
  _baseKeysIn = baseKeysIn;
  return _baseKeysIn;
}
var keysIn_1;
var hasRequiredKeysIn;
function requireKeysIn() {
  if (hasRequiredKeysIn)
    return keysIn_1;
  hasRequiredKeysIn = 1;
  var arrayLikeKeys2 = require_arrayLikeKeys(), baseKeysIn = require_baseKeysIn(), isArrayLike2 = requireIsArrayLike();
  function keysIn(object) {
    return isArrayLike2(object) ? arrayLikeKeys2(object, true) : baseKeysIn(object);
  }
  keysIn_1 = keysIn;
  return keysIn_1;
}
var _baseAssignIn;
var hasRequired_baseAssignIn;
function require_baseAssignIn() {
  if (hasRequired_baseAssignIn)
    return _baseAssignIn;
  hasRequired_baseAssignIn = 1;
  var copyObject = require_copyObject(), keysIn = requireKeysIn();
  function baseAssignIn(object, source) {
    return object && copyObject(source, keysIn(source), object);
  }
  _baseAssignIn = baseAssignIn;
  return _baseAssignIn;
}
var _cloneBuffer = { exports: {} };
_cloneBuffer.exports;
var hasRequired_cloneBuffer;
function require_cloneBuffer() {
  if (hasRequired_cloneBuffer)
    return _cloneBuffer.exports;
  hasRequired_cloneBuffer = 1;
  (function(module2, exports2) {
    var root2 = require_root();
    var freeExports2 = exports2 && !exports2.nodeType && exports2;
    var freeModule2 = freeExports2 && true && module2 && !module2.nodeType && module2;
    var moduleExports2 = freeModule2 && freeModule2.exports === freeExports2;
    var Buffer2 = moduleExports2 ? root2.Buffer : void 0, allocUnsafe = Buffer2 ? Buffer2.allocUnsafe : void 0;
    function cloneBuffer(buffer, isDeep) {
      if (isDeep) {
        return buffer.slice();
      }
      var length = buffer.length, result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);
      buffer.copy(result);
      return result;
    }
    module2.exports = cloneBuffer;
  })(_cloneBuffer, _cloneBuffer.exports);
  return _cloneBuffer.exports;
}
var _copyArray;
var hasRequired_copyArray;
function require_copyArray() {
  if (hasRequired_copyArray)
    return _copyArray;
  hasRequired_copyArray = 1;
  function copyArray(source, array) {
    var index = -1, length = source.length;
    array || (array = Array(length));
    while (++index < length) {
      array[index] = source[index];
    }
    return array;
  }
  _copyArray = copyArray;
  return _copyArray;
}
var _arrayFilter;
var hasRequired_arrayFilter;
function require_arrayFilter() {
  if (hasRequired_arrayFilter)
    return _arrayFilter;
  hasRequired_arrayFilter = 1;
  function arrayFilter2(array, predicate) {
    var index = -1, length = array == null ? 0 : array.length, resIndex = 0, result = [];
    while (++index < length) {
      var value = array[index];
      if (predicate(value, index, array)) {
        result[resIndex++] = value;
      }
    }
    return result;
  }
  _arrayFilter = arrayFilter2;
  return _arrayFilter;
}
var stubArray_1;
var hasRequiredStubArray;
function requireStubArray() {
  if (hasRequiredStubArray)
    return stubArray_1;
  hasRequiredStubArray = 1;
  function stubArray2() {
    return [];
  }
  stubArray_1 = stubArray2;
  return stubArray_1;
}
var _getSymbols;
var hasRequired_getSymbols;
function require_getSymbols() {
  if (hasRequired_getSymbols)
    return _getSymbols;
  hasRequired_getSymbols = 1;
  var arrayFilter2 = require_arrayFilter(), stubArray2 = requireStubArray();
  var objectProto2 = Object.prototype;
  var propertyIsEnumerable2 = objectProto2.propertyIsEnumerable;
  var nativeGetSymbols2 = Object.getOwnPropertySymbols;
  var getSymbols2 = !nativeGetSymbols2 ? stubArray2 : function(object) {
    if (object == null) {
      return [];
    }
    object = Object(object);
    return arrayFilter2(nativeGetSymbols2(object), function(symbol) {
      return propertyIsEnumerable2.call(object, symbol);
    });
  };
  _getSymbols = getSymbols2;
  return _getSymbols;
}
var _copySymbols;
var hasRequired_copySymbols;
function require_copySymbols() {
  if (hasRequired_copySymbols)
    return _copySymbols;
  hasRequired_copySymbols = 1;
  var copyObject = require_copyObject(), getSymbols2 = require_getSymbols();
  function copySymbols(source, object) {
    return copyObject(source, getSymbols2(source), object);
  }
  _copySymbols = copySymbols;
  return _copySymbols;
}
var _arrayPush;
var hasRequired_arrayPush;
function require_arrayPush() {
  if (hasRequired_arrayPush)
    return _arrayPush;
  hasRequired_arrayPush = 1;
  function arrayPush2(array, values) {
    var index = -1, length = values.length, offset = array.length;
    while (++index < length) {
      array[offset + index] = values[index];
    }
    return array;
  }
  _arrayPush = arrayPush2;
  return _arrayPush;
}
var _getPrototype;
var hasRequired_getPrototype;
function require_getPrototype() {
  if (hasRequired_getPrototype)
    return _getPrototype;
  hasRequired_getPrototype = 1;
  var overArg2 = require_overArg();
  var getPrototype = overArg2(Object.getPrototypeOf, Object);
  _getPrototype = getPrototype;
  return _getPrototype;
}
var _getSymbolsIn;
var hasRequired_getSymbolsIn;
function require_getSymbolsIn() {
  if (hasRequired_getSymbolsIn)
    return _getSymbolsIn;
  hasRequired_getSymbolsIn = 1;
  var arrayPush2 = require_arrayPush(), getPrototype = require_getPrototype(), getSymbols2 = require_getSymbols(), stubArray2 = requireStubArray();
  var nativeGetSymbols2 = Object.getOwnPropertySymbols;
  var getSymbolsIn = !nativeGetSymbols2 ? stubArray2 : function(object) {
    var result = [];
    while (object) {
      arrayPush2(result, getSymbols2(object));
      object = getPrototype(object);
    }
    return result;
  };
  _getSymbolsIn = getSymbolsIn;
  return _getSymbolsIn;
}
var _copySymbolsIn;
var hasRequired_copySymbolsIn;
function require_copySymbolsIn() {
  if (hasRequired_copySymbolsIn)
    return _copySymbolsIn;
  hasRequired_copySymbolsIn = 1;
  var copyObject = require_copyObject(), getSymbolsIn = require_getSymbolsIn();
  function copySymbolsIn(source, object) {
    return copyObject(source, getSymbolsIn(source), object);
  }
  _copySymbolsIn = copySymbolsIn;
  return _copySymbolsIn;
}
var _baseGetAllKeys;
var hasRequired_baseGetAllKeys;
function require_baseGetAllKeys() {
  if (hasRequired_baseGetAllKeys)
    return _baseGetAllKeys;
  hasRequired_baseGetAllKeys = 1;
  var arrayPush2 = require_arrayPush(), isArray2 = requireIsArray();
  function baseGetAllKeys2(object, keysFunc, symbolsFunc) {
    var result = keysFunc(object);
    return isArray2(object) ? result : arrayPush2(result, symbolsFunc(object));
  }
  _baseGetAllKeys = baseGetAllKeys2;
  return _baseGetAllKeys;
}
var _getAllKeys;
var hasRequired_getAllKeys;
function require_getAllKeys() {
  if (hasRequired_getAllKeys)
    return _getAllKeys;
  hasRequired_getAllKeys = 1;
  var baseGetAllKeys2 = require_baseGetAllKeys(), getSymbols2 = require_getSymbols(), keys2 = requireKeys();
  function getAllKeys2(object) {
    return baseGetAllKeys2(object, keys2, getSymbols2);
  }
  _getAllKeys = getAllKeys2;
  return _getAllKeys;
}
var _getAllKeysIn;
var hasRequired_getAllKeysIn;
function require_getAllKeysIn() {
  if (hasRequired_getAllKeysIn)
    return _getAllKeysIn;
  hasRequired_getAllKeysIn = 1;
  var baseGetAllKeys2 = require_baseGetAllKeys(), getSymbolsIn = require_getSymbolsIn(), keysIn = requireKeysIn();
  function getAllKeysIn(object) {
    return baseGetAllKeys2(object, keysIn, getSymbolsIn);
  }
  _getAllKeysIn = getAllKeysIn;
  return _getAllKeysIn;
}
var _DataView;
var hasRequired_DataView;
function require_DataView() {
  if (hasRequired_DataView)
    return _DataView;
  hasRequired_DataView = 1;
  var getNative2 = require_getNative(), root2 = require_root();
  var DataView2 = getNative2(root2, "DataView");
  _DataView = DataView2;
  return _DataView;
}
var _Promise;
var hasRequired_Promise;
function require_Promise() {
  if (hasRequired_Promise)
    return _Promise;
  hasRequired_Promise = 1;
  var getNative2 = require_getNative(), root2 = require_root();
  var Promise2 = getNative2(root2, "Promise");
  _Promise = Promise2;
  return _Promise;
}
var _Set;
var hasRequired_Set;
function require_Set() {
  if (hasRequired_Set)
    return _Set;
  hasRequired_Set = 1;
  var getNative2 = require_getNative(), root2 = require_root();
  var Set2 = getNative2(root2, "Set");
  _Set = Set2;
  return _Set;
}
var _WeakMap;
var hasRequired_WeakMap;
function require_WeakMap() {
  if (hasRequired_WeakMap)
    return _WeakMap;
  hasRequired_WeakMap = 1;
  var getNative2 = require_getNative(), root2 = require_root();
  var WeakMap2 = getNative2(root2, "WeakMap");
  _WeakMap = WeakMap2;
  return _WeakMap;
}
var _getTag;
var hasRequired_getTag;
function require_getTag() {
  if (hasRequired_getTag)
    return _getTag;
  hasRequired_getTag = 1;
  var DataView2 = require_DataView(), Map2 = require_Map(), Promise2 = require_Promise(), Set2 = require_Set(), WeakMap2 = require_WeakMap(), baseGetTag2 = require_baseGetTag(), toSource2 = require_toSource();
  var mapTag2 = "[object Map]", objectTag2 = "[object Object]", promiseTag2 = "[object Promise]", setTag2 = "[object Set]", weakMapTag2 = "[object WeakMap]";
  var dataViewTag2 = "[object DataView]";
  var dataViewCtorString2 = toSource2(DataView2), mapCtorString2 = toSource2(Map2), promiseCtorString2 = toSource2(Promise2), setCtorString2 = toSource2(Set2), weakMapCtorString2 = toSource2(WeakMap2);
  var getTag2 = baseGetTag2;
  if (DataView2 && getTag2(new DataView2(new ArrayBuffer(1))) != dataViewTag2 || Map2 && getTag2(new Map2()) != mapTag2 || Promise2 && getTag2(Promise2.resolve()) != promiseTag2 || Set2 && getTag2(new Set2()) != setTag2 || WeakMap2 && getTag2(new WeakMap2()) != weakMapTag2) {
    getTag2 = function(value) {
      var result = baseGetTag2(value), Ctor = result == objectTag2 ? value.constructor : void 0, ctorString = Ctor ? toSource2(Ctor) : "";
      if (ctorString) {
        switch (ctorString) {
          case dataViewCtorString2:
            return dataViewTag2;
          case mapCtorString2:
            return mapTag2;
          case promiseCtorString2:
            return promiseTag2;
          case setCtorString2:
            return setTag2;
          case weakMapCtorString2:
            return weakMapTag2;
        }
      }
      return result;
    };
  }
  _getTag = getTag2;
  return _getTag;
}
var _initCloneArray;
var hasRequired_initCloneArray;
function require_initCloneArray() {
  if (hasRequired_initCloneArray)
    return _initCloneArray;
  hasRequired_initCloneArray = 1;
  var objectProto2 = Object.prototype;
  var hasOwnProperty2 = objectProto2.hasOwnProperty;
  function initCloneArray(array) {
    var length = array.length, result = new array.constructor(length);
    if (length && typeof array[0] == "string" && hasOwnProperty2.call(array, "index")) {
      result.index = array.index;
      result.input = array.input;
    }
    return result;
  }
  _initCloneArray = initCloneArray;
  return _initCloneArray;
}
var _Uint8Array;
var hasRequired_Uint8Array;
function require_Uint8Array() {
  if (hasRequired_Uint8Array)
    return _Uint8Array;
  hasRequired_Uint8Array = 1;
  var root2 = require_root();
  var Uint8Array2 = root2.Uint8Array;
  _Uint8Array = Uint8Array2;
  return _Uint8Array;
}
var _cloneArrayBuffer;
var hasRequired_cloneArrayBuffer;
function require_cloneArrayBuffer() {
  if (hasRequired_cloneArrayBuffer)
    return _cloneArrayBuffer;
  hasRequired_cloneArrayBuffer = 1;
  var Uint8Array2 = require_Uint8Array();
  function cloneArrayBuffer(arrayBuffer) {
    var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
    new Uint8Array2(result).set(new Uint8Array2(arrayBuffer));
    return result;
  }
  _cloneArrayBuffer = cloneArrayBuffer;
  return _cloneArrayBuffer;
}
var _cloneDataView;
var hasRequired_cloneDataView;
function require_cloneDataView() {
  if (hasRequired_cloneDataView)
    return _cloneDataView;
  hasRequired_cloneDataView = 1;
  var cloneArrayBuffer = require_cloneArrayBuffer();
  function cloneDataView(dataView, isDeep) {
    var buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
    return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
  }
  _cloneDataView = cloneDataView;
  return _cloneDataView;
}
var _cloneRegExp;
var hasRequired_cloneRegExp;
function require_cloneRegExp() {
  if (hasRequired_cloneRegExp)
    return _cloneRegExp;
  hasRequired_cloneRegExp = 1;
  var reFlags = /\w*$/;
  function cloneRegExp(regexp) {
    var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
    result.lastIndex = regexp.lastIndex;
    return result;
  }
  _cloneRegExp = cloneRegExp;
  return _cloneRegExp;
}
var _cloneSymbol;
var hasRequired_cloneSymbol;
function require_cloneSymbol() {
  if (hasRequired_cloneSymbol)
    return _cloneSymbol;
  hasRequired_cloneSymbol = 1;
  var Symbol = require_Symbol();
  var symbolProto2 = Symbol ? Symbol.prototype : void 0, symbolValueOf2 = symbolProto2 ? symbolProto2.valueOf : void 0;
  function cloneSymbol(symbol) {
    return symbolValueOf2 ? Object(symbolValueOf2.call(symbol)) : {};
  }
  _cloneSymbol = cloneSymbol;
  return _cloneSymbol;
}
var _cloneTypedArray;
var hasRequired_cloneTypedArray;
function require_cloneTypedArray() {
  if (hasRequired_cloneTypedArray)
    return _cloneTypedArray;
  hasRequired_cloneTypedArray = 1;
  var cloneArrayBuffer = require_cloneArrayBuffer();
  function cloneTypedArray(typedArray, isDeep) {
    var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
    return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
  }
  _cloneTypedArray = cloneTypedArray;
  return _cloneTypedArray;
}
var _initCloneByTag;
var hasRequired_initCloneByTag;
function require_initCloneByTag() {
  if (hasRequired_initCloneByTag)
    return _initCloneByTag;
  hasRequired_initCloneByTag = 1;
  var cloneArrayBuffer = require_cloneArrayBuffer(), cloneDataView = require_cloneDataView(), cloneRegExp = require_cloneRegExp(), cloneSymbol = require_cloneSymbol(), cloneTypedArray = require_cloneTypedArray();
  var boolTag2 = "[object Boolean]", dateTag2 = "[object Date]", mapTag2 = "[object Map]", numberTag2 = "[object Number]", regexpTag2 = "[object RegExp]", setTag2 = "[object Set]", stringTag2 = "[object String]", symbolTag2 = "[object Symbol]";
  var arrayBufferTag2 = "[object ArrayBuffer]", dataViewTag2 = "[object DataView]", float32Tag2 = "[object Float32Array]", float64Tag2 = "[object Float64Array]", int8Tag2 = "[object Int8Array]", int16Tag2 = "[object Int16Array]", int32Tag2 = "[object Int32Array]", uint8Tag2 = "[object Uint8Array]", uint8ClampedTag2 = "[object Uint8ClampedArray]", uint16Tag2 = "[object Uint16Array]", uint32Tag2 = "[object Uint32Array]";
  function initCloneByTag(object, tag, isDeep) {
    var Ctor = object.constructor;
    switch (tag) {
      case arrayBufferTag2:
        return cloneArrayBuffer(object);
      case boolTag2:
      case dateTag2:
        return new Ctor(+object);
      case dataViewTag2:
        return cloneDataView(object, isDeep);
      case float32Tag2:
      case float64Tag2:
      case int8Tag2:
      case int16Tag2:
      case int32Tag2:
      case uint8Tag2:
      case uint8ClampedTag2:
      case uint16Tag2:
      case uint32Tag2:
        return cloneTypedArray(object, isDeep);
      case mapTag2:
        return new Ctor();
      case numberTag2:
      case stringTag2:
        return new Ctor(object);
      case regexpTag2:
        return cloneRegExp(object);
      case setTag2:
        return new Ctor();
      case symbolTag2:
        return cloneSymbol(object);
    }
  }
  _initCloneByTag = initCloneByTag;
  return _initCloneByTag;
}
var _baseCreate;
var hasRequired_baseCreate;
function require_baseCreate() {
  if (hasRequired_baseCreate)
    return _baseCreate;
  hasRequired_baseCreate = 1;
  var isObject2 = requireIsObject();
  var objectCreate = Object.create;
  var baseCreate = /* @__PURE__ */ function() {
    function object() {
    }
    return function(proto) {
      if (!isObject2(proto)) {
        return {};
      }
      if (objectCreate) {
        return objectCreate(proto);
      }
      object.prototype = proto;
      var result = new object();
      object.prototype = void 0;
      return result;
    };
  }();
  _baseCreate = baseCreate;
  return _baseCreate;
}
var _initCloneObject;
var hasRequired_initCloneObject;
function require_initCloneObject() {
  if (hasRequired_initCloneObject)
    return _initCloneObject;
  hasRequired_initCloneObject = 1;
  var baseCreate = require_baseCreate(), getPrototype = require_getPrototype(), isPrototype2 = require_isPrototype();
  function initCloneObject(object) {
    return typeof object.constructor == "function" && !isPrototype2(object) ? baseCreate(getPrototype(object)) : {};
  }
  _initCloneObject = initCloneObject;
  return _initCloneObject;
}
var _baseIsMap;
var hasRequired_baseIsMap;
function require_baseIsMap() {
  if (hasRequired_baseIsMap)
    return _baseIsMap;
  hasRequired_baseIsMap = 1;
  var getTag2 = require_getTag(), isObjectLike2 = requireIsObjectLike();
  var mapTag2 = "[object Map]";
  function baseIsMap(value) {
    return isObjectLike2(value) && getTag2(value) == mapTag2;
  }
  _baseIsMap = baseIsMap;
  return _baseIsMap;
}
var isMap_1;
var hasRequiredIsMap;
function requireIsMap() {
  if (hasRequiredIsMap)
    return isMap_1;
  hasRequiredIsMap = 1;
  var baseIsMap = require_baseIsMap(), baseUnary2 = require_baseUnary(), nodeUtil2 = require_nodeUtil();
  var nodeIsMap = nodeUtil2 && nodeUtil2.isMap;
  var isMap = nodeIsMap ? baseUnary2(nodeIsMap) : baseIsMap;
  isMap_1 = isMap;
  return isMap_1;
}
var _baseIsSet;
var hasRequired_baseIsSet;
function require_baseIsSet() {
  if (hasRequired_baseIsSet)
    return _baseIsSet;
  hasRequired_baseIsSet = 1;
  var getTag2 = require_getTag(), isObjectLike2 = requireIsObjectLike();
  var setTag2 = "[object Set]";
  function baseIsSet(value) {
    return isObjectLike2(value) && getTag2(value) == setTag2;
  }
  _baseIsSet = baseIsSet;
  return _baseIsSet;
}
var isSet_1;
var hasRequiredIsSet;
function requireIsSet() {
  if (hasRequiredIsSet)
    return isSet_1;
  hasRequiredIsSet = 1;
  var baseIsSet = require_baseIsSet(), baseUnary2 = require_baseUnary(), nodeUtil2 = require_nodeUtil();
  var nodeIsSet = nodeUtil2 && nodeUtil2.isSet;
  var isSet = nodeIsSet ? baseUnary2(nodeIsSet) : baseIsSet;
  isSet_1 = isSet;
  return isSet_1;
}
var _baseClone;
var hasRequired_baseClone;
function require_baseClone() {
  if (hasRequired_baseClone)
    return _baseClone;
  hasRequired_baseClone = 1;
  var Stack2 = require_Stack(), arrayEach = require_arrayEach(), assignValue = require_assignValue(), baseAssign = require_baseAssign(), baseAssignIn = require_baseAssignIn(), cloneBuffer = require_cloneBuffer(), copyArray = require_copyArray(), copySymbols = require_copySymbols(), copySymbolsIn = require_copySymbolsIn(), getAllKeys2 = require_getAllKeys(), getAllKeysIn = require_getAllKeysIn(), getTag2 = require_getTag(), initCloneArray = require_initCloneArray(), initCloneByTag = require_initCloneByTag(), initCloneObject = require_initCloneObject(), isArray2 = requireIsArray(), isBuffer2 = requireIsBuffer(), isMap = requireIsMap(), isObject2 = requireIsObject(), isSet = requireIsSet(), keys2 = requireKeys(), keysIn = requireKeysIn();
  var CLONE_DEEP_FLAG = 1, CLONE_FLAT_FLAG = 2, CLONE_SYMBOLS_FLAG = 4;
  var argsTag2 = "[object Arguments]", arrayTag2 = "[object Array]", boolTag2 = "[object Boolean]", dateTag2 = "[object Date]", errorTag2 = "[object Error]", funcTag2 = "[object Function]", genTag2 = "[object GeneratorFunction]", mapTag2 = "[object Map]", numberTag2 = "[object Number]", objectTag2 = "[object Object]", regexpTag2 = "[object RegExp]", setTag2 = "[object Set]", stringTag2 = "[object String]", symbolTag2 = "[object Symbol]", weakMapTag2 = "[object WeakMap]";
  var arrayBufferTag2 = "[object ArrayBuffer]", dataViewTag2 = "[object DataView]", float32Tag2 = "[object Float32Array]", float64Tag2 = "[object Float64Array]", int8Tag2 = "[object Int8Array]", int16Tag2 = "[object Int16Array]", int32Tag2 = "[object Int32Array]", uint8Tag2 = "[object Uint8Array]", uint8ClampedTag2 = "[object Uint8ClampedArray]", uint16Tag2 = "[object Uint16Array]", uint32Tag2 = "[object Uint32Array]";
  var cloneableTags = {};
  cloneableTags[argsTag2] = cloneableTags[arrayTag2] = cloneableTags[arrayBufferTag2] = cloneableTags[dataViewTag2] = cloneableTags[boolTag2] = cloneableTags[dateTag2] = cloneableTags[float32Tag2] = cloneableTags[float64Tag2] = cloneableTags[int8Tag2] = cloneableTags[int16Tag2] = cloneableTags[int32Tag2] = cloneableTags[mapTag2] = cloneableTags[numberTag2] = cloneableTags[objectTag2] = cloneableTags[regexpTag2] = cloneableTags[setTag2] = cloneableTags[stringTag2] = cloneableTags[symbolTag2] = cloneableTags[uint8Tag2] = cloneableTags[uint8ClampedTag2] = cloneableTags[uint16Tag2] = cloneableTags[uint32Tag2] = true;
  cloneableTags[errorTag2] = cloneableTags[funcTag2] = cloneableTags[weakMapTag2] = false;
  function baseClone(value, bitmask, customizer, key, object, stack) {
    var result, isDeep = bitmask & CLONE_DEEP_FLAG, isFlat = bitmask & CLONE_FLAT_FLAG, isFull = bitmask & CLONE_SYMBOLS_FLAG;
    if (customizer) {
      result = object ? customizer(value, key, object, stack) : customizer(value);
    }
    if (result !== void 0) {
      return result;
    }
    if (!isObject2(value)) {
      return value;
    }
    var isArr = isArray2(value);
    if (isArr) {
      result = initCloneArray(value);
      if (!isDeep) {
        return copyArray(value, result);
      }
    } else {
      var tag = getTag2(value), isFunc = tag == funcTag2 || tag == genTag2;
      if (isBuffer2(value)) {
        return cloneBuffer(value, isDeep);
      }
      if (tag == objectTag2 || tag == argsTag2 || isFunc && !object) {
        result = isFlat || isFunc ? {} : initCloneObject(value);
        if (!isDeep) {
          return isFlat ? copySymbolsIn(value, baseAssignIn(result, value)) : copySymbols(value, baseAssign(result, value));
        }
      } else {
        if (!cloneableTags[tag]) {
          return object ? value : {};
        }
        result = initCloneByTag(value, tag, isDeep);
      }
    }
    stack || (stack = new Stack2());
    var stacked = stack.get(value);
    if (stacked) {
      return stacked;
    }
    stack.set(value, result);
    if (isSet(value)) {
      value.forEach(function(subValue) {
        result.add(baseClone(subValue, bitmask, customizer, subValue, value, stack));
      });
    } else if (isMap(value)) {
      value.forEach(function(subValue, key2) {
        result.set(key2, baseClone(subValue, bitmask, customizer, key2, value, stack));
      });
    }
    var keysFunc = isFull ? isFlat ? getAllKeysIn : getAllKeys2 : isFlat ? keysIn : keys2;
    var props = isArr ? void 0 : keysFunc(value);
    arrayEach(props || value, function(subValue, key2) {
      if (props) {
        key2 = subValue;
        subValue = value[key2];
      }
      assignValue(result, key2, baseClone(subValue, bitmask, customizer, key2, value, stack));
    });
    return result;
  }
  _baseClone = baseClone;
  return _baseClone;
}
var clone_1;
var hasRequiredClone;
function requireClone() {
  if (hasRequiredClone)
    return clone_1;
  hasRequiredClone = 1;
  var baseClone = require_baseClone();
  var CLONE_SYMBOLS_FLAG = 4;
  function clone(value) {
    return baseClone(value, CLONE_SYMBOLS_FLAG);
  }
  clone_1 = clone;
  return clone_1;
}
var constant_1;
var hasRequiredConstant;
function requireConstant() {
  if (hasRequiredConstant)
    return constant_1;
  hasRequiredConstant = 1;
  function constant(value) {
    return function() {
      return value;
    };
  }
  constant_1 = constant;
  return constant_1;
}
var _createBaseFor;
var hasRequired_createBaseFor;
function require_createBaseFor() {
  if (hasRequired_createBaseFor)
    return _createBaseFor;
  hasRequired_createBaseFor = 1;
  function createBaseFor(fromRight) {
    return function(object, iteratee, keysFunc) {
      var index = -1, iterable = Object(object), props = keysFunc(object), length = props.length;
      while (length--) {
        var key = props[fromRight ? length : ++index];
        if (iteratee(iterable[key], key, iterable) === false) {
          break;
        }
      }
      return object;
    };
  }
  _createBaseFor = createBaseFor;
  return _createBaseFor;
}
var _baseFor;
var hasRequired_baseFor;
function require_baseFor() {
  if (hasRequired_baseFor)
    return _baseFor;
  hasRequired_baseFor = 1;
  var createBaseFor = require_createBaseFor();
  var baseFor = createBaseFor();
  _baseFor = baseFor;
  return _baseFor;
}
var _baseForOwn;
var hasRequired_baseForOwn;
function require_baseForOwn() {
  if (hasRequired_baseForOwn)
    return _baseForOwn;
  hasRequired_baseForOwn = 1;
  var baseFor = require_baseFor(), keys2 = requireKeys();
  function baseForOwn(object, iteratee) {
    return object && baseFor(object, iteratee, keys2);
  }
  _baseForOwn = baseForOwn;
  return _baseForOwn;
}
var _createBaseEach;
var hasRequired_createBaseEach;
function require_createBaseEach() {
  if (hasRequired_createBaseEach)
    return _createBaseEach;
  hasRequired_createBaseEach = 1;
  var isArrayLike2 = requireIsArrayLike();
  function createBaseEach(eachFunc, fromRight) {
    return function(collection, iteratee) {
      if (collection == null) {
        return collection;
      }
      if (!isArrayLike2(collection)) {
        return eachFunc(collection, iteratee);
      }
      var length = collection.length, index = fromRight ? length : -1, iterable = Object(collection);
      while (fromRight ? index-- : ++index < length) {
        if (iteratee(iterable[index], index, iterable) === false) {
          break;
        }
      }
      return collection;
    };
  }
  _createBaseEach = createBaseEach;
  return _createBaseEach;
}
var _baseEach;
var hasRequired_baseEach;
function require_baseEach() {
  if (hasRequired_baseEach)
    return _baseEach;
  hasRequired_baseEach = 1;
  var baseForOwn = require_baseForOwn(), createBaseEach = require_createBaseEach();
  var baseEach = createBaseEach(baseForOwn);
  _baseEach = baseEach;
  return _baseEach;
}
var identity_1;
var hasRequiredIdentity;
function requireIdentity() {
  if (hasRequiredIdentity)
    return identity_1;
  hasRequiredIdentity = 1;
  function identity2(value) {
    return value;
  }
  identity_1 = identity2;
  return identity_1;
}
var _castFunction;
var hasRequired_castFunction;
function require_castFunction() {
  if (hasRequired_castFunction)
    return _castFunction;
  hasRequired_castFunction = 1;
  var identity2 = requireIdentity();
  function castFunction(value) {
    return typeof value == "function" ? value : identity2;
  }
  _castFunction = castFunction;
  return _castFunction;
}
var forEach_1;
var hasRequiredForEach;
function requireForEach() {
  if (hasRequiredForEach)
    return forEach_1;
  hasRequiredForEach = 1;
  var arrayEach = require_arrayEach(), baseEach = require_baseEach(), castFunction = require_castFunction(), isArray2 = requireIsArray();
  function forEach(collection, iteratee) {
    var func = isArray2(collection) ? arrayEach : baseEach;
    return func(collection, castFunction(iteratee));
  }
  forEach_1 = forEach;
  return forEach_1;
}
var each;
var hasRequiredEach;
function requireEach() {
  if (hasRequiredEach)
    return each;
  hasRequiredEach = 1;
  each = requireForEach();
  return each;
}
var _baseFilter;
var hasRequired_baseFilter;
function require_baseFilter() {
  if (hasRequired_baseFilter)
    return _baseFilter;
  hasRequired_baseFilter = 1;
  var baseEach = require_baseEach();
  function baseFilter(collection, predicate) {
    var result = [];
    baseEach(collection, function(value, index, collection2) {
      if (predicate(value, index, collection2)) {
        result.push(value);
      }
    });
    return result;
  }
  _baseFilter = baseFilter;
  return _baseFilter;
}
var _setCacheAdd;
var hasRequired_setCacheAdd;
function require_setCacheAdd() {
  if (hasRequired_setCacheAdd)
    return _setCacheAdd;
  hasRequired_setCacheAdd = 1;
  var HASH_UNDEFINED2 = "__lodash_hash_undefined__";
  function setCacheAdd2(value) {
    this.__data__.set(value, HASH_UNDEFINED2);
    return this;
  }
  _setCacheAdd = setCacheAdd2;
  return _setCacheAdd;
}
var _setCacheHas;
var hasRequired_setCacheHas;
function require_setCacheHas() {
  if (hasRequired_setCacheHas)
    return _setCacheHas;
  hasRequired_setCacheHas = 1;
  function setCacheHas2(value) {
    return this.__data__.has(value);
  }
  _setCacheHas = setCacheHas2;
  return _setCacheHas;
}
var _SetCache;
var hasRequired_SetCache;
function require_SetCache() {
  if (hasRequired_SetCache)
    return _SetCache;
  hasRequired_SetCache = 1;
  var MapCache2 = require_MapCache(), setCacheAdd2 = require_setCacheAdd(), setCacheHas2 = require_setCacheHas();
  function SetCache2(values) {
    var index = -1, length = values == null ? 0 : values.length;
    this.__data__ = new MapCache2();
    while (++index < length) {
      this.add(values[index]);
    }
  }
  SetCache2.prototype.add = SetCache2.prototype.push = setCacheAdd2;
  SetCache2.prototype.has = setCacheHas2;
  _SetCache = SetCache2;
  return _SetCache;
}
var _arraySome;
var hasRequired_arraySome;
function require_arraySome() {
  if (hasRequired_arraySome)
    return _arraySome;
  hasRequired_arraySome = 1;
  function arraySome2(array, predicate) {
    var index = -1, length = array == null ? 0 : array.length;
    while (++index < length) {
      if (predicate(array[index], index, array)) {
        return true;
      }
    }
    return false;
  }
  _arraySome = arraySome2;
  return _arraySome;
}
var _cacheHas;
var hasRequired_cacheHas;
function require_cacheHas() {
  if (hasRequired_cacheHas)
    return _cacheHas;
  hasRequired_cacheHas = 1;
  function cacheHas2(cache, key) {
    return cache.has(key);
  }
  _cacheHas = cacheHas2;
  return _cacheHas;
}
var _equalArrays;
var hasRequired_equalArrays;
function require_equalArrays() {
  if (hasRequired_equalArrays)
    return _equalArrays;
  hasRequired_equalArrays = 1;
  var SetCache2 = require_SetCache(), arraySome2 = require_arraySome(), cacheHas2 = require_cacheHas();
  var COMPARE_PARTIAL_FLAG2 = 1, COMPARE_UNORDERED_FLAG2 = 2;
  function equalArrays2(array, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG2, arrLength = array.length, othLength = other.length;
    if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
      return false;
    }
    var arrStacked = stack.get(array);
    var othStacked = stack.get(other);
    if (arrStacked && othStacked) {
      return arrStacked == other && othStacked == array;
    }
    var index = -1, result = true, seen = bitmask & COMPARE_UNORDERED_FLAG2 ? new SetCache2() : void 0;
    stack.set(array, other);
    stack.set(other, array);
    while (++index < arrLength) {
      var arrValue = array[index], othValue = other[index];
      if (customizer) {
        var compared = isPartial ? customizer(othValue, arrValue, index, other, array, stack) : customizer(arrValue, othValue, index, array, other, stack);
      }
      if (compared !== void 0) {
        if (compared) {
          continue;
        }
        result = false;
        break;
      }
      if (seen) {
        if (!arraySome2(other, function(othValue2, othIndex) {
          if (!cacheHas2(seen, othIndex) && (arrValue === othValue2 || equalFunc(arrValue, othValue2, bitmask, customizer, stack))) {
            return seen.push(othIndex);
          }
        })) {
          result = false;
          break;
        }
      } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
        result = false;
        break;
      }
    }
    stack["delete"](array);
    stack["delete"](other);
    return result;
  }
  _equalArrays = equalArrays2;
  return _equalArrays;
}
var _mapToArray;
var hasRequired_mapToArray;
function require_mapToArray() {
  if (hasRequired_mapToArray)
    return _mapToArray;
  hasRequired_mapToArray = 1;
  function mapToArray2(map) {
    var index = -1, result = Array(map.size);
    map.forEach(function(value, key) {
      result[++index] = [key, value];
    });
    return result;
  }
  _mapToArray = mapToArray2;
  return _mapToArray;
}
var _setToArray;
var hasRequired_setToArray;
function require_setToArray() {
  if (hasRequired_setToArray)
    return _setToArray;
  hasRequired_setToArray = 1;
  function setToArray2(set) {
    var index = -1, result = Array(set.size);
    set.forEach(function(value) {
      result[++index] = value;
    });
    return result;
  }
  _setToArray = setToArray2;
  return _setToArray;
}
var _equalByTag;
var hasRequired_equalByTag;
function require_equalByTag() {
  if (hasRequired_equalByTag)
    return _equalByTag;
  hasRequired_equalByTag = 1;
  var Symbol = require_Symbol(), Uint8Array2 = require_Uint8Array(), eq2 = requireEq(), equalArrays2 = require_equalArrays(), mapToArray2 = require_mapToArray(), setToArray2 = require_setToArray();
  var COMPARE_PARTIAL_FLAG2 = 1, COMPARE_UNORDERED_FLAG2 = 2;
  var boolTag2 = "[object Boolean]", dateTag2 = "[object Date]", errorTag2 = "[object Error]", mapTag2 = "[object Map]", numberTag2 = "[object Number]", regexpTag2 = "[object RegExp]", setTag2 = "[object Set]", stringTag2 = "[object String]", symbolTag2 = "[object Symbol]";
  var arrayBufferTag2 = "[object ArrayBuffer]", dataViewTag2 = "[object DataView]";
  var symbolProto2 = Symbol ? Symbol.prototype : void 0, symbolValueOf2 = symbolProto2 ? symbolProto2.valueOf : void 0;
  function equalByTag2(object, other, tag, bitmask, customizer, equalFunc, stack) {
    switch (tag) {
      case dataViewTag2:
        if (object.byteLength != other.byteLength || object.byteOffset != other.byteOffset) {
          return false;
        }
        object = object.buffer;
        other = other.buffer;
      case arrayBufferTag2:
        if (object.byteLength != other.byteLength || !equalFunc(new Uint8Array2(object), new Uint8Array2(other))) {
          return false;
        }
        return true;
      case boolTag2:
      case dateTag2:
      case numberTag2:
        return eq2(+object, +other);
      case errorTag2:
        return object.name == other.name && object.message == other.message;
      case regexpTag2:
      case stringTag2:
        return object == other + "";
      case mapTag2:
        var convert = mapToArray2;
      case setTag2:
        var isPartial = bitmask & COMPARE_PARTIAL_FLAG2;
        convert || (convert = setToArray2);
        if (object.size != other.size && !isPartial) {
          return false;
        }
        var stacked = stack.get(object);
        if (stacked) {
          return stacked == other;
        }
        bitmask |= COMPARE_UNORDERED_FLAG2;
        stack.set(object, other);
        var result = equalArrays2(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
        stack["delete"](object);
        return result;
      case symbolTag2:
        if (symbolValueOf2) {
          return symbolValueOf2.call(object) == symbolValueOf2.call(other);
        }
    }
    return false;
  }
  _equalByTag = equalByTag2;
  return _equalByTag;
}
var _equalObjects;
var hasRequired_equalObjects;
function require_equalObjects() {
  if (hasRequired_equalObjects)
    return _equalObjects;
  hasRequired_equalObjects = 1;
  var getAllKeys2 = require_getAllKeys();
  var COMPARE_PARTIAL_FLAG2 = 1;
  var objectProto2 = Object.prototype;
  var hasOwnProperty2 = objectProto2.hasOwnProperty;
  function equalObjects2(object, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG2, objProps = getAllKeys2(object), objLength = objProps.length, othProps = getAllKeys2(other), othLength = othProps.length;
    if (objLength != othLength && !isPartial) {
      return false;
    }
    var index = objLength;
    while (index--) {
      var key = objProps[index];
      if (!(isPartial ? key in other : hasOwnProperty2.call(other, key))) {
        return false;
      }
    }
    var objStacked = stack.get(object);
    var othStacked = stack.get(other);
    if (objStacked && othStacked) {
      return objStacked == other && othStacked == object;
    }
    var result = true;
    stack.set(object, other);
    stack.set(other, object);
    var skipCtor = isPartial;
    while (++index < objLength) {
      key = objProps[index];
      var objValue = object[key], othValue = other[key];
      if (customizer) {
        var compared = isPartial ? customizer(othValue, objValue, key, other, object, stack) : customizer(objValue, othValue, key, object, other, stack);
      }
      if (!(compared === void 0 ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack) : compared)) {
        result = false;
        break;
      }
      skipCtor || (skipCtor = key == "constructor");
    }
    if (result && !skipCtor) {
      var objCtor = object.constructor, othCtor = other.constructor;
      if (objCtor != othCtor && ("constructor" in object && "constructor" in other) && !(typeof objCtor == "function" && objCtor instanceof objCtor && typeof othCtor == "function" && othCtor instanceof othCtor)) {
        result = false;
      }
    }
    stack["delete"](object);
    stack["delete"](other);
    return result;
  }
  _equalObjects = equalObjects2;
  return _equalObjects;
}
var _baseIsEqualDeep;
var hasRequired_baseIsEqualDeep;
function require_baseIsEqualDeep() {
  if (hasRequired_baseIsEqualDeep)
    return _baseIsEqualDeep;
  hasRequired_baseIsEqualDeep = 1;
  var Stack2 = require_Stack(), equalArrays2 = require_equalArrays(), equalByTag2 = require_equalByTag(), equalObjects2 = require_equalObjects(), getTag2 = require_getTag(), isArray2 = requireIsArray(), isBuffer2 = requireIsBuffer(), isTypedArray2 = requireIsTypedArray();
  var COMPARE_PARTIAL_FLAG2 = 1;
  var argsTag2 = "[object Arguments]", arrayTag2 = "[object Array]", objectTag2 = "[object Object]";
  var objectProto2 = Object.prototype;
  var hasOwnProperty2 = objectProto2.hasOwnProperty;
  function baseIsEqualDeep2(object, other, bitmask, customizer, equalFunc, stack) {
    var objIsArr = isArray2(object), othIsArr = isArray2(other), objTag = objIsArr ? arrayTag2 : getTag2(object), othTag = othIsArr ? arrayTag2 : getTag2(other);
    objTag = objTag == argsTag2 ? objectTag2 : objTag;
    othTag = othTag == argsTag2 ? objectTag2 : othTag;
    var objIsObj = objTag == objectTag2, othIsObj = othTag == objectTag2, isSameTag = objTag == othTag;
    if (isSameTag && isBuffer2(object)) {
      if (!isBuffer2(other)) {
        return false;
      }
      objIsArr = true;
      objIsObj = false;
    }
    if (isSameTag && !objIsObj) {
      stack || (stack = new Stack2());
      return objIsArr || isTypedArray2(object) ? equalArrays2(object, other, bitmask, customizer, equalFunc, stack) : equalByTag2(object, other, objTag, bitmask, customizer, equalFunc, stack);
    }
    if (!(bitmask & COMPARE_PARTIAL_FLAG2)) {
      var objIsWrapped = objIsObj && hasOwnProperty2.call(object, "__wrapped__"), othIsWrapped = othIsObj && hasOwnProperty2.call(other, "__wrapped__");
      if (objIsWrapped || othIsWrapped) {
        var objUnwrapped = objIsWrapped ? object.value() : object, othUnwrapped = othIsWrapped ? other.value() : other;
        stack || (stack = new Stack2());
        return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
      }
    }
    if (!isSameTag) {
      return false;
    }
    stack || (stack = new Stack2());
    return equalObjects2(object, other, bitmask, customizer, equalFunc, stack);
  }
  _baseIsEqualDeep = baseIsEqualDeep2;
  return _baseIsEqualDeep;
}
var _baseIsEqual;
var hasRequired_baseIsEqual;
function require_baseIsEqual() {
  if (hasRequired_baseIsEqual)
    return _baseIsEqual;
  hasRequired_baseIsEqual = 1;
  var baseIsEqualDeep2 = require_baseIsEqualDeep(), isObjectLike2 = requireIsObjectLike();
  function baseIsEqual2(value, other, bitmask, customizer, stack) {
    if (value === other) {
      return true;
    }
    if (value == null || other == null || !isObjectLike2(value) && !isObjectLike2(other)) {
      return value !== value && other !== other;
    }
    return baseIsEqualDeep2(value, other, bitmask, customizer, baseIsEqual2, stack);
  }
  _baseIsEqual = baseIsEqual2;
  return _baseIsEqual;
}
var _baseIsMatch;
var hasRequired_baseIsMatch;
function require_baseIsMatch() {
  if (hasRequired_baseIsMatch)
    return _baseIsMatch;
  hasRequired_baseIsMatch = 1;
  var Stack2 = require_Stack(), baseIsEqual2 = require_baseIsEqual();
  var COMPARE_PARTIAL_FLAG2 = 1, COMPARE_UNORDERED_FLAG2 = 2;
  function baseIsMatch2(object, source, matchData, customizer) {
    var index = matchData.length, length = index, noCustomizer = !customizer;
    if (object == null) {
      return !length;
    }
    object = Object(object);
    while (index--) {
      var data = matchData[index];
      if (noCustomizer && data[2] ? data[1] !== object[data[0]] : !(data[0] in object)) {
        return false;
      }
    }
    while (++index < length) {
      data = matchData[index];
      var key = data[0], objValue = object[key], srcValue = data[1];
      if (noCustomizer && data[2]) {
        if (objValue === void 0 && !(key in object)) {
          return false;
        }
      } else {
        var stack = new Stack2();
        if (customizer) {
          var result = customizer(objValue, srcValue, key, object, source, stack);
        }
        if (!(result === void 0 ? baseIsEqual2(srcValue, objValue, COMPARE_PARTIAL_FLAG2 | COMPARE_UNORDERED_FLAG2, customizer, stack) : result)) {
          return false;
        }
      }
    }
    return true;
  }
  _baseIsMatch = baseIsMatch2;
  return _baseIsMatch;
}
var _isStrictComparable;
var hasRequired_isStrictComparable;
function require_isStrictComparable() {
  if (hasRequired_isStrictComparable)
    return _isStrictComparable;
  hasRequired_isStrictComparable = 1;
  var isObject2 = requireIsObject();
  function isStrictComparable2(value) {
    return value === value && !isObject2(value);
  }
  _isStrictComparable = isStrictComparable2;
  return _isStrictComparable;
}
var _getMatchData;
var hasRequired_getMatchData;
function require_getMatchData() {
  if (hasRequired_getMatchData)
    return _getMatchData;
  hasRequired_getMatchData = 1;
  var isStrictComparable2 = require_isStrictComparable(), keys2 = requireKeys();
  function getMatchData2(object) {
    var result = keys2(object), length = result.length;
    while (length--) {
      var key = result[length], value = object[key];
      result[length] = [key, value, isStrictComparable2(value)];
    }
    return result;
  }
  _getMatchData = getMatchData2;
  return _getMatchData;
}
var _matchesStrictComparable;
var hasRequired_matchesStrictComparable;
function require_matchesStrictComparable() {
  if (hasRequired_matchesStrictComparable)
    return _matchesStrictComparable;
  hasRequired_matchesStrictComparable = 1;
  function matchesStrictComparable2(key, srcValue) {
    return function(object) {
      if (object == null) {
        return false;
      }
      return object[key] === srcValue && (srcValue !== void 0 || key in Object(object));
    };
  }
  _matchesStrictComparable = matchesStrictComparable2;
  return _matchesStrictComparable;
}
var _baseMatches;
var hasRequired_baseMatches;
function require_baseMatches() {
  if (hasRequired_baseMatches)
    return _baseMatches;
  hasRequired_baseMatches = 1;
  var baseIsMatch2 = require_baseIsMatch(), getMatchData2 = require_getMatchData(), matchesStrictComparable2 = require_matchesStrictComparable();
  function baseMatches2(source) {
    var matchData = getMatchData2(source);
    if (matchData.length == 1 && matchData[0][2]) {
      return matchesStrictComparable2(matchData[0][0], matchData[0][1]);
    }
    return function(object) {
      return object === source || baseIsMatch2(object, source, matchData);
    };
  }
  _baseMatches = baseMatches2;
  return _baseMatches;
}
var isSymbol_1;
var hasRequiredIsSymbol;
function requireIsSymbol() {
  if (hasRequiredIsSymbol)
    return isSymbol_1;
  hasRequiredIsSymbol = 1;
  var baseGetTag2 = require_baseGetTag(), isObjectLike2 = requireIsObjectLike();
  var symbolTag2 = "[object Symbol]";
  function isSymbol2(value) {
    return typeof value == "symbol" || isObjectLike2(value) && baseGetTag2(value) == symbolTag2;
  }
  isSymbol_1 = isSymbol2;
  return isSymbol_1;
}
var _isKey;
var hasRequired_isKey;
function require_isKey() {
  if (hasRequired_isKey)
    return _isKey;
  hasRequired_isKey = 1;
  var isArray2 = requireIsArray(), isSymbol2 = requireIsSymbol();
  var reIsDeepProp2 = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, reIsPlainProp2 = /^\w*$/;
  function isKey2(value, object) {
    if (isArray2(value)) {
      return false;
    }
    var type = typeof value;
    if (type == "number" || type == "symbol" || type == "boolean" || value == null || isSymbol2(value)) {
      return true;
    }
    return reIsPlainProp2.test(value) || !reIsDeepProp2.test(value) || object != null && value in Object(object);
  }
  _isKey = isKey2;
  return _isKey;
}
var memoize_1;
var hasRequiredMemoize;
function requireMemoize() {
  if (hasRequiredMemoize)
    return memoize_1;
  hasRequiredMemoize = 1;
  var MapCache2 = require_MapCache();
  var FUNC_ERROR_TEXT2 = "Expected a function";
  function memoize2(func, resolver) {
    if (typeof func != "function" || resolver != null && typeof resolver != "function") {
      throw new TypeError(FUNC_ERROR_TEXT2);
    }
    var memoized = function() {
      var args = arguments, key = resolver ? resolver.apply(this, args) : args[0], cache = memoized.cache;
      if (cache.has(key)) {
        return cache.get(key);
      }
      var result = func.apply(this, args);
      memoized.cache = cache.set(key, result) || cache;
      return result;
    };
    memoized.cache = new (memoize2.Cache || MapCache2)();
    return memoized;
  }
  memoize2.Cache = MapCache2;
  memoize_1 = memoize2;
  return memoize_1;
}
var _memoizeCapped;
var hasRequired_memoizeCapped;
function require_memoizeCapped() {
  if (hasRequired_memoizeCapped)
    return _memoizeCapped;
  hasRequired_memoizeCapped = 1;
  var memoize2 = requireMemoize();
  var MAX_MEMOIZE_SIZE2 = 500;
  function memoizeCapped2(func) {
    var result = memoize2(func, function(key) {
      if (cache.size === MAX_MEMOIZE_SIZE2) {
        cache.clear();
      }
      return key;
    });
    var cache = result.cache;
    return result;
  }
  _memoizeCapped = memoizeCapped2;
  return _memoizeCapped;
}
var _stringToPath;
var hasRequired_stringToPath;
function require_stringToPath() {
  if (hasRequired_stringToPath)
    return _stringToPath;
  hasRequired_stringToPath = 1;
  var memoizeCapped2 = require_memoizeCapped();
  var rePropName2 = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
  var reEscapeChar2 = /\\(\\)?/g;
  var stringToPath2 = memoizeCapped2(function(string) {
    var result = [];
    if (string.charCodeAt(0) === 46) {
      result.push("");
    }
    string.replace(rePropName2, function(match, number, quote, subString) {
      result.push(quote ? subString.replace(reEscapeChar2, "$1") : number || match);
    });
    return result;
  });
  _stringToPath = stringToPath2;
  return _stringToPath;
}
var _arrayMap;
var hasRequired_arrayMap;
function require_arrayMap() {
  if (hasRequired_arrayMap)
    return _arrayMap;
  hasRequired_arrayMap = 1;
  function arrayMap2(array, iteratee) {
    var index = -1, length = array == null ? 0 : array.length, result = Array(length);
    while (++index < length) {
      result[index] = iteratee(array[index], index, array);
    }
    return result;
  }
  _arrayMap = arrayMap2;
  return _arrayMap;
}
var _baseToString;
var hasRequired_baseToString;
function require_baseToString() {
  if (hasRequired_baseToString)
    return _baseToString;
  hasRequired_baseToString = 1;
  var Symbol = require_Symbol(), arrayMap2 = require_arrayMap(), isArray2 = requireIsArray(), isSymbol2 = requireIsSymbol();
  var symbolProto2 = Symbol ? Symbol.prototype : void 0, symbolToString2 = symbolProto2 ? symbolProto2.toString : void 0;
  function baseToString2(value) {
    if (typeof value == "string") {
      return value;
    }
    if (isArray2(value)) {
      return arrayMap2(value, baseToString2) + "";
    }
    if (isSymbol2(value)) {
      return symbolToString2 ? symbolToString2.call(value) : "";
    }
    var result = value + "";
    return result == "0" && 1 / value == -Infinity ? "-0" : result;
  }
  _baseToString = baseToString2;
  return _baseToString;
}
var toString_1;
var hasRequiredToString;
function requireToString() {
  if (hasRequiredToString)
    return toString_1;
  hasRequiredToString = 1;
  var baseToString2 = require_baseToString();
  function toString2(value) {
    return value == null ? "" : baseToString2(value);
  }
  toString_1 = toString2;
  return toString_1;
}
var _castPath;
var hasRequired_castPath;
function require_castPath() {
  if (hasRequired_castPath)
    return _castPath;
  hasRequired_castPath = 1;
  var isArray2 = requireIsArray(), isKey2 = require_isKey(), stringToPath2 = require_stringToPath(), toString2 = requireToString();
  function castPath2(value, object) {
    if (isArray2(value)) {
      return value;
    }
    return isKey2(value, object) ? [value] : stringToPath2(toString2(value));
  }
  _castPath = castPath2;
  return _castPath;
}
var _toKey;
var hasRequired_toKey;
function require_toKey() {
  if (hasRequired_toKey)
    return _toKey;
  hasRequired_toKey = 1;
  var isSymbol2 = requireIsSymbol();
  function toKey2(value) {
    if (typeof value == "string" || isSymbol2(value)) {
      return value;
    }
    var result = value + "";
    return result == "0" && 1 / value == -Infinity ? "-0" : result;
  }
  _toKey = toKey2;
  return _toKey;
}
var _baseGet;
var hasRequired_baseGet;
function require_baseGet() {
  if (hasRequired_baseGet)
    return _baseGet;
  hasRequired_baseGet = 1;
  var castPath2 = require_castPath(), toKey2 = require_toKey();
  function baseGet2(object, path) {
    path = castPath2(path, object);
    var index = 0, length = path.length;
    while (object != null && index < length) {
      object = object[toKey2(path[index++])];
    }
    return index && index == length ? object : void 0;
  }
  _baseGet = baseGet2;
  return _baseGet;
}
var get_1;
var hasRequiredGet;
function requireGet() {
  if (hasRequiredGet)
    return get_1;
  hasRequiredGet = 1;
  var baseGet2 = require_baseGet();
  function get2(object, path, defaultValue) {
    var result = object == null ? void 0 : baseGet2(object, path);
    return result === void 0 ? defaultValue : result;
  }
  get_1 = get2;
  return get_1;
}
var _baseHasIn;
var hasRequired_baseHasIn;
function require_baseHasIn() {
  if (hasRequired_baseHasIn)
    return _baseHasIn;
  hasRequired_baseHasIn = 1;
  function baseHasIn2(object, key) {
    return object != null && key in Object(object);
  }
  _baseHasIn = baseHasIn2;
  return _baseHasIn;
}
var _hasPath;
var hasRequired_hasPath;
function require_hasPath() {
  if (hasRequired_hasPath)
    return _hasPath;
  hasRequired_hasPath = 1;
  var castPath2 = require_castPath(), isArguments2 = requireIsArguments(), isArray2 = requireIsArray(), isIndex2 = require_isIndex(), isLength2 = requireIsLength(), toKey2 = require_toKey();
  function hasPath2(object, path, hasFunc) {
    path = castPath2(path, object);
    var index = -1, length = path.length, result = false;
    while (++index < length) {
      var key = toKey2(path[index]);
      if (!(result = object != null && hasFunc(object, key))) {
        break;
      }
      object = object[key];
    }
    if (result || ++index != length) {
      return result;
    }
    length = object == null ? 0 : object.length;
    return !!length && isLength2(length) && isIndex2(key, length) && (isArray2(object) || isArguments2(object));
  }
  _hasPath = hasPath2;
  return _hasPath;
}
var hasIn_1;
var hasRequiredHasIn;
function requireHasIn() {
  if (hasRequiredHasIn)
    return hasIn_1;
  hasRequiredHasIn = 1;
  var baseHasIn2 = require_baseHasIn(), hasPath2 = require_hasPath();
  function hasIn2(object, path) {
    return object != null && hasPath2(object, path, baseHasIn2);
  }
  hasIn_1 = hasIn2;
  return hasIn_1;
}
var _baseMatchesProperty;
var hasRequired_baseMatchesProperty;
function require_baseMatchesProperty() {
  if (hasRequired_baseMatchesProperty)
    return _baseMatchesProperty;
  hasRequired_baseMatchesProperty = 1;
  var baseIsEqual2 = require_baseIsEqual(), get2 = requireGet(), hasIn2 = requireHasIn(), isKey2 = require_isKey(), isStrictComparable2 = require_isStrictComparable(), matchesStrictComparable2 = require_matchesStrictComparable(), toKey2 = require_toKey();
  var COMPARE_PARTIAL_FLAG2 = 1, COMPARE_UNORDERED_FLAG2 = 2;
  function baseMatchesProperty2(path, srcValue) {
    if (isKey2(path) && isStrictComparable2(srcValue)) {
      return matchesStrictComparable2(toKey2(path), srcValue);
    }
    return function(object) {
      var objValue = get2(object, path);
      return objValue === void 0 && objValue === srcValue ? hasIn2(object, path) : baseIsEqual2(srcValue, objValue, COMPARE_PARTIAL_FLAG2 | COMPARE_UNORDERED_FLAG2);
    };
  }
  _baseMatchesProperty = baseMatchesProperty2;
  return _baseMatchesProperty;
}
var _baseProperty;
var hasRequired_baseProperty;
function require_baseProperty() {
  if (hasRequired_baseProperty)
    return _baseProperty;
  hasRequired_baseProperty = 1;
  function baseProperty2(key) {
    return function(object) {
      return object == null ? void 0 : object[key];
    };
  }
  _baseProperty = baseProperty2;
  return _baseProperty;
}
var _basePropertyDeep;
var hasRequired_basePropertyDeep;
function require_basePropertyDeep() {
  if (hasRequired_basePropertyDeep)
    return _basePropertyDeep;
  hasRequired_basePropertyDeep = 1;
  var baseGet2 = require_baseGet();
  function basePropertyDeep2(path) {
    return function(object) {
      return baseGet2(object, path);
    };
  }
  _basePropertyDeep = basePropertyDeep2;
  return _basePropertyDeep;
}
var property_1;
var hasRequiredProperty;
function requireProperty() {
  if (hasRequiredProperty)
    return property_1;
  hasRequiredProperty = 1;
  var baseProperty2 = require_baseProperty(), basePropertyDeep2 = require_basePropertyDeep(), isKey2 = require_isKey(), toKey2 = require_toKey();
  function property2(path) {
    return isKey2(path) ? baseProperty2(toKey2(path)) : basePropertyDeep2(path);
  }
  property_1 = property2;
  return property_1;
}
var _baseIteratee;
var hasRequired_baseIteratee;
function require_baseIteratee() {
  if (hasRequired_baseIteratee)
    return _baseIteratee;
  hasRequired_baseIteratee = 1;
  var baseMatches2 = require_baseMatches(), baseMatchesProperty2 = require_baseMatchesProperty(), identity2 = requireIdentity(), isArray2 = requireIsArray(), property2 = requireProperty();
  function baseIteratee2(value) {
    if (typeof value == "function") {
      return value;
    }
    if (value == null) {
      return identity2;
    }
    if (typeof value == "object") {
      return isArray2(value) ? baseMatchesProperty2(value[0], value[1]) : baseMatches2(value);
    }
    return property2(value);
  }
  _baseIteratee = baseIteratee2;
  return _baseIteratee;
}
var filter_1;
var hasRequiredFilter;
function requireFilter() {
  if (hasRequiredFilter)
    return filter_1;
  hasRequiredFilter = 1;
  var arrayFilter2 = require_arrayFilter(), baseFilter = require_baseFilter(), baseIteratee2 = require_baseIteratee(), isArray2 = requireIsArray();
  function filter(collection, predicate) {
    var func = isArray2(collection) ? arrayFilter2 : baseFilter;
    return func(collection, baseIteratee2(predicate, 3));
  }
  filter_1 = filter;
  return filter_1;
}
var _baseHas;
var hasRequired_baseHas;
function require_baseHas() {
  if (hasRequired_baseHas)
    return _baseHas;
  hasRequired_baseHas = 1;
  var objectProto2 = Object.prototype;
  var hasOwnProperty2 = objectProto2.hasOwnProperty;
  function baseHas(object, key) {
    return object != null && hasOwnProperty2.call(object, key);
  }
  _baseHas = baseHas;
  return _baseHas;
}
var has_1;
var hasRequiredHas;
function requireHas() {
  if (hasRequiredHas)
    return has_1;
  hasRequiredHas = 1;
  var baseHas = require_baseHas(), hasPath2 = require_hasPath();
  function has(object, path) {
    return object != null && hasPath2(object, path, baseHas);
  }
  has_1 = has;
  return has_1;
}
var isEmpty_1;
var hasRequiredIsEmpty;
function requireIsEmpty() {
  if (hasRequiredIsEmpty)
    return isEmpty_1;
  hasRequiredIsEmpty = 1;
  var baseKeys2 = require_baseKeys(), getTag2 = require_getTag(), isArguments2 = requireIsArguments(), isArray2 = requireIsArray(), isArrayLike2 = requireIsArrayLike(), isBuffer2 = requireIsBuffer(), isPrototype2 = require_isPrototype(), isTypedArray2 = requireIsTypedArray();
  var mapTag2 = "[object Map]", setTag2 = "[object Set]";
  var objectProto2 = Object.prototype;
  var hasOwnProperty2 = objectProto2.hasOwnProperty;
  function isEmpty(value) {
    if (value == null) {
      return true;
    }
    if (isArrayLike2(value) && (isArray2(value) || typeof value == "string" || typeof value.splice == "function" || isBuffer2(value) || isTypedArray2(value) || isArguments2(value))) {
      return !value.length;
    }
    var tag = getTag2(value);
    if (tag == mapTag2 || tag == setTag2) {
      return !value.size;
    }
    if (isPrototype2(value)) {
      return !baseKeys2(value).length;
    }
    for (var key in value) {
      if (hasOwnProperty2.call(value, key)) {
        return false;
      }
    }
    return true;
  }
  isEmpty_1 = isEmpty;
  return isEmpty_1;
}
var isUndefined_1;
var hasRequiredIsUndefined;
function requireIsUndefined() {
  if (hasRequiredIsUndefined)
    return isUndefined_1;
  hasRequiredIsUndefined = 1;
  function isUndefined(value) {
    return value === void 0;
  }
  isUndefined_1 = isUndefined;
  return isUndefined_1;
}
var _baseMap;
var hasRequired_baseMap;
function require_baseMap() {
  if (hasRequired_baseMap)
    return _baseMap;
  hasRequired_baseMap = 1;
  var baseEach = require_baseEach(), isArrayLike2 = requireIsArrayLike();
  function baseMap(collection, iteratee) {
    var index = -1, result = isArrayLike2(collection) ? Array(collection.length) : [];
    baseEach(collection, function(value, key, collection2) {
      result[++index] = iteratee(value, key, collection2);
    });
    return result;
  }
  _baseMap = baseMap;
  return _baseMap;
}
var map_1;
var hasRequiredMap;
function requireMap() {
  if (hasRequiredMap)
    return map_1;
  hasRequiredMap = 1;
  var arrayMap2 = require_arrayMap(), baseIteratee2 = require_baseIteratee(), baseMap = require_baseMap(), isArray2 = requireIsArray();
  function map(collection, iteratee) {
    var func = isArray2(collection) ? arrayMap2 : baseMap;
    return func(collection, baseIteratee2(iteratee, 3));
  }
  map_1 = map;
  return map_1;
}
var _arrayReduce;
var hasRequired_arrayReduce;
function require_arrayReduce() {
  if (hasRequired_arrayReduce)
    return _arrayReduce;
  hasRequired_arrayReduce = 1;
  function arrayReduce2(array, iteratee, accumulator, initAccum) {
    var index = -1, length = array == null ? 0 : array.length;
    if (initAccum && length) {
      accumulator = array[++index];
    }
    while (++index < length) {
      accumulator = iteratee(accumulator, array[index], index, array);
    }
    return accumulator;
  }
  _arrayReduce = arrayReduce2;
  return _arrayReduce;
}
var _baseReduce;
var hasRequired_baseReduce;
function require_baseReduce() {
  if (hasRequired_baseReduce)
    return _baseReduce;
  hasRequired_baseReduce = 1;
  function baseReduce(collection, iteratee, accumulator, initAccum, eachFunc) {
    eachFunc(collection, function(value, index, collection2) {
      accumulator = initAccum ? (initAccum = false, value) : iteratee(accumulator, value, index, collection2);
    });
    return accumulator;
  }
  _baseReduce = baseReduce;
  return _baseReduce;
}
var reduce_1;
var hasRequiredReduce;
function requireReduce() {
  if (hasRequiredReduce)
    return reduce_1;
  hasRequiredReduce = 1;
  var arrayReduce2 = require_arrayReduce(), baseEach = require_baseEach(), baseIteratee2 = require_baseIteratee(), baseReduce = require_baseReduce(), isArray2 = requireIsArray();
  function reduce(collection, iteratee, accumulator) {
    var func = isArray2(collection) ? arrayReduce2 : baseReduce, initAccum = arguments.length < 3;
    return func(collection, baseIteratee2(iteratee, 4), accumulator, initAccum, baseEach);
  }
  reduce_1 = reduce;
  return reduce_1;
}
var isString_1;
var hasRequiredIsString;
function requireIsString() {
  if (hasRequiredIsString)
    return isString_1;
  hasRequiredIsString = 1;
  var baseGetTag2 = require_baseGetTag(), isArray2 = requireIsArray(), isObjectLike2 = requireIsObjectLike();
  var stringTag2 = "[object String]";
  function isString(value) {
    return typeof value == "string" || !isArray2(value) && isObjectLike2(value) && baseGetTag2(value) == stringTag2;
  }
  isString_1 = isString;
  return isString_1;
}
var _asciiSize;
var hasRequired_asciiSize;
function require_asciiSize() {
  if (hasRequired_asciiSize)
    return _asciiSize;
  hasRequired_asciiSize = 1;
  var baseProperty2 = require_baseProperty();
  var asciiSize = baseProperty2("length");
  _asciiSize = asciiSize;
  return _asciiSize;
}
var _hasUnicode;
var hasRequired_hasUnicode;
function require_hasUnicode() {
  if (hasRequired_hasUnicode)
    return _hasUnicode;
  hasRequired_hasUnicode = 1;
  var rsAstralRange2 = "\\ud800-\\udfff", rsComboMarksRange2 = "\\u0300-\\u036f", reComboHalfMarksRange2 = "\\ufe20-\\ufe2f", rsComboSymbolsRange2 = "\\u20d0-\\u20ff", rsComboRange2 = rsComboMarksRange2 + reComboHalfMarksRange2 + rsComboSymbolsRange2, rsVarRange2 = "\\ufe0e\\ufe0f";
  var rsZWJ2 = "\\u200d";
  var reHasUnicode = RegExp("[" + rsZWJ2 + rsAstralRange2 + rsComboRange2 + rsVarRange2 + "]");
  function hasUnicode(string) {
    return reHasUnicode.test(string);
  }
  _hasUnicode = hasUnicode;
  return _hasUnicode;
}
var _unicodeSize;
var hasRequired_unicodeSize;
function require_unicodeSize() {
  if (hasRequired_unicodeSize)
    return _unicodeSize;
  hasRequired_unicodeSize = 1;
  var rsAstralRange2 = "\\ud800-\\udfff", rsComboMarksRange2 = "\\u0300-\\u036f", reComboHalfMarksRange2 = "\\ufe20-\\ufe2f", rsComboSymbolsRange2 = "\\u20d0-\\u20ff", rsComboRange2 = rsComboMarksRange2 + reComboHalfMarksRange2 + rsComboSymbolsRange2, rsVarRange2 = "\\ufe0e\\ufe0f";
  var rsAstral = "[" + rsAstralRange2 + "]", rsCombo2 = "[" + rsComboRange2 + "]", rsFitz2 = "\\ud83c[\\udffb-\\udfff]", rsModifier2 = "(?:" + rsCombo2 + "|" + rsFitz2 + ")", rsNonAstral2 = "[^" + rsAstralRange2 + "]", rsRegional2 = "(?:\\ud83c[\\udde6-\\uddff]){2}", rsSurrPair2 = "[\\ud800-\\udbff][\\udc00-\\udfff]", rsZWJ2 = "\\u200d";
  var reOptMod2 = rsModifier2 + "?", rsOptVar2 = "[" + rsVarRange2 + "]?", rsOptJoin2 = "(?:" + rsZWJ2 + "(?:" + [rsNonAstral2, rsRegional2, rsSurrPair2].join("|") + ")" + rsOptVar2 + reOptMod2 + ")*", rsSeq2 = rsOptVar2 + reOptMod2 + rsOptJoin2, rsSymbol = "(?:" + [rsNonAstral2 + rsCombo2 + "?", rsCombo2, rsRegional2, rsSurrPair2, rsAstral].join("|") + ")";
  var reUnicode = RegExp(rsFitz2 + "(?=" + rsFitz2 + ")|" + rsSymbol + rsSeq2, "g");
  function unicodeSize(string) {
    var result = reUnicode.lastIndex = 0;
    while (reUnicode.test(string)) {
      ++result;
    }
    return result;
  }
  _unicodeSize = unicodeSize;
  return _unicodeSize;
}
var _stringSize;
var hasRequired_stringSize;
function require_stringSize() {
  if (hasRequired_stringSize)
    return _stringSize;
  hasRequired_stringSize = 1;
  var asciiSize = require_asciiSize(), hasUnicode = require_hasUnicode(), unicodeSize = require_unicodeSize();
  function stringSize(string) {
    return hasUnicode(string) ? unicodeSize(string) : asciiSize(string);
  }
  _stringSize = stringSize;
  return _stringSize;
}
var size_1;
var hasRequiredSize;
function requireSize() {
  if (hasRequiredSize)
    return size_1;
  hasRequiredSize = 1;
  var baseKeys2 = require_baseKeys(), getTag2 = require_getTag(), isArrayLike2 = requireIsArrayLike(), isString = requireIsString(), stringSize = require_stringSize();
  var mapTag2 = "[object Map]", setTag2 = "[object Set]";
  function size(collection) {
    if (collection == null) {
      return 0;
    }
    if (isArrayLike2(collection)) {
      return isString(collection) ? stringSize(collection) : collection.length;
    }
    var tag = getTag2(collection);
    if (tag == mapTag2 || tag == setTag2) {
      return collection.size;
    }
    return baseKeys2(collection).length;
  }
  size_1 = size;
  return size_1;
}
var transform_1;
var hasRequiredTransform;
function requireTransform() {
  if (hasRequiredTransform)
    return transform_1;
  hasRequiredTransform = 1;
  var arrayEach = require_arrayEach(), baseCreate = require_baseCreate(), baseForOwn = require_baseForOwn(), baseIteratee2 = require_baseIteratee(), getPrototype = require_getPrototype(), isArray2 = requireIsArray(), isBuffer2 = requireIsBuffer(), isFunction2 = requireIsFunction(), isObject2 = requireIsObject(), isTypedArray2 = requireIsTypedArray();
  function transform(object, iteratee, accumulator) {
    var isArr = isArray2(object), isArrLike = isArr || isBuffer2(object) || isTypedArray2(object);
    iteratee = baseIteratee2(iteratee, 4);
    if (accumulator == null) {
      var Ctor = object && object.constructor;
      if (isArrLike) {
        accumulator = isArr ? new Ctor() : [];
      } else if (isObject2(object)) {
        accumulator = isFunction2(Ctor) ? baseCreate(getPrototype(object)) : {};
      } else {
        accumulator = {};
      }
    }
    (isArrLike ? arrayEach : baseForOwn)(object, function(value, index, object2) {
      return iteratee(accumulator, value, index, object2);
    });
    return accumulator;
  }
  transform_1 = transform;
  return transform_1;
}
var _isFlattenable;
var hasRequired_isFlattenable;
function require_isFlattenable() {
  if (hasRequired_isFlattenable)
    return _isFlattenable;
  hasRequired_isFlattenable = 1;
  var Symbol = require_Symbol(), isArguments2 = requireIsArguments(), isArray2 = requireIsArray();
  var spreadableSymbol = Symbol ? Symbol.isConcatSpreadable : void 0;
  function isFlattenable(value) {
    return isArray2(value) || isArguments2(value) || !!(spreadableSymbol && value && value[spreadableSymbol]);
  }
  _isFlattenable = isFlattenable;
  return _isFlattenable;
}
var _baseFlatten;
var hasRequired_baseFlatten;
function require_baseFlatten() {
  if (hasRequired_baseFlatten)
    return _baseFlatten;
  hasRequired_baseFlatten = 1;
  var arrayPush2 = require_arrayPush(), isFlattenable = require_isFlattenable();
  function baseFlatten(array, depth, predicate, isStrict, result) {
    var index = -1, length = array.length;
    predicate || (predicate = isFlattenable);
    result || (result = []);
    while (++index < length) {
      var value = array[index];
      if (depth > 0 && predicate(value)) {
        if (depth > 1) {
          baseFlatten(value, depth - 1, predicate, isStrict, result);
        } else {
          arrayPush2(result, value);
        }
      } else if (!isStrict) {
        result[result.length] = value;
      }
    }
    return result;
  }
  _baseFlatten = baseFlatten;
  return _baseFlatten;
}
var _apply;
var hasRequired_apply;
function require_apply() {
  if (hasRequired_apply)
    return _apply;
  hasRequired_apply = 1;
  function apply(func, thisArg, args) {
    switch (args.length) {
      case 0:
        return func.call(thisArg);
      case 1:
        return func.call(thisArg, args[0]);
      case 2:
        return func.call(thisArg, args[0], args[1]);
      case 3:
        return func.call(thisArg, args[0], args[1], args[2]);
    }
    return func.apply(thisArg, args);
  }
  _apply = apply;
  return _apply;
}
var _overRest;
var hasRequired_overRest;
function require_overRest() {
  if (hasRequired_overRest)
    return _overRest;
  hasRequired_overRest = 1;
  var apply = require_apply();
  var nativeMax = Math.max;
  function overRest(func, start, transform) {
    start = nativeMax(start === void 0 ? func.length - 1 : start, 0);
    return function() {
      var args = arguments, index = -1, length = nativeMax(args.length - start, 0), array = Array(length);
      while (++index < length) {
        array[index] = args[start + index];
      }
      index = -1;
      var otherArgs = Array(start + 1);
      while (++index < start) {
        otherArgs[index] = args[index];
      }
      otherArgs[start] = transform(array);
      return apply(func, this, otherArgs);
    };
  }
  _overRest = overRest;
  return _overRest;
}
var _baseSetToString;
var hasRequired_baseSetToString;
function require_baseSetToString() {
  if (hasRequired_baseSetToString)
    return _baseSetToString;
  hasRequired_baseSetToString = 1;
  var constant = requireConstant(), defineProperty = require_defineProperty(), identity2 = requireIdentity();
  var baseSetToString = !defineProperty ? identity2 : function(func, string) {
    return defineProperty(func, "toString", {
      "configurable": true,
      "enumerable": false,
      "value": constant(string),
      "writable": true
    });
  };
  _baseSetToString = baseSetToString;
  return _baseSetToString;
}
var _shortOut;
var hasRequired_shortOut;
function require_shortOut() {
  if (hasRequired_shortOut)
    return _shortOut;
  hasRequired_shortOut = 1;
  var HOT_COUNT = 800, HOT_SPAN = 16;
  var nativeNow = Date.now;
  function shortOut(func) {
    var count = 0, lastCalled = 0;
    return function() {
      var stamp = nativeNow(), remaining = HOT_SPAN - (stamp - lastCalled);
      lastCalled = stamp;
      if (remaining > 0) {
        if (++count >= HOT_COUNT) {
          return arguments[0];
        }
      } else {
        count = 0;
      }
      return func.apply(void 0, arguments);
    };
  }
  _shortOut = shortOut;
  return _shortOut;
}
var _setToString;
var hasRequired_setToString;
function require_setToString() {
  if (hasRequired_setToString)
    return _setToString;
  hasRequired_setToString = 1;
  var baseSetToString = require_baseSetToString(), shortOut = require_shortOut();
  var setToString = shortOut(baseSetToString);
  _setToString = setToString;
  return _setToString;
}
var _baseRest;
var hasRequired_baseRest;
function require_baseRest() {
  if (hasRequired_baseRest)
    return _baseRest;
  hasRequired_baseRest = 1;
  var identity2 = requireIdentity(), overRest = require_overRest(), setToString = require_setToString();
  function baseRest(func, start) {
    return setToString(overRest(func, start, identity2), func + "");
  }
  _baseRest = baseRest;
  return _baseRest;
}
var _baseFindIndex;
var hasRequired_baseFindIndex;
function require_baseFindIndex() {
  if (hasRequired_baseFindIndex)
    return _baseFindIndex;
  hasRequired_baseFindIndex = 1;
  function baseFindIndex(array, predicate, fromIndex, fromRight) {
    var length = array.length, index = fromIndex + (fromRight ? 1 : -1);
    while (fromRight ? index-- : ++index < length) {
      if (predicate(array[index], index, array)) {
        return index;
      }
    }
    return -1;
  }
  _baseFindIndex = baseFindIndex;
  return _baseFindIndex;
}
var _baseIsNaN;
var hasRequired_baseIsNaN;
function require_baseIsNaN() {
  if (hasRequired_baseIsNaN)
    return _baseIsNaN;
  hasRequired_baseIsNaN = 1;
  function baseIsNaN(value) {
    return value !== value;
  }
  _baseIsNaN = baseIsNaN;
  return _baseIsNaN;
}
var _strictIndexOf;
var hasRequired_strictIndexOf;
function require_strictIndexOf() {
  if (hasRequired_strictIndexOf)
    return _strictIndexOf;
  hasRequired_strictIndexOf = 1;
  function strictIndexOf(array, value, fromIndex) {
    var index = fromIndex - 1, length = array.length;
    while (++index < length) {
      if (array[index] === value) {
        return index;
      }
    }
    return -1;
  }
  _strictIndexOf = strictIndexOf;
  return _strictIndexOf;
}
var _baseIndexOf;
var hasRequired_baseIndexOf;
function require_baseIndexOf() {
  if (hasRequired_baseIndexOf)
    return _baseIndexOf;
  hasRequired_baseIndexOf = 1;
  var baseFindIndex = require_baseFindIndex(), baseIsNaN = require_baseIsNaN(), strictIndexOf = require_strictIndexOf();
  function baseIndexOf(array, value, fromIndex) {
    return value === value ? strictIndexOf(array, value, fromIndex) : baseFindIndex(array, baseIsNaN, fromIndex);
  }
  _baseIndexOf = baseIndexOf;
  return _baseIndexOf;
}
var _arrayIncludes;
var hasRequired_arrayIncludes;
function require_arrayIncludes() {
  if (hasRequired_arrayIncludes)
    return _arrayIncludes;
  hasRequired_arrayIncludes = 1;
  var baseIndexOf = require_baseIndexOf();
  function arrayIncludes(array, value) {
    var length = array == null ? 0 : array.length;
    return !!length && baseIndexOf(array, value, 0) > -1;
  }
  _arrayIncludes = arrayIncludes;
  return _arrayIncludes;
}
var _arrayIncludesWith;
var hasRequired_arrayIncludesWith;
function require_arrayIncludesWith() {
  if (hasRequired_arrayIncludesWith)
    return _arrayIncludesWith;
  hasRequired_arrayIncludesWith = 1;
  function arrayIncludesWith(array, value, comparator) {
    var index = -1, length = array == null ? 0 : array.length;
    while (++index < length) {
      if (comparator(value, array[index])) {
        return true;
      }
    }
    return false;
  }
  _arrayIncludesWith = arrayIncludesWith;
  return _arrayIncludesWith;
}
var noop_1;
var hasRequiredNoop;
function requireNoop() {
  if (hasRequiredNoop)
    return noop_1;
  hasRequiredNoop = 1;
  function noop2() {
  }
  noop_1 = noop2;
  return noop_1;
}
var _createSet;
var hasRequired_createSet;
function require_createSet() {
  if (hasRequired_createSet)
    return _createSet;
  hasRequired_createSet = 1;
  var Set2 = require_Set(), noop2 = requireNoop(), setToArray2 = require_setToArray();
  var INFINITY2 = 1 / 0;
  var createSet = !(Set2 && 1 / setToArray2(new Set2([, -0]))[1] == INFINITY2) ? noop2 : function(values) {
    return new Set2(values);
  };
  _createSet = createSet;
  return _createSet;
}
var _baseUniq;
var hasRequired_baseUniq;
function require_baseUniq() {
  if (hasRequired_baseUniq)
    return _baseUniq;
  hasRequired_baseUniq = 1;
  var SetCache2 = require_SetCache(), arrayIncludes = require_arrayIncludes(), arrayIncludesWith = require_arrayIncludesWith(), cacheHas2 = require_cacheHas(), createSet = require_createSet(), setToArray2 = require_setToArray();
  var LARGE_ARRAY_SIZE2 = 200;
  function baseUniq(array, iteratee, comparator) {
    var index = -1, includes = arrayIncludes, length = array.length, isCommon = true, result = [], seen = result;
    if (comparator) {
      isCommon = false;
      includes = arrayIncludesWith;
    } else if (length >= LARGE_ARRAY_SIZE2) {
      var set = iteratee ? null : createSet(array);
      if (set) {
        return setToArray2(set);
      }
      isCommon = false;
      includes = cacheHas2;
      seen = new SetCache2();
    } else {
      seen = iteratee ? [] : result;
    }
    outer:
      while (++index < length) {
        var value = array[index], computed = iteratee ? iteratee(value) : value;
        value = comparator || value !== 0 ? value : 0;
        if (isCommon && computed === computed) {
          var seenIndex = seen.length;
          while (seenIndex--) {
            if (seen[seenIndex] === computed) {
              continue outer;
            }
          }
          if (iteratee) {
            seen.push(computed);
          }
          result.push(value);
        } else if (!includes(seen, computed, comparator)) {
          if (seen !== result) {
            seen.push(computed);
          }
          result.push(value);
        }
      }
    return result;
  }
  _baseUniq = baseUniq;
  return _baseUniq;
}
var isArrayLikeObject_1;
var hasRequiredIsArrayLikeObject;
function requireIsArrayLikeObject() {
  if (hasRequiredIsArrayLikeObject)
    return isArrayLikeObject_1;
  hasRequiredIsArrayLikeObject = 1;
  var isArrayLike2 = requireIsArrayLike(), isObjectLike2 = requireIsObjectLike();
  function isArrayLikeObject(value) {
    return isObjectLike2(value) && isArrayLike2(value);
  }
  isArrayLikeObject_1 = isArrayLikeObject;
  return isArrayLikeObject_1;
}
var union_1;
var hasRequiredUnion;
function requireUnion() {
  if (hasRequiredUnion)
    return union_1;
  hasRequiredUnion = 1;
  var baseFlatten = require_baseFlatten(), baseRest = require_baseRest(), baseUniq = require_baseUniq(), isArrayLikeObject = requireIsArrayLikeObject();
  var union = baseRest(function(arrays) {
    return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true));
  });
  union_1 = union;
  return union_1;
}
var _baseValues;
var hasRequired_baseValues;
function require_baseValues() {
  if (hasRequired_baseValues)
    return _baseValues;
  hasRequired_baseValues = 1;
  var arrayMap2 = require_arrayMap();
  function baseValues(object, props) {
    return arrayMap2(props, function(key) {
      return object[key];
    });
  }
  _baseValues = baseValues;
  return _baseValues;
}
var values_1;
var hasRequiredValues;
function requireValues() {
  if (hasRequiredValues)
    return values_1;
  hasRequiredValues = 1;
  var baseValues = require_baseValues(), keys2 = requireKeys();
  function values(object) {
    return object == null ? [] : baseValues(object, keys2(object));
  }
  values_1 = values;
  return values_1;
}
var lodash;
if (typeof commonjsRequire === "function") {
  try {
    lodash = {
      clone: requireClone(),
      constant: requireConstant(),
      each: requireEach(),
      filter: requireFilter(),
      has: requireHas(),
      isArray: requireIsArray(),
      isEmpty: requireIsEmpty(),
      isFunction: requireIsFunction(),
      isUndefined: requireIsUndefined(),
      keys: requireKeys(),
      map: requireMap(),
      reduce: requireReduce(),
      size: requireSize(),
      transform: requireTransform(),
      union: requireUnion(),
      values: requireValues()
    };
  } catch (e) {
  }
}
if (!lodash) {
  lodash = window._;
}
var lodash_1 = lodash;
var _$b = lodash_1;
var graph = Graph$2;
var DEFAULT_EDGE_NAME = "\0";
var GRAPH_NODE = "\0";
var EDGE_KEY_DELIM = "";
function Graph$2(opts) {
  this._isDirected = _$b.has(opts, "directed") ? opts.directed : true;
  this._isMultigraph = _$b.has(opts, "multigraph") ? opts.multigraph : false;
  this._isCompound = _$b.has(opts, "compound") ? opts.compound : false;
  this._label = void 0;
  this._defaultNodeLabelFn = _$b.constant(void 0);
  this._defaultEdgeLabelFn = _$b.constant(void 0);
  this._nodes = {};
  if (this._isCompound) {
    this._parent = {};
    this._children = {};
    this._children[GRAPH_NODE] = {};
  }
  this._in = {};
  this._preds = {};
  this._out = {};
  this._sucs = {};
  this._edgeObjs = {};
  this._edgeLabels = {};
}
Graph$2.prototype._nodeCount = 0;
Graph$2.prototype._edgeCount = 0;
Graph$2.prototype.isDirected = function() {
  return this._isDirected;
};
Graph$2.prototype.isMultigraph = function() {
  return this._isMultigraph;
};
Graph$2.prototype.isCompound = function() {
  return this._isCompound;
};
Graph$2.prototype.setGraph = function(label) {
  this._label = label;
  return this;
};
Graph$2.prototype.graph = function() {
  return this._label;
};
Graph$2.prototype.setDefaultNodeLabel = function(newDefault) {
  if (!_$b.isFunction(newDefault)) {
    newDefault = _$b.constant(newDefault);
  }
  this._defaultNodeLabelFn = newDefault;
  return this;
};
Graph$2.prototype.nodeCount = function() {
  return this._nodeCount;
};
Graph$2.prototype.nodes = function() {
  return _$b.keys(this._nodes);
};
Graph$2.prototype.sources = function() {
  var self2 = this;
  return _$b.filter(this.nodes(), function(v) {
    return _$b.isEmpty(self2._in[v]);
  });
};
Graph$2.prototype.sinks = function() {
  var self2 = this;
  return _$b.filter(this.nodes(), function(v) {
    return _$b.isEmpty(self2._out[v]);
  });
};
Graph$2.prototype.setNodes = function(vs, value) {
  var args = arguments;
  var self2 = this;
  _$b.each(vs, function(v) {
    if (args.length > 1) {
      self2.setNode(v, value);
    } else {
      self2.setNode(v);
    }
  });
  return this;
};
Graph$2.prototype.setNode = function(v, value) {
  if (_$b.has(this._nodes, v)) {
    if (arguments.length > 1) {
      this._nodes[v] = value;
    }
    return this;
  }
  this._nodes[v] = arguments.length > 1 ? value : this._defaultNodeLabelFn(v);
  if (this._isCompound) {
    this._parent[v] = GRAPH_NODE;
    this._children[v] = {};
    this._children[GRAPH_NODE][v] = true;
  }
  this._in[v] = {};
  this._preds[v] = {};
  this._out[v] = {};
  this._sucs[v] = {};
  ++this._nodeCount;
  return this;
};
Graph$2.prototype.node = function(v) {
  return this._nodes[v];
};
Graph$2.prototype.hasNode = function(v) {
  return _$b.has(this._nodes, v);
};
Graph$2.prototype.removeNode = function(v) {
  var self2 = this;
  if (_$b.has(this._nodes, v)) {
    var removeEdge = function(e) {
      self2.removeEdge(self2._edgeObjs[e]);
    };
    delete this._nodes[v];
    if (this._isCompound) {
      this._removeFromParentsChildList(v);
      delete this._parent[v];
      _$b.each(this.children(v), function(child) {
        self2.setParent(child);
      });
      delete this._children[v];
    }
    _$b.each(_$b.keys(this._in[v]), removeEdge);
    delete this._in[v];
    delete this._preds[v];
    _$b.each(_$b.keys(this._out[v]), removeEdge);
    delete this._out[v];
    delete this._sucs[v];
    --this._nodeCount;
  }
  return this;
};
Graph$2.prototype.setParent = function(v, parent) {
  if (!this._isCompound) {
    throw new Error("Cannot set parent in a non-compound graph");
  }
  if (_$b.isUndefined(parent)) {
    parent = GRAPH_NODE;
  } else {
    parent += "";
    for (var ancestor = parent; !_$b.isUndefined(ancestor); ancestor = this.parent(ancestor)) {
      if (ancestor === v) {
        throw new Error("Setting " + parent + " as parent of " + v + " would create a cycle");
      }
    }
    this.setNode(parent);
  }
  this.setNode(v);
  this._removeFromParentsChildList(v);
  this._parent[v] = parent;
  this._children[parent][v] = true;
  return this;
};
Graph$2.prototype._removeFromParentsChildList = function(v) {
  delete this._children[this._parent[v]][v];
};
Graph$2.prototype.parent = function(v) {
  if (this._isCompound) {
    var parent = this._parent[v];
    if (parent !== GRAPH_NODE) {
      return parent;
    }
  }
};
Graph$2.prototype.children = function(v) {
  if (_$b.isUndefined(v)) {
    v = GRAPH_NODE;
  }
  if (this._isCompound) {
    var children = this._children[v];
    if (children) {
      return _$b.keys(children);
    }
  } else if (v === GRAPH_NODE) {
    return this.nodes();
  } else if (this.hasNode(v)) {
    return [];
  }
};
Graph$2.prototype.predecessors = function(v) {
  var predsV = this._preds[v];
  if (predsV) {
    return _$b.keys(predsV);
  }
};
Graph$2.prototype.successors = function(v) {
  var sucsV = this._sucs[v];
  if (sucsV) {
    return _$b.keys(sucsV);
  }
};
Graph$2.prototype.neighbors = function(v) {
  var preds = this.predecessors(v);
  if (preds) {
    return _$b.union(preds, this.successors(v));
  }
};
Graph$2.prototype.isLeaf = function(v) {
  var neighbors;
  if (this.isDirected()) {
    neighbors = this.successors(v);
  } else {
    neighbors = this.neighbors(v);
  }
  return neighbors.length === 0;
};
Graph$2.prototype.filterNodes = function(filter) {
  var copy2 = new this.constructor({
    directed: this._isDirected,
    multigraph: this._isMultigraph,
    compound: this._isCompound
  });
  copy2.setGraph(this.graph());
  var self2 = this;
  _$b.each(this._nodes, function(value, v) {
    if (filter(v)) {
      copy2.setNode(v, value);
    }
  });
  _$b.each(this._edgeObjs, function(e) {
    if (copy2.hasNode(e.v) && copy2.hasNode(e.w)) {
      copy2.setEdge(e, self2.edge(e));
    }
  });
  var parents = {};
  function findParent(v) {
    var parent = self2.parent(v);
    if (parent === void 0 || copy2.hasNode(parent)) {
      parents[v] = parent;
      return parent;
    } else if (parent in parents) {
      return parents[parent];
    } else {
      return findParent(parent);
    }
  }
  if (this._isCompound) {
    _$b.each(copy2.nodes(), function(v) {
      copy2.setParent(v, findParent(v));
    });
  }
  return copy2;
};
Graph$2.prototype.setDefaultEdgeLabel = function(newDefault) {
  if (!_$b.isFunction(newDefault)) {
    newDefault = _$b.constant(newDefault);
  }
  this._defaultEdgeLabelFn = newDefault;
  return this;
};
Graph$2.prototype.edgeCount = function() {
  return this._edgeCount;
};
Graph$2.prototype.edges = function() {
  return _$b.values(this._edgeObjs);
};
Graph$2.prototype.setPath = function(vs, value) {
  var self2 = this;
  var args = arguments;
  _$b.reduce(vs, function(v, w) {
    if (args.length > 1) {
      self2.setEdge(v, w, value);
    } else {
      self2.setEdge(v, w);
    }
    return w;
  });
  return this;
};
Graph$2.prototype.setEdge = function() {
  var v, w, name, value;
  var valueSpecified = false;
  var arg0 = arguments[0];
  if (typeof arg0 === "object" && arg0 !== null && "v" in arg0) {
    v = arg0.v;
    w = arg0.w;
    name = arg0.name;
    if (arguments.length === 2) {
      value = arguments[1];
      valueSpecified = true;
    }
  } else {
    v = arg0;
    w = arguments[1];
    name = arguments[3];
    if (arguments.length > 2) {
      value = arguments[2];
      valueSpecified = true;
    }
  }
  v = "" + v;
  w = "" + w;
  if (!_$b.isUndefined(name)) {
    name = "" + name;
  }
  var e = edgeArgsToId(this._isDirected, v, w, name);
  if (_$b.has(this._edgeLabels, e)) {
    if (valueSpecified) {
      this._edgeLabels[e] = value;
    }
    return this;
  }
  if (!_$b.isUndefined(name) && !this._isMultigraph) {
    throw new Error("Cannot set a named edge when isMultigraph = false");
  }
  this.setNode(v);
  this.setNode(w);
  this._edgeLabels[e] = valueSpecified ? value : this._defaultEdgeLabelFn(v, w, name);
  var edgeObj = edgeArgsToObj(this._isDirected, v, w, name);
  v = edgeObj.v;
  w = edgeObj.w;
  Object.freeze(edgeObj);
  this._edgeObjs[e] = edgeObj;
  incrementOrInitEntry(this._preds[w], v);
  incrementOrInitEntry(this._sucs[v], w);
  this._in[w][e] = edgeObj;
  this._out[v][e] = edgeObj;
  this._edgeCount++;
  return this;
};
Graph$2.prototype.edge = function(v, w, name) {
  var e = arguments.length === 1 ? edgeObjToId(this._isDirected, arguments[0]) : edgeArgsToId(this._isDirected, v, w, name);
  return this._edgeLabels[e];
};
Graph$2.prototype.hasEdge = function(v, w, name) {
  var e = arguments.length === 1 ? edgeObjToId(this._isDirected, arguments[0]) : edgeArgsToId(this._isDirected, v, w, name);
  return _$b.has(this._edgeLabels, e);
};
Graph$2.prototype.removeEdge = function(v, w, name) {
  var e = arguments.length === 1 ? edgeObjToId(this._isDirected, arguments[0]) : edgeArgsToId(this._isDirected, v, w, name);
  var edge = this._edgeObjs[e];
  if (edge) {
    v = edge.v;
    w = edge.w;
    delete this._edgeLabels[e];
    delete this._edgeObjs[e];
    decrementOrRemoveEntry(this._preds[w], v);
    decrementOrRemoveEntry(this._sucs[v], w);
    delete this._in[w][e];
    delete this._out[v][e];
    this._edgeCount--;
  }
  return this;
};
Graph$2.prototype.inEdges = function(v, u) {
  var inV = this._in[v];
  if (inV) {
    var edges = _$b.values(inV);
    if (!u) {
      return edges;
    }
    return _$b.filter(edges, function(edge) {
      return edge.v === u;
    });
  }
};
Graph$2.prototype.outEdges = function(v, w) {
  var outV = this._out[v];
  if (outV) {
    var edges = _$b.values(outV);
    if (!w) {
      return edges;
    }
    return _$b.filter(edges, function(edge) {
      return edge.w === w;
    });
  }
};
Graph$2.prototype.nodeEdges = function(v, w) {
  var inEdges = this.inEdges(v, w);
  if (inEdges) {
    return inEdges.concat(this.outEdges(v, w));
  }
};
function incrementOrInitEntry(map, k) {
  if (map[k]) {
    map[k]++;
  } else {
    map[k] = 1;
  }
}
function decrementOrRemoveEntry(map, k) {
  if (!--map[k]) {
    delete map[k];
  }
}
function edgeArgsToId(isDirected, v_, w_, name) {
  var v = "" + v_;
  var w = "" + w_;
  if (!isDirected && v > w) {
    var tmp = v;
    v = w;
    w = tmp;
  }
  return v + EDGE_KEY_DELIM + w + EDGE_KEY_DELIM + (_$b.isUndefined(name) ? DEFAULT_EDGE_NAME : name);
}
function edgeArgsToObj(isDirected, v_, w_, name) {
  var v = "" + v_;
  var w = "" + w_;
  if (!isDirected && v > w) {
    var tmp = v;
    v = w;
    w = tmp;
  }
  var edgeObj = { v, w };
  if (name) {
    edgeObj.name = name;
  }
  return edgeObj;
}
function edgeObjToId(isDirected, edgeObj) {
  return edgeArgsToId(isDirected, edgeObj.v, edgeObj.w, edgeObj.name);
}
var lib$1 = {
  Graph: graph};
var _$9 = lodash_1;
var components_1 = components;
function components(g) {
  var visited = {};
  var cmpts = [];
  var cmpt;
  function dfs2(v) {
    if (_$9.has(visited, v))
      return;
    visited[v] = true;
    cmpt.push(v);
    _$9.each(g.successors(v), dfs2);
    _$9.each(g.predecessors(v), dfs2);
  }
  _$9.each(g.nodes(), function(v) {
    cmpt = [];
    dfs2(v);
    if (cmpt.length) {
      cmpts.push(cmpt);
    }
  });
  return cmpts;
}
var _$8 = lodash_1;
var priorityQueue = PriorityQueue$2;
function PriorityQueue$2() {
  this._arr = [];
  this._keyIndices = {};
}
PriorityQueue$2.prototype.size = function() {
  return this._arr.length;
};
PriorityQueue$2.prototype.keys = function() {
  return this._arr.map(function(x) {
    return x.key;
  });
};
PriorityQueue$2.prototype.has = function(key) {
  return _$8.has(this._keyIndices, key);
};
PriorityQueue$2.prototype.priority = function(key) {
  var index = this._keyIndices[key];
  if (index !== void 0) {
    return this._arr[index].priority;
  }
};
PriorityQueue$2.prototype.min = function() {
  if (this.size() === 0) {
    throw new Error("Queue underflow");
  }
  return this._arr[0].key;
};
PriorityQueue$2.prototype.add = function(key, priority) {
  var keyIndices = this._keyIndices;
  key = String(key);
  if (!_$8.has(keyIndices, key)) {
    var arr = this._arr;
    var index = arr.length;
    keyIndices[key] = index;
    arr.push({ key, priority });
    this._decrease(index);
    return true;
  }
  return false;
};
PriorityQueue$2.prototype.removeMin = function() {
  this._swap(0, this._arr.length - 1);
  var min2 = this._arr.pop();
  delete this._keyIndices[min2.key];
  this._heapify(0);
  return min2.key;
};
PriorityQueue$2.prototype.decrease = function(key, priority) {
  var index = this._keyIndices[key];
  if (priority > this._arr[index].priority) {
    throw new Error("New priority is greater than current priority. Key: " + key + " Old: " + this._arr[index].priority + " New: " + priority);
  }
  this._arr[index].priority = priority;
  this._decrease(index);
};
PriorityQueue$2.prototype._heapify = function(i) {
  var arr = this._arr;
  var l = 2 * i;
  var r = l + 1;
  var largest = i;
  if (l < arr.length) {
    largest = arr[l].priority < arr[largest].priority ? l : largest;
    if (r < arr.length) {
      largest = arr[r].priority < arr[largest].priority ? r : largest;
    }
    if (largest !== i) {
      this._swap(i, largest);
      this._heapify(largest);
    }
  }
};
PriorityQueue$2.prototype._decrease = function(index) {
  var arr = this._arr;
  var priority = arr[index].priority;
  var parent;
  while (index !== 0) {
    parent = index >> 1;
    if (arr[parent].priority < priority) {
      break;
    }
    this._swap(index, parent);
    index = parent;
  }
};
PriorityQueue$2.prototype._swap = function(i, j) {
  var arr = this._arr;
  var keyIndices = this._keyIndices;
  var origArrI = arr[i];
  var origArrJ = arr[j];
  arr[i] = origArrJ;
  arr[j] = origArrI;
  keyIndices[origArrJ.key] = i;
  keyIndices[origArrI.key] = j;
};
var _$7 = lodash_1;
var PriorityQueue$1 = priorityQueue;
var dijkstra_1 = dijkstra$1;
var DEFAULT_WEIGHT_FUNC$1 = _$7.constant(1);
function dijkstra$1(g, source, weightFn, edgeFn) {
  return runDijkstra(
    g,
    String(source),
    weightFn || DEFAULT_WEIGHT_FUNC$1,
    edgeFn || function(v) {
      return g.outEdges(v);
    }
  );
}
function runDijkstra(g, source, weightFn, edgeFn) {
  var results = {};
  var pq = new PriorityQueue$1();
  var v, vEntry;
  var updateNeighbors = function(edge) {
    var w = edge.v !== v ? edge.v : edge.w;
    var wEntry = results[w];
    var weight = weightFn(edge);
    var distance = vEntry.distance + weight;
    if (weight < 0) {
      throw new Error("dijkstra does not allow negative edge weights. Bad edge: " + edge + " Weight: " + weight);
    }
    if (distance < wEntry.distance) {
      wEntry.distance = distance;
      wEntry.predecessor = v;
      pq.decrease(w, distance);
    }
  };
  g.nodes().forEach(function(v2) {
    var distance = v2 === source ? 0 : Number.POSITIVE_INFINITY;
    results[v2] = { distance };
    pq.add(v2, distance);
  });
  while (pq.size() > 0) {
    v = pq.removeMin();
    vEntry = results[v];
    if (vEntry.distance === Number.POSITIVE_INFINITY) {
      break;
    }
    edgeFn(v).forEach(updateNeighbors);
  }
  return results;
}
var dijkstra = dijkstra_1;
var _$6 = lodash_1;
var dijkstraAll_1 = dijkstraAll;
function dijkstraAll(g, weightFunc, edgeFunc) {
  return _$6.transform(g.nodes(), function(acc, v) {
    acc[v] = dijkstra(g, v, weightFunc, edgeFunc);
  }, {});
}
var _$5 = lodash_1;
var tarjan_1 = tarjan$1;
function tarjan$1(g) {
  var index = 0;
  var stack = [];
  var visited = {};
  var results = [];
  function dfs2(v) {
    var entry = visited[v] = {
      onStack: true,
      lowlink: index,
      index: index++
    };
    stack.push(v);
    g.successors(v).forEach(function(w2) {
      if (!_$5.has(visited, w2)) {
        dfs2(w2);
        entry.lowlink = Math.min(entry.lowlink, visited[w2].lowlink);
      } else if (visited[w2].onStack) {
        entry.lowlink = Math.min(entry.lowlink, visited[w2].index);
      }
    });
    if (entry.lowlink === entry.index) {
      var cmpt = [];
      var w;
      do {
        w = stack.pop();
        visited[w].onStack = false;
        cmpt.push(w);
      } while (v !== w);
      results.push(cmpt);
    }
  }
  g.nodes().forEach(function(v) {
    if (!_$5.has(visited, v)) {
      dfs2(v);
    }
  });
  return results;
}
var _$4 = lodash_1;
var tarjan = tarjan_1;
var findCycles_1 = findCycles;
function findCycles(g) {
  return _$4.filter(tarjan(g), function(cmpt) {
    return cmpt.length > 1 || cmpt.length === 1 && g.hasEdge(cmpt[0], cmpt[0]);
  });
}
var _$3 = lodash_1;
var floydWarshall_1 = floydWarshall;
var DEFAULT_WEIGHT_FUNC = _$3.constant(1);
function floydWarshall(g, weightFn, edgeFn) {
  return runFloydWarshall(
    g,
    weightFn || DEFAULT_WEIGHT_FUNC,
    edgeFn || function(v) {
      return g.outEdges(v);
    }
  );
}
function runFloydWarshall(g, weightFn, edgeFn) {
  var results = {};
  var nodes = g.nodes();
  nodes.forEach(function(v) {
    results[v] = {};
    results[v][v] = { distance: 0 };
    nodes.forEach(function(w) {
      if (v !== w) {
        results[v][w] = { distance: Number.POSITIVE_INFINITY };
      }
    });
    edgeFn(v).forEach(function(edge) {
      var w = edge.v === v ? edge.w : edge.v;
      var d = weightFn(edge);
      results[v][w] = { distance: d, predecessor: v };
    });
  });
  nodes.forEach(function(k) {
    var rowK = results[k];
    nodes.forEach(function(i) {
      var rowI = results[i];
      nodes.forEach(function(j) {
        var ik = rowI[k];
        var kj = rowK[j];
        var ij = rowI[j];
        var altDistance = ik.distance + kj.distance;
        if (altDistance < ij.distance) {
          ij.distance = altDistance;
          ij.predecessor = kj.predecessor;
        }
      });
    });
  });
  return results;
}
var _$2 = lodash_1;
var topsort_1 = topsort$1;
topsort$1.CycleException = CycleException;
function topsort$1(g) {
  var visited = {};
  var stack = {};
  var results = [];
  function visit(node) {
    if (_$2.has(stack, node)) {
      throw new CycleException();
    }
    if (!_$2.has(visited, node)) {
      stack[node] = true;
      visited[node] = true;
      _$2.each(g.predecessors(node), visit);
      delete stack[node];
      results.push(node);
    }
  }
  _$2.each(g.sinks(), visit);
  if (_$2.size(visited) !== g.nodeCount()) {
    throw new CycleException();
  }
  return results;
}
function CycleException() {
}
CycleException.prototype = new Error();
var topsort = topsort_1;
var isAcyclic_1 = isAcyclic;
function isAcyclic(g) {
  try {
    topsort(g);
  } catch (e) {
    if (e instanceof topsort.CycleException) {
      return false;
    }
    throw e;
  }
  return true;
}
var _$1 = lodash_1;
var dfs_1 = dfs$2;
function dfs$2(g, vs, order) {
  if (!_$1.isArray(vs)) {
    vs = [vs];
  }
  var navigation = (g.isDirected() ? g.successors : g.neighbors).bind(g);
  var acc = [];
  var visited = {};
  _$1.each(vs, function(v) {
    if (!g.hasNode(v)) {
      throw new Error("Graph does not have node: " + v);
    }
    doDfs$1(g, v, order === "post", visited, navigation, acc);
  });
  return acc;
}
function doDfs$1(g, v, postorder2, visited, navigation, acc) {
  if (!_$1.has(visited, v)) {
    visited[v] = true;
    if (!postorder2) {
      acc.push(v);
    }
    _$1.each(navigation(v), function(w) {
      doDfs$1(g, w, postorder2, visited, navigation, acc);
    });
    if (postorder2) {
      acc.push(v);
    }
  }
}
var dfs$1 = dfs_1;
var postorder_1 = postorder;
function postorder(g, vs) {
  return dfs$1(g, vs, "post");
}
var dfs = dfs_1;
var preorder_1 = preorder;
function preorder(g, vs) {
  return dfs(g, vs, "pre");
}
var _ = lodash_1;
var Graph = graph;
var PriorityQueue = priorityQueue;
var prim_1 = prim;
function prim(g, weightFunc) {
  var result = new Graph();
  var parents = {};
  var pq = new PriorityQueue();
  var v;
  function updateNeighbors(edge) {
    var w = edge.v === v ? edge.w : edge.v;
    var pri = pq.priority(w);
    if (pri !== void 0) {
      var edgeWeight = weightFunc(edge);
      if (edgeWeight < pri) {
        parents[w] = v;
        pq.decrease(w, edgeWeight);
      }
    }
  }
  if (g.nodeCount() === 0) {
    return result;
  }
  _.each(g.nodes(), function(v2) {
    pq.add(v2, Number.POSITIVE_INFINITY);
    result.setNode(v2);
  });
  pq.decrease(g.nodes()[0], 0);
  var init = false;
  while (pq.size() > 0) {
    v = pq.removeMin();
    if (_.has(parents, v)) {
      result.setEdge(v, parents[v]);
    } else if (init) {
      throw new Error("Input graph is not connected: " + g);
    } else {
      init = true;
    }
    g.nodeEdges(v).forEach(updateNeighbors);
  }
  return result;
}
var alg = {
  components: components_1,
  dijkstra: dijkstra_1,
  dijkstraAll: dijkstraAll_1,
  findCycles: findCycles_1,
  floydWarshall: floydWarshall_1,
  isAcyclic: isAcyclic_1,
  postorder: postorder_1,
  preorder: preorder_1,
  prim: prim_1,
  tarjan: tarjan_1,
  topsort: topsort_1
};
var lib = lib$1;
var graphlib = {
  Graph: lib.Graph,
  alg};
function initialOrdering(G2) {
  const order = [];
  let start = G2.nodes().filter((u) => G2.node(u).rank === 0).concat(G2.sources());
  if (start.length === 0) {
    start = G2.nodes().slice(0, 1);
  }
  graphlib.alg.preorder(G2, start).forEach((u) => {
    const rank = G2.node(u).rank;
    while (rank >= order.length)
      order.push([]);
    order[rank].push(u);
  });
  return order;
}
function swapNodes(G2, order) {
  let improved = true;
  while (improved) {
    improved = false;
    for (let i = 0; i < order.length; ++i) {
      for (let j = 0; j < order[i].length - 1; ++j) {
        const count0 = allCrossings$1(G2, order, i);
        transpose(order[i], j, j + 1);
        const count1 = allCrossings$1(G2, order, i);
        if (count1 < count0) {
          improved = true;
        } else {
          transpose(order[i], j, j + 1);
        }
      }
    }
  }
}
function allCrossings$1(G2, order, i) {
  let count = 0;
  if (i > 0) {
    count += countCrossings(G2, order[i - 1], order[i]);
  }
  if (i + 1 < order.length) {
    count += countCrossings(G2, order[i], order[i + 1]);
  }
  return count;
}
function transpose(list, i, j) {
  const tmp = list[i];
  list[i] = list[j];
  list[j] = tmp;
}
function medianValue(positions) {
  const m = Math.floor(positions.length / 2);
  if (positions.length === 0) {
    return -1;
  } else if (positions.length % 2 === 1) {
    return positions[m];
  } else if (positions.length === 2) {
    return (positions[0] + positions[1]) / 2;
  }
  const left = positions[m - 1] - positions[0];
  const right = positions[positions.length - 1] - positions[m];
  return (positions[m - 1] * right + positions[m] * left) / (left + right);
}
function sortNodes(G2, order, sweepDirection = 1, includeLoops = false) {
  if (sweepDirection > 0) {
    for (let r = 1; r < order.length; ++r) {
      const medians = /* @__PURE__ */ new Map();
      order[r].forEach((u) => {
        const neighbour = medianValue(neighbourPositions(G2, order, r, r - 1, u, includeLoops));
        medians.set(u, neighbour);
      });
      sortByPositions(order[r], medians);
    }
  } else {
    for (let r = order.length - 2; r >= 0; --r) {
      const medians = /* @__PURE__ */ new Map();
      order[r].forEach((u) => {
        const neighbour = medianValue(neighbourPositions(G2, order, r, r + 1, u, includeLoops));
        medians.set(u, neighbour);
      });
      sortByPositions(order[r], medians);
    }
  }
}
function neighbourPositions(G2, order, i, j, u, includeLoops = false) {
  const thisRank = order[i];
  const otherRank = order[j];
  const positions = [];
  otherRank.forEach((n, i2) => {
    if (G2.nodeEdges(n, u).length > 0) {
      positions.push(i2);
    }
  });
  if (positions.length === 0 && includeLoops) {
    thisRank.forEach((n, i2) => {
      if (G2.nodeEdges(n, u).length > 0) {
        positions.push(i2 + 0.5);
      }
    });
  }
  positions.sort((a, b) => a - b);
  return positions;
}
function sortByPositions(arr, order) {
  const origOrder = new Map(arr.map((d, i) => [d, i]));
  for (let i = 1; i < arr.length; ++i) {
    for (let k = i; k > 0; --k) {
      let j = k - 1;
      let a = order.get(arr[j]);
      let b = order.get(arr[k]);
      while ((a = order.get(arr[j])) === -1 && j > 0)
        j--;
      if (b === -1 || a === -1) {
        break;
      }
      if (a === b) {
        a = origOrder.get(arr[j]);
        b = origOrder.get(arr[k]);
      }
      if (b >= a) {
        break;
      }
      [arr[k], arr[j]] = [arr[j], arr[k]];
    }
  }
}
function ordering(G2, maxIterations = 25) {
  const order = initialOrdering(G2);
  let best = order;
  let i = 0;
  while (i++ < maxIterations) {
    sortNodes(G2, order, i % 2 === 0 ? 1 : 0);
    swapNodes(G2, order);
    if (allCrossings(G2, order) < allCrossings(G2, best)) {
      best = copy(order);
    }
  }
  best = best.map((rank) => [rank]);
  return best;
}
function allCrossings(G2, order) {
  let count = 0;
  for (let i = 0; i < order.length - 1; ++i) {
    count += countCrossings(G2, order[i], order[i + 1]);
  }
  return count;
}
function copy(order) {
  const result = [];
  for (const rank of order) {
    const r = [];
    result.push(r);
    for (const node of rank)
      r.push(node);
  }
  return result;
}
function spanMinWidths(G2, order) {
  const widths = [];
  order.forEach((rank, i) => {
    if (i === order.length - 1)
      return;
    let minWidth2 = 0;
    rank.forEach((band) => {
      band.forEach((v) => {
        G2.outEdges(v).forEach((e) => {
          const w = G2.edge(e).dy;
          const dy = G2.node(e.w).y - G2.node(e.v).y;
          const ay = Math.abs(dy) - w;
          const dx2 = w * w - ay * ay;
          const dx = dx2 >= 0 ? Math.sqrt(dx2) : w;
          if (dx > minWidth2)
            minWidth2 = dx;
        });
      });
    });
    widths.push(minWidth2);
  });
  return widths;
}
function positionHorizontally(G2, order, width, minWidths) {
  const totalMinWidth = sumBy(minWidths);
  let dx;
  if (totalMinWidth > width) {
    dx = minWidths.map((w) => width * w / totalMinWidth);
  } else {
    const spare = width - totalMinWidth;
    dx = minWidths.map((w) => w + spare / (order.length - 1));
  }
  let x = 0;
  order.forEach((rank, i) => {
    rank.forEach((band) => {
      band.forEach((u) => {
        const node = G2.node(u);
        node.x = x;
      });
    });
    x += dx[i];
  });
}
function justifiedPositioning() {
  let size = [100, 100];
  let scale = null;
  let whitespace = 0.5;
  let separation = function(a, b, c) {
    return 1;
  };
  const edgeValue = function(e) {
    return e.data.value;
  };
  const nodeDirection = function(n) {
    return n.data ? n.data.direction : "r";
  };
  function position(G2, order) {
    if (scale === null)
      position.scaleToFit(G2, order);
    setNodeValues(G2, edgeValue, nodeDirection);
    setNodeEdgeHeights(G2, edgeValue, scale);
    const bandVals = bandValues(G2, order);
    order.forEach((rank) => {
      let y = 0;
      rank.forEach((band, j) => {
        const bandHeight = bandVals[j] / sumBy(bandVals) * size[1];
        const margin = y === 0 ? 0 : whitespace * bandHeight / 5;
        const height = bandHeight - 2 * margin;
        const total = sumBy(band, (u) => G2.node(u).dy);
        const gaps = band.map((u, i) => {
          const node = G2.node(u);
          if (!node.value)
            return 0;
          return band[i + 1] ? separation(band[i], band[i + 1], G2) : 0;
        });
        const space = Math.max(0, height - total);
        const kg = sumBy(gaps) ? space / sumBy(gaps) : 0;
        let yy = y + margin;
        if (band.length === 1) {
          yy += (height - G2.node(band[0]).dy) / 2;
        }
        let prevGap = Number.MAX_VALUE;
        band.forEach((u, i) => {
          const node = G2.node(u);
          node.y = yy;
          node.spaceAbove = prevGap;
          node.spaceBelow = gaps[i] * kg;
          yy += node.dy + node.spaceBelow;
          prevGap = node.spaceBelow;
          if (node.data && node.data.forceY !== void 0) {
            node.y = margin + node.data.forceY * (height - node.dy);
          }
        });
        if (band.length > 0) {
          G2.node(band[band.length - 1]).spaceBelow = Number.MAX_VALUE;
        }
        y += bandHeight;
      });
    });
    const minWidths = spanMinWidths(G2, order);
    positionHorizontally(G2, order, size[0], minWidths);
    const nodes = [];
    G2.nodes().forEach((u) => {
      const node = G2.node(u);
      node.id = u;
      nodes.push(node);
    });
    return nodes;
  }
  position.scaleToFit = function(G2, order) {
    setNodeValues(G2, edgeValue, nodeDirection);
    const maxValue = sumBy(bandValues(G2, order));
    if (maxValue <= 0) {
      scale = 1;
      return;
    }
    scale = size[1] / maxValue;
    if (whitespace !== 1)
      scale *= 1 - whitespace;
  };
  position.size = function(x) {
    if (!arguments.length)
      return size;
    size = x;
    return position;
  };
  position.separation = function(x) {
    if (!arguments.length)
      return separation;
    separation = isFunction(x) ? x : () => x;
    return position;
  };
  position.whitespace = function(x) {
    if (!arguments.length)
      return whitespace;
    whitespace = x;
    return position;
  };
  position.scale = function(x) {
    if (!arguments.length)
      return scale;
    scale = x;
    return position;
  };
  return position;
}
function setNodeValues(G2, edgeValue, nodeDirection) {
  G2.nodes().forEach((n) => {
    const incoming = sumBy(G2.inEdges(n), (e) => edgeValue(G2.edge(e)));
    const outgoing = sumBy(G2.outEdges(n), (e) => edgeValue(G2.edge(e)));
    let node = G2.node(n);
    if (!node)
      G2.setNode(n, node = {});
    node.value = Math.max(incoming, outgoing);
    if (node.direction === void 0)
      node.direction = nodeDirection(node) || "r";
  });
}
function setNodeEdgeHeights(G2, edgeValue, scale) {
  G2.nodes().forEach((n) => {
    const node = G2.node(n);
    node.dy = node.value * scale;
  });
  G2.edges().forEach((e) => {
    const edge = G2.edge(e);
    edge.value = edgeValue(edge);
    edge.dy = edge.value * scale;
  });
}
function bandValues(G2, order) {
  if (order.length === 0 || order[0].length === 0)
    return [];
  const Nb = order[0].length;
  const values = new Array(Nb);
  for (let i = 0; i < Nb; i++)
    values[i] = 0;
  order.forEach((rank) => {
    rank.forEach((band, j) => {
      const total = sumBy(band, (u) => G2.node(u).value);
      values[j] = Math.max(values[j], total);
    });
  });
  return values;
}
function baseExtremum(array, iteratee, comparator) {
  var index = -1, length = array.length;
  while (++index < length) {
    var value = array[index], current = iteratee(value);
    if (current != null && (computed === void 0 ? current === current && !isSymbol(current) : comparator(current, computed))) {
      var computed = current, result = value;
    }
  }
  return result;
}
function baseLt(value, other) {
  return value < other;
}
function min(array) {
  return array && array.length ? baseExtremum(array, identity, baseLt) : void 0;
}
function groupedGraph(G2, rankSets) {
  const GG = new graphlib.Graph({ directed: true });
  let Smin = false;
  for (const set of rankSets) {
    if (set.type === "min") {
      Smin = true;
      break;
    }
  }
  if (!Smin) {
    const sources = G2.sources();
    if (sources.length > 0) {
      rankSets = [{ nodes: [sources[0]], type: "min" }, ...rankSets];
    } else {
      rankSets = [{ nodes: [G2.nodes()[0]], type: "min" }, ...rankSets];
    }
  }
  const nodeSets = /* @__PURE__ */ new Map();
  let i = 0;
  rankSets.forEach((set) => {
    if (!set.nodes || set.nodes.length === 0)
      return;
    const id = `${i++}`;
    set.nodes.forEach((n) => {
      nodeSets.set(n, id);
    });
    GG.setNode(id, { nodes: set.nodes, type: set.type });
  });
  G2.nodes().forEach((u) => {
    if (!nodeSets.has(u)) {
      const id = `${i++}`;
      const set = { nodes: [u], type: "same" };
      nodeSets.set(u, id);
      GG.setNode(id, set);
    }
  });
  G2.edges().forEach((e) => {
    const source = nodeSets.has(e.v) ? nodeSets.get(e.v) : e.v;
    const target = nodeSets.has(e.w) ? nodeSets.get(e.w) : e.w;
    const V = G2.node(e.v) || {};
    const W = G2.node(e.w) || {};
    const edge = GG.edge(source, target) || { delta: 0 };
    if (source === target) {
      edge.delta = 0;
      GG.setEdge(source, target, edge);
    } else if (V.direction === "l") {
      edge.delta = Math.max(edge.delta, W.direction === "l" ? 1 : 0);
      GG.setEdge(target, source, edge);
    } else {
      edge.delta = Math.max(edge.delta, W.direction === "l" ? 0 : 1);
      GG.setEdge(source, target, edge);
    }
  });
  return GG;
}
var defined = function defined2() {
  for (var i = 0; i < arguments.length; i++) {
    if (typeof arguments[i] !== "undefined") {
      return arguments[i];
    }
  }
};
const defined$1 = /* @__PURE__ */ getDefaultExportFromCjs(defined);
function assignInitialRanks(G2) {
  var _a;
  const queue = G2.sources();
  const seen = /* @__PURE__ */ new Set();
  const marked = /* @__PURE__ */ new Set();
  G2.edges().forEach((e) => {
    if (e.v === e.w)
      marked.add(e);
  });
  while (queue.length > 0) {
    const v = queue.shift();
    seen.add(v);
    let V = G2.node(v);
    if (!V)
      G2.setNode(v, V = {});
    V.rank = 0;
    for (const e of G2.inEdges(v)) {
      const delta = defined$1((_a = G2.edge(e) || {}) == null ? void 0 : _a.delta, 1);
      V.rank = Math.max(V.rank, G2.node(e.v).rank + delta);
    }
    for (const e of G2.outEdges(v)) {
      marked.add(e);
    }
    for (const n of G2.nodes()) {
      if (queue.indexOf(n) < 0 && !seen.has(n) && !G2.inEdges(n).some((e) => !marked.has(e))) {
        queue.push(n);
      }
    }
  }
}
function makeAcyclic(G2, v0) {
  const tree = findSpanningTree(G2, v0);
  G2.edges().forEach((e) => {
    const rel = nodeRelationship(tree, e.v, e.w);
    if (rel < 0) {
      const label = G2.edge(e) || {};
      label.reversed = true;
      G2.removeEdge(e);
      G2.setEdge(e.w, e.v, label);
    }
  });
  return G2;
}
function findSpanningTree(G2, v0) {
  const visited = /* @__PURE__ */ new Set();
  const tree = new graphlib.Graph({ directed: true });
  const thread = [];
  if (!G2.hasNode(v0))
    throw Error("node not in graph");
  doDfs(G2, v0, visited, tree, thread);
  G2.nodes().forEach((u) => {
    if (!visited.has(u)) {
      doDfs(G2, u, visited, tree, thread);
    }
  });
  thread.forEach((u, i) => {
    tree.node(u).thread = i + 1 < thread.length ? thread[i + 1] : thread[0];
  });
  return tree;
}
function nodeRelationship(tree, v, w) {
  const V = tree.node(v), W = tree.node(w);
  if (V.depth < W.depth) {
    let u = V.thread;
    while (tree.node(u).depth > V.depth) {
      if (u === w)
        return 1;
      u = tree.node(u).thread;
    }
  } else if (W.depth < V.depth) {
    let u = W.thread;
    while (tree.node(u).depth > W.depth) {
      if (u === v)
        return -1;
      u = tree.node(u).thread;
    }
  }
  return 0;
}
function doDfs(G2, v, visited, tree, thread, depth = 0) {
  if (!visited.has(v)) {
    visited.add(v);
    thread.push(v);
    tree.setNode(v, { depth });
    const next = G2.outEdges(v).map((e) => e.w);
    next.forEach((w) => {
      if (!visited.has(w)) {
        tree.setEdge(v, w, { delta: 1 });
      }
      doDfs(G2, w, visited, tree, thread, depth + 1);
    });
  }
}
function assignRanks(graph2, rankSets) {
  if (graph2.nodes().length === 0)
    return;
  const GG = groupedGraph(graph2, rankSets);
  addTemporaryEdges(GG);
  makeAcyclic(GG, "0");
  assignInitialRanks(GG);
  moveSourcesRight(GG);
  graph2.nodes().forEach((u) => {
    if (!graph2.node(u))
      graph2.setNode(u, {});
  });
  GG.nodes().forEach((u) => {
    const node = GG.node(u);
    node.nodes.forEach((v) => {
      graph2.node(v).rank = node.rank;
    });
  });
}
function addTemporaryEdges(GG) {
  GG.sources().forEach((u) => {
    if (u !== "0") {
      GG.setEdge("0", u, { delta: 0, temp: true });
    }
  });
}
function moveSourcesRight(GG) {
  GG.edges().forEach((e) => {
    const edge = GG.edge(e);
    if (edge.temp)
      moveRight(e.w);
  });
  function moveRight(v) {
    const V = GG.node(v);
    const rank = min(GG.outEdges(v).map((e) => GG.node(e.w).rank - GG.edge(e).delta));
    if (rank !== void 0)
      V.rank = rank;
  }
}
function createGraph(nodes = [], edges = []) {
  const graph2 = new graphlib.Graph({ directed: true, multigraph: true });
  edges.forEach((edge) => {
    graph2.setEdge(edge.source, edge.target, { data: edge, points: [] }, edge.type);
  });
  graph2.nodes().forEach((u) => graph2.setNode(u, { data: {} }));
  nodes.forEach((node) => {
    if (graph2.hasNode(node.id)) {
      graph2.node(node.id).data = node;
      if (node.direction !== void 0)
        graph2.node(node.id).direction = node.direction;
    }
  });
  graph2.edges().forEach((e) => {
    graph2.edge(e).source = graph2.node(e.v);
    graph2.edge(e).target = graph2.node(e.w);
  });
  return graph2;
}
function sankey(options) {
  const nodeLayout = justifiedPositioning();
  const edgeLayout = linkLayout(options);
  let nodes = [];
  let links = [];
  let order = null;
  function layout(linksIn = [], nodesIn = [], data = {}) {
    const graph2 = createGraph(nodesIn, linksIn);
    if (!data.order) {
      assignRanks(graph2, data.rankSets || []);
      addDummyNodes(graph2);
      order = ordering(graph2);
    } else {
      assignRanks(graph2, data.rankSets || []);
      order = data.order;
      if (order.length > 0 && order[0].length > 0 && !isArray(order[0][0])) {
        order = order.map((rank) => [rank]);
      }
      order = order.map((bands) => bands.map((nodes2) => nodes2.filter((n) => graph2.node(n) !== void 0)));
    }
    nodes = nodeLayout(graph2, order);
    orderEdges(graph2, { alignLinkTypes: data.alignLinkTypes || false });
    links = edgeLayout(graph2);
    removeDummyNodes(graph2);
    addLinkEndpoints(graph2);
    return graph2;
  }
  layout.nodes = function() {
    return nodes;
  };
  layout.links = function() {
    return links;
  };
  layout.order = function() {
    return order;
  };
  layout.size = function(x) {
    if (!arguments.length)
      return nodeLayout.size();
    nodeLayout.size(x);
    return layout;
  };
  layout.separation = function(x) {
    if (!arguments.length)
      return nodeLayout.separation();
    nodeLayout.separation(x);
    return layout;
  };
  layout.whitespace = function(x) {
    if (!arguments.length)
      return nodeLayout.whitespace();
    nodeLayout.whitespace(x);
    return layout;
  };
  layout.edgeValue = function(_x) {
    return layout;
  };
  layout.scale = function(x) {
    if (!arguments.length)
      return nodeLayout.scale();
    nodeLayout.scale(x);
    return layout;
  };
  return layout;
}
const DefaultPalette = [
  "#ACD5FC",
  "#E37816",
  "#07CC80",
  "#0871D4",
  "#CB8E55",
  "#9FAE29",
  "#427565",
  "#6D55A6",
  "#FEF445",
  "#E177C2",
  "#F48B7B",
  "#D74B05",
  "#AA896F",
  "#14A14D",
  "#C5114D"
];
var numberTag = "[object Number]";
function isNumber(value) {
  return typeof value == "number" || isObjectLike(value) && baseGetTag(value) == numberTag;
}
function isNaN(value) {
  return isNumber(value) && value != +value;
}
const minWidth = (d) => d.dy === 0 ? 0 : 2;
function radiusBounds(d) {
  const Dx = d.x1 - d.x0;
  const Dy = d.y1 - d.y0;
  const Rmin = d.dy / 2;
  const Rmax = (Dx * Dx + Dy * Dy) / Math.abs(4 * Dy);
  return [Rmin, Rmax];
}
function segmentPath(edge) {
  const h = Math.max(minWidth(edge), edge.dy) / 2;
  let { x0 } = edge;
  let { x1 } = edge;
  let { y0 } = edge;
  let { y1 } = edge;
  if (x1 < x0) {
    [x0, x1] = [x1, x0];
    [y0, y1] = [y1, y0];
  }
  const f = y1 > y0 ? 1 : -1;
  const fx = 1;
  const Rlim = radiusBounds(edge);
  const defaultRadius = Math.max(Rlim[0], Math.min(Rlim[1], (x1 - x0) / 3));
  let r0 = Math.max(Rlim[0], Math.min(Rlim[1], edge.r0 || defaultRadius));
  let r1 = Math.max(Rlim[0], Math.min(Rlim[1], edge.r1 || defaultRadius));
  const dcx = x1 - x0;
  const dcy = y1 - y0 - f * (r0 + r1);
  const D = Math.sqrt(dcx * dcx + dcy * dcy);
  const phi = -f * Math.acos(Math.min(1, (r0 + r1) / D));
  const psi = Math.atan2(dcy, dcx);
  let theta = Math.PI / 2 + f * (psi + phi);
  let hs = h * f * Math.sin(theta);
  let hc = h * Math.cos(theta);
  let x2 = x0 + fx * r0 * Math.sin(Math.abs(theta));
  let x3 = x1 - fx * r1 * Math.sin(Math.abs(theta));
  let y2 = y0 + r0 * f * (1 - Math.cos(theta));
  let y3 = y1 - r1 * f * (1 - Math.cos(theta));
  if (isNaN(theta) || Math.abs(theta) < 1e-3) {
    theta = 0;
    r0 = 0;
    r1 = 0;
    x2 = x0;
    x3 = x1;
    y2 = y0;
    y3 = y1;
    hs = 0;
    hc = h;
  }
  function arc(dir, r) {
    const ff = dir * (y1 - y0) > 0 ? 1 : 0;
    let rr = fx * dir * (y1 - y0) > 0 ? r + h : r - h;
    if (theta === 0) {
      rr = r;
    }
    return `A${rr} ${rr} ${Math.abs(theta)} 0 ${ff} `;
  }
  const path = `M${[x0, y0 - h]} ${arc(1, r0)}${[x2 + hs, y2 - hc]} L${[x3 + hs, y3 - hc]} ${arc(-1, r1)}${[x1, y1 - h]} L${[x1, y1 + h]} ${arc(1, r1)}${[x3 - hs, y3 + hc]} L${[x2 - hs, y2 + hc]} ${arc(-1, r0)}${[x0, y0 + h]} Z`;
  return path;
}
function toOrFromElsewherePath(d) {
  const p = d.points[0];
  const h = Math.max(minWidth(d), d.dy) / 2;
  if (p.style === "down-right") {
    return `M${[p.x - 20, p.y - h]} L${[p.x, p.y - h]} L${[p.x, p.y + h]} L${[p.x - 20, p.y + h]} Z`;
  }
  if (p.style === "right-down") {
    return `M${[p.x, p.y - h]} L${[p.x + 20, p.y - h]} L${[p.x + 20, p.y + h]} L${[p.x, p.y + h]} Z`;
  }
  return null;
}
function generatePath(d) {
  var _a;
  if (((_a = d.points) == null ? void 0 : _a.length) === 1) {
    return toOrFromElsewherePath(d);
  }
  let path = "";
  let seg;
  for (let i = 0; i < d.points.length - 1; ++i) {
    seg = {
      d0: d.points[i].d,
      d1: d.points[i + 1].d,
      dy: d.dy,
      r0: d.points[i].ro,
      r1: d.points[i + 1].ri,
      x0: d.points[i].x,
      x1: d.points[i + 1].x,
      y0: d.points[i].y,
      y1: d.points[i + 1].y
    };
    path += segmentPath(seg);
  }
  return path;
}
const nodeTitle = (nodeData, maxLength) => {
  const text = nodeData.title !== void 0 ? nodeData.title : nodeData.id;
  if (maxLength && text.length > maxLength) {
    return `${text.substr(0, 15)}...`;
  }
  return text;
};
function titlePosition(node, maxRank) {
  let top = false;
  let right = false;
  if (node.rank < maxRank / 2) {
    right = true;
    top = false;
  }
  return { right, top };
}
function textTransform(node, position, nodeWidth) {
  const y = position.top ? -25 : node.dy / 2 - 10;
  let x;
  if (position.top) {
    x = position.right ? 4 : -4;
  } else {
    x = position.right ? 10 + nodeWidth / 2 : -10 + -nodeWidth / 2;
  }
  return { x: node.x + x, y: node.y + y };
}
function renderNodeText(graphNode, { fontColor, maxRank, nodeWidth }) {
  const { data } = graphNode;
  const position = titlePosition(graphNode, maxRank);
  const { x, y } = textTransform(graphNode, position, nodeWidth);
  const text = drawText(nodeTitle(data, position.top ? 25 : 15), {
    fontColor,
    pointerEvents: "none",
    // eslint-disable-next-line no-nested-ternary
    textAnchor: position.top ? "middle" : position.right ? "start" : "end",
    x,
    y
  });
  return text;
}
function renderNode(graphNode, maxRank, options) {
  var _a, _b;
  const { dy, x, y } = graphNode;
  const { fontColor, fontSize, nodeBorderColor, nodeBorderWidth, nodeWidth, onNodeClick } = options;
  const group = new G({ class: "node" });
  const nodeBody = drawRect({
    height: dy,
    width: nodeWidth,
    x: x - nodeWidth / 2,
    y
  });
  nodeBody.fill((_a = graphNode.data) == null ? void 0 : _a.color);
  nodeBody.stroke({
    color: nodeBorderColor ?? ((_b = graphNode.data) == null ? void 0 : _b.color),
    width: nodeBorderWidth
  });
  nodeBody.on("click", () => {
    if (typeof onNodeClick === "function") {
      onNodeClick(graphNode);
    }
  });
  group.add(nodeBody);
  if (graphNode.data && dy > Number.parseInt(fontSize, 10)) {
    const text = renderNodeText(graphNode, { fontColor, maxRank, nodeWidth });
    group.add(text);
  }
  return group;
}
class Paper {
  constructor(element, options) {
    this.element = element;
    this.options = options;
    this.canvas = SVG().addTo(element).size("100%", "100%").viewbox(
      `-${this.spacing} -${this.spacing + this.getYShift()} ${this.width + this.spacing * 2} ${this.height + this.spacing + this.getYShift()}`
    ).attr({ style: this.options.canvasStyle });
  }
  getYShift() {
    return this.options.enableToolbar ? 30 : 0;
  }
  add(element) {
    this.canvas.add(element);
  }
  clear() {
    this.canvas.clear().viewbox(
      `-${this.spacing} -${this.spacing + this.getYShift()} ${this.width + this.spacing * 2} ${this.height + this.spacing + this.getYShift()}`
    );
  }
  resetViewBox() {
    this.canvas.viewbox(
      `-${this.spacing} -${this.spacing + this.getYShift()} ${this.width + this.spacing * 2} ${this.height + this.spacing + this.getYShift()}`
    );
  }
  updateViewBox(x, y, width, height) {
    this.canvas.viewbox(`${x} ${y} ${width} ${height}`);
  }
  get height() {
    return this.options.viewPortHeight;
  }
  get spacing() {
    return this.options.spacing;
  }
  get width() {
    return this.options.viewPortWidth;
  }
}
class SankeyGraph extends Paper {
  construct(data) {
    const { nodeWidth, spacing, viewPortHeight, viewPortWidth } = this.options;
    const layout = sankey({ nodeWidth });
    layout.size([viewPortWidth - nodeWidth, viewPortHeight - spacing]);
    const updatedNodes = data.nodes.map((node, index) => {
      const colorIndex = index % DefaultPalette.length;
      return {
        ...node,
        color: node.color ?? DefaultPalette[colorIndex],
        colorIndex
      };
    });
    const graph2 = layout(data.edges, updatedNodes, data.options);
    this.maxRank = layout.order().length - 1;
    this.graph = graph2;
  }
  render({ keepOldPosition = false } = {}) {
    var _a, _b;
    const {
      enableTooltip,
      fontColor,
      fontFamily,
      fontSize,
      fontWeight,
      nodeBorderColor,
      nodeBorderWidth,
      nodeWidth,
      onNodeClick,
      tooltipId
    } = this.options;
    const oldViewbox = this.canvas.viewbox();
    this.clear();
    const globalStyle = generateStyles({
      color: fontColor,
      fontFamily,
      fontSize,
      fontWeight
    });
    const mainGroup = drawGroup(nodeWidth / 2, 0);
    mainGroup.attr("style", globalStyle);
    const nodes = ((_a = this.graph) == null ? void 0 : _a.nodes()) || [];
    const edges = ((_b = this.graph) == null ? void 0 : _b.edges()) || [];
    const edgesGroup = drawGroup();
    edges.forEach((edgeObj) => {
      this.renderEdge(edgeObj, edgesGroup);
    });
    mainGroup.add(edgesGroup);
    const nodesGroup = drawGroup();
    nodes.forEach((nodeId) => {
      const node = this.graph.node(nodeId);
      if (node.dummy) {
        return;
      }
      const nodeGroup = renderNode(node, this.maxRank, {
        fontColor,
        fontSize,
        nodeBorderColor,
        nodeBorderWidth,
        nodeWidth,
        onNodeClick
      });
      nodesGroup.add(nodeGroup);
    });
    mainGroup.add(nodesGroup);
    this.add(mainGroup);
    if (keepOldPosition) {
      this.updateViewBox(oldViewbox.x, oldViewbox.y, oldViewbox.width, oldViewbox.height);
    }
    if (enableTooltip) {
      const tooltipElement = getTooltip(tooltipId);
      const body = document.body || document.getElementsByTagName("body")[0];
      body.append(tooltipElement);
    }
  }
  renderEdge(edgeObj, group) {
    const {
      edgeGradientFill,
      edgeOpacity,
      enableTooltip,
      fontColor,
      fontFamily,
      fontSize,
      fontWeight,
      nodeWidth,
      tooltipBGColor,
      tooltipBorderColor,
      tooltipId,
      tooltipTemplate
    } = this.options;
    const edgeLabel = this.graph.edge(edgeObj.v, edgeObj.w, edgeObj.name);
    const csNode = this.graph.node(edgeObj.v);
    const ctNode = this.graph.node(edgeObj.w);
    const sourceNode = edgeLabel.source;
    const targetNode = edgeLabel.target;
    if (csNode.dummy) {
      edgeLabel.x0 -= nodeWidth / 2;
    }
    if (ctNode.dummy) {
      edgeLabel.x1 += nodeWidth / 2;
    }
    const edge = generatePath(edgeLabel);
    const edgeColor = this.canvas.gradient("linear", (add) => {
      var _a, _b, _c;
      add.stop(0, (_a = sourceNode.data) == null ? void 0 : _a.color);
      add.stop(1, edgeGradientFill ? (_b = targetNode.data) == null ? void 0 : _b.color : (_c = sourceNode.data) == null ? void 0 : _c.color);
    });
    const path = drawPath(edge, {
      edgeColor,
      id: `${edgeObj.v}-${edgeObj.w}`,
      opacity: edgeOpacity
    });
    if (enableTooltip && sourceNode.data && targetNode.data) {
      const tooltipContent = tooltipTemplate ? tooltipTemplate({
        source: { ...sourceNode.data, value: sourceNode.value },
        target: { ...targetNode.data, value: targetNode.value },
        value: edgeLabel.value
      }) : null;
      path.on("mousemove", (e) => {
        var _a;
        const fontStyle = generateStyles({
          color: fontColor,
          fontFamily,
          fontSize,
          fontWeight
        });
        const styles = getTooltipStyles({
          bgColor: tooltipBGColor,
          borderColor: tooltipBorderColor,
          x: e.pageX,
          y: e.pageY
        });
        (_a = SVG(`[id="${e.target.id}"]`)) == null ? void 0 : _a.front().opacity(1);
        updateTooltip(tooltipId, styles + fontStyle, tooltipContent);
      });
      path.on("mouseout", (e) => {
        var _a;
        updateTooltip(tooltipId);
        (_a = SVG(`[id="${e.target.id}"]`)) == null ? void 0 : _a.front().opacity(edgeOpacity);
      });
    }
    group.add(path);
  }
}
const DefaultOptions = {
  canvasStyle: "border: 1px solid #caced0; box-sizing: border-box",
  edgeGradientFill: true,
  edgeOpacity: 0.4,
  enableToolbar: true,
  enableTooltip: true,
  fontColor: "#212121",
  fontFamily: "",
  fontSize: "14px",
  fontWeight: "400",
  height: "auto",
  nodeBorderColor: null,
  nodeBorderWidth: 1,
  nodeWidth: 20,
  onNodeClick: void 0,
  spacing: 20,
  tooltipBGColor: "#FFFFFF",
  tooltipBorderColor: "#BCBCBC",
  tooltipId: "apexsankey-tooltip-container",
  tooltipTemplate({ source, target, value }) {
    return `
      <div style='display:flex;align-items:center;gap:5px;padding:5px 10px;'>
        <div style='width:12px;height:12px;background-color:${source.color}'></div>
        <div>${source.title}</div>
        <div>=></div>
        <div style='width:12px;height:12px;background-color:${target.color}'></div>
        <div>${target.title}</div>
        <div>: ${value}</div> 
      </div>
    `;
  },
  viewPortHeight: 500,
  viewPortWidth: 800,
  width: "100%"
};
class ApexSankey {
  constructor(element, options) {
    this.element = element;
    this.options = options;
    this.options = { ...DefaultOptions, ...options };
    const { height, width } = this.options;
    this.graph = new SankeyGraph(this.element, this.options);
    let isPercentValues = false;
    let calculatedWidth = 0;
    if (typeof width === "string" && /^\d+(\.\d+)?%$/.test(width)) {
      calculatedWidth = Number(width.substring(0, width.length - 1));
      isPercentValues = true;
    } else {
      calculatedWidth = Number(width);
    }
    const calculatedHeight = height === "auto" ? calculatedWidth / 1.6 : height;
    this.element.style.width = `${calculatedWidth}${isPercentValues ? "%" : "px"}`;
    this.element.style.height = `${calculatedHeight}${isPercentValues ? "%" : "px"}`;
    this.element.style.position = "relative";
  }
  render(data) {
    if (!this.element) {
      throw new Error("Element not found");
    }
    this.graph.construct(data);
    this.graph.render();
    if (this.options.enableToolbar) {
      const toolbar = new Toolbar(this.element, this.graph.canvas, "apex-sankey");
      toolbar.render({ enableExport: true });
    }
    return this.graph;
  }
}

export { ApexSankey as default };
