import { __exports as MatcherList } from '../../../virtual/MatcherList.js';

var hasRequiredMatcherList;

function requireMatcherList () {
	if (hasRequiredMatcherList) return MatcherList;
	hasRequiredMatcherList = 1;
	//.CommonJS
	var CSSOM = {};
	///CommonJS


	/**
	 * @constructor
	 * @see https://developer.mozilla.org/en/CSS/@-moz-document
	 */
	CSSOM.MatcherList = function MatcherList(){
	    this.length = 0;
	};

	CSSOM.MatcherList.prototype = {

	    constructor: CSSOM.MatcherList,

	    /**
	     * @return {string}
	     */
	    get matcherText() {
	        return Array.prototype.join.call(this, ", ");
	    },

	    /**
	     * @param {string} value
	     */
	    set matcherText(value) {
	        // just a temporary solution, actually it may be wrong by just split the value with ',', because a url can include ','.
	        var values = value.split(",");
	        var length = this.length = values.length;
	        for (var i=0; i<length; i++) {
	            this[i] = values[i].trim();
	        }
	    },

	    /**
	     * @param {string} matcher
	     */
	    appendMatcher: function(matcher) {
	        if (Array.prototype.indexOf.call(this, matcher) === -1) {
	            this[this.length] = matcher;
	            this.length++;
	        }
	    },

	    /**
	     * @param {string} matcher
	     */
	    deleteMatcher: function(matcher) {
	        var index = Array.prototype.indexOf.call(this, matcher);
	        if (index !== -1) {
	            Array.prototype.splice.call(this, index, 1);
	        }
	    }

	};


	//.CommonJS
	MatcherList.MatcherList = CSSOM.MatcherList;
	///CommonJS
	return MatcherList;
}

export { requireMatcherList as __require };
