import { html } from '../../../npm/hybrids/src/template/index.js';

/**
 * Ghostery Browser Extension
 * https://www.ghostery.com/
 *
 * Copyright 2017-present Ghostery GmbH. All rights reserved.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0
 */


// prettier-ignore
const protection = html`
  <svg width="160" height="160" viewBox="0 0 160 160" fill="none" xmlns="http://www.w3.org/2000/svg">
    <circle cx="79.9993" cy="79.9993" r="73.3333" fill="#D9F3FD"/>
    <path d="M122.607 38.0054C121.404 34.822 118.834 26.2859 118.834 26.2859L128.761 29.8701L133.737 21.334L140.481 30.8605L152.601 29.6579L145.645 42.1791L148.427 49.324L137.109 47.3432L131.167 57.0819L128.172 51.0218L123.267 51.5641L122.418 44.5371L116.264 42.3913L122.607 38.0054Z" fill="#00AEF0"/>
    <path d="M22.0355 112.943L20.0547 124.615C20.0311 124.828 20.2433 124.969 20.432 124.851L34.203 116.952C34.3444 116.881 34.4859 116.928 34.5567 117.046L43.7295 134.566C43.8238 134.731 44.0832 134.731 44.1775 134.566L57.807 113.273C57.8777 113.155 58.0192 113.108 58.1371 113.155L69.8802 117.659C70.0452 117.73 70.2575 117.588 70.2575 117.4L69.7859 95.2577C69.7859 95.1398 69.8802 95.0219 70.0217 94.9983L79.1945 93.3241C79.2888 93.3005 79.3595 93.2534 79.4067 93.1591L81.0809 89.4805C81.128 89.3626 81.0809 89.2211 80.963 89.174L67.8051 82.878C67.7108 82.8308 67.6636 82.7365 67.6636 82.6422L68.9134 71.9602C68.937 71.7952 68.7719 71.6537 68.6068 71.7009L60.2358 73.5401C60.165 73.5637 60.1179 73.5401 60.0707 73.5165L46.7478 66.8669C46.7242 66.8669 46.7006 66.8433 46.677 66.8433L35.3348 64.8389C35.1698 64.8154 35.0047 64.9333 35.0047 65.0983L34.6982 73.8703C34.6982 74.0353 34.5331 74.1532 34.368 74.1296L15.9989 70.8991C15.8102 70.8755 15.6452 71.0406 15.6687 71.2057L18.3569 84.1042C18.3805 84.2221 18.3333 84.3164 18.2154 84.3871L7.48633 90.4001C7.29769 90.4945 7.29769 90.7303 7.46275 90.8246L17.2958 96.5546C17.4609 96.649 17.4609 96.8612 17.2958 96.9791L3.45407 106.859C3.26543 106.977 3.31259 107.237 3.50124 107.307L21.8468 112.684C21.9883 112.707 22.059 112.825 22.0355 112.943Z" fill="#00AEF0"/>
    <path d="M44.1775 134.566C44.0832 134.731 43.8238 134.731 43.7295 134.566L34.5567 117.045C34.4859 116.927 34.3444 116.88 34.203 116.951L20.432 124.851C20.2433 124.968 20.0311 124.827 20.0547 124.615L22.0355 112.942C22.059 112.824 21.9883 112.707 21.8468 112.683L3.50124 107.307C3.31259 107.236 3.26543 106.977 3.45407 106.859L17.2958 96.9784C17.4609 96.8605 17.4609 96.6483 17.2958 96.554L7.46275 90.8239C7.29769 90.7296 7.29769 90.4938 7.48633 90.3995L18.2154 84.3865C18.3333 84.3157 18.3805 84.2214 18.3569 84.1035" stroke="#101C48" stroke-linecap="round"/>
    <path d="M122.629 73.2594C129.231 67.718 130.292 60.0544 127.746 54.961C125.199 49.844 122.747 44.6328 125.623 40.011C129.514 33.7386 133.499 35.3892 133.499 37.7237C133.499 40.0582 129.939 41.2843 130.41 43.9961C130.953 47.038 135.622 48.7829 137.744 47.2974C139.866 45.8118 138.805 40.2704 136.47 39.8459C134.136 39.4215 133.287 37.2993 134.136 35.5779C134.985 33.8801 140.314 33.0312 143.497 39.3979C143.497 39.3979 143.073 34.0687 146.044 34.4932C149.015 34.9176 149.44 38.549 149.227 48.3349C149.227 48.3349 150.713 38.3368 154.344 40.0346C157.976 41.7324 154.769 44.9393 153.708 55.1496C152.647 65.36 156.042 76.655 146.044 87.7142C136.046 98.7735 119.445 96.8634 119.445 96.8634L122.629 73.2594Z" fill="white"/>
    <path d="M122.181 97.6177C120.459 97.6177 119.398 97.4998 119.351 97.4998C119.186 97.4762 119.021 97.3819 118.927 97.264C118.832 97.1225 118.785 96.9574 118.809 96.7924L121.992 73.1648C122.016 72.9997 122.086 72.8582 122.204 72.7639C128.83 67.1989 129.42 59.7711 127.156 55.2436C124.822 50.5747 121.898 44.7503 125.058 39.6806C128.265 34.5164 131.236 34.8937 132.085 35.1295C132.58 35.271 133.004 35.5304 133.334 35.8605C133.381 35.6719 133.476 35.5068 133.547 35.3182C134.018 34.3514 135.339 33.7383 136.871 33.7383C138.027 33.7383 140.668 34.1156 142.932 37.2518C143.073 36.2614 143.38 35.1767 144.111 34.5164C144.653 34.0212 145.36 33.809 146.162 33.9033C149.062 34.3278 149.841 37.2282 149.935 43.1469C150.524 41.567 151.35 40.1286 152.434 39.5391C153.118 39.1618 153.896 39.1618 154.627 39.5155C157.363 40.8124 156.844 42.9582 155.948 46.5425C155.429 48.6175 154.745 51.4944 154.344 55.2672C154.085 57.7903 154.085 60.337 154.109 63.0252C154.156 71.2312 154.203 79.6966 146.516 88.1855C138.899 96.5801 127.439 97.6177 122.181 97.6177ZM120.153 96.2972C123.289 96.4858 137.013 96.7688 145.573 87.2895C152.906 79.1778 152.859 70.9482 152.835 63.0016C152.812 60.2663 152.812 57.6724 153.071 55.1022C153.472 51.235 154.179 48.3346 154.698 46.2123C155.618 42.463 155.783 41.4491 154.062 40.6238C153.684 40.4351 153.354 40.4351 153.024 40.6238C151.255 41.567 150.147 46.5896 149.864 48.4289C149.817 48.759 149.534 48.9948 149.18 48.9712C148.85 48.9477 148.591 48.6647 148.591 48.311C148.803 38.2893 148.237 35.4597 145.95 35.1295C145.525 35.0588 145.219 35.1531 144.959 35.3889C144.087 36.2142 144.063 38.5723 144.111 39.3268C144.134 39.6334 143.946 39.9164 143.639 39.9871C143.356 40.0814 143.026 39.9399 142.908 39.657C140.786 35.4125 137.98 34.9645 136.848 34.9645C135.716 34.9645 134.891 35.4125 134.678 35.8369C134.348 36.4972 134.348 37.2518 134.655 37.8649C134.985 38.5487 135.669 39.0203 136.565 39.1618C138.098 39.4447 138.994 41.1897 139.347 42.7224C139.701 44.3966 139.607 46.7075 138.098 47.7686C136.919 48.594 135.056 48.6411 133.24 47.8865C131.33 47.1084 130.033 45.67 129.75 44.0429C129.444 42.2744 130.528 41.0718 131.471 39.9871C132.179 39.2089 132.816 38.478 132.816 37.6526C132.816 37.016 132.391 36.4736 131.707 36.285C130.434 35.9313 128.288 36.7802 126.119 40.2936C123.548 44.4438 125.482 49.042 128.265 54.6306C130.74 59.5589 130.175 67.5526 123.195 73.5421L120.153 96.2972ZM133.829 38.9731C133.499 39.6806 132.957 40.2936 132.438 40.8832C131.566 41.85 130.811 42.6988 131.023 43.8543C131.236 45.0333 132.273 46.118 133.735 46.7311C135.126 47.297 136.541 47.297 137.367 46.7311C138.145 46.1888 138.451 44.656 138.098 43.0054C137.791 41.5906 137.084 40.553 136.353 40.4351C135.268 40.2701 134.395 39.7513 133.829 38.9731Z" fill="#101C48"/>
    <path d="M134.183 49.3491C133.476 48.9246 132.839 50.0329 133.547 50.4573C136.588 52.2495 138.333 55.48 138.168 58.9935C138.121 59.8188 139.418 59.8188 139.442 58.9935C139.63 55.0084 137.602 51.3534 134.183 49.3491Z" fill="#101C48"/>
    <path d="M142.861 39.6091C142.649 43.2169 142.413 46.8483 142.2 50.4561C142.153 51.2814 143.427 51.2814 143.474 50.4561C143.686 46.8483 143.922 43.2169 144.134 39.6091C144.181 38.8074 142.908 38.8074 142.861 39.6091Z" fill="#101C48"/>
    <path d="M148.614 47.8163C148.543 49.4433 148.472 51.0703 148.402 52.721C148.354 53.5463 149.651 53.5463 149.675 52.721C149.746 51.0939 149.816 49.4669 149.887 47.8163C149.934 46.9909 148.661 46.9909 148.614 47.8163Z" fill="#101C48"/>
    <path d="M130.929 36.3321C130.788 35.5304 129.561 35.8605 129.703 36.6623C129.915 37.8885 128.712 38.643 127.628 38.2422C126.85 37.9592 126.519 39.1854 127.298 39.4683C129.373 40.2465 131.283 38.4308 130.929 36.3321Z" fill="#101C48"/>
    <path d="M41.1604 62.592L40.1936 53.0183C40.005 52.8297 39.7928 52.641 39.5805 52.4288C38.8731 51.7214 38.1893 51.014 37.5055 50.283C33.9212 47.1468 26.4698 46.5337 23.0507 43.2324C21.7302 45.3782 20.5747 47.3354 20.1503 49.5991C18.6647 57.475 19.3957 65.8696 21.0463 69.9491C23.2865 75.5376 30.3134 83.8379 44.839 82.2345C59.3645 80.631 41.1604 62.592 41.1604 62.592Z" fill="white"/>
    <path d="M41.2074 83.0602C26.4224 83.0602 21.3762 72.449 20.4566 70.1617C18.8295 66.0823 17.9806 57.6641 19.5369 49.4581C19.985 47.1 21.164 45.0957 22.5317 42.8791L22.9561 42.1953L23.522 42.7377C25.1727 44.3411 27.9787 45.3079 30.6905 46.2747C33.3551 47.2179 36.114 48.1612 37.9533 49.7646L38.0004 49.8118C38.8022 50.6607 39.4388 51.3445 40.0519 51.934C40.1462 52.0284 40.2641 52.1227 40.3585 52.2406L40.8301 52.6886L41.7969 62.2623C43.2353 63.7243 52.8089 73.6988 50.8518 79.2873C50.1679 81.2681 48.1636 82.4707 44.9331 82.8244C43.6126 83.013 42.3628 83.0602 41.2074 83.0602ZM23.2155 44.2232C22.0836 46.0625 21.164 47.8075 20.7867 49.7175C19.3011 57.5933 20.1029 65.8937 21.6356 69.7137C22.5552 72.0246 28.0259 83.4375 44.768 81.5982C47.4798 81.2917 49.1068 80.3956 49.6256 78.9101C51.1112 74.642 43.7069 66.0116 40.7122 63.064L40.5471 62.8989L39.5803 53.3253L39.4624 53.2074C39.3445 53.1131 39.2502 52.9952 39.1323 52.9008C38.5192 52.2877 37.8354 51.6039 37.0572 50.755C35.4066 49.3166 32.7892 48.4205 30.2425 47.5245C27.6958 46.6284 25.0548 45.7088 23.2155 44.2232Z" fill="#101C48"/>
    <path d="M77.9917 109.714C33.0002 110.492 36.9853 106.578 36.4193 81.5592C36.0656 65.9254 33.1652 54.9841 44.8376 50.3623C51.8409 47.6034 65.1403 48.2165 84.382 48.3816C115.909 48.6645 122.488 45.1982 124.327 58.3325C124.374 58.7334 124.445 59.1578 124.492 59.6059C124.917 63.4966 124.94 73.6834 125.176 80.5689C126.308 113.44 122.983 108.936 77.9917 109.714Z" fill="white"/>
    <path d="M99.7446 62.753C97.6211 62.7227 61.9404 62.6999 60.1382 62.6856C37.7938 62.5083 39.1566 63.6302 39.4592 67.7021C39.7723 71.914 37.7525 72.7275 59.4778 72.6647C60.45 72.6619 95.1942 72.6573 96.2639 72.6512C121.236 72.509 122.521 73.3423 121.891 67.5599C121.236 61.7978 119.017 63.0376 99.7446 62.753Z" fill="#101C48"/>
    <path d="M99.4363 62.7417C97.347 62.7154 62.2418 62.6957 60.4687 62.6833C38.4846 62.5296 39.8255 63.5019 40.1232 67.0309C40.4312 70.6812 38.444 71.3862 59.8189 71.3318C60.7755 71.3294 94.9592 71.3254 96.0117 71.3201C120.581 71.1968 121.846 71.919 121.225 66.9076C120.581 61.9138 118.398 62.9883 99.4363 62.7417Z" fill="#00AEF0"/>
    <path d="M73.8169 63.2042C66.534 63.1964 60.3673 63.1898 59.6363 63.1844C54.0068 63.1431 49.8799 63.1776 46.8595 63.3113C43.8279 63.4454 41.9508 63.6785 40.7971 64.0179C39.6587 64.3529 39.3488 64.7512 39.2359 65.1459C39.1691 65.3793 39.1559 65.6643 39.1777 66.0384C39.1905 66.2596 39.2121 66.4754 39.2358 66.7132C39.2544 66.8997 39.2744 67.0997 39.2926 67.3265C39.3208 67.6768 39.3312 68.0134 39.3405 68.3112C39.3445 68.4404 39.3483 68.5623 39.3532 68.6748C39.3703 69.0662 39.4008 69.3621 39.4778 69.6071C39.5499 69.8367 39.6637 70.0235 39.8645 70.1917C40.0749 70.3679 40.4031 70.542 40.9323 70.6992C42.0011 71.0168 43.754 71.2282 46.6477 71.3525C49.5291 71.4764 53.4982 71.5129 58.9729 71.4983C59.367 71.4972 65.2 71.4959 72.1291 71.4943C82.5325 71.492 95.4067 71.4891 96.0544 71.4857C99.2355 71.4689 102.03 71.4667 104.487 71.4647C106.9 71.4627 108.988 71.461 110.799 71.4461C114.456 71.416 116.924 71.3316 118.58 71.089C120.262 70.8426 120.939 70.4528 121.237 69.9715C121.389 69.725 121.474 69.405 121.496 68.9581C121.517 68.5074 121.473 67.965 121.394 67.2933C121.231 65.9632 120.98 65.1689 120.49 64.6417C120.005 64.1197 119.201 63.7725 117.699 63.5689C116.202 63.3659 114.113 63.317 111.155 63.3041C110.3 63.3004 109.373 63.2996 108.369 63.2988C105.917 63.2968 103.007 63.2944 99.5592 63.2473L73.8169 63.2042ZM73.8169 63.2042C84.779 63.2159 98.27 63.2303 99.559 63.2473L73.8169 63.2042Z" stroke="#101C48"/>
    <path d="M68.6072 110.445C52.5489 110.445 43.7534 109.361 39.6269 105.352C35.9483 101.768 35.9012 96.014 35.8304 87.2893C35.8068 85.5207 35.8068 83.6107 35.7597 81.5592C35.7125 79.0125 35.571 76.6073 35.4531 74.2965C34.84 62.3883 34.392 53.7815 44.5788 49.7728C50.7568 47.344 61.7217 47.4619 76.9075 47.6741C79.2892 47.6977 81.7887 47.7449 84.3825 47.7685C90.7728 47.8156 96.2435 47.7213 100.629 47.6506C118.574 47.3204 123.408 47.2261 124.964 58.2853C125.012 58.7098 125.082 59.1342 125.13 59.5823C125.412 62.1525 125.53 67.5289 125.625 72.7401C125.672 75.4519 125.743 78.2344 125.813 80.5924C126.309 94.7643 125.884 101.744 122.135 105.658C117.796 110.162 109.354 110.186 92.5649 110.257C88.2969 110.28 83.4393 110.28 78.0158 110.375C74.6202 110.398 71.5076 110.445 68.6072 110.445ZM66.1077 48.8532C56.5812 48.8532 49.4835 49.2304 45.0739 50.9754C35.7361 54.6539 36.1605 62.4591 36.7736 74.2493C36.8915 76.5838 37.0094 78.989 37.0802 81.5592C37.1273 83.6107 37.1509 85.5207 37.1509 87.3129C37.2217 96.014 37.2688 101.249 40.5465 104.456C45.0739 108.865 56.2275 109.455 77.9922 109.078C83.4393 108.983 88.2733 108.96 92.5649 108.96C109.001 108.913 117.277 108.865 121.239 104.762C124.682 101.202 125.035 94.4341 124.564 80.6396C124.493 78.2815 124.422 75.4755 124.375 72.7637C124.281 67.5996 124.163 62.2469 123.88 59.7237C123.833 59.2993 123.785 58.8748 123.715 58.474C122.323 48.5466 118.574 48.6174 100.677 48.9475C96.2671 49.0182 90.7964 49.1361 84.3825 49.0654C81.7887 49.0418 79.2892 49.0182 76.9075 48.9711C73.0168 48.9003 69.409 48.8532 66.1077 48.8532Z" fill="#101C48"/>
    <path d="M124.494 59.6288C97.6592 59.7939 70.8246 59.9825 43.9901 60.1476C43.1648 60.1476 43.1648 58.8742 43.9901 58.8742C70.7775 58.6856 97.5413 58.5205 124.329 58.3555C124.376 58.7563 124.423 59.1808 124.494 59.6288Z" fill="#101C48"/>
    <path d="M102.822 57.2004C102.35 57.2004 101.949 57.1061 101.619 56.8231C101.077 56.3515 100.935 55.4791 100.912 54.1586V53.9228C100.864 52.5079 100.841 51.7298 101.36 51.2346C101.878 50.7158 102.704 50.7394 104.307 50.7866C106.453 50.8573 106.783 51.4704 106.877 53.8756V54.1114C106.972 56.3987 106.76 56.8939 104.331 57.1061C104.118 57.1297 103.953 57.1533 103.765 57.1533C103.435 57.1533 103.105 57.2004 102.822 57.2004ZM103.175 52.0127C102.704 52.0127 102.35 52.0363 102.256 52.1071C102.138 52.225 102.161 53.0974 102.185 53.852V54.0878C102.232 55.3612 102.35 55.7384 102.468 55.8328C102.586 55.9271 103.128 55.8799 103.647 55.8328C103.836 55.8092 104.024 55.7856 104.236 55.7856C104.567 55.762 105.463 55.6913 105.557 55.5498C105.651 55.4319 105.628 54.7716 105.604 54.135V53.8992C105.533 52.0835 105.533 52.0835 104.284 52.0363C103.883 52.0363 103.505 52.0127 103.175 52.0127Z" fill="#00AEF0"/>
    <path d="M115.203 55.2204C113.505 54.1121 111.973 52.8151 110.605 51.306C110.063 50.6929 109.143 51.6125 109.709 52.2021C111.147 53.7819 112.774 55.1496 114.566 56.3051C115.25 56.7767 115.887 55.6684 115.203 55.2204Z" fill="#00AEF0"/>
    <path d="M114.636 51.2819C113.221 52.6968 111.806 54.1116 110.368 55.55C109.778 56.1395 110.698 57.0356 111.264 56.4461C112.679 55.0312 114.093 53.6164 115.532 52.178C116.098 51.6121 115.202 50.716 114.636 51.2819Z" fill="#00AEF0"/>
    <path d="M96.9743 52.3906H92.494C91.6687 52.3906 91.6687 53.664 92.494 53.664H96.9743C97.7996 53.664 97.7996 52.3906 96.9743 52.3906Z" fill="#00AEF0"/>
    <path d="M56.6385 79.272C56.6385 77.9987 75.6207 68.8495 77.0827 70.0049C78.6862 71.2783 75.1727 89.4824 73.8994 90.119C73.3334 90.402 69.7964 88.5156 66.0942 86.2283C65.3161 87.1479 64.6323 87.9025 64.1371 88.5392C62.6043 90.4492 62.062 91.1566 61.0716 90.4492C59.421 89.3173 59.0437 89.1287 61.6847 85.9217C62.1799 85.3322 62.6279 84.7899 63.0288 84.2475C59.5625 82.0074 56.6385 79.838 56.6385 79.272Z" fill="white"/>
    <path d="M61.7073 91.3687C62.6269 91.3687 63.4051 90.4019 64.5134 89.0343L64.5841 88.9399C64.9614 88.4683 65.4094 87.9496 65.9282 87.36L66.1876 87.0535C73.0495 91.2508 73.8276 90.8735 74.1578 90.7085C75.6198 89.9775 77.4826 79.4606 77.9071 75.3104C78.4258 70.3114 77.7656 69.769 77.459 69.5332C76.2564 68.5664 69.8897 71.3018 64.7492 73.7777C56.0008 77.975 56.0008 78.8947 56.0008 79.2955C56.0008 79.6492 56.0008 80.4038 62.061 84.4361C61.778 84.7898 61.4715 85.1671 61.1649 85.5444C59.6322 87.3836 58.972 88.3504 59.1134 89.2465C59.2078 90.0011 59.8209 90.4019 60.599 90.9443L60.6698 90.9914C61.047 91.2508 61.4008 91.3687 61.7073 91.3687ZM66.0697 85.5915C65.881 85.5915 65.716 85.6623 65.5745 85.8037L64.9614 86.5112C64.4426 87.1242 63.971 87.643 63.5937 88.1146L63.523 88.2089C61.9431 90.1897 61.8016 90.1897 61.4008 89.9067L61.33 89.8596C60.8348 89.5294 60.4104 89.2229 60.3868 89.0343C60.316 88.5626 61.613 86.9828 62.1553 86.3225C62.6505 85.733 63.0985 85.1671 63.523 84.6483C63.6409 84.5068 63.6881 84.3182 63.6645 84.1531C63.6409 83.9645 63.523 83.823 63.3815 83.7287C59.7501 81.347 57.9344 79.8615 57.4157 79.2955C58.241 78.5881 61.5658 76.631 66.7064 74.2493C72.908 71.3489 76.0678 70.4529 76.728 70.5236C77.742 72.245 74.7709 87.643 73.6154 89.4823C73.0023 89.3644 70.9508 88.4447 66.4234 85.6623C66.3055 85.6151 66.1876 85.5915 66.0697 85.5915Z" fill="#101C48"/>
    <path d="M20.1484 49.6008C25.2418 26.8928 42.597 29.7461 49.9305 34.9809C55.637 39.0368 59.1033 48.351 62.381 53.6566C62.381 53.6566 63.1592 54.364 65.5644 58.7736C67.3093 61.9569 67.4744 64.032 65.3993 64.6687C63.6308 65.211 62.0509 64.6687 60.1644 61.6504C58.9854 59.764 57.7357 58.1369 57.7357 58.1369C57.7357 58.1369 57.9007 59.7404 54.8588 60.5421C51.817 61.3438 50.7087 59.2688 50.7087 59.2688C49.3646 61.4853 45.9454 61.0373 42.7621 59.8819C40.5455 59.0565 36.9141 57.1701 36.867 53.916" fill="white"/>
    <path d="M64.2911 65.4941C62.5933 65.4941 61.1313 64.3622 59.6458 61.9806C59.0327 60.9902 58.396 60.0941 57.948 59.4575C57.5235 60.0706 56.6746 60.7308 55.0712 61.1553C52.9961 61.6976 51.5577 61.0374 50.7795 60.2828C49.2704 61.8155 46.4643 61.8862 42.5971 60.4478C40.7107 59.764 36.3247 57.7361 36.2776 53.8925L37.5509 53.8689C37.5981 56.9108 41.3945 58.6321 43.0451 59.2452C45.191 60.0234 48.9638 61.0374 50.2136 58.9151L50.7795 57.9483L51.3219 58.9387C51.3455 59.0094 52.2651 60.5657 54.741 59.9055C56.6511 59.4103 57.1462 58.5378 57.1462 58.1605L57.0991 56.2034L58.2781 57.7361C58.3253 57.8068 59.5514 59.4103 60.7305 61.2967C62.6405 64.3622 64.0317 64.4329 65.2343 64.0557C65.8946 63.8434 66.1068 63.5133 66.2011 63.3011C66.4134 62.7587 66.4134 61.5561 65.0221 59.0802C62.7584 54.9536 61.9802 54.1519 61.9567 54.1283L61.8388 53.9868C60.9191 52.5012 59.9995 50.7091 59.0091 48.8227C56.4624 43.918 53.562 38.3294 49.5533 35.4762C45.4739 32.5522 38.6356 30.6657 32.6226 32.953C26.8218 35.1696 22.6952 41.159 20.738 49.9074L19.4883 49.6244C22.0821 38.0228 27.8358 33.4247 32.1746 31.774C38.6356 29.2981 45.9455 31.326 50.3079 34.4386C54.5524 37.4805 57.5235 43.187 60.141 48.2332C61.1078 50.0725 62.0038 51.8174 62.8763 53.2558C63.1357 53.5388 64.0317 54.6706 66.1304 58.4435C67.4745 60.8723 67.8518 62.5701 67.3566 63.7727C67.0736 64.5037 66.4605 64.9989 65.588 65.2818C65.1636 65.4233 64.7156 65.4941 64.2911 65.4941Z" fill="#101C48"/>
    <path d="M58.3962 57.5469C57.1229 55.6369 55.8495 53.7033 54.5762 51.7933C54.1282 51.1095 53.0199 51.7462 53.4679 52.43C54.7413 54.34 56.0146 56.2736 57.288 58.1836C57.736 58.8674 58.8443 58.2308 58.3962 57.5469Z" fill="#101C48"/>
    <path d="M51.2518 58.326C50.7094 56.9347 49.9784 55.6614 48.9881 54.5531C48.4457 53.94 47.5497 54.8361 48.092 55.4492C48.9173 56.3924 49.5776 57.4771 50.0256 58.6561C50.3086 59.4107 51.5583 59.0806 51.2518 58.326Z" fill="#101C48"/>
    <path d="M37.3618 53.3728C35.0273 51.6514 32.2448 50.8969 29.368 51.2034C28.5663 51.2977 28.5427 52.5711 29.368 52.4768C32.0562 52.1938 34.5557 52.8541 36.7251 54.4575C37.3853 54.9763 38.022 53.868 37.3618 53.3728Z" fill="#101C48"/>
    <path d="M64.8807 62.9006C64.0318 63.3958 63.348 62.4526 63.513 61.6744C63.6781 60.8727 64.3855 60.3775 65.1165 60.0945C65.8711 59.8116 65.5409 58.5618 64.7864 58.8684C63.3244 59.4107 62.0039 60.6605 62.2633 62.3583C62.4991 63.891 64.1733 64.8106 65.5409 64.0089C66.2248 63.5844 65.5881 62.4762 64.8807 62.9006Z" fill="#101C48"/>
    <path d="M44.3648 57.7132C43.1386 56.8643 42.0775 55.8268 41.2286 54.6242C40.757 53.9639 39.6487 54.6006 40.1203 55.2608C41.1107 56.6521 42.3133 57.8311 43.7281 58.8215C44.3884 59.2931 45.025 58.1848 44.3648 57.7132Z" fill="#101C48"/>
    <circle cx="45.334" cy="66.668" r="2" stroke="#101C48" stroke-linecap="round"/>
    <path d="M47 68.334L48.3333 69.6673" stroke="#101C48" stroke-linecap="round"/>
    <path fill-rule="evenodd" clip-rule="evenodd" d="M131.816 111.301C129.422 121.122 119.519 127.143 109.697 124.749C99.876 122.355 93.8549 112.452 96.2491 102.631C98.6432 92.8096 108.546 86.7885 118.367 89.1826C128.189 91.5767 134.21 101.479 131.816 111.301Z" fill="#FFFFFE"/>
    <path fill-rule="evenodd" clip-rule="evenodd" d="M132.071 135.051C131.034 129.049 131.748 124.352 132.126 122.53L135.749 107.665C138.517 96.3096 131.51 84.8497 120.098 82.068C108.686 79.286 97.1901 86.2356 94.422 97.5912L90.7461 112.671C90.1842 114.593 88.6339 118.938 85.0936 123.6C80.3357 129.865 83.0632 129.645 85.4643 129.619C87.8646 129.596 93.4613 128.576 94.3624 131.733C95.2632 134.889 95.9915 137.616 100.054 136.944C104.117 136.272 105.979 136.172 106.504 136.3L107.219 136.474C107.744 136.602 109.351 137.548 112.649 140.014C115.946 142.48 117.848 140.394 120.1 138.007C122.353 135.618 126.852 139.1 128.973 140.225C131.093 141.353 133.412 142.803 132.071 135.051ZM110.987 91.7246C113.213 92.2671 114.325 95.5476 113.47 99.053C112.616 102.558 110.119 104.96 107.893 104.417C105.668 103.875 104.556 100.593 105.41 97.0882C106.265 93.5829 108.762 91.1821 110.987 91.7246ZM111.182 118.645C106.278 117.449 103.32 111.64 103.378 105.993C104.98 109.865 108.174 112.882 112.339 113.897C116.505 114.912 120.728 113.704 123.932 111.003C121.386 116.044 116.086 119.84 111.182 118.645ZM120.649 107.527C118.422 106.984 117.311 103.702 118.166 100.197C119.02 96.6919 121.516 94.2909 123.743 94.8338C125.97 95.3767 127.081 98.6568 126.226 102.162C125.372 105.667 122.876 108.069 120.649 107.527Z" fill="#00AEF0"/>
  </svg>
`;

export { protection as default };
