import '../../ui/theme.js';
/* empty css                  */
import '../../ui/localize.js';
import '../../ui/elements.js';
import Options from '../../store/options.js';
import { GHOSTERY_DOMAIN } from '../../utils/urls.js';
import './elements.js';
import Main from './views/main.js';
import Success from './views/success.js';
import ManagedConfig from '../../store/managed-config.js';
import store from '../../npm/hybrids/src/store.js';
import mount from '../../npm/hybrids/src/mount.js';
import router from '../../npm/hybrids/src/router.js';
import { html } from '../../npm/hybrids/src/template/index.js';

/**
 * Ghostery Browser Extension
 * https://www.ghostery.com/
 *
 * Copyright 2017-present Ghostery GmbH. All rights reserved.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0
 */


Promise.all([store.resolve(Options), store.resolve(ManagedConfig)]).then(
  ([{ onboarding, terms }, managedConfig]) => {
    // As the user can access settings page from browser native UI
    // we must redirect to the Ghostery website if the user has already
    // accepted the terms and conditions and the extension is managed
    if (terms && managedConfig.disableUserControl) {
      return window.location.replace(`https://www.${GHOSTERY_DOMAIN}`);
    }

    store.set(Options, {
      onboarding: {
        shown: onboarding.shown + 1,
      },
    });

    mount(document.body, {
      stack: router([Main, Success]),
      render: ({ stack }) => html`
        <template layout="grid height::100%">
          <onboarding-layout>${stack}</onboarding-layout>
        </template>
      `,
    });
  },
);
