import contributionImage from '../assets/contribution.js';
import router from '../../../npm/hybrids/src/router.js';
import { html } from '../../../npm/hybrids/src/template/index.js';

/**
 * Ghostery Browser Extension
 * https://www.ghostery.com/
 *
 * Copyright 2017-present Ghostery GmbH. All rights reserved.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0
 */


const __vite_glob_0_19 = {
  render: () => html`
    <template layout="column grow">
      <ui-header>
        <ui-text type="label-m" layout="row gap items:center">
          <ui-icon name="report" layout="size:2"></ui-icon>
          Report a broken page
        </ui-text>
        <ui-action slot="actions">
          <a href="${router.backUrl()}">
            <ui-icon name="close" color="primary" layout="size:3"></ui-icon>
          </a>
        </ui-action>
      </ui-header>

      <panel-container>
        <div layout="column items:center gap padding:2:2:4">
          <img
            src="${contributionImage}"
            alt="Contribution"
            layout="size:20 margin:3"
          />
          <ui-text type="headline-s" layout="block:center width:::40">
            Many thanks for your report!
          </ui-text>
          <ui-text type="body-m" layout="block:center width:::36">
            Your contribution helps build a more private and safe internet for
            the entire Ghostery community.
          </ui-text>
        </div>
      </panel-container>
    </template>
  `,
};

export { __vite_glob_0_19 as default };
