import '../../ui/theme.js';
/* empty css                  */
import '../../ui/localize.js';
import '../../ui/elements.js';
import Options from '../../store/options.js';
import ManagedConfig from '../../store/managed-config.js';
import Settings from './settings.js';
import './elements.js';
/* empty css           */
import store from '../../npm/hybrids/src/store.js';
import mount from '../../npm/hybrids/src/mount.js';

Promise.all([store.resolve(Options), store.resolve(ManagedConfig)]).then(([{ terms }, managedConfig]) => {
  if (!terms || managedConfig.disableUserControl)
    throw new Error("Access denied");
  chrome.runtime.sendMessage({ action: "syncOptions" });
  mount(document.body, Settings);
}).catch(() => {
  window.location.replace(
    chrome.runtime.getURL("/pages/onboarding/index.html")
  );
});
