import Options from '../../../store/options.js';
import CustomFilters from '../../../store/custom-filters.js';
import store from '../../../npm/hybrids/src/store.js';
import router from '../../../npm/hybrids/src/router.js';
import { html } from '../../../npm/hybrids/src/template/index.js';

async function update(host, event) {
  const button = event.currentTarget;
  button.disabled = true;
  host.result = void 0;
  try {
    store.submit(host.input);
    host.result = await chrome.runtime.sendMessage({
      action: "customFilters:update",
      input: host.input.text
    });
  } finally {
    button.disabled = false;
  }
}
const __vite_glob_0_15 = {
  options: store(Options),
  input: store(CustomFilters, { draft: true }),
  result: void 0,
  render: ({ options, input, result }) => html`
    <template layout="contents">
      <settings-page-layout layout="column gap:4">
        ${store.ready(options) && html`
          <section layout="column gap:4">
            <div layout="column gap" layout@992px="margin:bottom">
              <settings-link
                href="${router.backUrl()}"
                data-qa="button:back"
                layout="self:start"
              >
                <ui-icon name="chevron-left" color="primary"></ui-icon>
                <ui-text type="headline-s" layout="row gap items:center">
                  Back
                </ui-text>
              </settings-link>
              <ui-text type="headline-m">Custom Filters</ui-text>
              <div layout="column gap:0.5">
                <ui-text type="body-l" mobile-type="body-m" color="secondary">
                  Facilitates the creation of your own ad-blocking rules to
                  customize your Ghostery experience.
                </ui-text>
                <ui-text type="label-s" color="secondary" underline>
                  <a
                    href="https://github.com/ghostery/adblocker/wiki/Compatibility-Matrix"
                    target="_blank"
                    rel="noreferrer"
                    layout="row gap:0.5"
                  >
                    Learn more on supported syntax
                    <ui-icon name="chevron-right-s"></ui-icon>
                  </a>
                </ui-text>
              </div>
            </div>
            <settings-card in-content>
              <ui-toggle
                value="${options.customFilters.enabled}"
                onchange="${html.set(options, "customFilters.enabled")}"
              >
                <div layout="column grow gap:0.5">
                  <div layout="row gap items:center">
                    <ui-icon
                      name="flask"
                      color="quaternary"
                      layout="size:3"
                    ></ui-icon>
                    <ui-text type="headline-xs">Custom Filters</ui-text>
                  </div>
                </div>
              </ui-toggle>
            </settings-card>
            ${options.customFilters.enabled && store.ready(input) && html`
              <div layout="column gap:2">
                <label layout="row gap items:center ::user-select:none">
                  <ui-input>
                    <input
                      type="checkbox"
                      checked="${options.customFilters.trustedScriptlets}"
                      onchange="${html.set(
    options,
    "customFilters.trustedScriptlets"
  )}"
                      data-qa="checkbox:custom-filters:trusted-scriptlets"
                    />
                  </ui-input>
                  <ui-text type="body-s">Allow trusted scriptlets</ui-text>
                </label>
                <ui-input>
                  <textarea
                    rows="10"
                    autocomplete="off"
                    autocorrect="off"
                    autocapitalize="off"
                    spellcheck="false"
                    oninput="${html.set(input, "text")}"
                    defaultValue="${input.text}"
                    data-qa="input:custom-filters"
                  ></textarea>
                </ui-input>

                <ui-button
                  layout="self:start"
                  onclick="${update}"
                  data-qa="button:custom-filters:save"
                >
                  <button>Save</button>
                </ui-button>
                ${result && html`
                  <div
                    layout="column gap margin:top"
                    data-qa="component:custom-filters:result"
                  >
                    <div layout="column gap:0.5">
                      <ui-text type="label-s" color="secondary">
                        Custom filters have been updated
                      </ui-text>
                      <ui-text type="body-s" color="secondary">
                        ${html`
                              <details>
                                <summary>
                                  <ui-text
                                    type="body-s"
                                    layout="inline"
                                    color="secondary"
                                  >
                                    DNR rules: ${result.dnrRules.length}
                                  </ui-text>
                                </summary>
                                <ui-text type="body-s" color="secondary">
                                  ${result.dnrRules.map(
    (rule) => (
      // prettier-ignore
      html`<pre>${JSON.stringify(rule, null, 2)}</pre>`
    )
  )}
                                </ui-text>
                              </details>
                            `}
                      </ui-text>
                      <ui-text type="body-s" color="secondary">
                        Cosmetic filters: ${result.cosmeticFilters || 0}
                      </ui-text>
                    </div>
                  </div>
                `}
                ${!!result?.errors.length && html`
                  <div
                    layout="column gap:0.5"
                    data-qa="component:custom-filters:errors"
                  >
                    <ui-text type="label-s" color="secondary">
                      Errors (${result.errors.length})
                    </ui-text>
                    ${result?.errors.map(
    (error) => html`<ui-text type="body-s" color="danger-secondary">
                          ${error}
                        </ui-text>`
  )}
                  </div>
                `}
              </div>
            `}
          </section>
        `}
      </settings-page-layout>
    </template>
  `
};

export { __vite_glob_0_15 as default };
