import { isOpera } from '../utils/browser-info.js';
import store from '../npm/hybrids/src/store.js';

const ManagedConfig = {
  disableOnboarding: false,
  disableUserControl: false,
  disableUserAccount: false,
  disableTrackersPreview: false,
  trustedDomains: [String],
  [store.connect]: async () => {
    if (isOpera()) return {};
    try {
      return await chrome.storage.managed.get() || {};
    } catch {
      return {};
    }
  }
};

export { ManagedConfig as default };
