import { html } from '../../npm/hybrids/src/template/index.js';

/**
 * Ghostery Browser Extension
 * https://www.ghostery.com/
 *
 * Copyright 2017-present Ghostery GmbH. All rights reserved.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0
 */


const __vite_glob_0_8 = {
  name: '',
  color: '',
  render: ({ name, color }) => html`
    <template layout="block">${html([icons[name]]) || ''}</template>
  `.css`
    :host {
      color: ${color ? `var(--color-${color});` : 'inherit'};
    }

    svg {
      display: block;
      width: inherit;
      height: inherit;
    }
   `,
};

// prettier-ignore
const icons = {
  'alert': /* html */`
    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
      <g clip-path="url(#clip0_4366_65557)">
        <path d="M10.0002 19.3337C15.1548 19.3337 19.3335 15.1549 19.3335 10.0003C19.3335 4.84566 15.1548 0.666992 10.0002 0.666992C4.84554 0.666992 0.66687 4.84567 0.66687 10.0003C0.66687 15.1549 4.84554 19.3337 10.0002 19.3337Z" fill="currentColor" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
        <path d="M10.0002 6.66699V10.0003M10.0002 13.3337H10.0086" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
      </g>
      <defs>
        <clipPath id="clip0_4366_65557">
          <rect width="20" height="20" fill="white"/>
        </clipPath>
      </defs>
    </svg>
  `,
  'ghosty': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path fill-rule="evenodd" clip-rule="evenodd" d="M13 7C13 9.76142 10.7614 12 8 12C5.23859 12 3 9.76142 3 7C3 4.23859 5.23859 2 8 2C10.7614 2 13 4.23859 13 7Z" fill="#FFFFFE"/>
      <path fill-rule="evenodd" clip-rule="evenodd" d="M14.6041 13.2868C13.9406 11.761 13.8264 10.4682 13.8085 9.9602V5.78079C13.8085 2.58804 11.2074 0 7.99899 0C4.79019 0 2.18898 2.58804 2.18898 5.78079V10.0206C2.16419 10.5671 2.03381 11.8204 1.39588 13.2868C0.53845 15.2572 1.24806 15.0223 1.88366 14.8603C2.51917 14.6988 3.93848 14.0659 4.38187 14.8455C4.82508 15.6248 5.19483 16.3016 6.22953 15.8603C7.26432 15.4192 7.75192 15.2722 7.89966 15.2722H8.10064C8.2482 15.2722 8.73598 15.4192 9.77068 15.8603C10.8054 16.3016 11.1749 15.6248 11.6184 14.8455C12.0616 14.0659 13.4809 14.6988 14.1165 14.8603C14.7522 15.0223 15.4614 15.2572 14.6041 13.2868ZM6.20572 3.15214C6.83148 3.15214 7.33877 3.95083 7.33877 4.9364C7.33877 5.92188 6.83148 6.72084 6.20572 6.72084C5.57996 6.72084 5.07259 5.92188 5.07259 4.9364C5.07259 3.95083 5.57996 3.15214 6.20572 3.15214ZM7.99898 10.2839C6.62004 10.2839 5.45925 8.93357 5.10946 7.43105C5.78506 8.3552 6.82782 8.94911 7.99898 8.94911C9.17006 8.94911 10.2127 8.3552 10.8884 7.43105C10.5386 8.93357 9.37766 10.2839 7.99898 10.2839ZM9.79224 6.72084C9.16603 6.72084 8.65892 5.92188 8.65892 4.9364C8.65892 3.95083 9.16603 3.15214 9.79224 3.15214C10.4184 3.15214 10.9253 3.95083 10.9253 4.9364C10.9253 5.92188 10.4184 6.72084 9.79224 6.72084Z" fill="currentColor"/>
    </svg>
  `,
  'logo': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path fill-rule="evenodd" clip-rule="evenodd" d="M19.5 10.5C19.5 14.6421 16.1421 18 12 18C7.85788 18 4.5 14.6421 4.5 10.5C4.5 6.35788 7.85788 3 12 3C16.1421 3 19.5 6.35788 19.5 10.5Z" fill="#FFFFFE"/>
      <path fill-rule="evenodd" clip-rule="evenodd" d="M21.9062 19.9302C20.9109 17.6415 20.7395 15.7022 20.7128 14.9403V8.67118C20.7128 3.88205 16.8111 0 11.9985 0C7.18528 0 3.28347 3.88205 3.28347 8.67118V15.0309C3.24629 15.8507 3.05072 17.7306 2.09383 19.9302C0.807675 22.8858 1.87209 22.5335 2.82549 22.2904C3.77876 22.0482 5.90772 21.0989 6.57281 22.2683C7.23763 23.4372 7.79225 24.4523 9.3443 23.7904C10.8965 23.1288 11.6279 22.9083 11.8495 22.9083H12.151C12.3723 22.9083 13.104 23.1288 14.656 23.7904C16.2081 24.4523 16.7624 23.4372 17.4276 22.2683C18.0925 21.0989 20.2213 22.0482 21.1748 22.2904C22.1282 22.5335 23.1921 22.8858 21.9062 19.9302ZM9.30859 4.72821C10.2472 4.72821 11.0082 5.92624 11.0082 7.4046C11.0082 8.88282 10.2472 10.0813 9.30859 10.0813C8.36995 10.0813 7.60888 8.88282 7.60888 7.4046C7.60888 5.92624 8.36995 4.72821 9.30859 4.72821ZM11.9985 15.4259C9.93006 15.4259 8.18888 13.4004 7.66419 11.1466C8.6776 12.5328 10.2417 13.4237 11.9985 13.4237C13.7551 13.4237 15.3191 12.5328 16.3326 11.1466C15.8079 13.4004 14.0665 15.4259 11.9985 15.4259ZM14.6884 10.0813C13.749 10.0813 12.9884 8.88282 12.9884 7.4046C12.9884 5.92624 13.749 4.72821 14.6884 4.72821C15.6275 4.72821 16.3879 5.92624 16.3879 7.4046C16.3879 8.88282 15.6275 10.0813 14.6884 10.0813Z" fill="#00AEF0"/>
    </svg>
  `,
  'logo-pause': /* html */`
    <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path fill-rule="evenodd" clip-rule="evenodd" d="M27.1715 25.2519C25.9926 22.5817 25.7895 20.3193 25.7579 19.4304V12.1164C25.7579 6.52906 21.1363 2 15.4356 2C9.7343 2 5.11255 6.52906 5.11255 12.1164V19.5361C5.06851 20.4924 4.83686 22.6857 3.7034 25.2519C2.17993 28.7001 3.44074 28.2891 4.57007 28.0055C5.69923 27.7229 8.22101 26.6154 9.00882 27.9797C9.79631 29.3434 10.4533 30.5277 12.2917 29.7555C14.1303 28.9836 14.9966 28.7263 15.2591 28.7263H15.6162C15.8784 28.7263 16.7451 28.9836 18.5835 29.7555C20.4219 30.5277 21.0786 29.3434 21.8666 27.9797C22.654 26.6154 25.1757 27.7229 26.3051 28.0055C27.4345 28.2891 28.6946 28.7001 27.1715 25.2519Z" fill="#00AEF0"/>
      <g clip-path="url(#clip0_47_1076)">
        <path d="M14.0667 14.9999V10.9999M16.7334 14.9999V10.9999M22.0667 12.9999C22.0667 16.6818 19.082 19.6666 15.4001 19.6666C11.7182 19.6666 8.7334 16.6818 8.7334 12.9999C8.7334 9.31802 11.7182 6.33325 15.4001 6.33325C19.082 6.33325 22.0667 9.31802 22.0667 12.9999Z" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      </g>
      <defs>
      <clipPath id="clip0_47_1076">
        <rect width="16" height="16" fill="white" transform="translate(7.40039 5)"/>
      </clipPath>
      </defs>
    </svg>
  `,
  'logo-with-slogan': /* html */`
    <svg width="216" height="32" viewBox="0 0 216 32" fill="none" xmlns="http://www.w3.org/2000/svg">
      <style>@media (prefers-color-scheme: dark) { .text { fill: white; } }</style>
      <path fill-rule="evenodd" clip-rule="evenodd" d="M28.1246 26.5736C26.7772 23.522 26.5452 20.9363 26.509 19.9204V11.5616C26.509 5.17607 21.2272 0 14.7121 0C8.19635 0 2.91434 5.17607 2.91434 11.5616V20.0412C2.86401 21.1342 2.59926 23.6408 1.30388 26.5736C-0.437223 30.5144 1.0037 30.0447 2.29436 29.7205C3.58484 29.3976 6.46687 28.1319 7.36722 29.6911C8.26721 31.2496 9.01802 32.6031 11.1191 31.7206C13.2203 30.8384 14.2104 30.5444 14.5104 30.5444H14.9186C15.2182 30.5444 16.2087 30.8384 18.3097 31.7206C20.4108 32.6031 21.1612 31.2496 22.0618 29.6911C22.9618 28.1319 25.8436 29.3976 27.1345 29.7205C28.4251 30.0447 29.8653 30.5144 28.1246 26.5736Z" fill="#00AEF0"/>
      <path class="text" fill-rule="evenodd" clip-rule="evenodd" d="M11.0705 6.30426C12.3411 6.30426 13.3712 7.90164 13.3712 9.87278C13.3712 11.8437 12.3411 13.4417 11.0705 13.4417C9.7998 13.4417 8.76953 11.8437 8.76953 9.87278C8.76953 7.90164 9.7998 6.30426 11.0705 6.30426ZM14.7117 20.5679C11.9116 20.5679 9.55453 17.8672 8.84424 14.8621C10.2161 16.7104 12.3335 17.8982 14.7117 17.8982C17.0897 17.8982 19.2069 16.7104 20.579 14.8621C19.8687 17.8672 17.5112 20.5679 14.7117 20.5679ZM16.0518 9.87278C16.0518 11.8437 17.0815 13.4417 18.3531 13.4417C19.6245 13.4417 20.6538 11.8437 20.6538 9.87278C20.6538 7.90164 19.6245 6.30426 18.3531 6.30426C17.0815 6.30426 16.0518 7.90164 16.0518 9.87278Z" fill="white"/>
      <path class="text" fill-rule="evenodd" clip-rule="evenodd" d="M51.3685 10.2817C51.3685 7.60985 52.8051 6.08279 55.4338 6.08279C58.0633 6.08279 59.4991 7.60985 59.4991 10.2817V18.9656C59.4991 21.6374 58.0633 23.1648 55.4338 23.1648C52.8051 23.1648 51.3685 21.6374 51.3685 18.9656V10.2817ZM54.0462 19.1327C54.0462 20.3256 54.5826 20.7791 55.4338 20.7791C56.2862 20.7791 56.8212 20.3256 56.8212 19.1327V10.1145C56.8212 8.92175 56.2862 8.4684 55.4338 8.4684C54.5826 8.4684 54.0462 8.92175 54.0462 10.1145V19.1327ZM39.4648 13.6694H35.7158V16.0553H36.9331V19.1327C36.9331 20.3256 36.398 20.7552 35.5458 20.7552C34.6934 20.7552 34.1579 20.3256 34.1579 19.1327V10.1145C34.1579 8.92212 34.6934 8.46894 35.5458 8.46894C36.398 8.46894 36.9331 8.92212 36.9331 10.1145V11.9041H39.4648V10.2816C39.4648 7.60929 38.1013 6.08315 35.4722 6.08315C32.8434 6.08315 31.4805 7.60929 31.4805 10.2816V18.9655C31.4805 21.6373 32.8434 23.1644 35.4722 23.1644C38.1013 23.1644 39.4648 21.6373 39.4648 18.9655V13.6694ZM41.1937 22.9733H43.8712V15.8162H46.9135V22.9733H49.6401V6.27412H46.9135V13.4308H43.8712V6.27412H41.1937V22.9733ZM68.7749 10.2824C68.7749 7.61038 67.4361 6.08315 64.8311 6.08315C62.2258 6.08315 60.8874 7.61038 60.8874 10.2824C60.8874 12.8629 62.4186 14.2359 63.8245 15.4966C65.0177 16.5665 66.1205 17.5554 66.1205 19.1327C66.1205 20.3252 65.5854 20.7548 64.7337 20.7548C63.8819 20.7548 63.3459 20.3252 63.3459 19.1327V17.94H60.8142V18.9659C60.8142 21.6383 62.178 23.1644 64.8064 23.1644C67.4361 23.1644 68.7987 21.6383 68.7987 18.9659C68.7987 16.3847 67.2668 15.0112 65.8604 13.7503C64.6672 12.6804 63.5643 11.6916 63.5643 10.1148C63.5643 8.92212 64.052 8.46894 64.9033 8.46894C65.7558 8.46894 66.2432 8.92212 66.2432 10.1148V10.8066H68.7749V10.2824ZM69.3468 6.27336H77.6228V8.6597H74.8244V22.9732H72.1462V8.6597H69.3468V6.27336ZM85.3522 13.3118H81.6761V8.65992H86.3016V6.27412H78.9994V22.9742H86.3016V20.588H81.6761V15.6972H85.3522V13.3118ZM93.5561 22.9733L93.5477 22.9485C93.407 22.5331 93.3126 22.2546 93.3126 20.9222V18.2976C93.3126 16.7469 92.7773 16.1744 91.5595 16.1744H90.6352V22.9733H87.9576V6.27412H91.9987C94.7733 6.27412 95.9671 7.53861 95.9671 10.1152V11.4273C95.9671 13.1442 95.4066 14.2661 94.2139 14.8143C95.5521 15.3629 95.9904 16.6275 95.9904 18.369V20.9456C95.9904 21.7569 96.0147 22.3535 96.2822 22.9733H93.5561ZM90.6351 8.65978V13.7884H91.6818C92.6804 13.7884 93.2877 13.3596 93.2877 12.0232V10.3769C93.2877 9.184 92.8745 8.65978 91.9258 8.65978H90.6351ZM96.6236 6.27412L100.007 17.4389V22.9733H102.685V17.4389L106.069 6.27412H103.513L101.469 13.8845L99.4226 6.27412H96.6236Z" fill="#202225"/>
      <path class="text" fill-rule="evenodd" clip-rule="evenodd" d="M107.629 6.26358C108.189 6.26358 108.614 6.67969 108.614 7.25769C108.614 7.83479 108.189 8.25199 107.629 8.25199C107.067 8.25199 106.641 7.83479 106.641 7.25769C106.641 6.67969 107.067 6.26358 107.629 6.26358ZM107.629 8.0572C108.075 8.0572 108.41 7.72159 108.41 7.25769C108.41 6.79398 108.075 6.45728 107.629 6.45728C107.18 6.45728 106.846 6.79398 106.846 7.25769C106.846 7.72159 107.18 8.0572 107.629 8.0572ZM107.77 7.85115C107.755 7.81572 107.749 7.7961 107.749 7.68489V7.55733C107.749 7.42959 107.704 7.38544 107.605 7.38544H107.532V7.85115H107.317V6.66334H107.645C107.866 6.66334 107.966 6.76637 107.966 6.9746V6.99932C107.966 7.14086 107.919 7.23026 107.818 7.27405C107.928 7.31839 107.966 7.41851 107.966 7.5606V7.68798C107.966 7.75194 107.968 7.80155 107.991 7.85115H107.77ZM107.532 6.85795V7.19065H107.619C107.699 7.19065 107.749 7.1574 107.749 7.04929V6.99932C107.749 6.90229 107.715 6.85795 107.634 6.85795H107.532Z" fill="#202225"/>
      <rect class="text" x="120.5" width="2" height="32" fill="#202225"/>
      <path class="text" d="M131.297 8.99219H128.969V7.09375H131.297C131.625 7.09375 131.891 7.02083 132.094 6.875C132.297 6.72917 132.445 6.52865 132.539 6.27344C132.633 6.01302 132.68 5.72135 132.68 5.39844C132.68 5.07031 132.633 4.76302 132.539 4.47656C132.445 4.1901 132.297 3.96094 132.094 3.78906C131.891 3.61198 131.625 3.52344 131.297 3.52344H129.711V13H127.422V1.625H131.297C132.062 1.625 132.719 1.78646 133.266 2.10938C133.818 2.43229 134.242 2.8776 134.539 3.44531C134.836 4.00781 134.984 4.65365 134.984 5.38281C134.984 6.11719 134.836 6.75521 134.539 7.29688C134.242 7.83333 133.818 8.25 133.266 8.54688C132.719 8.84375 132.062 8.99219 131.297 8.99219ZM136.523 1.625H140.172C140.932 1.625 141.581 1.75521 142.117 2.01562C142.654 2.27604 143.065 2.66146 143.352 3.17188C143.638 3.68229 143.781 4.3125 143.781 5.0625C143.781 5.67708 143.698 6.20312 143.531 6.64062C143.365 7.07292 143.128 7.4349 142.82 7.72656C142.513 8.01302 142.146 8.24219 141.719 8.41406L141.023 8.82812H138.062L138.055 6.92969H140.109C140.422 6.92969 140.68 6.86198 140.883 6.72656C141.091 6.58594 141.245 6.39062 141.344 6.14062C141.448 5.88542 141.5 5.58854 141.5 5.25C141.5 4.89062 141.453 4.58333 141.359 4.32812C141.271 4.06771 141.128 3.86979 140.93 3.73438C140.737 3.59375 140.484 3.52344 140.172 3.52344H138.812V13H136.523V1.625ZM141.688 13L139.602 7.92969L142 7.92188L144.133 12.8906V13H141.688ZM147.75 1.625V13H145.477V1.625H147.75ZM153.242 10.5703L155.398 1.625H157.867L154.57 13H152.906L153.242 10.5703ZM151.398 1.625L153.547 10.5703L153.898 13H152.227L148.953 1.625H151.398ZM162.477 3.65625L160.031 13H157.617L161.172 1.625H162.68L162.477 3.65625ZM164.406 13L161.945 3.65625L161.719 1.625H163.25L166.836 13H164.406ZM164.492 8.75781V10.6562H159.359V8.75781H164.492ZM173.172 9.21094H175.445C175.414 10.0651 175.242 10.7865 174.93 11.375C174.617 11.9583 174.172 12.401 173.594 12.7031C173.021 13.0052 172.328 13.1562 171.516 13.1562C170.885 13.1562 170.326 13.0521 169.836 12.8438C169.346 12.6302 168.93 12.3177 168.586 11.9062C168.242 11.4948 167.982 10.987 167.805 10.3828C167.633 9.77344 167.547 9.07292 167.547 8.28125V6.35156C167.547 5.5599 167.638 4.85938 167.82 4.25C168.008 3.64062 168.273 3.13021 168.617 2.71875C168.966 2.30208 169.385 1.98958 169.875 1.78125C170.37 1.56771 170.927 1.46094 171.547 1.46094C172.375 1.46094 173.068 1.61719 173.625 1.92969C174.182 2.24219 174.612 2.69792 174.914 3.29688C175.221 3.89062 175.406 4.61719 175.469 5.47656H173.18C173.169 4.9349 173.109 4.51042 173 4.20312C172.896 3.89062 172.729 3.67188 172.5 3.54688C172.271 3.41667 171.953 3.35156 171.547 3.35156C171.245 3.35156 170.984 3.40625 170.766 3.51562C170.547 3.61979 170.367 3.78906 170.227 4.02344C170.086 4.25781 169.982 4.5651 169.914 4.94531C169.852 5.32552 169.82 5.78906 169.82 6.33594V8.28125C169.82 8.81771 169.849 9.27604 169.906 9.65625C169.964 10.0312 170.055 10.3385 170.18 10.5781C170.305 10.8177 170.474 10.9922 170.688 11.1016C170.906 11.2109 171.182 11.2656 171.516 11.2656C171.901 11.2656 172.211 11.2083 172.445 11.0938C172.685 10.9792 172.862 10.7734 172.977 10.4766C173.091 10.1797 173.156 9.75781 173.172 9.21094ZM178.562 1.625L180.297 6.75L182.016 1.625H184.508L181.445 8.86719V13H179.141V8.86719L176.078 1.625H178.562ZM129.109 17.625L130.844 22.75L132.562 17.625H135.055L131.992 24.8672V29H129.688V24.8672L126.625 17.625H129.109ZM143.867 22.4297V24.3281C143.867 25.1302 143.768 25.8333 143.57 26.4375C143.378 27.0365 143.102 27.5391 142.742 27.9453C142.388 28.3464 141.958 28.6484 141.453 28.8516C140.953 29.0547 140.398 29.1562 139.789 29.1562C139.18 29.1562 138.622 29.0547 138.117 28.8516C137.617 28.6484 137.185 28.3464 136.82 27.9453C136.461 27.5391 136.182 27.0365 135.984 26.4375C135.786 25.8333 135.688 25.1302 135.688 24.3281V22.4297C135.688 21.6068 135.784 20.888 135.977 20.2734C136.169 19.6536 136.448 19.138 136.812 18.7266C137.177 18.3099 137.609 17.9974 138.109 17.7891C138.609 17.5755 139.164 17.4688 139.773 17.4688C140.383 17.4688 140.938 17.5755 141.438 17.7891C141.938 17.9974 142.37 18.3099 142.734 18.7266C143.099 19.138 143.378 19.6536 143.57 20.2734C143.768 20.888 143.867 21.6068 143.867 22.4297ZM141.594 24.3281V22.4141C141.594 21.8724 141.555 21.4115 141.477 21.0312C141.398 20.6458 141.281 20.3307 141.125 20.0859C140.969 19.8411 140.779 19.6615 140.555 19.5469C140.331 19.4323 140.07 19.375 139.773 19.375C139.477 19.375 139.214 19.4323 138.984 19.5469C138.76 19.6615 138.57 19.8411 138.414 20.0859C138.263 20.3307 138.148 20.6458 138.07 21.0312C137.997 21.4115 137.961 21.8724 137.961 22.4141V24.3281C137.961 24.849 138 25.2943 138.078 25.6641C138.156 26.0339 138.273 26.3359 138.43 26.5703C138.586 26.8047 138.776 26.9792 139 27.0938C139.229 27.2031 139.492 27.2578 139.789 27.2578C140.081 27.2578 140.339 27.2031 140.562 27.0938C140.792 26.9792 140.982 26.8047 141.133 26.5703C141.284 26.3359 141.398 26.0339 141.477 25.6641C141.555 25.2943 141.594 24.849 141.594 24.3281ZM150.641 17.625H152.922V25.4375C152.922 26.3125 152.76 27.026 152.438 27.5781C152.12 28.125 151.68 28.526 151.117 28.7812C150.555 29.0312 149.911 29.1562 149.188 29.1562C148.458 29.1562 147.81 29.0312 147.242 28.7812C146.674 28.526 146.232 28.125 145.914 27.5781C145.602 27.026 145.445 26.3125 145.445 25.4375V17.625H147.727V25.4375C147.727 25.9323 147.781 26.3125 147.891 26.5781C148.005 26.8438 148.169 27.026 148.383 27.125C148.602 27.2188 148.87 27.2656 149.188 27.2656C149.51 27.2656 149.776 27.2188 149.984 27.125C150.198 27.026 150.359 26.8438 150.469 26.5781C150.583 26.3125 150.641 25.9323 150.641 25.4375V17.625ZM163.781 25.2109H166.055C166.023 26.0651 165.852 26.7865 165.539 27.375C165.227 27.9583 164.781 28.401 164.203 28.7031C163.63 29.0052 162.938 29.1562 162.125 29.1562C161.495 29.1562 160.935 29.0521 160.445 28.8438C159.956 28.6302 159.539 28.3177 159.195 27.9062C158.852 27.4948 158.591 26.987 158.414 26.3828C158.242 25.7734 158.156 25.0729 158.156 24.2812V22.3516C158.156 21.5599 158.247 20.8594 158.43 20.25C158.617 19.6406 158.883 19.1302 159.227 18.7188C159.576 18.3021 159.995 17.9896 160.484 17.7812C160.979 17.5677 161.536 17.4609 162.156 17.4609C162.984 17.4609 163.677 17.6172 164.234 17.9297C164.792 18.2422 165.221 18.6979 165.523 19.2969C165.831 19.8906 166.016 20.6172 166.078 21.4766H163.789C163.779 20.9349 163.719 20.5104 163.609 20.2031C163.505 19.8906 163.339 19.6719 163.109 19.5469C162.88 19.4167 162.562 19.3516 162.156 19.3516C161.854 19.3516 161.594 19.4062 161.375 19.5156C161.156 19.6198 160.977 19.7891 160.836 20.0234C160.695 20.2578 160.591 20.5651 160.523 20.9453C160.461 21.3255 160.43 21.7891 160.43 22.3359V24.2812C160.43 24.8177 160.458 25.276 160.516 25.6562C160.573 26.0312 160.664 26.3385 160.789 26.5781C160.914 26.8177 161.083 26.9922 161.297 27.1016C161.516 27.2109 161.792 27.2656 162.125 27.2656C162.51 27.2656 162.82 27.2083 163.055 27.0938C163.294 26.9792 163.471 26.7734 163.586 26.4766C163.701 26.1797 163.766 25.7578 163.781 25.2109ZM171.602 19.6562L169.156 29H166.742L170.297 17.625H171.805L171.602 19.6562ZM173.531 29L171.07 19.6562L170.844 17.625H172.375L175.961 29H173.531ZM173.617 24.7578V26.6562H168.484V24.7578H173.617ZM185 17.625V29H182.789L179.219 21.8828V29H177.047V17.625H179.227L182.828 24.8203V17.625H185ZM195.344 26.0078C195.344 25.8047 195.326 25.6198 195.289 25.4531C195.253 25.2865 195.174 25.1328 195.055 24.9922C194.94 24.8516 194.771 24.7109 194.547 24.5703C194.328 24.4297 194.042 24.2839 193.688 24.1328C193.266 23.9557 192.857 23.7682 192.461 23.5703C192.065 23.3672 191.708 23.1328 191.391 22.8672C191.073 22.6016 190.82 22.2891 190.633 21.9297C190.451 21.5651 190.359 21.138 190.359 20.6484C190.359 20.1693 190.445 19.7344 190.617 19.3438C190.794 18.9531 191.044 18.6198 191.367 18.3438C191.69 18.0625 192.068 17.8464 192.5 17.6953C192.938 17.5443 193.424 17.4688 193.961 17.4688C194.69 17.4688 195.32 17.6198 195.852 17.9219C196.388 18.224 196.802 18.638 197.094 19.1641C197.391 19.6901 197.539 20.2943 197.539 20.9766H195.258C195.258 20.6536 195.211 20.3698 195.117 20.125C195.029 19.875 194.885 19.6797 194.688 19.5391C194.49 19.3984 194.234 19.3281 193.922 19.3281C193.63 19.3281 193.388 19.388 193.195 19.5078C193.008 19.6224 192.867 19.7812 192.773 19.9844C192.685 20.1823 192.641 20.4062 192.641 20.6562C192.641 20.8438 192.685 21.013 192.773 21.1641C192.867 21.3099 192.995 21.4427 193.156 21.5625C193.318 21.6771 193.508 21.7891 193.727 21.8984C193.951 22.0078 194.195 22.1146 194.461 22.2188C194.977 22.4219 195.432 22.6458 195.828 22.8906C196.224 23.1302 196.555 23.401 196.82 23.7031C197.086 24 197.286 24.3359 197.422 24.7109C197.557 25.0859 197.625 25.513 197.625 25.9922C197.625 26.4661 197.542 26.8984 197.375 27.2891C197.214 27.6745 196.977 28.0078 196.664 28.2891C196.352 28.5651 195.974 28.7786 195.531 28.9297C195.094 29.0807 194.604 29.1562 194.062 29.1562C193.536 29.1562 193.039 29.0833 192.57 28.9375C192.102 28.7865 191.688 28.5599 191.328 28.2578C190.974 27.9505 190.695 27.5625 190.492 27.0938C190.289 26.6198 190.188 26.0599 190.188 25.4141H192.477C192.477 25.7578 192.51 26.0521 192.578 26.2969C192.646 26.5365 192.75 26.7292 192.891 26.875C193.031 27.0156 193.203 27.1224 193.406 27.1953C193.615 27.263 193.852 27.2969 194.117 27.2969C194.419 27.2969 194.659 27.2396 194.836 27.125C195.018 27.0104 195.148 26.8568 195.227 26.6641C195.305 26.4714 195.344 26.2526 195.344 26.0078ZM205.695 27.1094V29H200.75V27.1094H205.695ZM201.461 17.625V29H199.172V17.625H201.461ZM205.031 22.2344V24.0703H200.75V22.2344H205.031ZM205.68 17.625V19.5234H200.75V17.625H205.68ZM213.555 27.1094V29H208.609V27.1094H213.555ZM209.32 17.625V29H207.031V17.625H209.32ZM212.891 22.2344V24.0703H208.609V22.2344H212.891ZM213.539 17.625V19.5234H208.609V17.625H213.539Z" fill="#202225"/>
    </svg>
  `,
  'logo-opera': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M11.9996 1.00079C5.9247 1.00079 1 5.92549 1 12.0004C1 17.8995 5.64415 22.714 11.4757 22.9871C11.6497 22.9953 11.824 23 11.9997 23C14.8159 23 17.3843 21.9411 19.3303 20.2007C18.041 21.0558 16.5335 21.5479 14.9225 21.5479C12.303 21.5479 9.95705 20.2484 8.37926 18.1991C7.16296 16.7634 6.37519 14.6411 6.32152 12.2593V11.7413C6.37515 9.35957 7.16292 7.23684 8.37894 5.80145C9.95698 3.75221 12.3029 2.45272 14.9222 2.45272C16.5336 2.45272 18.0413 2.94473 19.3308 3.80037C17.3943 2.06801 14.8415 1.01124 12.0409 1.00084C12.027 1.00084 12.0133 1.0003 11.9994 1.0003L11.9996 1.00079Z" fill="url(#paint0_linear_5669_3820)"/>
      <path d="M8.37891 5.80215C9.38833 4.61049 10.6919 3.89191 12.1162 3.89191C15.3185 3.89191 17.914 7.52248 17.914 12.0009C17.914 16.4794 15.3183 20.1099 12.1162 20.1099C10.6919 20.1099 9.38833 19.3917 8.37918 18.2C9.95694 20.2492 12.3027 21.5487 14.9224 21.5487C16.5336 21.5487 18.041 21.0567 19.3303 20.2016C21.5817 18.1874 22.9994 15.2598 22.9994 12.001C22.9994 8.74257 21.582 5.81515 19.3311 3.80118C18.0414 2.94554 16.5337 2.45354 14.9225 2.45354C12.303 2.45354 9.95702 3.75303 8.37922 5.80227" fill="url(#paint1_linear_5669_3820)"/>
      <defs>
      <linearGradient id="paint0_linear_5669_3820" x1="10.1657" y1="1.35934" x2="10.1657" y2="22.6802" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FF1B2D"/>
      <stop offset="0.3" stop-color="#FF1B2D"/>
      <stop offset="0.614" stop-color="#FF1B2D"/>
      <stop offset="1" stop-color="#A70014"/>
      </linearGradient>
      <linearGradient id="paint1_linear_5669_3820" x1="15.6889" y1="2.61628" x2="15.6889" y2="21.4734" gradientUnits="userSpaceOnUse">
      <stop stop-color="#9C0000"/>
      <stop offset="0.7" stop-color="#FF4B4B"/>
      <stop offset="1" stop-color="#FF4B4B"/>
      </linearGradient>
      </defs>
    </svg>
  `,
  'ads': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M2.66634 8.74367L3.71611 12.9427C3.74563 13.0608 3.76039 13.1199 3.77785 13.1714C3.94845 13.6751 4.40202 14.0292 4.93202 14.0726C4.98627 14.077 5.04714 14.077 5.16887 14.077C5.3213 14.077 5.39752 14.077 5.46173 14.0708C6.09634 14.0092 6.59857 13.507 6.66011 12.8724C6.66634 12.8082 6.66634 12.7319 6.66634 12.5795V3.07701M12.333 8.41033C13.6217 8.41033 14.6663 7.36567 14.6663 6.07701C14.6663 4.78834 13.6217 3.74367 12.333 3.74367M6.83301 3.07701H4.33301C2.67615 3.07701 1.33301 4.42015 1.33301 6.07701C1.33301 7.73387 2.67615 9.077 4.33301 9.077H6.83301C8.01061 9.077 9.45114 9.70827 10.5625 10.3141C11.2109 10.6675 11.5351 10.8443 11.7474 10.8183C11.9443 10.7941 12.0931 10.7057 12.2085 10.5444C12.333 10.3705 12.333 10.0223 12.333 9.32613V2.82787C12.333 2.13167 12.333 1.78357 12.2085 1.6096C12.0931 1.44827 11.9443 1.35987 11.7474 1.33576C11.5351 1.30975 11.2109 1.48647 10.5625 1.83991C9.45114 2.44575 8.01061 3.07701 6.83301 3.07701Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'autoconsent': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M8 7.5V10M8 12.5V12.51" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M3 3L13 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M5 1L11 1" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <rect x="1" y="5" width="14" height="10" rx="1" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'autoconsent-managed': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M3.16699 1H13.167" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <rect x="1.16699" y="3" width="14" height="12" rx="1" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M6.16699 7L10.167 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M6.16699 11L10.167 7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'arrow-right-s': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M2.66406 8H13.3307M13.3307 8L9.33073 4M13.3307 8L9.33073 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'arrow-square-down': /* html */`
    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
      <path d="M5.33333 8L8 10.6667M8 10.6667L10.6667 8M8 10.6667V5.33333M5.2 14H10.8C11.9201 14 12.4801 14 12.908 13.782C13.2843 13.5903 13.5903 13.2843 13.782 12.908C14 12.4801 14 11.9201 14 10.8V5.2C14 4.07989 14 3.51984 13.782 3.09202C13.5903 2.71569 13.2843 2.40973 12.908 2.21799C12.4801 2 11.9201 2 10.8 2H5.2C4.07989 2 3.51984 2 3.09202 2.21799C2.71569 2.40973 2.40973 2.71569 2.21799 3.09202C2 3.51984 2 4.07989 2 5.2V10.8C2 11.9201 2 12.4801 2.21799 12.908C2.40973 13.2843 2.71569 13.5903 3.09202 13.782C3.51984 14 4.07989 14 5.2 14Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'arrow-square-up': /* html */`
    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
      <path d="M10.6667 8L8 5.33333M8 5.33333L5.33333 8M8 5.33333L8 10.6667M10.8 2L5.2 2C4.07987 2 3.51987 2 3.092 2.218C2.71567 2.40973 2.40973 2.71567 2.218 3.092C2 3.51987 2 4.07987 2 5.2L2 10.8C2 11.9201 2 12.4802 2.218 12.908C2.40973 13.2843 2.71567 13.5903 3.092 13.782C3.51987 14 4.07987 14 5.2 14L10.8 14C11.9201 14 12.4802 14 12.908 13.782C13.2843 13.5903 13.5903 13.2843 13.782 12.908C14 12.4802 14 11.9201 14 10.8L14 5.2C14 4.07987 14 3.51987 13.782 3.092C13.5903 2.71567 13.2843 2.40973 12.908 2.218C12.4802 2 11.9201 2 10.8 2Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'block-s': /* html */`
    <svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M3.78659 3.28666L13.2133 12.7133M1.83325 5.68182V10.3182C1.83325 10.4812 1.83325 10.5627 1.85167 10.6395C1.86801 10.7075 1.89494 10.7725 1.93149 10.8322C1.97272 10.8995 2.03037 10.9571 2.14567 11.0724L5.4275 14.3543C5.5428 14.4695 5.60045 14.5272 5.66773 14.5684C5.72738 14.605 5.7924 14.6319 5.86043 14.6483C5.93716 14.6667 6.01869 14.6667 6.18175 14.6667H10.8181C10.9811 14.6667 11.0627 14.6667 11.1394 14.6483C11.2075 14.6319 11.2725 14.605 11.3321 14.5684C11.3994 14.5272 11.4571 14.4695 11.5723 14.3543L14.8542 11.0724C14.9695 10.9571 15.0271 10.8995 15.0683 10.8322C15.1049 10.7725 15.1319 10.7075 15.1482 10.6395C15.1666 10.5627 15.1666 10.4812 15.1666 10.3182V5.68182C15.1666 5.51876 15.1666 5.43723 15.1482 5.36051C15.1319 5.29248 15.1049 5.22745 15.0683 5.16781C15.0271 5.10053 14.9695 5.04287 14.8542 4.92757L11.5723 1.64575C11.4571 1.53045 11.3994 1.47279 11.3321 1.43157C11.2725 1.39501 11.2075 1.36808 11.1394 1.35175C11.0627 1.33333 10.9811 1.33333 10.8181 1.33333H6.18175C6.01869 1.33333 5.93716 1.33333 5.86043 1.35175C5.7924 1.36808 5.72738 1.39501 5.66773 1.43157C5.60045 1.47279 5.5428 1.53045 5.4275 1.64575L2.14567 4.92757C2.03037 5.04287 1.97272 5.10053 1.93149 5.16781C1.89494 5.22745 1.86801 5.29248 1.85167 5.36051C1.83325 5.43723 1.83325 5.51876 1.83325 5.68182Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'block-m': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M4.93146 19.0692L2.47009 16.6078C2.29714 16.4349 2.21066 16.3484 2.14882 16.2475C2.09399 16.158 2.05359 16.0605 2.02909 15.9584C2.00146 15.8433 2.00146 15.721 2.00146 15.4765V8.52196C2.00146 8.27737 2.00146 8.15508 2.02909 8.03999C2.05359 7.93795 2.09399 7.84041 2.14882 7.75094C2.21066 7.65002 2.29714 7.56354 2.47009 7.39059L7.39283 2.46785C7.56578 2.2949 7.65226 2.20842 7.75318 2.14658C7.84265 2.09175 7.94019 2.05135 8.04223 2.02685C8.15732 1.99922 8.27962 1.99922 8.52421 1.99922H15.4788C15.7233 1.99922 15.8456 1.99922 15.9607 2.02685C16.0628 2.05135 16.1603 2.09175 16.2498 2.14658C16.3507 2.20842 16.4372 2.2949 16.6101 2.46785L19.0715 4.92922M4.93146 19.0692L7.39283 21.5306C7.56578 21.7035 7.65226 21.79 7.75318 21.8518C7.84265 21.9067 7.94019 21.9471 8.04223 21.9716C8.15732 21.9992 8.27962 21.9992 8.52421 21.9992H15.4788C15.7233 21.9992 15.8456 21.9992 15.9607 21.9716C16.0628 21.9471 16.1603 21.9067 16.2498 21.8518C16.3507 21.79 16.4372 21.7035 16.6101 21.5306L21.5329 16.6078C21.7058 16.4349 21.7923 16.3484 21.8541 16.2475C21.909 16.158 21.9494 16.0605 21.9739 15.9584C22.0015 15.8433 22.0015 15.721 22.0015 15.4765V8.52196C22.0015 8.27737 22.0015 8.15508 21.9739 8.03999C21.9494 7.93795 21.909 7.84041 21.8541 7.75094C21.7923 7.65002 21.7058 7.56354 21.5329 7.39059L19.0715 4.92922M4.93146 19.0692L19.0715 4.92922" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'call-for-review': /* html */`
    <svg width="280" height="280" viewBox="0 0 280 280" fill="none" xmlns="http://www.w3.org/2000/svg">
      <circle opacity="0.05" cx="140" cy="139.222" r="140" fill="white"/>
      <circle opacity="0.05" cx="140" cy="140" r="112" fill="white"/>
      <circle opacity="0.05" cx="140" cy="139.3" r="84" fill="white"/>
      <path fill-rule="evenodd" clip-rule="evenodd" d="M202.721 189.17C196.651 175.21 195.605 163.382 195.442 158.734V120.496C195.442 91.2853 171.644 67.6069 142.29 67.6069C112.932 67.6069 89.133 91.2853 89.133 120.496V159.287C88.9063 164.287 87.7134 175.754 81.8769 189.17C74.0321 207.198 80.5244 205.049 86.3396 203.566C92.1541 202.089 105.139 196.298 109.196 203.431C113.251 210.561 116.634 216.752 126.101 212.715C135.568 208.68 140.029 207.335 141.381 207.335H143.22C144.57 207.335 149.033 208.68 158.499 212.715C167.966 216.752 171.347 210.561 175.405 203.431C179.46 196.298 192.444 202.089 198.26 203.566C204.076 205.049 210.565 207.198 202.721 189.17Z" fill="url(#paint0_radial_357_1006)"/>
      <g style="mix-blend-mode:soft-light">
      <path fill-rule="evenodd" clip-rule="evenodd" d="M202.721 189.17C196.651 175.21 195.605 163.382 195.442 158.734V120.496C195.442 91.2853 171.644 67.6069 142.29 67.6069C112.932 67.6069 89.133 91.2853 89.133 120.496V159.287C88.9063 164.287 87.7134 175.754 81.8769 189.17C74.0321 207.198 80.5244 205.049 86.3396 203.566C92.1541 202.089 105.139 196.298 109.196 203.431C113.251 210.561 116.634 216.752 126.101 212.715C135.568 208.68 140.029 207.335 141.381 207.335H143.22C144.57 207.335 149.033 208.68 158.499 212.715C167.966 216.752 171.347 210.561 175.405 203.431C179.46 196.298 192.444 202.089 198.26 203.566C204.076 205.049 210.565 207.198 202.721 189.17Z" fill="url(#paint1_radial_357_1006)"/>
      </g>
      <g style="mix-blend-mode:soft-light" opacity="0.4">
      <path fill-rule="evenodd" clip-rule="evenodd" d="M202.721 189.17C196.651 175.21 195.605 163.382 195.442 158.734V120.496C195.442 91.2853 171.644 67.6069 142.29 67.6069C112.932 67.6069 89.133 91.2853 89.133 120.496V159.287C88.9063 164.287 87.7134 175.754 81.8769 189.17C74.0321 207.198 80.5244 205.049 86.3396 203.566C92.1541 202.089 105.139 196.298 109.196 203.431C113.251 210.561 116.634 216.752 126.101 212.715C135.568 208.68 140.029 207.335 141.381 207.335H143.22C144.57 207.335 149.033 208.68 158.499 212.715C167.966 216.752 171.347 210.561 175.405 203.431C179.46 196.298 192.444 202.089 198.26 203.566C204.076 205.049 210.565 207.198 202.721 189.17Z" fill="url(#paint2_radial_357_1006)"/>
      </g>
      <g style="mix-blend-mode:overlay">
      <path fill-rule="evenodd" clip-rule="evenodd" d="M202.721 189.17C196.651 175.21 195.605 163.382 195.442 158.734V120.496C195.442 91.2853 171.644 67.6069 142.29 67.6069C112.932 67.6069 89.133 91.2853 89.133 120.496V159.287C88.9063 164.287 87.7134 175.754 81.8769 189.17C74.0321 207.198 80.5244 205.049 86.3396 203.566C92.1541 202.089 105.139 196.298 109.196 203.431C113.251 210.561 116.634 216.752 126.101 212.715C135.568 208.68 140.029 207.335 141.381 207.335H143.22C144.57 207.335 149.033 208.68 158.499 212.715C167.966 216.752 171.347 210.561 175.405 203.431C179.46 196.298 192.444 202.089 198.26 203.566C204.076 205.049 210.565 207.198 202.721 189.17Z" fill="url(#paint3_radial_357_1006)" fill-opacity="0.7"/>
      </g>
      <g opacity="0.3" filter="url(#filter0_f_357_1006)">
      <path fill-rule="evenodd" clip-rule="evenodd" d="M202.721 189.17C196.651 175.21 195.605 163.382 195.442 158.734V120.496C195.442 91.2853 171.644 67.6069 142.29 67.6069C112.932 67.6069 89.133 91.2853 89.133 120.496V159.287C88.9063 164.287 87.7134 175.754 81.8769 189.17C74.0321 207.198 80.5244 205.049 86.3396 203.566C92.1541 202.089 105.139 196.298 109.196 203.431C113.251 210.561 116.634 216.752 126.101 212.715C135.568 208.68 140.029 207.335 141.381 207.335H143.22C144.57 207.335 149.033 208.68 158.499 212.715C167.966 216.752 171.347 210.561 175.405 203.431C179.46 196.298 192.444 202.089 198.26 203.566C204.076 205.049 210.565 207.198 202.721 189.17Z" fill="url(#paint4_linear_357_1006)"/>
      </g>
      <g opacity="0.7">
      <g filter="url(#filter1_f_357_1006)">
      <circle cx="171.281" cy="118.674" r="10.9042" fill="#0099E6"/>
      </g>
      <g filter="url(#filter2_f_357_1006)">
      <circle cx="113.053" cy="118.674" r="10.9042" fill="#0099E6"/>
      </g>
      </g>
      <path d="M157.53 135.862C157.614 135.795 157.717 135.758 157.825 135.754C157.932 135.75 158.038 135.78 158.127 135.839C158.216 135.899 158.284 135.986 158.321 136.086C158.358 136.187 158.362 136.297 158.332 136.4C156.522 143.294 149.96 148.395 142.135 148.395C134.31 148.395 127.742 143.283 125.938 136.385C125.909 136.282 125.914 136.173 125.951 136.072C125.988 135.972 126.056 135.886 126.145 135.826C126.234 135.767 126.34 135.737 126.446 135.741C126.553 135.745 126.656 135.783 126.741 135.849C130.631 138.825 136.094 140.679 142.135 140.679C148.176 140.679 153.637 138.832 157.53 135.862Z" fill="url(#paint5_radial_357_1006)"/>
      <path d="M157.81 135.372C157.624 135.379 157.444 135.445 157.296 135.56C153.477 138.473 148.101 140.297 142.135 140.297C136.17 140.297 130.791 138.466 126.974 135.546C126.827 135.432 126.647 135.366 126.461 135.36C126.273 135.353 126.089 135.405 125.933 135.509C125.777 135.613 125.658 135.764 125.593 135.939C125.528 136.114 125.52 136.305 125.569 136.484C127.42 143.557 134.146 148.777 142.135 148.777C150.124 148.777 156.843 143.568 158.701 136.501C158.751 136.321 158.743 136.13 158.679 135.955C158.614 135.779 158.496 135.627 158.339 135.522C158.183 135.418 157.998 135.365 157.81 135.372Z" stroke="url(#paint6_linear_357_1006)" stroke-width="0.763568" stroke-miterlimit="10"/>
      <path d="M129.1 117.488C128.33 117.049 127.505 116.715 126.647 116.494C123.358 115.621 120.174 116.561 117.306 118.228C114.098 120.09 111.2 115.122 114.404 113.262C120.375 109.794 128.106 109.173 133.717 113.711C136.522 115.979 132.707 119.881 129.87 117.942C129.622 117.775 129.365 117.622 129.1 117.482V117.488Z" fill="url(#paint7_radial_357_1006)"/>
      <path d="M114.212 112.932C113.317 113.451 112.828 114.204 112.679 115.015C112.531 115.816 112.719 116.645 113.121 117.333C113.523 118.021 114.153 118.593 114.924 118.86C115.704 119.13 116.602 119.078 117.498 118.558L117.498 118.558C120.318 116.919 123.395 116.026 126.549 116.863L126.552 116.864C127.377 117.076 128.171 117.398 128.911 117.82L129.482 118.145V118.144C129.541 118.182 129.599 118.219 129.656 118.258C131.267 119.358 133.135 118.783 134.187 117.666C134.717 117.103 135.071 116.375 135.08 115.606C135.089 114.823 134.74 114.047 133.957 113.414C128.185 108.746 120.273 109.412 114.212 112.932ZM114.212 112.932L114.404 113.262M114.212 112.932L114.404 113.262M114.404 113.262C111.2 115.122 114.098 120.09 117.306 118.228L133.717 113.711C128.106 109.173 120.375 109.794 114.404 113.262Z" stroke="url(#paint8_linear_357_1006)" stroke-width="0.763568" stroke-miterlimit="10"/>
      <path d="M165.54 117.488C164.77 117.05 163.945 116.716 163.087 116.494C159.798 115.621 156.614 116.561 153.744 118.228C150.538 120.09 147.637 115.122 150.841 113.262C156.814 109.794 164.543 109.173 170.155 113.711C172.961 115.979 169.147 119.881 166.308 117.942C166.06 117.776 165.804 117.622 165.54 117.482V117.488Z" fill="url(#paint9_radial_357_1006)"/>
      <path d="M165.351 117.82L165.903 118.134C165.967 118.174 166.031 118.216 166.094 118.258C167.706 119.358 169.574 118.783 170.626 117.666C171.157 117.103 171.51 116.375 171.519 115.606C171.527 114.823 171.178 114.047 170.395 113.414C164.623 108.746 156.712 109.412 150.649 112.932L150.649 112.932C149.755 113.451 149.266 114.204 149.117 115.015C148.97 115.816 149.157 116.645 149.559 117.333C149.961 118.021 150.592 118.593 151.362 118.86C152.143 119.13 153.041 119.078 153.936 118.558C156.758 116.919 159.835 116.026 162.989 116.863L162.991 116.863C163.816 117.077 164.61 117.399 165.351 117.82Z" stroke="url(#paint10_linear_357_1006)" stroke-width="0.763568" stroke-miterlimit="10"/>
      <g style="mix-blend-mode:multiply" filter="url(#filter3_f_357_1006)">
      <path d="M184.841 70.43C195.015 55.4928 224.863 77.5232 184.841 102.557C144.845 77.5232 174.667 55.4928 184.841 70.43Z" fill="#004669"/>
      </g>
      <g style="mix-blend-mode:multiply" filter="url(#filter4_f_357_1006)">
      <path d="M92.3352 142.369C102.509 127.432 132.358 149.462 92.3352 174.496C52.3388 149.462 82.1614 127.432 92.3352 142.369Z" fill="#005B88"/>
      </g>
      <g style="mix-blend-mode:multiply" filter="url(#filter5_f_357_1006)">
      <path d="M184.754 158.679C194.928 143.742 224.776 165.772 184.754 190.805C144.758 165.772 174.58 143.742 184.754 158.679Z" fill="#004669"/>
      </g>
      <path d="M189.862 158.657C200.035 143.719 229.884 165.75 189.862 190.783C149.865 165.75 179.688 143.719 189.862 158.657Z" fill="url(#paint11_linear_357_1006)"/>
      <mask id="mask0_357_1006" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="169" y="153" width="42" height="38">
      <path d="M189.862 158.657C200.035 143.719 229.884 165.75 189.862 190.783C149.865 165.75 179.688 143.719 189.862 158.657Z" fill="url(#paint12_linear_357_1006)"/>
      </mask>
      <g mask="url(#mask0_357_1006)">
      <g filter="url(#filter6_f_357_1006)">
      <path d="M172.212 168.701C171.617 166.552 171.979 164.041 173.196 161.867C174.413 159.692 176.458 157.88 178.943 156.87C180.186 156.378 181.532 156.068 182.93 156.016C184.328 155.964 185.752 156.145 187.124 156.585C188.496 157.026 189.79 157.725 190.929 158.605C192.068 159.485 193 160.546 193.777 161.659H187.357C187.564 161.375 187.771 161.116 187.978 160.831C188.185 160.546 188.418 160.287 188.651 160.029C188.884 159.77 189.143 159.537 189.402 159.278C189.661 159.019 189.945 158.812 190.204 158.579C191.343 157.699 192.638 157 194.01 156.56C195.382 156.119 196.832 155.938 198.229 155.99C199.627 156.042 200.974 156.352 202.216 156.844C204.701 157.854 206.747 159.666 207.963 161.841C209.18 164.015 209.542 166.526 208.947 168.675C208.377 167.717 207.808 166.863 207.161 166.138C206.514 165.413 205.815 164.818 205.064 164.326C203.614 163.368 202.035 162.85 200.559 162.747C199.084 162.643 197.712 162.902 196.599 163.472C195.485 164.041 194.579 164.869 193.777 166.034L190.567 170.642L187.357 166.034C186.554 164.895 185.648 164.041 184.535 163.472C183.422 162.902 182.076 162.617 180.574 162.747C179.099 162.876 177.519 163.368 176.07 164.352C175.345 164.844 174.646 165.439 173.973 166.164C173.351 166.889 172.756 167.717 172.212 168.701Z" fill="#FF3E3E"/>
      </g>
      <g filter="url(#filter7_f_357_1006)">
      <path d="M185.652 187.754C185.082 187.418 184.539 187.081 183.995 186.745C183.71 186.563 183.451 186.408 183.167 186.227C182.908 186.046 182.649 185.864 182.364 185.657L180.785 184.518C180.267 184.104 179.775 183.69 179.284 183.276C177.316 181.593 175.452 179.703 173.873 177.606C172.294 175.509 170.999 173.154 170.249 170.617L169.99 169.659C169.912 169.348 169.86 169.012 169.809 168.675L169.731 168.183C169.705 168.028 169.705 167.847 169.679 167.691L169.602 166.708C169.602 165.387 169.757 164.067 170.145 162.824C170.016 164.119 170.068 165.387 170.223 166.63L170.404 167.562C170.43 167.717 170.456 167.873 170.508 168.028L170.637 168.494C170.741 168.805 170.792 169.089 170.896 169.4L171.207 170.28C172.087 172.636 173.381 174.81 174.909 176.83C176.41 178.849 178.144 180.713 179.957 182.525C180.423 182.965 180.863 183.405 181.329 183.871L182.752 185.165C182.985 185.373 183.218 185.606 183.451 185.813C183.684 186.02 183.943 186.227 184.176 186.434C184.694 186.874 185.186 187.314 185.652 187.754Z" fill="white"/>
      </g>
      <g filter="url(#filter8_f_357_1006)">
      <path d="M170.378 163.989C170.378 161.711 171.129 159.355 172.578 157.414C174.002 155.472 176.099 153.997 178.429 153.22C180.785 152.443 183.425 152.418 185.833 153.298C187.024 153.712 188.163 154.359 189.146 155.162C190.13 155.964 190.984 156.896 191.709 157.932H189.561C190.26 156.896 191.114 155.964 192.098 155.162C193.081 154.359 194.22 153.738 195.411 153.298C197.819 152.443 200.459 152.443 202.815 153.22C205.171 153.997 207.242 155.472 208.692 157.414C210.141 159.355 210.892 161.711 210.892 163.989C210.814 163.705 210.737 163.446 210.659 163.161C210.581 162.902 210.478 162.617 210.374 162.358C210.167 161.841 209.934 161.323 209.675 160.831C209.132 159.873 208.485 158.993 207.734 158.216C206.206 156.689 204.291 155.628 202.272 155.162C200.252 154.696 198.129 154.825 196.291 155.576C194.428 156.327 192.848 157.673 191.709 159.355L190.648 160.935L189.587 159.355C188.422 157.673 186.868 156.301 185.004 155.55C183.141 154.799 181.044 154.67 178.999 155.136C176.979 155.602 175.064 156.663 173.536 158.191C172.785 158.941 172.112 159.847 171.595 160.805C171.336 161.297 171.103 161.789 170.896 162.333C170.792 162.591 170.689 162.85 170.611 163.135C170.533 163.42 170.456 163.705 170.378 163.989Z" fill="#700000"/>
      </g>
      <g filter="url(#filter9_f_357_1006)">
      <path d="M170.378 163.989C170.378 161.711 171.129 159.355 172.578 157.414C174.002 155.472 176.099 153.997 178.429 153.22C180.785 152.443 183.425 152.418 185.833 153.298C187.024 153.712 188.163 154.359 189.146 155.162C190.13 155.964 190.984 156.896 191.709 157.932H189.561C190.26 156.896 191.114 155.964 192.098 155.162C193.081 154.359 194.22 153.738 195.411 153.298C197.819 152.443 200.459 152.443 202.815 153.22C205.171 153.997 207.242 155.472 208.692 157.414C210.141 159.355 210.892 161.711 210.892 163.989C210.814 163.705 210.737 163.446 210.659 163.161C210.581 162.902 210.478 162.617 210.374 162.358C210.167 161.841 209.934 161.323 209.675 160.831C209.132 159.873 208.485 158.993 207.734 158.216C206.206 156.689 204.291 155.628 202.272 155.162C200.252 154.696 198.129 154.825 196.291 155.576C194.428 156.327 192.848 157.673 191.709 159.355L190.648 160.935L189.587 159.355C188.422 157.673 186.868 156.301 185.004 155.55C183.141 154.799 181.044 154.67 178.999 155.136C176.979 155.602 175.064 156.663 173.536 158.191C172.785 158.941 172.112 159.847 171.595 160.805C171.336 161.297 171.103 161.789 170.896 162.333C170.792 162.591 170.689 162.85 170.611 163.135C170.533 163.42 170.456 163.705 170.378 163.989Z" fill="#700000"/>
      </g>
      <g filter="url(#filter10_f_357_1006)">
      <path d="M171.436 168.701C170.84 166.552 171.203 164.041 172.419 161.867C173.636 159.692 175.681 157.88 178.166 156.87C179.409 156.378 180.755 156.068 182.153 156.016C183.551 155.964 184.975 156.145 186.347 156.585C187.719 157.026 189.013 157.725 190.152 158.605C191.291 159.485 192.223 160.546 193 161.659H186.58C186.787 161.375 186.994 161.116 187.201 160.831C187.408 160.546 187.641 160.287 187.874 160.029C188.107 159.77 188.366 159.537 188.625 159.278C188.884 159.019 189.169 158.812 189.427 158.579C190.567 157.699 191.861 157 193.233 156.56C194.605 156.119 196.055 155.938 197.453 155.99C198.851 156.042 200.197 156.352 201.439 156.844C203.925 157.854 205.97 159.666 207.186 161.841C208.403 164.015 208.766 166.526 208.17 168.675C207.601 167.717 207.031 166.863 206.384 166.138C205.737 165.413 205.038 164.818 204.287 164.326C202.837 163.368 201.258 162.85 199.783 162.747C198.307 162.643 196.935 162.902 195.822 163.472C194.709 164.041 193.802 164.869 193 166.034L189.79 170.642L186.606 166.034C185.803 164.895 184.897 164.041 183.784 163.472C182.671 162.902 181.325 162.617 179.823 162.747C178.348 162.876 176.768 163.368 175.319 164.352C174.594 164.844 173.895 165.439 173.222 166.164C172.575 166.889 171.979 167.717 171.436 168.701Z" fill="#FF9797"/>
      </g>
      <g filter="url(#filter11_f_357_1006)">
      <path d="M194.195 187.754C194.661 187.314 195.153 186.874 195.645 186.46C195.878 186.253 196.136 186.046 196.369 185.839C196.602 185.631 196.835 185.398 197.068 185.191L198.492 183.897C198.932 183.431 199.398 182.991 199.864 182.551C201.676 180.739 203.385 178.875 204.912 176.856C206.414 174.836 207.734 172.662 208.614 170.306L208.925 169.426C209.028 169.115 209.08 168.83 209.184 168.52L209.313 168.054C209.365 167.898 209.365 167.743 209.417 167.588L209.598 166.656C209.779 165.413 209.805 164.119 209.676 162.85C210.09 164.093 210.219 165.413 210.219 166.733L210.142 167.717C210.116 167.873 210.116 168.054 210.09 168.209L210.012 168.701C209.96 169.037 209.909 169.348 209.831 169.685L209.572 170.643C208.821 173.18 207.527 175.535 205.948 177.632C204.369 179.729 202.531 181.619 200.537 183.302C200.045 183.716 199.554 184.13 199.036 184.544L197.457 185.683C197.198 185.864 196.939 186.072 196.654 186.253C196.369 186.434 196.111 186.615 195.826 186.771C195.308 187.081 194.764 187.444 194.195 187.754Z" fill="white"/>
      </g>
      </g>
      <g style="mix-blend-mode:soft-light">
      <path d="M189.873 158.657C200.047 143.719 229.895 165.75 189.873 190.783C149.851 165.75 179.699 143.719 189.873 158.657Z" fill="url(#paint13_linear_357_1006)"/>
      </g>
      <g style="mix-blend-mode:soft-light">
      <path d="M189.873 158.657C179.699 143.719 149.851 165.75 189.873 190.783C229.895 165.75 200.047 143.719 189.873 158.657Z" fill="url(#paint14_linear_357_1006)"/>
      </g>
      <mask id="mask1_357_1006" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="169" y="153" width="42" height="38">
      <path d="M189.862 158.657C200.035 143.719 229.884 165.75 189.862 190.783C149.865 165.75 179.688 143.719 189.862 158.657Z" fill="url(#paint15_linear_357_1006)"/>
      </mask>
      <g mask="url(#mask1_357_1006)">
      <g filter="url(#filter12_f_357_1006)">
      <path d="M182.804 153.945C183.529 154.049 184.228 154.23 184.927 154.489C185.6 154.748 186.273 155.084 186.894 155.498C187.516 155.887 188.085 156.379 188.603 156.896C189.121 157.414 189.587 157.984 190.001 158.605H189.794C190.208 158.009 190.674 157.44 191.192 156.896C191.71 156.379 192.279 155.887 192.9 155.498C193.522 155.084 194.169 154.748 194.868 154.489C195.567 154.23 196.266 154.049 196.991 153.945C195.541 154.23 194.195 154.825 193.004 155.654C192.409 156.068 191.865 156.534 191.347 157.052C190.855 157.569 190.389 158.139 189.975 158.734L189.872 158.89L189.794 158.734C189.38 158.139 188.94 157.569 188.422 157.052C187.93 156.534 187.36 156.068 186.765 155.654C185.6 154.825 184.228 154.23 182.804 153.945Z" fill="#820010"/>
      </g>
      <g filter="url(#filter13_f_357_1006)">
      <path d="M182.804 153.945C183.529 154.049 184.228 154.23 184.927 154.489C185.6 154.748 186.273 155.084 186.894 155.498C187.516 155.887 188.085 156.379 188.603 156.896C189.121 157.414 189.587 157.984 190.001 158.605H189.794C190.208 158.009 190.674 157.44 191.192 156.896C191.71 156.379 192.279 155.887 192.9 155.498C193.522 155.084 194.169 154.748 194.868 154.489C195.567 154.23 196.266 154.049 196.991 153.945C195.541 154.23 194.195 154.825 193.004 155.654C192.409 156.068 191.865 156.534 191.347 157.052C190.855 157.569 190.389 158.139 189.975 158.734L189.872 158.89L189.794 158.734C189.38 158.139 188.94 157.569 188.422 157.052C187.93 156.534 187.36 156.068 186.765 155.654C185.6 154.825 184.228 154.23 182.804 153.945Z" fill="#820010"/>
      </g>
      <g filter="url(#filter14_f_357_1006)">
      <path d="M182.804 153.945C183.529 154.049 184.228 154.23 184.927 154.489C185.6 154.748 186.273 155.084 186.894 155.498C187.516 155.887 188.085 156.379 188.603 156.896C189.121 157.414 189.587 157.984 190.001 158.605H189.794C190.208 158.009 190.674 157.44 191.192 156.896C191.71 156.379 192.279 155.887 192.9 155.498C193.522 155.084 194.169 154.748 194.868 154.489C195.567 154.23 196.266 154.049 196.991 153.945C195.541 154.23 194.195 154.825 193.004 155.654C192.409 156.068 191.865 156.534 191.347 157.052C190.855 157.569 190.389 158.139 189.975 158.734L189.872 158.89L189.794 158.734C189.38 158.139 188.94 157.569 188.422 157.052C187.93 156.534 187.36 156.068 186.765 155.654C185.6 154.825 184.228 154.23 182.804 153.945Z" fill="#820010"/>
      </g>
      </g>
      <path d="M89.5545 142.342C99.7283 127.404 129.577 149.435 89.5545 174.468C49.5581 149.435 79.3806 127.404 89.5545 142.342Z" fill="url(#paint16_linear_357_1006)"/>
      <mask id="mask2_357_1006" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="69" y="137" width="41" height="38">
      <path d="M89.5545 142.342C99.7283 127.404 129.577 149.435 89.5545 174.468C49.5581 149.435 79.3806 127.404 89.5545 142.342Z" fill="url(#paint17_linear_357_1006)"/>
      </mask>
      <g mask="url(#mask2_357_1006)">
      <g filter="url(#filter15_f_357_1006)">
      <path d="M71.9048 152.386C71.3094 150.237 71.6718 147.726 72.8885 145.552C74.1053 143.377 76.1504 141.565 78.6356 140.555C79.8782 140.063 81.2244 139.753 82.6223 139.701C84.0202 139.649 85.4441 139.83 86.8161 140.271C88.1882 140.711 89.4825 141.41 90.6216 142.29C91.7606 143.17 92.6926 144.231 93.4692 145.344H87.0491C87.2562 145.06 87.4633 144.801 87.6704 144.516C87.8775 144.231 88.1105 143.972 88.3435 143.714C88.5764 143.455 88.8353 143.222 89.0942 142.963C89.3531 142.704 89.6378 142.497 89.8967 142.264C91.0358 141.384 92.3302 140.685 93.7022 140.245C95.0743 139.805 96.5239 139.623 97.9219 139.675C99.3198 139.727 100.666 140.038 101.909 140.529C104.394 141.539 106.439 143.351 107.656 145.526C108.872 147.7 109.235 150.211 108.639 152.36C108.07 151.402 107.5 150.548 106.853 149.823C106.206 149.098 105.507 148.503 104.756 148.011C103.307 147.053 101.727 146.535 100.252 146.432C98.7762 146.328 97.4041 146.587 96.291 147.157C95.1778 147.726 94.2717 148.555 93.4692 149.72L90.2591 154.328L87.0491 149.72C86.2466 148.58 85.3405 147.726 84.2273 147.157C83.1142 146.587 81.768 146.302 80.2665 146.432C78.7909 146.561 77.2118 147.053 75.7621 148.037C75.0372 148.529 74.3383 149.124 73.6652 149.849C73.0439 150.574 72.4484 151.402 71.9048 152.386Z" fill="#FF3E3E"/>
      </g>
      <g filter="url(#filter16_f_357_1006)">
      <path d="M85.3448 171.439C84.7752 171.103 84.2316 170.766 83.688 170.43C83.4032 170.248 83.1443 170.093 82.8596 169.912C82.6007 169.731 82.3418 169.55 82.0571 169.342L80.4779 168.203C79.9602 167.789 79.4683 167.375 78.9764 166.961C77.009 165.278 75.145 163.388 73.5659 161.291C71.9867 159.194 70.6924 156.839 69.9416 154.302L69.6827 153.344C69.6051 153.033 69.5533 152.697 69.5015 152.36L69.4239 151.868C69.398 151.713 69.398 151.532 69.3721 151.376L69.2944 150.393C69.2944 149.072 69.4498 147.752 69.8381 146.51C69.7087 147.804 69.7604 149.072 69.9157 150.315L70.097 151.247C70.1229 151.402 70.1487 151.558 70.2005 151.713L70.3299 152.179C70.4335 152.49 70.4853 152.774 70.5888 153.085L70.8995 153.965C71.7797 156.321 73.074 158.495 74.6014 160.515C76.1029 162.534 77.8374 164.398 79.6495 166.21C80.1155 166.65 80.5556 167.09 81.0215 167.556L82.4454 168.851C82.6784 169.058 82.9113 169.291 83.1443 169.498C83.3773 169.705 83.6362 169.912 83.8692 170.119C84.3869 170.559 84.8788 170.999 85.3448 171.439Z" fill="white"/>
      </g>
      <g filter="url(#filter17_f_357_1006)">
      <path d="M70.0708 147.674C70.0708 145.396 70.8215 143.041 72.2713 141.099C73.6951 139.157 75.792 137.682 78.1219 136.905C80.4776 136.129 83.1182 136.103 85.5257 136.983C86.7166 137.397 87.8556 138.044 88.8393 138.847C89.8231 139.649 90.6774 140.581 91.4022 141.617H89.2535C89.9525 140.581 90.8068 139.649 91.7905 138.847C92.7743 138.044 93.9133 137.423 95.1042 136.983C97.5117 136.129 100.152 136.129 102.508 136.905C104.864 137.682 106.935 139.157 108.385 141.099C109.834 143.041 110.585 145.396 110.585 147.674C110.507 147.39 110.43 147.131 110.352 146.846C110.274 146.587 110.171 146.302 110.067 146.043C109.86 145.526 109.627 145.008 109.368 144.516C108.825 143.558 108.177 142.678 107.427 141.901C105.899 140.374 103.984 139.313 101.964 138.847C99.9451 138.381 97.8223 138.51 95.9843 139.261C94.1204 140.012 92.5413 141.358 91.4022 143.041L90.3408 144.62L89.2794 143.041C88.1145 141.358 86.5612 139.986 84.6973 139.235C82.8334 138.484 80.7365 138.355 78.6914 138.821C76.6721 139.287 74.7565 140.348 73.2291 141.876C72.4784 142.626 71.8053 143.532 71.2875 144.49C71.0286 144.982 70.7957 145.474 70.5886 146.018C70.485 146.276 70.3815 146.535 70.3038 146.82C70.2261 147.105 70.1485 147.39 70.0708 147.674Z" fill="#700000"/>
      </g>
      <g filter="url(#filter18_f_357_1006)">
      <path d="M70.0708 147.674C70.0708 145.396 70.8215 143.041 72.2713 141.099C73.6951 139.157 75.792 137.682 78.1219 136.905C80.4776 136.129 83.1182 136.103 85.5257 136.983C86.7166 137.397 87.8556 138.044 88.8393 138.847C89.8231 139.649 90.6774 140.581 91.4022 141.617H89.2535C89.9525 140.581 90.8068 139.649 91.7905 138.847C92.7743 138.044 93.9133 137.423 95.1042 136.983C97.5117 136.129 100.152 136.129 102.508 136.905C104.864 137.682 106.935 139.157 108.385 141.099C109.834 143.041 110.585 145.396 110.585 147.674C110.507 147.39 110.43 147.131 110.352 146.846C110.274 146.587 110.171 146.302 110.067 146.043C109.86 145.526 109.627 145.008 109.368 144.516C108.825 143.558 108.177 142.678 107.427 141.901C105.899 140.374 103.984 139.313 101.964 138.847C99.9451 138.381 97.8223 138.51 95.9843 139.261C94.1204 140.012 92.5413 141.358 91.4022 143.041L90.3408 144.62L89.2794 143.041C88.1145 141.358 86.5612 139.986 84.6973 139.235C82.8334 138.484 80.7365 138.355 78.6914 138.821C76.6721 139.287 74.7565 140.348 73.2291 141.876C72.4784 142.626 71.8053 143.532 71.2875 144.49C71.0286 144.982 70.7957 145.474 70.5886 146.018C70.485 146.276 70.3815 146.535 70.3038 146.82C70.2261 147.105 70.1485 147.39 70.0708 147.674Z" fill="#700000"/>
      </g>
      <g filter="url(#filter19_f_357_1006)">
      <path d="M71.1284 152.386C70.533 150.237 70.8955 147.726 72.1122 145.552C73.3289 143.377 75.374 141.565 77.8592 140.555C79.1018 140.063 80.448 139.753 81.8459 139.701C83.2439 139.649 84.6677 139.83 86.0397 140.271C87.4118 140.711 88.7061 141.41 89.8452 142.29C90.9843 143.17 91.9162 144.231 92.6928 145.344H86.2727C86.4798 145.06 86.6869 144.801 86.894 144.516C87.1011 144.231 87.3341 143.972 87.5671 143.714C87.8001 143.455 88.059 143.222 88.3178 142.963C88.5767 142.704 88.8615 142.497 89.1203 142.264C90.2594 141.384 91.5538 140.685 92.9258 140.245C94.2979 139.805 95.7476 139.623 97.1455 139.675C98.5434 139.727 99.8896 140.038 101.132 140.529C103.617 141.539 105.663 143.351 106.879 145.526C108.096 147.7 108.458 150.211 107.863 152.36C107.293 151.402 106.724 150.548 106.077 149.823C105.43 149.098 104.731 148.503 103.98 148.011C102.53 147.053 100.951 146.535 99.4754 146.432C97.9998 146.328 96.6278 146.587 95.5146 147.157C94.4014 147.726 93.4954 148.555 92.6928 149.72L89.4828 154.328L86.2986 149.72C85.4961 148.58 84.59 147.726 83.4768 147.157C82.3637 146.587 81.0175 146.302 79.516 146.432C78.0404 146.561 76.4613 147.053 75.0116 148.037C74.2867 148.529 73.5878 149.124 72.9147 149.849C72.2675 150.574 71.6721 151.402 71.1284 152.386Z" fill="#FF9797"/>
      </g>
      <g filter="url(#filter20_f_357_1006)">
      <path d="M93.8877 171.439C94.3537 170.999 94.8455 170.559 95.3374 170.145C95.5704 169.938 95.8293 169.731 96.0623 169.524C96.2952 169.317 96.5282 169.084 96.7612 168.876L98.185 167.582C98.6251 167.116 99.0911 166.676 99.5571 166.236C101.369 164.424 103.078 162.56 104.605 160.541C106.107 158.521 107.427 156.347 108.307 153.991L108.618 153.111C108.721 152.8 108.773 152.515 108.877 152.205L109.006 151.739C109.058 151.583 109.058 151.428 109.11 151.273L109.291 150.341C109.472 149.098 109.498 147.804 109.369 146.535C109.783 147.778 109.912 149.098 109.912 150.419L109.834 151.402C109.809 151.558 109.809 151.739 109.783 151.894L109.705 152.386C109.653 152.723 109.601 153.033 109.524 153.37L109.265 154.328C108.514 156.865 107.22 159.22 105.641 161.317C104.062 163.414 102.224 165.304 100.23 166.987C99.7383 167.401 99.2464 167.815 98.7287 168.229L97.1495 169.368C96.8907 169.55 96.6318 169.757 96.347 169.938C96.0623 170.119 95.8034 170.3 95.5186 170.456C95.0009 170.766 94.4572 171.129 93.8877 171.439Z" fill="white"/>
      </g>
      </g>
      <g style="mix-blend-mode:soft-light">
      <path d="M89.5658 142.342C99.7397 127.404 129.588 149.435 89.5658 174.468C49.5436 149.435 79.392 127.404 89.5658 142.342Z" fill="url(#paint18_linear_357_1006)"/>
      </g>
      <g style="mix-blend-mode:soft-light">
      <path d="M89.5658 142.342C79.392 127.404 49.5436 149.435 89.5658 174.468C129.588 149.435 99.7397 127.404 89.5658 142.342Z" fill="url(#paint19_linear_357_1006)"/>
      </g>
      <mask id="mask3_357_1006" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="69" y="137" width="41" height="38">
      <path d="M89.5545 142.342C99.7283 127.404 129.577 149.435 89.5545 174.468C49.5581 149.435 79.3806 127.404 89.5545 142.342Z" fill="url(#paint20_linear_357_1006)"/>
      </mask>
      <g mask="url(#mask3_357_1006)">
      <g filter="url(#filter21_f_357_1006)">
      <path d="M82.4971 137.63C83.2219 137.734 83.9209 137.915 84.6199 138.174C85.2929 138.433 85.966 138.769 86.5873 139.183C87.2086 139.572 87.7781 140.064 88.2959 140.581C88.8137 141.099 89.2796 141.669 89.6938 142.29H89.4867C89.9009 141.694 90.3669 141.125 90.8847 140.581C91.4024 140.064 91.9719 139.572 92.5932 139.183C93.2146 138.769 93.8617 138.433 94.5607 138.174C95.2597 137.915 95.9586 137.734 96.6835 137.63C95.2338 137.915 93.8876 138.51 92.6968 139.339C92.1014 139.753 91.5577 140.219 91.04 140.737C90.5481 141.254 90.0821 141.824 89.6679 142.419L89.5644 142.575L89.4867 142.419C89.0725 141.824 88.6324 141.254 88.1147 140.737C87.6228 140.219 87.0533 139.753 86.4579 139.339C85.2929 138.51 83.9209 137.915 82.4971 137.63Z" fill="#820010"/>
      </g>
      <g filter="url(#filter22_f_357_1006)">
      <path d="M82.4971 137.63C83.2219 137.734 83.9209 137.915 84.6199 138.174C85.2929 138.433 85.966 138.769 86.5873 139.183C87.2086 139.572 87.7781 140.064 88.2959 140.581C88.8137 141.099 89.2796 141.669 89.6938 142.29H89.4867C89.9009 141.694 90.3669 141.125 90.8847 140.581C91.4024 140.064 91.9719 139.572 92.5932 139.183C93.2146 138.769 93.8617 138.433 94.5607 138.174C95.2597 137.915 95.9586 137.734 96.6835 137.63C95.2338 137.915 93.8876 138.51 92.6968 139.339C92.1014 139.753 91.5577 140.219 91.04 140.737C90.5481 141.254 90.0821 141.824 89.6679 142.419L89.5644 142.575L89.4867 142.419C89.0725 141.824 88.6324 141.254 88.1147 140.737C87.6228 140.219 87.0533 139.753 86.4579 139.339C85.2929 138.51 83.9209 137.915 82.4971 137.63Z" fill="#820010"/>
      </g>
      <g filter="url(#filter23_f_357_1006)">
      <path d="M82.4971 137.63C83.2219 137.734 83.9209 137.915 84.6199 138.174C85.2929 138.433 85.966 138.769 86.5873 139.183C87.2086 139.572 87.7781 140.064 88.2959 140.581C88.8137 141.099 89.2796 141.669 89.6938 142.29H89.4867C89.9009 141.694 90.3669 141.125 90.8847 140.581C91.4024 140.064 91.9719 139.572 92.5932 139.183C93.2146 138.769 93.8617 138.433 94.5607 138.174C95.2597 137.915 95.9586 137.734 96.6835 137.63C95.2338 137.915 93.8876 138.51 92.6968 139.339C92.1014 139.753 91.5577 140.219 91.04 140.737C90.5481 141.254 90.0821 141.824 89.6679 142.419L89.5644 142.575L89.4867 142.419C89.0725 141.824 88.6324 141.254 88.1147 140.737C87.6228 140.219 87.0533 139.753 86.4579 139.339C85.2929 138.51 83.9209 137.915 82.4971 137.63Z" fill="#820010"/>
      </g>
      </g>
      <path d="M184.771 65.2525C194.945 50.3153 224.794 72.3457 184.771 97.379C144.775 72.3457 174.597 50.3153 184.771 65.2525Z" fill="url(#paint21_linear_357_1006)"/>
      <mask id="mask4_357_1006" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="164" y="60" width="42" height="38">
      <path d="M184.771 65.2525C194.945 50.3153 224.794 72.3457 184.771 97.379C144.775 72.3457 174.597 50.3153 184.771 65.2525Z" fill="url(#paint22_linear_357_1006)"/>
      </mask>
      <g mask="url(#mask4_357_1006)">
      <g filter="url(#filter24_f_357_1006)">
      <path d="M167.122 75.2968C166.527 73.1481 166.889 70.637 168.106 68.4625C169.323 66.2879 171.368 64.4758 173.853 63.4662C175.095 62.9743 176.442 62.6636 177.84 62.6119C179.238 62.5601 180.661 62.7413 182.033 63.1814C183.405 63.6215 184.7 64.3205 185.839 65.2006C186.978 66.0808 187.91 67.1422 188.687 68.2554H182.266C182.473 67.9706 182.681 67.7117 182.888 67.427C183.095 67.1422 183.328 66.8833 183.561 66.6245C183.794 66.3656 184.053 66.1326 184.311 65.8737C184.57 65.6148 184.855 65.4077 185.114 65.1748C186.253 64.2946 187.547 63.5956 188.919 63.1555C190.292 62.7154 191.741 62.5342 193.139 62.586C194.537 62.6378 195.883 62.9484 197.126 63.4403C199.611 64.4499 201.656 66.262 202.873 68.4366C204.09 70.6112 204.452 73.1223 203.857 75.2709C203.287 74.3131 202.718 73.4588 202.07 72.7339C201.423 72.0091 200.724 71.4137 199.974 70.9218C198.524 69.964 196.945 69.4462 195.469 69.3427C193.993 69.2391 192.621 69.498 191.508 70.0675C190.395 70.637 189.489 71.4654 188.687 72.6304L185.476 77.2384L182.266 72.6304C181.464 71.4913 180.558 70.637 179.445 70.0675C178.331 69.498 176.985 69.2132 175.484 69.3427C174.008 69.4721 172.429 69.964 170.979 70.9477C170.254 71.4396 169.556 72.035 168.882 72.7598C168.261 73.4847 167.666 74.3131 167.122 75.2968Z" fill="#FF3E3E"/>
      </g>
      <g filter="url(#filter25_f_357_1006)">
      <path d="M180.562 94.3502C179.992 94.0137 179.448 93.6771 178.905 93.3406C178.62 93.1594 178.361 93.004 178.076 92.8228C177.817 92.6416 177.559 92.4604 177.274 92.2533L175.695 91.1143C175.177 90.7 174.685 90.2858 174.193 89.8716C172.226 88.1889 170.362 86.2991 168.783 84.2022C167.204 82.1054 165.909 79.7496 165.158 77.2126L164.9 76.2547C164.822 75.9441 164.77 75.6076 164.718 75.271L164.641 74.7792C164.615 74.6238 164.615 74.4426 164.589 74.2873L164.511 73.3036C164.511 71.9833 164.667 70.663 165.055 69.4204C164.925 70.7148 164.977 71.9833 165.133 73.2259L165.314 74.1578C165.34 74.3132 165.366 74.4685 165.417 74.6238L165.547 75.0898C165.65 75.4005 165.702 75.6852 165.806 75.9959L166.116 76.876C166.996 79.2318 168.291 81.4064 169.818 83.4256C171.32 85.4449 173.054 87.3088 174.866 89.1209C175.332 89.561 175.772 90.0011 176.238 90.4671L177.662 91.7614C177.895 91.9685 178.128 92.2015 178.361 92.4086C178.594 92.6157 178.853 92.8228 179.086 93.0299C179.604 93.47 180.096 93.9101 180.562 94.3502Z" fill="white"/>
      </g>
      <g filter="url(#filter26_f_357_1006)">
      <path d="M165.288 70.5853C165.288 68.3072 166.039 65.9514 167.489 64.0098C168.912 62.0682 171.009 60.5927 173.339 59.816C175.695 59.0394 178.335 59.0135 180.743 59.8937C181.934 60.3079 183.073 60.9551 184.057 61.7576C185.04 62.5601 185.895 63.4921 186.62 64.5276H184.471C185.17 63.4921 186.024 62.5601 187.008 61.7576C187.992 60.9551 189.131 60.3338 190.321 59.8937C192.729 59.0394 195.37 59.0394 197.725 59.816C200.081 60.5927 202.152 62.0682 203.602 64.0098C205.051 65.9514 205.802 68.3072 205.802 70.5853C205.725 70.3005 205.647 70.0416 205.569 69.7569C205.492 69.498 205.388 69.2132 205.284 68.9544C205.077 68.4366 204.844 67.9189 204.586 67.427C204.042 66.4691 203.395 65.589 202.644 64.8123C201.117 63.285 199.201 62.2236 197.182 61.7576C195.162 61.2916 193.04 61.4211 191.202 62.1718C189.338 62.9225 187.759 64.2687 186.62 65.9514L185.558 67.5305L184.497 65.9514C183.332 64.2687 181.779 62.8967 179.915 62.1459C178.051 61.3952 175.954 61.2657 173.909 61.7317C171.889 62.1977 169.974 63.2591 168.446 64.7864C167.696 65.5372 167.023 66.4433 166.505 67.4011C166.246 67.893 166.013 68.3848 165.806 68.9285C165.702 69.1873 165.599 69.4462 165.521 69.731C165.443 70.0157 165.366 70.3005 165.288 70.5853Z" fill="#700000"/>
      </g>
      <g filter="url(#filter27_f_357_1006)">
      <path d="M165.288 70.5853C165.288 68.3072 166.039 65.9514 167.489 64.0098C168.912 62.0682 171.009 60.5927 173.339 59.816C175.695 59.0394 178.335 59.0135 180.743 59.8937C181.934 60.3079 183.073 60.9551 184.057 61.7576C185.04 62.5601 185.895 63.4921 186.62 64.5276H184.471C185.17 63.4921 186.024 62.5601 187.008 61.7576C187.992 60.9551 189.131 60.3338 190.321 59.8937C192.729 59.0394 195.37 59.0394 197.725 59.816C200.081 60.5927 202.152 62.0682 203.602 64.0098C205.051 65.9514 205.802 68.3072 205.802 70.5853C205.725 70.3005 205.647 70.0416 205.569 69.7569C205.492 69.498 205.388 69.2132 205.284 68.9544C205.077 68.4366 204.844 67.9189 204.586 67.427C204.042 66.4691 203.395 65.589 202.644 64.8123C201.117 63.285 199.201 62.2236 197.182 61.7576C195.162 61.2916 193.04 61.4211 191.202 62.1718C189.338 62.9225 187.759 64.2687 186.62 65.9514L185.558 67.5305L184.497 65.9514C183.332 64.2687 181.779 62.8967 179.915 62.1459C178.051 61.3952 175.954 61.2657 173.909 61.7317C171.889 62.1977 169.974 63.2591 168.446 64.7864C167.696 65.5372 167.023 66.4433 166.505 67.4011C166.246 67.893 166.013 68.3848 165.806 68.9285C165.702 69.1873 165.599 69.4462 165.521 69.731C165.443 70.0157 165.366 70.3005 165.288 70.5853Z" fill="#700000"/>
      </g>
      <g filter="url(#filter28_f_357_1006)">
      <path d="M166.345 75.2968C165.75 73.1481 166.112 70.637 167.329 68.4625C168.546 66.2879 170.591 64.4758 173.076 63.4662C174.319 62.9743 175.665 62.6636 177.063 62.6119C178.461 62.5601 179.884 62.7413 181.257 63.1814C182.629 63.6215 183.923 64.3205 185.062 65.2006C186.201 66.0808 187.133 67.1422 187.91 68.2554H181.49C181.697 67.9706 181.904 67.7117 182.111 67.427C182.318 67.1422 182.551 66.8833 182.784 66.6245C183.017 66.3656 183.276 66.1326 183.535 65.8737C183.794 65.6148 184.078 65.4077 184.337 65.1748C185.476 64.2946 186.771 63.5956 188.143 63.1555C189.515 62.7154 190.964 62.5342 192.362 62.586C193.76 62.6378 195.106 62.9484 196.349 63.4403C198.834 64.4499 200.879 66.262 202.096 68.4366C203.313 70.6112 203.675 73.1223 203.08 75.2709C202.51 74.3131 201.941 73.4588 201.294 72.7339C200.646 72.0091 199.947 71.4137 199.197 70.9218C197.747 69.964 196.168 69.4462 194.692 69.3427C193.217 69.2391 191.845 69.498 190.731 70.0675C189.618 70.637 188.712 71.4654 187.91 72.6304L184.7 77.2384L181.515 72.6304C180.713 71.4913 179.807 70.637 178.694 70.0675C177.58 69.498 176.234 69.2132 174.733 69.3427C173.257 69.4721 171.678 69.964 170.228 70.9477C169.504 71.4396 168.805 72.035 168.131 72.7598C167.484 73.4847 166.889 74.3131 166.345 75.2968Z" fill="#FF9797"/>
      </g>
      <g filter="url(#filter29_f_357_1006)">
      <path d="M189.104 94.3502C189.57 93.9101 190.062 93.47 190.554 93.0558C190.787 92.8487 191.046 92.6416 191.279 92.4345C191.512 92.2274 191.745 91.9944 191.978 91.7873L193.402 90.4929C193.842 90.027 194.308 89.5869 194.774 89.1468C196.586 87.3346 198.295 85.4707 199.822 83.4515C201.323 81.4323 202.644 79.2577 203.524 76.9019L203.835 76.0217C203.938 75.7111 203.99 75.4263 204.093 75.1157L204.223 74.6497C204.275 74.4944 204.275 74.3391 204.326 74.1837L204.508 73.2518C204.689 72.0092 204.715 70.7148 204.585 69.4463C205 70.6889 205.129 72.0092 205.129 73.3294L205.051 74.3132C205.025 74.4685 205.025 74.6497 204.999 74.805L204.922 75.2969C204.87 75.6334 204.818 75.9441 204.741 76.2806L204.482 77.2385C203.731 79.7755 202.437 82.1312 200.857 84.2281C199.278 86.325 197.44 88.2148 195.447 89.8975C194.955 90.3117 194.463 90.7259 193.945 91.1401L192.366 92.2792C192.107 92.4604 191.849 92.6675 191.564 92.8487C191.279 93.0299 191.02 93.2111 190.735 93.3665C190.218 93.6771 189.674 94.0395 189.104 94.3502Z" fill="white"/>
      </g>
      </g>
      <g style="mix-blend-mode:soft-light">
      <path d="M184.783 65.2525C194.956 50.3153 224.805 72.3457 184.783 97.379C144.76 72.3457 174.609 50.3153 184.783 65.2525Z" fill="url(#paint23_linear_357_1006)"/>
      </g>
      <g style="mix-blend-mode:soft-light">
      <path d="M184.783 65.2525C174.609 50.3153 144.76 72.3457 184.783 97.379C224.805 72.3457 194.956 50.3153 184.783 65.2525Z" fill="url(#paint24_linear_357_1006)"/>
      </g>
      <mask id="mask5_357_1006" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="164" y="60" width="42" height="38">
      <path d="M184.771 65.2525C194.945 50.3153 224.794 72.3457 184.771 97.379C144.775 72.3457 174.597 50.3153 184.771 65.2525Z" fill="url(#paint25_linear_357_1006)"/>
      </mask>
      <g mask="url(#mask5_357_1006)">
      <g filter="url(#filter30_f_357_1006)">
      <path d="M177.714 60.541C178.439 60.6446 179.138 60.8258 179.837 61.0847C180.51 61.3435 181.183 61.6801 181.804 62.0943C182.425 62.4826 182.995 62.9745 183.513 63.4922C184.03 64.01 184.496 64.5795 184.911 65.2008H184.704C185.118 64.6054 185.584 64.0358 186.101 63.4922C186.619 62.9745 187.189 62.4826 187.81 62.0943C188.431 61.6801 189.079 61.3435 189.778 61.0847C190.476 60.8258 191.175 60.6446 191.9 60.541C190.451 60.8258 189.104 61.4212 187.914 62.2496C187.318 62.6638 186.775 63.1298 186.257 63.6475C185.765 64.1653 185.299 64.7348 184.885 65.3302L184.781 65.4856L184.704 65.3302C184.289 64.7348 183.849 64.1653 183.331 63.6475C182.84 63.1298 182.27 62.6638 181.675 62.2496C180.51 61.4212 179.138 60.8258 177.714 60.541Z" fill="#820010"/>
      </g>
      <g filter="url(#filter31_f_357_1006)">
      <path d="M177.714 60.541C178.439 60.6446 179.138 60.8258 179.837 61.0847C180.51 61.3435 181.183 61.6801 181.804 62.0943C182.425 62.4826 182.995 62.9745 183.513 63.4922C184.03 64.01 184.496 64.5795 184.911 65.2008H184.704C185.118 64.6054 185.584 64.0358 186.101 63.4922C186.619 62.9745 187.189 62.4826 187.81 62.0943C188.431 61.6801 189.079 61.3435 189.778 61.0847C190.476 60.8258 191.175 60.6446 191.9 60.541C190.451 60.8258 189.104 61.4212 187.914 62.2496C187.318 62.6638 186.775 63.1298 186.257 63.6475C185.765 64.1653 185.299 64.7348 184.885 65.3302L184.781 65.4856L184.704 65.3302C184.289 64.7348 183.849 64.1653 183.331 63.6475C182.84 63.1298 182.27 62.6638 181.675 62.2496C180.51 61.4212 179.138 60.8258 177.714 60.541Z" fill="#820010"/>
      </g>
      <g filter="url(#filter32_f_357_1006)">
      <path d="M177.714 60.541C178.439 60.6446 179.138 60.8258 179.837 61.0847C180.51 61.3435 181.183 61.6801 181.804 62.0943C182.425 62.4826 182.995 62.9745 183.513 63.4922C184.03 64.01 184.496 64.5795 184.911 65.2008H184.704C185.118 64.6054 185.584 64.0358 186.101 63.4922C186.619 62.9745 187.189 62.4826 187.81 62.0943C188.431 61.6801 189.079 61.3435 189.778 61.0847C190.476 60.8258 191.175 60.6446 191.9 60.541C190.451 60.8258 189.104 61.4212 187.914 62.2496C187.318 62.6638 186.775 63.1298 186.257 63.6475C185.765 64.1653 185.299 64.7348 184.885 65.3302L184.781 65.4856L184.704 65.3302C184.289 64.7348 183.849 64.1653 183.331 63.6475C182.84 63.1298 182.27 62.6638 181.675 62.2496C180.51 61.4212 179.138 60.8258 177.714 60.541Z" fill="#820010"/>
      </g>
      </g>
      <defs>
      <filter id="filter0_f_357_1006" x="69.5315" y="58.8836" width="145.535" height="163.833" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="4.36168" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter1_f_357_1006" x="147.292" y="94.6852" width="47.9787" height="47.9784" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="6.54252" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter2_f_357_1006" x="89.0634" y="94.6852" width="47.9787" height="47.9784" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="6.54252" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter3_f_357_1006" x="149.048" y="50.0424" width="71.5964" height="68.0469" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="7.76629" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter4_f_357_1006" x="56.5426" y="121.982" width="71.5964" height="68.0469" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="7.76629" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter5_f_357_1006" x="148.962" y="138.291" width="71.5964" height="68.0469" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="7.76629" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter6_f_357_1006" x="166.754" y="150.804" width="47.651" height="25.0159" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="2.58876" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter7_f_357_1006" x="167.013" y="160.236" width="21.2278" height="30.1072" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="1.29438" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter8_f_357_1006" x="165.2" y="147.46" width="50.8692" height="21.7069" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="2.58876" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter9_f_357_1006" x="165.2" y="147.46" width="50.8692" height="21.7069" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="2.58876" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter10_f_357_1006" x="160.8" y="145.626" width="58.006" height="35.371" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="5.17753" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter11_f_357_1006" x="191.606" y="160.262" width="21.2019" height="30.0813" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="1.29438" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter12_f_357_1006" x="181.251" y="152.392" width="17.293" height="8.0511" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="0.776629" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter13_f_357_1006" x="181.769" y="152.91" width="16.2575" height="7.01559" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="0.517753" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter14_f_357_1006" x="180.733" y="151.874" width="18.3285" height="9.0866" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="1.03551" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter15_f_357_1006" x="66.4465" y="134.489" width="47.651" height="25.0159" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="2.58876" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter16_f_357_1006" x="66.7057" y="143.921" width="21.2278" height="30.1072" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="1.29438" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter17_f_357_1006" x="64.8933" y="131.145" width="50.8692" height="21.7069" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="2.58876" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter18_f_357_1006" x="64.8933" y="131.145" width="50.8692" height="21.7069" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="2.58876" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter19_f_357_1006" x="60.4926" y="129.311" width="58.006" height="35.371" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="5.17753" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter20_f_357_1006" x="91.2989" y="143.947" width="21.2019" height="30.0813" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="1.29438" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter21_f_357_1006" x="80.9438" y="136.077" width="17.293" height="8.0511" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="0.776629" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter22_f_357_1006" x="81.4616" y="136.595" width="16.2575" height="7.01559" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="0.517753" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter23_f_357_1006" x="80.4261" y="135.559" width="18.3285" height="9.0866" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="1.03551" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter24_f_357_1006" x="161.664" y="57.3999" width="47.651" height="25.0159" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="2.58876" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter25_f_357_1006" x="161.922" y="66.8316" width="21.2278" height="30.1072" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="1.29438" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter26_f_357_1006" x="160.111" y="54.0559" width="50.8692" height="21.7069" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="2.58876" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter27_f_357_1006" x="160.111" y="54.0559" width="50.8692" height="21.7069" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="2.58876" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter28_f_357_1006" x="155.709" y="52.2223" width="58.006" height="35.371" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="5.17753" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter29_f_357_1006" x="186.516" y="66.8575" width="21.2019" height="30.0813" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="1.29438" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter30_f_357_1006" x="176.161" y="58.9878" width="17.293" height="8.0511" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="0.776629" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter31_f_357_1006" x="176.678" y="59.5055" width="16.2575" height="7.01559" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="0.517753" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <filter id="filter32_f_357_1006" x="175.643" y="58.47" width="18.3285" height="9.0866" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feGaussianBlur stdDeviation="1.03551" result="effect1_foregroundBlur_357_1006"/>
      </filter>
      <radialGradient id="paint0_radial_357_1006" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(142.251 67.6069) rotate(90) scale(146.277 127.993)">
      <stop stop-color="#66E6FF"/>
      <stop offset="1" stop-color="#33CCFF"/>
      </radialGradient>
      <radialGradient id="paint1_radial_357_1006" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(142.251 87.1814) rotate(90) scale(126.703 110.865)">
      <stop stop-color="white" stop-opacity="0.5"/>
      <stop offset="0.782278"/>
      </radialGradient>
      <radialGradient id="paint2_radial_357_1006" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(142.251 87.1814) rotate(90) scale(126.703 110.865)">
      <stop stop-color="white" stop-opacity="0.5"/>
      <stop offset="0.782278"/>
      </radialGradient>
      <radialGradient id="paint3_radial_357_1006" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(142.251 51.6742) rotate(90) scale(162.21 191.945)">
      <stop offset="0.0922635" stop-color="white"/>
      <stop offset="0.670207" stop-color="white" stop-opacity="0"/>
      </radialGradient>
      <linearGradient id="paint4_linear_357_1006" x1="142.299" y1="206.239" x2="142.5" y2="103.921" gradientUnits="userSpaceOnUse">
      <stop stop-color="#022B40" stop-opacity="0.8"/>
      <stop offset="0.166667" stop-color="#022B40" stop-opacity="0.5"/>
      <stop offset="1" stop-color="#022B40" stop-opacity="0"/>
      </linearGradient>
      <radialGradient id="paint5_radial_357_1006" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(142.136 142.042) scale(12.2403 12.7815)">
      <stop stop-color="#1C5774"/>
      <stop offset="1" stop-color="#022B40"/>
      </radialGradient>
      <linearGradient id="paint6_linear_357_1006" x1="142.136" y1="148.751" x2="142.136" y2="135.334" gradientUnits="userSpaceOnUse">
      <stop offset="0.265625" stop-color="#BEE9FF"/>
      <stop offset="1" stop-color="#6CCEFF"/>
      </linearGradient>
      <radialGradient id="paint7_radial_357_1006" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(123.84 114.558) scale(13.8232 4.08431)">
      <stop stop-color="#1C5774"/>
      <stop offset="1" stop-color="#022B40"/>
      </radialGradient>
      <linearGradient id="paint8_linear_357_1006" x1="123.855" y1="118.868" x2="123.855" y2="110.221" gradientUnits="userSpaceOnUse">
      <stop stop-color="#93DBFF"/>
      <stop offset="0.22" stop-color="#83D6FF"/>
      <stop offset="0.51" stop-color="#6CCEFF"/>
      <stop offset="0.82" stop-color="#47C2FF"/>
      <stop offset="1" stop-color="#2DB9FF"/>
      </linearGradient>
      <radialGradient id="paint9_radial_357_1006" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(160.278 114.558) scale(13.8237 4.08431)">
      <stop stop-color="#1C5774"/>
      <stop offset="1" stop-color="#022B40"/>
      </radialGradient>
      <linearGradient id="paint10_linear_357_1006" x1="160.293" y1="118.868" x2="160.293" y2="110.221" gradientUnits="userSpaceOnUse">
      <stop stop-color="#93DBFF"/>
      <stop offset="0.22" stop-color="#83D6FF"/>
      <stop offset="0.51" stop-color="#6CCEFF"/>
      <stop offset="0.82" stop-color="#47C2FF"/>
      <stop offset="1" stop-color="#2DB9FF"/>
      </linearGradient>
      <linearGradient id="paint11_linear_357_1006" x1="189.87" y1="153.801" x2="189.87" y2="190.782" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FF0000"/>
      <stop offset="1" stop-color="#610003"/>
      </linearGradient>
      <linearGradient id="paint12_linear_357_1006" x1="189.87" y1="153.801" x2="189.87" y2="190.782" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FF0000"/>
      <stop offset="1" stop-color="#610003"/>
      </linearGradient>
      <linearGradient id="paint13_linear_357_1006" x1="210.14" y1="172.292" x2="169.605" y2="172.292" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FF8F00"/>
      <stop offset="0.0143476" stop-color="#FF9001" stop-opacity="0.9857"/>
      <stop offset="0.2987" stop-color="#FF9912" stop-opacity="0.7013"/>
      <stop offset="0.6103" stop-color="#FF9F1C" stop-opacity="0.3897"/>
      <stop offset="1" stop-color="#FFA11F" stop-opacity="0"/>
      </linearGradient>
      <linearGradient id="paint14_linear_357_1006" x1="169.616" y1="172.292" x2="210.151" y2="172.292" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FF8F00"/>
      <stop offset="0.0143476" stop-color="#FF9001" stop-opacity="0.9857"/>
      <stop offset="0.2987" stop-color="#FF9912" stop-opacity="0.7013"/>
      <stop offset="0.6103" stop-color="#FF9F1C" stop-opacity="0.3897"/>
      <stop offset="1" stop-color="#FFA11F" stop-opacity="0"/>
      </linearGradient>
      <linearGradient id="paint15_linear_357_1006" x1="189.87" y1="153.801" x2="189.87" y2="190.782" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FF0000"/>
      <stop offset="1" stop-color="#610003"/>
      </linearGradient>
      <linearGradient id="paint16_linear_357_1006" x1="89.5629" y1="137.486" x2="89.5629" y2="174.467" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FF0000"/>
      <stop offset="1" stop-color="#610003"/>
      </linearGradient>
      <linearGradient id="paint17_linear_357_1006" x1="89.5629" y1="137.486" x2="89.5629" y2="174.467" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FF0000"/>
      <stop offset="1" stop-color="#610003"/>
      </linearGradient>
      <linearGradient id="paint18_linear_357_1006" x1="109.833" y1="155.977" x2="69.2983" y2="155.977" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FF8F00"/>
      <stop offset="0.0143476" stop-color="#FF9001" stop-opacity="0.9857"/>
      <stop offset="0.2987" stop-color="#FF9912" stop-opacity="0.7013"/>
      <stop offset="0.6103" stop-color="#FF9F1C" stop-opacity="0.3897"/>
      <stop offset="1" stop-color="#FFA11F" stop-opacity="0"/>
      </linearGradient>
      <linearGradient id="paint19_linear_357_1006" x1="69.3093" y1="155.977" x2="109.844" y2="155.977" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FF8F00"/>
      <stop offset="0.0143476" stop-color="#FF9001" stop-opacity="0.9857"/>
      <stop offset="0.2987" stop-color="#FF9912" stop-opacity="0.7013"/>
      <stop offset="0.6103" stop-color="#FF9F1C" stop-opacity="0.3897"/>
      <stop offset="1" stop-color="#FFA11F" stop-opacity="0"/>
      </linearGradient>
      <linearGradient id="paint20_linear_357_1006" x1="89.5629" y1="137.486" x2="89.5629" y2="174.467" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FF0000"/>
      <stop offset="1" stop-color="#610003"/>
      </linearGradient>
      <linearGradient id="paint21_linear_357_1006" x1="184.78" y1="60.3966" x2="184.78" y2="97.3783" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FF0000"/>
      <stop offset="1" stop-color="#610003"/>
      </linearGradient>
      <linearGradient id="paint22_linear_357_1006" x1="184.78" y1="60.3966" x2="184.78" y2="97.3783" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FF0000"/>
      <stop offset="1" stop-color="#610003"/>
      </linearGradient>
      <linearGradient id="paint23_linear_357_1006" x1="205.049" y1="78.8875" x2="164.515" y2="78.8875" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FF8F00"/>
      <stop offset="0.0143476" stop-color="#FF9001" stop-opacity="0.9857"/>
      <stop offset="0.2987" stop-color="#FF9912" stop-opacity="0.7013"/>
      <stop offset="0.6103" stop-color="#FF9F1C" stop-opacity="0.3897"/>
      <stop offset="1" stop-color="#FFA11F" stop-opacity="0"/>
      </linearGradient>
      <linearGradient id="paint24_linear_357_1006" x1="164.526" y1="78.8875" x2="205.06" y2="78.8875" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FF8F00"/>
      <stop offset="0.0143476" stop-color="#FF9001" stop-opacity="0.9857"/>
      <stop offset="0.2987" stop-color="#FF9912" stop-opacity="0.7013"/>
      <stop offset="0.6103" stop-color="#FF9F1C" stop-opacity="0.3897"/>
      <stop offset="1" stop-color="#FFA11F" stop-opacity="0"/>
      </linearGradient>
      <linearGradient id="paint25_linear_357_1006" x1="184.78" y1="60.3966" x2="184.78" y2="97.3783" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FF0000"/>
      <stop offset="1" stop-color="#610003"/>
      </linearGradient>
      </defs>
    </svg>
  `,
  'category-advertising': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M2.66732 8.74342L3.71708 12.9425C3.7466 13.0606 3.76136 13.1196 3.77883 13.1712C3.94943 13.6748 4.403 14.029 4.933 14.0724C4.98725 14.0768 5.04812 14.0768 5.16984 14.0768C5.32228 14.0768 5.3985 14.0768 5.4627 14.0706C6.09732 14.009 6.59954 13.5068 6.66109 12.8722C6.66732 12.808 6.66732 12.7317 6.66732 12.5793V3.07676M12.334 8.41009C13.6227 8.41009 14.6673 7.36542 14.6673 6.07676C14.6673 4.7881 13.6227 3.74343 12.334 3.74343M6.83398 3.07676H4.33398C2.67713 3.07676 1.33398 4.41991 1.33398 6.07676C1.33398 7.73362 2.67713 9.07676 4.33398 9.07676H6.83398C8.01158 9.07676 9.45212 9.70802 10.5635 10.3139C11.2119 10.6673 11.536 10.844 11.7484 10.818C11.9452 10.7939 12.0941 10.7055 12.2095 10.5442C12.334 10.3702 12.334 10.0221 12.334 9.32589V2.82762C12.334 2.13143 12.334 1.78333 12.2095 1.60936C12.0941 1.44803 11.9452 1.35963 11.7484 1.33552C11.536 1.30951 11.2119 1.48623 10.5635 1.83967C9.45212 2.4455 8.01158 3.07676 6.83398 3.07676Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'category-site_analytics': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M14 14H3.06667C2.6933 14 2.50661 14 2.36401 13.9273C2.23857 13.8634 2.13658 13.7615 2.07266 13.636C2 13.4934 2 13.3067 2 12.9333V2M14 4.66667L10.3771 8.28953C10.2451 8.42153 10.1791 8.48753 10.103 8.51227C10.0361 8.53407 9.96393 8.53407 9.897 8.51227C9.82087 8.48753 9.75487 8.42153 9.62287 8.28953L8.37713 7.0438C8.24513 6.9118 8.17913 6.8458 8.103 6.82107C8.03607 6.79927 7.96393 6.79927 7.897 6.82107C7.82087 6.8458 7.75487 6.9118 7.62287 7.0438L4.66667 10M14 4.66667H11.3333M14 4.66667V7.33333" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'category-consent': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M9.33268 1.51294V4.26663C9.33268 4.64 9.33268 4.82669 9.40535 4.96929C9.46928 5.09473 9.57122 5.19672 9.69668 5.26064C9.83928 5.3333 10.0259 5.3333 10.3993 5.3333H13.153M5.99935 10.6666L7.33268 11.9999L10.3327 8.99992M9.33268 1.33325H5.86602C4.74591 1.33325 4.18586 1.33325 3.75804 1.55124C3.38171 1.74299 3.07575 2.04895 2.884 2.42527C2.66602 2.85309 2.66602 3.41315 2.66602 4.53325V11.4666C2.66602 12.5867 2.66602 13.1467 2.884 13.5746C3.07575 13.9509 3.38171 14.2569 3.75804 14.4486C4.18586 14.6666 4.74591 14.6666 5.86602 14.6666H10.1327C11.2528 14.6666 11.8128 14.6666 12.2407 14.4486C12.617 14.2569 12.9229 13.9509 13.1147 13.5746C13.3327 13.1467 13.3327 12.5867 13.3327 11.4666V5.33325L9.33268 1.33325Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'category-essential': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M9.33268 7.33301H5.33268M6.66602 9.99967H5.33268M10.666 4.66634H5.33268M13.3327 4.53301V11.4663C13.3327 12.5865 13.3327 13.1465 13.1147 13.5743C12.9229 13.9507 12.617 14.2566 12.2407 14.4483C11.8128 14.6663 11.2528 14.6663 10.1327 14.6663H5.86602C4.74591 14.6663 4.18586 14.6663 3.75804 14.4483C3.38171 14.2566 3.07575 13.9507 2.884 13.5743C2.66602 13.1465 2.66602 12.5865 2.66602 11.4663V4.53301C2.66602 3.4129 2.66602 2.85285 2.884 2.42503C3.07575 2.0487 3.38171 1.74274 3.75804 1.55099C4.18586 1.33301 4.74591 1.33301 5.86602 1.33301H10.1327C11.2528 1.33301 11.8128 1.33301 12.2407 1.55099C12.617 1.74274 12.9229 2.0487 13.1147 2.42503C13.3327 2.85285 13.3327 3.4129 13.3327 4.53301Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'category-utilities': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M9.33268 7.33301H5.33268M6.66602 9.99967H5.33268M10.666 4.66634H5.33268M13.3327 4.53301V11.4663C13.3327 12.5865 13.3327 13.1465 13.1147 13.5743C12.9229 13.9507 12.617 14.2566 12.2407 14.4483C11.8128 14.6663 11.2528 14.6663 10.1327 14.6663H5.86602C4.74591 14.6663 4.18586 14.6663 3.75804 14.4483C3.38171 14.2566 3.07575 13.9507 2.884 13.5743C2.66602 13.1465 2.66602 12.5865 2.66602 11.4663V4.53301C2.66602 3.4129 2.66602 2.85285 2.884 2.42503C3.07575 2.0487 3.38171 1.74274 3.75804 1.55099C4.18586 1.33301 4.74591 1.33301 5.86602 1.33301H10.1327C11.2528 1.33301 11.8128 1.33301 12.2407 1.55099C12.617 1.74274 12.9229 2.0487 13.1147 2.42503C13.3327 2.85285 13.3327 3.4129 13.3327 4.53301Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'category-hosting': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M4.00065 3.99992H4.00732M4.00065 11.9999H4.00732M3.46732 6.66658H12.534C13.2807 6.66658 13.6541 6.66659 13.9393 6.52126C14.1902 6.39343 14.3942 6.18946 14.522 5.93857C14.6673 5.65336 14.6673 5.27999 14.6673 4.53325V3.46659C14.6673 2.71985 14.6673 2.34648 14.522 2.06127C14.3942 1.81038 14.1902 1.60641 13.9393 1.47858C13.6541 1.33325 13.2807 1.33325 12.534 1.33325H3.46732C2.72058 1.33325 2.34721 1.33325 2.062 1.47858C1.81111 1.60641 1.60714 1.81038 1.47931 2.06127C1.33398 2.34648 1.33398 2.71985 1.33398 3.46659V4.53325C1.33398 5.27999 1.33398 5.65336 1.47931 5.93857C1.60714 6.18946 1.81111 6.39343 2.062 6.52126C2.34721 6.66659 2.72058 6.66658 3.46732 6.66658ZM3.46732 14.6666H12.534C13.2807 14.6666 13.6541 14.6666 13.9393 14.5213C14.1902 14.3935 14.3942 14.1895 14.522 13.9386C14.6673 13.6534 14.6673 13.28 14.6673 12.5333V11.4666C14.6673 10.7199 14.6673 10.3465 14.522 10.0613C14.3942 9.81038 14.1902 9.60639 13.9393 9.47859C13.6541 9.33325 13.2807 9.33325 12.534 9.33325H3.46732C2.72058 9.33325 2.34721 9.33325 2.062 9.47859C1.81111 9.60639 1.60714 9.81038 1.47931 10.0613C1.33398 10.3465 1.33398 10.7199 1.33398 11.4666V12.5333C1.33398 13.28 1.33398 13.6534 1.47931 13.9386C1.60714 14.1895 1.81111 14.3935 2.062 14.5213C2.34721 14.6666 2.72058 14.6666 3.46732 14.6666Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'category-customer_interaction': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M6.00065 2.33301V1.33301M3.37442 3.37345L2.66732 2.66634M3.37442 8.66634L2.66732 9.37347M8.66732 3.37345L9.37445 2.66634M2.33398 5.99967H1.33398M10.577 10.7927L8.91578 13.8777C8.72605 14.2301 8.63112 14.4063 8.51698 14.4509C8.41792 14.4896 8.30632 14.4787 8.21665 14.4215C8.11325 14.3557 8.05438 14.1644 7.93652 13.7819L5.63078 6.29651C5.53452 5.98401 5.48638 5.82776 5.52511 5.72223C5.55884 5.63031 5.63128 5.55787 5.7232 5.52414C5.82874 5.48541 5.98498 5.53354 6.29748 5.6298L13.7828 7.93554C14.1653 8.05341 14.3566 8.11234 14.4225 8.21567C14.4797 8.30541 14.4905 8.41694 14.4519 8.51601C14.4073 8.63021 14.231 8.72507 13.8786 8.91487L10.7937 10.576C10.7413 10.6042 10.7151 10.6183 10.6923 10.6364C10.6719 10.6525 10.6535 10.6709 10.6374 10.6913C10.6193 10.7141 10.6052 10.7403 10.577 10.7927Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'category-unidentified': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M8.66732 4.66667L7.92365 3.17928C7.70958 2.7512 7.60258 2.53715 7.44292 2.38077C7.30172 2.24249 7.13152 2.13731 6.94472 2.07287C6.73345 2 6.49412 2 6.01551 2H3.46732C2.72058 2 2.34721 2 2.062 2.14533C1.81111 2.27315 1.60714 2.47713 1.47931 2.72801C1.33398 3.01323 1.33398 3.3866 1.33398 4.13333V4.66667M6.56738 7.8348C6.68485 7.50093 6.91672 7.21933 7.22185 7.04C7.52705 6.8606 7.88585 6.79507 8.23472 6.85493C8.58358 6.91473 8.90005 7.09613 9.12798 7.36693C9.35598 7.63773 9.48072 7.98047 9.48018 8.33447C9.48018 9.33373 7.98132 9.83333 7.98132 9.83333M8.00065 11.8333H8.00732M1.33398 4.66667H11.4673C12.5875 4.66667 13.1475 4.66667 13.5753 4.88465C13.9516 5.0764 14.2576 5.38236 14.4493 5.75869C14.6673 6.18651 14.6673 6.74653 14.6673 7.86667V10.8C14.6673 11.9201 14.6673 12.4801 14.4493 12.908C14.2576 13.2843 13.9516 13.5903 13.5753 13.782C13.1475 14 12.5875 14 11.4673 14H4.53398C3.41388 14 2.85382 14 2.426 13.782C2.04968 13.5903 1.74372 13.2843 1.55197 12.908C1.33398 12.4801 1.33398 11.9201 1.33398 10.8V4.66667Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'category-audio_video_player': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M6.33398 5.97691C6.33398 5.65872 6.33398 5.49963 6.40048 5.41081C6.45842 5.3334 6.54712 5.28498 6.64357 5.27809C6.75425 5.27019 6.88805 5.35621 7.15572 5.52828L10.3028 7.55142C10.5351 7.70069 10.6512 7.77535 10.6913 7.87029C10.7263 7.95322 10.7263 8.04682 10.6913 8.12975C10.6512 8.22469 10.5351 8.29935 10.3028 8.44862L7.15572 10.4718C6.88805 10.6438 6.75425 10.7299 6.64357 10.722C6.54712 10.7151 6.45842 10.6666 6.40048 10.5892C6.33398 10.5004 6.33398 10.3414 6.33398 10.0232V5.97691Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M1 5.2C1 4.07989 1 3.51984 1.25432 3.09202C1.47802 2.71569 1.83498 2.40973 2.27402 2.21799C2.77315 2 3.42654 2 4.73333 2H11.2667C12.5735 2 13.2268 2 13.726 2.21799C14.1651 2.40973 14.522 2.71569 14.7457 3.09202C15 3.51984 15 4.07989 15 5.2V10.8C15 11.9201 15 12.4801 14.7457 12.908C14.522 13.2843 14.1651 13.5903 13.726 13.782C13.2268 14 12.5735 14 11.2667 14H4.73333C3.42654 14 2.77315 14 2.27402 13.782C1.83498 13.5903 1.47802 13.2843 1.25432 12.908C1 12.4801 1 11.9201 1 10.8V5.2Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'category-cdn': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M8.00065 1.33325C9.66818 3.15882 10.6159 5.52794 10.6673 7.99992C10.6159 10.4719 9.66818 12.841 8.00065 14.6666M8.00065 1.33325C6.33313 3.15882 5.38548 5.52794 5.33398 7.99992C5.38548 10.4719 6.33313 12.841 8.00065 14.6666M8.00065 1.33325C4.31875 1.33325 1.33398 4.31802 1.33398 7.99992C1.33398 11.6818 4.31875 14.6666 8.00065 14.6666M8.00065 1.33325C11.6825 1.33325 14.6673 4.31802 14.6673 7.99992C14.6673 11.6818 11.6825 14.6666 8.00065 14.6666M1.66733 5.99992H14.334M1.66732 9.99992H14.334" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'category-comments': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M4.06356 7.48578C4.02212 7.21872 4.00062 6.94518 4.00062 6.66658C4.00062 3.72107 6.40415 1.33325 9.36905 1.33325C12.3339 1.33325 14.7375 3.72107 14.7375 6.66658C14.7375 7.33198 14.6148 7.96892 14.3908 8.55625C14.3442 8.67825 14.3209 8.73925 14.3104 8.78685C14.2999 8.83405 14.2958 8.86725 14.2947 8.91558C14.2936 8.96432 14.3002 9.01805 14.3135 9.12545L14.5818 11.3056C14.6109 11.5416 14.6254 11.6596 14.5861 11.7454C14.5517 11.8206 14.4906 11.8803 14.4147 11.9129C14.328 11.9502 14.2104 11.9329 13.9751 11.8985L11.8517 11.5872C11.7407 11.5709 11.6853 11.5628 11.6348 11.5631C11.5849 11.5634 11.5503 11.5671 11.5014 11.5773C11.452 11.5877 11.3889 11.6114 11.2627 11.6587C10.6738 11.8793 10.0356 11.9999 9.36905 11.9999C9.09025 11.9999 8.81645 11.9788 8.54912 11.9381M5.08837 14.6666C7.06498 14.6666 8.66732 13.025 8.66732 10.9999C8.66732 8.97485 7.06498 7.33325 5.08837 7.33325C3.11177 7.33325 1.50942 8.97485 1.50942 10.9999C1.50942 11.407 1.57417 11.7985 1.69368 12.1644C1.7442 12.3191 1.76946 12.3964 1.77776 12.4492C1.78641 12.5044 1.78792 12.5353 1.7847 12.5911C1.78162 12.6445 1.76826 12.7048 1.74154 12.8255L1.33398 14.6666L3.33052 14.3939C3.4395 14.3791 3.49398 14.3716 3.54156 14.3719C3.59166 14.3723 3.61826 14.375 3.66739 14.3848C3.71405 14.3941 3.78342 14.4185 3.92216 14.4675C4.28771 14.5965 4.68006 14.6666 5.08837 14.6666Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'category-email': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M14.334 12.0001L9.90538 8.00008M6.09589 8.00008L1.66734 12.0001M1.33398 4.66675L6.77725 8.47701C7.21805 8.78561 7.43845 8.93988 7.67818 8.99961C7.88992 9.05241 8.11138 9.05241 8.32312 8.99961C8.56285 8.93988 8.78325 8.78561 9.22405 8.47701L14.6673 4.66675M4.53398 13.3334H11.4673C12.5875 13.3334 13.1475 13.3334 13.5753 13.1154C13.9516 12.9237 14.2576 12.6177 14.4493 12.2414C14.6673 11.8135 14.6673 11.2535 14.6673 10.1334V5.86675C14.6673 4.74664 14.6673 4.18659 14.4493 3.75877C14.2576 3.38244 13.9516 3.07648 13.5753 2.88473C13.1475 2.66675 12.5875 2.66675 11.4673 2.66675H4.53398C3.41388 2.66675 2.85382 2.66675 2.426 2.88473C2.04968 3.07648 1.74372 3.38244 1.55197 3.75877C1.33398 4.18659 1.33398 4.74664 1.33398 5.86675V10.1334C1.33398 11.2535 1.33398 11.8135 1.55197 12.2414C1.74372 12.6177 2.04968 12.9237 2.426 13.1154C2.85382 13.3334 3.41388 13.3334 4.53398 13.3334Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'category-extensions': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M5.00065 3.00004C5.00065 2.07957 5.74684 1.33337 6.66732 1.33337C7.58778 1.33337 8.33398 2.07957 8.33398 3.00004V4.00004H9.00065C9.93252 4.00004 10.3985 4.00004 10.7661 4.15228C11.2561 4.35527 11.6455 4.74462 11.8484 5.23467C12.0007 5.60221 12.0007 6.06816 12.0007 7.00004H13.0007C13.9211 7.00004 14.6673 7.74624 14.6673 8.66671C14.6673 9.58717 13.9211 10.3334 13.0007 10.3334H12.0007V11.4667C12.0007 12.5868 12.0007 13.1468 11.7827 13.5747C11.5909 13.951 11.285 14.257 10.9087 14.4487C10.4808 14.6667 9.92078 14.6667 8.80065 14.6667H8.33398V13.5C8.33398 12.6716 7.66238 12 6.83398 12C6.00556 12 5.33398 12.6716 5.33398 13.5V14.6667H4.53398C3.41388 14.6667 2.85382 14.6667 2.426 14.4487C2.04968 14.257 1.74372 13.951 1.55197 13.5747C1.33398 13.1468 1.33398 12.5868 1.33398 11.4667V10.3334H2.33398C3.25446 10.3334 4.00065 9.58717 4.00065 8.66671C4.00065 7.74624 3.25446 7.00004 2.33398 7.00004H1.33398C1.33398 6.06816 1.33398 5.60221 1.48622 5.23467C1.68921 4.74462 2.07856 4.35527 2.56862 4.15228C2.93616 4.00004 3.4021 4.00004 4.33398 4.00004H5.00065V3.00004Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'category-misc': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M5 8H5.00667M8 8H8.00667M11 8H11.0067M5.33333 8C5.33333 8.18407 5.18409 8.33333 5 8.33333C4.81591 8.33333 4.66667 8.18407 4.66667 8C4.66667 7.81593 4.81591 7.66667 5 7.66667C5.18409 7.66667 5.33333 7.81593 5.33333 8ZM8.33333 8C8.33333 8.18407 8.18407 8.33333 8 8.33333C7.81593 8.33333 7.66667 8.18407 7.66667 8C7.66667 7.81593 7.81593 7.66667 8 7.66667C8.18407 7.66667 8.33333 7.81593 8.33333 8ZM11.3333 8C11.3333 8.18407 11.1841 8.33333 11 8.33333C10.8159 8.33333 10.6667 8.18407 10.6667 8C10.6667 7.81593 10.8159 7.66667 11 7.66667C11.1841 7.66667 11.3333 7.81593 11.3333 8ZM14 8C14 11.3137 11.3137 14 8 14C4.68629 14 2 11.3137 2 8C2 4.68629 4.68629 2 8 2C11.3137 2 14 4.68629 14 8Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'category-pornvertising': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M1.33398 6.2V9.8C1.33398 10.9201 1.33398 11.4801 1.55197 11.908C1.74372 12.2843 2.04968 12.5903 2.426 12.782C2.85382 13 3.41388 13 4.53398 13H11.4673C12.5875 13 13.1474 13 13.5753 12.782C13.9516 12.5903 14.2576 12.2843 14.4493 11.908C14.6673 11.4801 14.6673 10.9201 14.6673 9.8V6.2C14.6673 5.07989 14.6673 4.51985 14.4493 4.09202C14.2576 3.71569 13.9516 3.40973 13.5753 3.21799C13.1474 3 12.5875 3 11.4673 3H4.53398C3.41388 3 2.85382 3 2.426 3.21799C2.04968 3.40973 1.74372 3.71569 1.55197 4.09202C1.33398 4.51984 1.33398 5.07989 1.33398 6.2Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M3.5 7L5.3 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M7.10156 7L8.90156 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M10.6992 7L12.4992 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M5.30078 7L3.50078 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M8.89844 7L7.09844 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M12.5 7L10.7 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'category-social_media': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M5.66667 8.33333C5.66667 8.33333 6.54167 9.33333 8 9.33333C9.45833 9.33333 10.3333 8.33333 10.3333 8.33333M9.83333 5H9.84M6.16667 5H6.17333M4.66667 12V13.557C4.66667 13.9123 4.66667 14.0899 4.73949 14.1811C4.80281 14.2604 4.89885 14.3066 5.00036 14.3065C5.11709 14.3063 5.25578 14.1954 5.53317 13.9735L7.12347 12.7012C7.44833 12.4413 7.6108 12.3114 7.79167 12.219C7.95213 12.137 8.12293 12.0771 8.29947 12.0409C8.49847 12 8.70647 12 9.12247 12H10.8C11.9201 12 12.4801 12 12.908 11.782C13.2843 11.5903 13.5903 11.2843 13.782 10.908C14 10.4801 14 9.92013 14 8.8V5.2C14 4.07989 14 3.51984 13.782 3.09202C13.5903 2.71569 13.2843 2.40973 12.908 2.21799C12.4801 2 11.9201 2 10.8 2H5.2C4.07989 2 3.51984 2 3.09202 2.21799C2.71569 2.40973 2.40973 2.71569 2.21799 3.09202C2 3.51984 2 4.07989 2 5.2V9.33333C2 9.95333 2 10.2633 2.06815 10.5177C2.25308 11.2078 2.79218 11.7469 3.48236 11.9319C3.73669 12 4.04669 12 4.66667 12ZM10.1667 5C10.1667 5.18409 10.0174 5.33333 9.83333 5.33333C9.64927 5.33333 9.5 5.18409 9.5 5C9.5 4.81591 9.64927 4.66667 9.83333 4.66667C10.0174 4.66667 10.1667 4.81591 10.1667 5ZM6.5 5C6.5 5.18409 6.35076 5.33333 6.16667 5.33333C5.98257 5.33333 5.83333 5.18409 5.83333 5C5.83333 4.81591 5.98257 4.66667 6.16667 4.66667C6.35076 4.66667 6.5 4.81591 6.5 5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'category-telemetry': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <circle cx="8.00065" cy="8.00004" r="6.66667" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M1.66602 8.66667H4.66602L5.99935 7L7.99935 11L10.3327 5L11.9993 8.66667H14.3327" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'category-organization': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M8.66536 7.33333H11.8654C12.6121 7.33333 12.9855 7.33333 13.2707 7.47867C13.5216 7.60647 13.7256 7.81047 13.8534 8.06133C13.9987 8.34653 13.9987 8.71993 13.9987 9.46667V14M8.66536 14V4.13333C8.66536 3.3866 8.66536 3.01323 8.52003 2.72801C8.39223 2.47713 8.18823 2.27315 7.93736 2.14533C7.65216 2 7.27876 2 6.53203 2H4.13203C3.3853 2 3.01192 2 2.72671 2.14533C2.47582 2.27315 2.27185 2.47713 2.14402 2.72801C1.9987 3.01323 1.9987 3.3866 1.9987 4.13333V14M14.6654 14H1.33203M4.33203 4.66667H6.33203M4.33203 7.33333H6.33203M4.33203 10H6.33203" stroke="currentColor" stroke-width="1.33333" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'contributor' : /* html */`
    <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
      <g clip-path="url(#clip0_6704_38737)">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M16.0677 0.666759C16.542 0.668312 17.0158 0.834527 17.3979 1.1654L20.4135 3.77947C20.5624 3.83074 20.7102 3.88458 20.8567 3.94092L24.8347 3.86836C25.3468 3.85904 25.8226 4.04027 26.1897 4.34991C26.5522 4.65593 26.8093 5.08879 26.889 5.58795L27.5208 9.54237C27.5975 9.66997 27.672 9.79895 27.7445 9.92928L30.8473 12.4375C31.2455 12.7596 31.4941 13.2043 31.5753 13.6776L31.5732 13.678C31.6544 14.1455 31.573 14.6413 31.3132 15.0746L29.2567 18.5072C29.233 18.6574 29.2069 18.8067 29.1782 18.9551L29.9417 22.8665C30.0399 23.3683 29.9444 23.868 29.7037 24.2835L29.705 24.2843C29.4663 24.6944 29.0852 25.0221 28.6078 25.1873L24.8207 26.4971C24.7099 26.5933 24.5976 26.6878 24.4837 26.7804L22.5501 30.2753C22.3021 30.7232 21.907 31.0447 21.4555 31.2078L21.4518 31.2073C21.0055 31.3683 20.5032 31.3746 20.031 31.1938L16.2966 29.7658C16.2193 29.7671 16.1418 29.7678 16.0642 29.7678C15.9891 29.7678 15.9141 29.7671 15.8392 29.7659L12.1202 31.1969C11.6428 31.3807 11.1333 31.3735 10.6823 31.2078L10.683 31.206C10.2392 31.042 9.85172 30.724 9.60695 30.2835L7.67067 26.8013C7.54612 26.7006 7.42342 26.5976 7.30262 26.4926L3.54036 25.2008C3.05628 25.0346 2.67107 24.7017 2.43237 24.2844C2.19677 23.8727 2.10288 23.3791 2.19867 22.8831L2.95345 18.9718C2.92251 18.8124 2.89441 18.6521 2.86919 18.4907L0.82375 15.0922C0.559725 14.6537 0.478413 14.151 0.563773 13.6778C0.647655 13.2113 0.892333 12.773 1.2843 12.454L4.37589 9.94379C4.45557 9.80008 4.53784 9.65799 4.62261 9.51759L5.23947 5.60093C5.31914 5.09594 5.57977 4.65868 5.94851 4.35114C6.31252 4.04719 6.78208 3.86888 7.28744 3.87716L11.2701 3.94155C11.4203 3.88376 11.5718 3.82861 11.7246 3.77615L14.7193 1.16852C15.1055 0.832466 15.5872 0.665205 16.0677 0.666759Z" fill="#00AEF0"/>
        <circle cx="16.0013" cy="16.0001" r="13.3333" fill="#008FC5"/>
        <circle cx="16.0013" cy="16.0001" r="11.3333" fill="#45CCFF"/>
        <circle cx="16.0013" cy="16.0001" r="9.33333" fill="#00AEF0"/>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M21.023 19.4625C20.5178 18.3182 20.4307 17.3486 20.4172 16.9676V13.8331C20.4172 11.4386 18.4366 9.49756 15.9935 9.49756C13.5501 9.49756 11.5694 11.4386 11.5694 13.8331V17.0129C11.5505 17.4228 11.4513 18.3627 10.9655 19.4625C10.3126 20.9403 10.8529 20.7642 11.3369 20.6426C11.8208 20.5215 12.9016 20.0469 13.2392 20.6316C13.5767 21.216 13.8582 21.7235 14.6461 21.3926C15.4341 21.0618 15.8053 20.9515 15.9178 20.9515H16.0709C16.1832 20.9515 16.5547 21.0618 17.3425 21.3926C18.1304 21.7235 18.4118 21.216 18.7495 20.6316C19.087 20.0469 20.1677 20.5215 20.6517 20.6426C21.1357 20.7642 21.6758 20.9403 21.023 19.4625ZM14.6328 11.8617C15.1095 11.8617 15.496 12.461 15.496 13.2005C15.496 13.94 15.1095 14.5395 14.6328 14.5395C14.1561 14.5395 13.7695 13.94 13.7695 13.2005C13.7695 12.461 14.1561 11.8617 14.6328 11.8617ZM15.9893 17.2103C14.9393 17.2103 14.0554 16.1976 13.7891 15.0707C14.3035 15.7638 15.0975 16.2092 15.9893 16.2092C16.881 16.2092 17.675 15.7638 18.1895 15.0707C17.9231 16.1976 17.0391 17.2103 15.9893 17.2103ZM17.3595 14.5395C16.8824 14.5395 16.4961 13.94 16.4961 13.2005C16.4961 12.461 16.8824 11.8617 17.3595 11.8617C17.8365 11.8617 18.2227 12.461 18.2227 13.2005C18.2227 13.94 17.8365 14.5395 17.3595 14.5395Z" fill="white"/>
      </g>
      <defs>
        <clipPath id="clip0_6704_38737">
          <rect width="32" height="32" fill="white"/>
        </clipPath>
      </defs>
    </svg>
  `,
  'chart': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M8.00065 1.33325C8.87612 1.33325 9.74305 1.50569 10.5519 1.84073C11.3607 2.17575 12.0957 2.66682 12.7147 3.28587C13.3338 3.90493 13.8249 4.63986 14.1599 5.4487C14.4949 6.25754 14.6673 7.12445 14.6673 7.99992M8.00065 1.33325V7.99992M8.00065 1.33325C4.31875 1.33325 1.33398 4.31802 1.33398 7.99992C1.33398 11.6818 4.31875 14.6666 8.00065 14.6666C11.6825 14.6666 14.6673 11.6819 14.6673 7.99992M8.00065 1.33325C11.6825 1.33325 14.6673 4.31803 14.6673 7.99992M14.6673 7.99992H8.00065M14.6673 7.99992C14.6673 9.05198 14.4183 10.0891 13.9407 11.0265C13.4631 11.9639 12.7704 12.775 11.9192 13.3934L8.00065 7.99992" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'check': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M13.3337 4L6.00033 11.3333L2.66699 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'chevron-right': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M9 18L15 12L9 6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'chevron-right-s': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M7 12L11 8L7 4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'chevron-left': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M15 18L9 12L15 6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'chevron-left-s': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M9 12L5 8L9 4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'chevron-down': /* html */`
    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path fill-rule="evenodd" clip-rule="evenodd" d="M6.10651 8.78147C6.24852 8.65129 6.47876 8.65129 6.62077 8.78147L10 11.8791L13.3792 8.78147C13.5212 8.65129 13.7515 8.65129 13.8935 8.78147C14.0355 8.91164 14.0355 9.1227 13.8935 9.25287L10.2571 12.5862C10.1151 12.7164 9.88488 12.7164 9.74287 12.5862L6.10651 9.25287C5.9645 9.1227 5.9645 8.91164 6.10651 8.78147Z" fill="currentColor" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'close': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M12 4L4 12M4 4L12 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'copy': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M5.33398 5.33301V3.46634C5.33398 2.71961 5.33398 2.34623 5.47931 2.06102C5.60714 1.81013 5.81111 1.60616 6.062 1.47833C6.34721 1.33301 6.72058 1.33301 7.46732 1.33301H12.534C13.2807 1.33301 13.6541 1.33301 13.9393 1.47833C14.1902 1.60616 14.3942 1.81013 14.522 2.06102C14.6673 2.34623 14.6673 2.71961 14.6673 3.46634V8.53301C14.6673 9.27974 14.6673 9.65314 14.522 9.93834C14.3942 10.1892 14.1902 10.3932 13.9393 10.521C13.6541 10.6663 13.2807 10.6663 12.534 10.6663H10.6673M3.46732 14.6663H8.53398C9.28072 14.6663 9.65412 14.6663 9.93932 14.521C10.1902 14.3932 10.3942 14.1892 10.522 13.9383C10.6673 13.6531 10.6673 13.2797 10.6673 12.533V7.46634C10.6673 6.71961 10.6673 6.34623 10.522 6.06102C10.3942 5.81013 10.1902 5.60616 9.93932 5.47833C9.65412 5.33301 9.28072 5.33301 8.53398 5.33301H3.46732C2.72058 5.33301 2.34721 5.33301 2.062 5.47833C1.81111 5.60616 1.60714 5.81013 1.47931 6.06102C1.33398 6.34623 1.33398 6.71961 1.33398 7.46634V12.533C1.33398 13.2797 1.33398 13.6531 1.47931 13.9383C1.60714 14.1892 1.81111 14.3932 2.062 14.521C2.34721 14.6663 2.72058 14.6663 3.46732 14.6663Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'detailed-view': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M14 8H6M14 4H6M14 12H6M3.33333 8C3.33333 8.3682 3.03485 8.66667 2.66667 8.66667C2.29848 8.66667 2 8.3682 2 8C2 7.6318 2.29848 7.33334 2.66667 7.33334C3.03485 7.33334 3.33333 7.6318 3.33333 8ZM3.33333 4C3.33333 4.36819 3.03485 4.66667 2.66667 4.66667C2.29848 4.66667 2 4.36819 2 4C2 3.63182 2.29848 3.33334 2.66667 3.33334C3.03485 3.33334 3.33333 3.63182 3.33333 4ZM3.33333 12C3.33333 12.3682 3.03485 12.6667 2.66667 12.6667C2.29848 12.6667 2 12.3682 2 12C2 11.6318 2.29848 11.3333 2.66667 11.3333C3.03485 11.3333 3.33333 11.6318 3.33333 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'doc-m': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M14 11H8M10 15H8M16 7H8M20 6.8V17.2C20 18.8802 20 19.7202 19.673 20.362C19.3854 20.9265 18.9265 21.3854 18.362 21.673C17.7202 22 16.8802 22 15.2 22H8.8C7.11984 22 6.27976 22 5.63803 21.673C5.07354 21.3854 4.6146 20.9265 4.32698 20.362C4 19.7202 4 18.8802 4 17.2V6.8C4 5.11984 4 4.27976 4.32698 3.63803C4.6146 3.07354 5.07354 2.6146 5.63803 2.32698C6.27976 2 7.11984 2 8.8 2H15.2C16.8802 2 17.7202 2 18.362 2.32698C18.9265 2.6146 19.3854 3.07354 19.673 3.63803C20 4.27976 20 5.11984 20 6.8Z" stroke="currentCOlor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'dots': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M8.00016 8.66666C8.36836 8.66666 8.66683 8.36819 8.66683 7.99999C8.66683 7.63179 8.36836 7.33333 8.00016 7.33333C7.63196 7.33333 7.3335 7.63179 7.3335 7.99999C7.3335 8.36819 7.63196 8.66666 8.00016 8.66666Z" stroke="currentColor" stroke-width="1.33333" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M12.6667 8.66666C13.0349 8.66666 13.3333 8.36819 13.3333 7.99999C13.3333 7.63179 13.0349 7.33333 12.6667 7.33333C12.2985 7.33333 12 7.63179 12 7.99999C12 8.36819 12.2985 8.66666 12.6667 8.66666Z" stroke="currentColor" stroke-width="1.33333" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M3.33317 8.66666C3.70136 8.66666 3.99984 8.36819 3.99984 7.99999C3.99984 7.63179 3.70136 7.33333 3.33317 7.33333C2.96498 7.33333 2.6665 7.63179 2.6665 7.99999C2.6665 8.36819 2.96498 8.66666 3.33317 8.66666Z" stroke="currentColor" stroke-width="1.33333" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'download': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M8 10V2M8 10L4.66667 6.66667M8 10L11.3333 6.66667M14 10V12.6667C14 13.0203 13.8595 13.3594 13.6095 13.6095C13.3594 13.8595 13.0203 14 12.6667 14H3.33333C2.97971 14 2.64057 13.8595 2.39052 13.6095C2.14048 13.3594 2 13.0203 2 12.6667V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'drag': /* html */`
    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M7.49999 10.833C7.96023 10.833 8.33332 10.4599 8.33332 9.99967C8.33332 9.53944 7.96023 9.16634 7.49999 9.16634C7.03975 9.16634 6.66666 9.53944 6.66666 9.99967C6.66666 10.4599 7.03975 10.833 7.49999 10.833Z" stroke="currentColor" stroke-width="1.66667" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M7.49999 4.99967C7.96023 4.99967 8.33332 4.62658 8.33332 4.16634C8.33332 3.7061 7.96023 3.33301 7.49999 3.33301C7.03975 3.33301 6.66666 3.7061 6.66666 4.16634C6.66666 4.62658 7.03975 4.99967 7.49999 4.99967Z" stroke="currentColor" stroke-width="1.66667" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M7.49999 16.6663C7.96023 16.6663 8.33332 16.2932 8.33332 15.833C8.33332 15.3728 7.96023 14.9997 7.49999 14.9997C7.03975 14.9997 6.66666 15.3728 6.66666 15.833C6.66666 16.2932 7.03975 16.6663 7.49999 16.6663Z" stroke="currentColor" stroke-width="1.66667" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M12.5 10.833C12.9602 10.833 13.3333 10.4599 13.3333 9.99967C13.3333 9.53944 12.9602 9.16634 12.5 9.16634C12.0398 9.16634 11.6667 9.53944 11.6667 9.99967C11.6667 10.4599 12.0398 10.833 12.5 10.833Z" stroke="currentColor" stroke-width="1.66667" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M12.5 4.99967C12.9602 4.99967 13.3333 4.62658 13.3333 4.16634C13.3333 3.7061 12.9602 3.33301 12.5 3.33301C12.0398 3.33301 11.6667 3.7061 11.6667 4.16634C11.6667 4.62658 12.0398 4.99967 12.5 4.99967Z" stroke="currentColor" stroke-width="1.66667" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M12.5 16.6663C12.9602 16.6663 13.3333 16.2932 13.3333 15.833C13.3333 15.3728 12.9602 14.9997 12.5 14.9997C12.0398 14.9997 11.6667 15.3728 11.6667 15.833C11.6667 16.2932 12.0398 16.6663 12.5 16.6663Z" stroke="currentColor" stroke-width="1.66667" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'extension-chrome': /* html */`
    <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M21 10.748H19.5V6.74805C19.5 5.64404 18.604 4.74805 17.5 4.74805H13.5V3.24805C13.5 1.86707 12.381 0.748047 11 0.748047C9.61899 0.748047 8.5 1.86707 8.5 3.24805V4.74805H4.5C3.396 4.74805 2.51001 5.64404 2.51001 6.74805L2.50699 10.548H4C5.491 10.548 6.70001 11.757 6.70001 13.248C6.70001 14.7391 5.491 15.9481 4 15.9481H2.50299L2.5 19.748C2.5 20.8521 3.396 21.748 4.5 21.748H8.29999V20.248C8.29999 18.757 9.509 17.548 11 17.548C12.491 17.548 13.7 18.757 13.7 20.248V21.748H17.5C18.604 21.748 19.5 20.8521 19.5 19.748V15.748H21C22.381 15.748 23.5 14.629 23.5 13.248C23.5 11.8671 22.381 10.748 21 10.748Z" fill="currentColor"/>
    </svg>
  `,
  'extension-firefox': /* html */`
    <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
      <mask id="path-1-inside-1_4388_64152" fill="white">
      <path fill-rule="evenodd" clip-rule="evenodd" d="M8.5 3.68555C8.5 1.78707 10.039 0.248047 11.9375 0.248047C13.836 0.248047 15.375 1.78707 15.375 3.68555V5.74805H18.125C19.6438 5.74805 20.875 6.97926 20.875 8.49805V19.498C20.875 21.0168 19.6438 22.248 18.125 22.248H5.75C4.23122 22.248 3 21.0168 3 19.498V15.373H6.4375C7.57659 15.373 8.5 14.4496 8.5 13.3105C8.5 12.1715 7.57659 11.248 6.4375 11.248H3V8.49805C3 6.97926 4.23122 5.74805 5.75 5.74805H8.5V3.68555Z"/>
      </mask>
      <path d="M15.375 5.74805H13.375V7.74805H15.375V5.74805ZM3 15.373V13.373H1V15.373H3ZM3 11.248H1V13.248H3V11.248ZM8.5 5.74805V7.74805H10.5V5.74805H8.5ZM11.9375 -1.75195C8.93445 -1.75195 6.5 0.682499 6.5 3.68555H10.5C10.5 2.89164 11.1436 2.24805 11.9375 2.24805V-1.75195ZM17.375 3.68555C17.375 0.682499 14.9405 -1.75195 11.9375 -1.75195V2.24805C12.7314 2.24805 13.375 2.89164 13.375 3.68555H17.375ZM17.375 5.74805V3.68555H13.375V5.74805H17.375ZM18.125 3.74805H15.375V7.74805H18.125V3.74805ZM22.875 8.49805C22.875 5.87469 20.7484 3.74805 18.125 3.74805V7.74805C18.5392 7.74805 18.875 8.08383 18.875 8.49805H22.875ZM22.875 19.498V8.49805H18.875V19.498H22.875ZM18.125 24.248C20.7484 24.248 22.875 22.1214 22.875 19.498H18.875C18.875 19.9123 18.5392 20.248 18.125 20.248V24.248ZM5.75 24.248H18.125V20.248H5.75V24.248ZM1 19.498C1 22.1214 3.12665 24.248 5.75 24.248V20.248C5.33579 20.248 5 19.9123 5 19.498H1ZM1 15.373V19.498H5V15.373H1ZM6.4375 13.373H3V17.373H6.4375V13.373ZM6.5 13.3105C6.5 13.3229 6.4979 13.3296 6.49591 13.3343C6.49336 13.3403 6.4888 13.3476 6.48169 13.3547C6.47459 13.3618 6.46724 13.3664 6.46121 13.369C6.45652 13.3709 6.44982 13.373 6.4375 13.373V17.373C8.68116 17.373 10.5 15.5542 10.5 13.3105H6.5ZM6.4375 13.248C6.44982 13.248 6.45652 13.2502 6.46121 13.2521C6.46724 13.2547 6.47459 13.2592 6.48169 13.2664C6.4888 13.2735 6.49336 13.2808 6.49591 13.2868C6.4979 13.2915 6.5 13.2982 6.5 13.3105H10.5C10.5 11.0669 8.68116 9.24805 6.4375 9.24805V13.248ZM3 13.248H6.4375V9.24805H3V13.248ZM1 8.49805V11.248H5V8.49805H1ZM5.75 3.74805C3.12665 3.74805 1 5.87469 1 8.49805H5C5 8.08383 5.33579 7.74805 5.75 7.74805V3.74805ZM8.5 3.74805H5.75V7.74805H8.5V3.74805ZM6.5 3.68555V5.74805H10.5V3.68555H6.5Z" fill="currentColor" mask="url(#path-1-inside-1_4388_64152)"/>
    </svg>
  `,
  'extension-edge': /* html */`
    <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
      <mask id="path-1-inside-1_4388_64267" fill="white">
      <path fill-rule="evenodd" clip-rule="evenodd" d="M10.25 3.99805C10.25 2.47926 11.4812 1.24805 13 1.24805C14.5188 1.24805 15.75 2.47926 15.75 3.99805H19.875C20.6344 3.99805 21.25 4.61366 21.25 5.37305V10.873H19.505C18.7456 10.873 18.13 11.4887 18.13 12.248C18.13 13.0074 18.7456 13.623 19.505 13.623H21.25V19.123C21.25 19.8824 20.6344 20.498 19.875 20.498H15.75C15.75 22.0168 14.5188 23.248 13 23.248C11.4812 23.248 10.25 22.0168 10.25 20.498H6.125C5.36561 20.498 4.75 19.8824 4.75 19.123V14.998C3.23122 14.998 2 13.7668 2 12.248C2 10.7293 3.23122 9.49805 4.75 9.49805V5.37305C4.75 4.61366 5.36561 3.99805 6.125 3.99805H10.25Z"/>
      </mask>
      <path d="M10.25 3.99805V5.49805H11.75V3.99805H10.25ZM15.75 3.99805H14.25V5.49805H15.75V3.99805ZM21.25 10.873V12.373H22.75V10.873H21.25ZM21.25 13.623H22.75V12.123H21.25V13.623ZM15.75 20.498V18.998H14.25V20.498H15.75ZM10.25 20.498H11.75V18.998H10.25V20.498ZM4.75 14.998H6.25V13.498H4.75V14.998ZM4.75 9.49805V10.998H6.25V9.49805H4.75ZM13 -0.251953C10.6528 -0.251953 8.75 1.65084 8.75 3.99805H11.75C11.75 3.30769 12.3096 2.74805 13 2.74805V-0.251953ZM17.25 3.99805C17.25 1.65084 15.3472 -0.251953 13 -0.251953V2.74805C13.6904 2.74805 14.25 3.30769 14.25 3.99805H17.25ZM19.875 2.49805H15.75V5.49805H19.875V2.49805ZM22.75 5.37305C22.75 3.78523 21.4628 2.49805 19.875 2.49805V5.49805C19.806 5.49805 19.75 5.44208 19.75 5.37305H22.75ZM22.75 10.873V5.37305H19.75V10.873H22.75ZM19.505 12.373H21.25V9.37305H19.505V12.373ZM19.63 12.248C19.63 12.3171 19.574 12.373 19.505 12.373V9.37305C17.9172 9.37305 16.63 10.6602 16.63 12.248H19.63ZM19.505 12.123C19.574 12.123 19.63 12.179 19.63 12.248H16.63C16.63 13.8359 17.9172 15.123 19.505 15.123V12.123ZM21.25 12.123H19.505V15.123H21.25V12.123ZM22.75 19.123V13.623H19.75V19.123H22.75ZM19.875 21.998C21.4628 21.998 22.75 20.7109 22.75 19.123H19.75C19.75 19.054 19.806 18.998 19.875 18.998V21.998ZM15.75 21.998H19.875V18.998H15.75V21.998ZM13 24.748C15.3472 24.748 17.25 22.8453 17.25 20.498H14.25C14.25 21.1884 13.6904 21.748 13 21.748V24.748ZM8.75 20.498C8.75 22.8453 10.6528 24.748 13 24.748V21.748C12.3096 21.748 11.75 21.1884 11.75 20.498H8.75ZM6.125 21.998H10.25V18.998H6.125V21.998ZM3.25 19.123C3.25 20.7109 4.53718 21.998 6.125 21.998V18.998C6.19404 18.998 6.25 19.054 6.25 19.123H3.25ZM3.25 14.998V19.123H6.25V14.998H3.25ZM0.5 12.248C0.5 14.5953 2.40279 16.498 4.75 16.498V13.498C4.05964 13.498 3.5 12.9384 3.5 12.248H0.5ZM4.75 7.99805C2.40279 7.99805 0.5 9.90084 0.5 12.248H3.5C3.5 11.5577 4.05964 10.998 4.75 10.998V7.99805ZM3.25 5.37305V9.49805H6.25V5.37305H3.25ZM6.125 2.49805C4.53718 2.49805 3.25 3.78523 3.25 5.37305H6.25C6.25 5.44208 6.19404 5.49805 6.125 5.49805V2.49805ZM10.25 2.49805H6.125V5.49805H10.25V2.49805Z" fill="currentColor" mask="url(#path-1-inside-1_4388_64267)"/>
    </svg>
  `,
  'extension-opera': /* html */`
    <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M20.5 7.52637L12 12.2486M12 12.2486L3.49997 7.52637M12 12.2486V21.7486M21 16.3071V8.19007C21 7.84743 21 7.67611 20.9495 7.52331C20.9049 7.38813 20.8318 7.26405 20.7354 7.15936C20.6263 7.04102 20.4766 6.95782 20.177 6.79142L12.777 2.68031C12.4934 2.52275 12.3516 2.44397 12.2015 2.41308C12.0685 2.38575 11.9315 2.38575 11.7986 2.41308C11.6484 2.44397 11.5066 2.52275 11.223 2.68031L3.82297 6.79142C3.52345 6.95782 3.37369 7.04102 3.26463 7.15936C3.16816 7.26405 3.09515 7.38813 3.05048 7.52331C3 7.67611 3 7.84743 3 8.19007V16.3071C3 16.6498 3 16.8211 3.05048 16.9739C3.09515 17.1091 3.16816 17.2332 3.26463 17.3378C3.37369 17.4562 3.52345 17.5394 3.82297 17.7058L11.223 21.8169C11.5066 21.9745 11.6484 22.0532 11.7986 22.0841C11.9315 22.1115 12.0685 22.1115 12.2015 22.0841C12.3516 22.0532 12.4934 21.9745 12.777 21.8169L20.177 17.7058C20.4766 17.5394 20.6263 17.4562 20.7354 17.3378C20.8318 17.2332 20.9049 17.1091 20.9495 16.9739C21 16.8211 21 16.6498 21 16.3071Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'error': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <rect x="5" y="2" width="6" height="12" fill="white"/>
      <path fill-rule="evenodd" clip-rule="evenodd" d="M11.8675 1.21339C9.31779 0.928871 6.68223 0.928871 4.13242 1.21339C2.62414 1.38168 1.40612 2.56784 1.22869 4.08241C0.92377 6.68526 0.92377 9.31474 1.22869 11.9176C1.40612 13.4322 2.62414 14.6183 4.13242 14.7867C6.68223 15.0711 9.31779 15.0711 11.8675 14.7867C13.3758 14.6183 14.5939 13.4322 14.7713 11.9176C15.0762 9.31474 15.0762 6.68526 14.7713 4.08241C14.5939 2.56784 13.3758 1.38168 11.8675 1.21339ZM6.9829 4.10727C6.93323 3.51121 7.40361 3 8.00174 3C8.59986 3 9.07025 3.51121 9.02057 4.10727L8.60343 9.11303C8.57735 9.42596 8.31575 9.66667 8.00174 9.66667C7.68772 9.66667 7.42612 9.42596 7.40004 9.11303L6.9829 4.10727ZM9.11285 11.8889C9.11285 12.5025 8.61539 13 8.00174 13C7.38809 13 6.89062 12.5025 6.89062 11.8889C6.89062 11.2752 7.38809 10.7778 8.00174 10.7778C8.61539 10.7778 9.11285 11.2752 9.11285 11.8889Z" fill="currentColor"/>
    </svg>
  `,
  'eye': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M7.16193 3.39488C7.43293 3.35482 7.7124 3.33333 8.00026 3.33333C11.4036 3.33333 13.6369 6.33656 14.3871 7.52453C14.4779 7.66833 14.5233 7.7402 14.5487 7.85113C14.5679 7.9344 14.5678 8.0658 14.5487 8.14907C14.5233 8.25993 14.4776 8.33233 14.3861 8.47707C14.1862 8.7934 13.8815 9.23807 13.4777 9.72033M4.48288 4.47669C3.0415 5.45447 2.06296 6.81293 1.61407 7.52353C1.52285 7.66793 1.47725 7.74013 1.45183 7.851C1.43273 7.93427 1.43272 8.0656 1.4518 8.14893C1.47722 8.2598 1.52262 8.33167 1.61342 8.47547C2.36369 9.66347 4.59694 12.6667 8.00026 12.6667C9.37253 12.6667 10.5546 12.1784 11.5259 11.5177M2.00028 2L14.0003 14M6.58607 6.58579C6.22413 6.94773 6.00028 7.44773 6.00028 8C6.00028 9.1046 6.89573 10 8.00026 10C8.55253 10 9.05253 9.77613 9.41447 9.4142" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'flask': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M14 2V8C13.9999 8.33548 14.0841 8.66561 14.245 8.96L19.755 19.04C19.9217 19.3446 20.0062 19.6874 20.0002 20.0345C19.9942 20.3817 19.8979 20.7213 19.7208 21.02C19.5437 21.3187 19.2919 21.5661 18.9902 21.7379C18.6885 21.9098 18.3472 22.0001 18 22H6.00001C5.65278 22.0001 5.31152 21.9098 5.0098 21.7379C4.70807 21.5661 4.45628 21.3187 4.2792 21.02C4.10211 20.7213 4.00584 20.3817 3.99984 20.0345C3.99385 19.6874 4.07834 19.3446 4.24501 19.04L9.75501 8.96C9.9159 8.66561 10.0001 8.33548 10 8V2M6.45301 15H17.547M8.50001 2H15.5" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'globe': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M1.33398 7.99967H14.6673M1.33398 7.99967C1.33398 11.6815 4.31875 14.6663 8.00065 14.6663M1.33398 7.99967C1.33398 4.31777 4.31875 1.33301 8.00065 1.33301M14.6673 7.99967C14.6673 11.6815 11.6825 14.6663 8.00065 14.6663M14.6673 7.99967C14.6673 4.31777 11.6825 1.33301 8.00065 1.33301M8.00065 1.33301C9.66818 3.15857 10.6159 5.52769 10.6673 7.99967C10.6159 10.4717 9.66818 12.8407 8.00065 14.6663M8.00065 1.33301C6.33313 3.15857 5.38548 5.52769 5.33398 7.99967C5.38548 10.4717 6.33313 12.8407 8.00065 14.6663" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'ghosty-m': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M20.491 18.6085C19.6379 16.7013 19.491 15.0852 19.4681 14.4503V9.22599C19.4681 5.23505 16.1238 2 11.9987 2C7.8731 2 4.52869 5.23505 4.52869 9.22599V14.5258C4.49682 15.2089 4.32919 16.7755 3.50899 18.6085C2.40658 21.0715 3.31893 20.7779 4.13614 20.5753C4.95323 20.3735 6.77804 19.5824 7.34812 20.5569C7.91797 21.531 8.39336 22.3769 9.72369 21.8254C11.0541 21.274 11.681 21.0902 11.871 21.0902H12.1294C12.3191 21.0902 12.9463 21.274 14.2766 21.8254C15.6069 22.3769 16.0821 21.531 16.6523 20.5569C17.2221 19.5824 19.0468 20.3735 19.8641 20.5753C20.6813 20.7779 21.5932 21.0715 20.491 18.6085" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'heart': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M16.1111 3C19.6333 3 22 6.3525 22 9.48C22 15.8138 12.1778 21 12 21C11.8222 21 2 15.8138 2 9.48C2 6.3525 4.36667 3 7.88889 3C9.91111 3 11.2333 4.02375 12 4.92375C12.7667 4.02375 14.0889 3 16.1111 3Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'help': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M9.09 9C9.3251 8.33167 9.78915 7.76811 10.4 7.40913C11.0108 7.05016 11.7289 6.91894 12.4272 7.03871C13.1255 7.15849 13.7588 7.52152 14.2151 8.06353C14.6713 8.60553 14.9211 9.29152 14.92 10C14.92 12 11.92 13 11.92 13M12 17H12.01M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'hide-element': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M6.99999 3.33331H12.6667C13.0203 3.33331 13.3594 3.47379 13.6095 3.72384C13.8595 3.97389 14 4.31302 14 4.66665V10.3333M11.3333 7.33331H11M12.6667 12.6666H3.33333C2.97971 12.6666 2.64057 12.5262 2.39052 12.2761C2.14047 12.0261 1.99999 11.6869 1.99999 11.3333V4.66665C1.99999 4.31302 2.14047 3.97389 2.39052 3.72384C2.64057 3.47379 2.97971 3.33331 3.33333 3.33331M1.33333 1.33331L14.6667 14.6666M4.66666 7.33331H7.33333M4.66666 9.99998H6.33333" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'info': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M8.00065 10.6663V7.99967M8.00065 5.33301H8.00732M14.6673 7.99967C14.6673 11.6815 11.6825 14.6663 8.00065 14.6663C4.31875 14.6663 1.33398 11.6815 1.33398 7.99967C1.33398 4.31777 4.31875 1.33301 8.00065 1.33301C11.6825 1.33301 14.6673 4.31777 14.6673 7.99967Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'info-menu': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M12 14V10.5M12 7H12.01M9.9 19.2L11.36 21.1467C11.5771 21.4362 11.6857 21.5809 11.8188 21.6327C11.9353 21.678 12.0647 21.678 12.1812 21.6327C12.3143 21.5809 12.4229 21.4362 12.64 21.1467L14.1 19.2C14.3931 18.8091 14.5397 18.6137 14.7185 18.4645C14.9569 18.2656 15.2383 18.1248 15.5405 18.0535C15.7671 18 16.0114 18 16.5 18C17.8978 18 18.5967 18 19.1481 17.7716C19.8831 17.4672 20.4672 16.8831 20.7716 16.1481C21 15.5967 21 14.8978 21 13.5V7.8C21 6.11984 21 5.27976 20.673 4.63803C20.3854 4.07354 19.9265 3.6146 19.362 3.32698C18.7202 3 17.8802 3 16.2 3H7.8C6.11984 3 5.27976 3 4.63803 3.32698C4.07354 3.6146 3.6146 4.07354 3.32698 4.63803C3 5.27976 3 6.11984 3 7.8V13.5C3 14.8978 3 15.5967 3.22836 16.1481C3.53284 16.8831 4.11687 17.4672 4.85195 17.7716C5.40326 18 6.10218 18 7.5 18C7.98858 18 8.23287 18 8.45951 18.0535C8.76169 18.1248 9.04312 18.2656 9.2815 18.4645C9.46028 18.6137 9.60685 18.8091 9.9 19.2Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'info-filled': /* html */`
    <svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path fill-rule="evenodd" clip-rule="evenodd" d="M12.3675 1.21339C9.81779 0.928871 7.18223 0.928871 4.63242 1.21339C3.12414 1.38168 1.90612 2.56784 1.72869 4.08241C1.42377 6.68526 1.42377 9.31474 1.72869 11.9176C1.90612 13.4322 3.12414 14.6183 4.63242 14.7867C7.18223 15.0711 9.81779 15.0711 12.3675 14.7867C13.8758 14.6183 15.0939 13.4322 15.2713 11.9176C15.5762 9.31474 15.5762 6.68526 15.2713 4.08241C15.0939 2.56784 13.8758 1.38168 12.3675 1.21339ZM9.5 4.5C9.5 5.05228 9.05228 5.5 8.5 5.5C7.94772 5.5 7.5 5.05228 7.5 4.5C7.5 3.94772 7.94772 3.5 8.5 3.5C9.05228 3.5 9.5 3.94772 9.5 4.5ZM7.5 8C7.5 7.44772 7.94772 7 8.5 7C9.05228 7 9.5 7.44772 9.5 8V11C9.5 11.5523 9.05228 12 8.5 12C7.94772 12 7.5 11.5523 7.5 11V8Z" fill="currentColor"/>
    </svg>
  `,
  'imprint-m': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M8 17H16M11.0177 2.764L4.23539 8.03912C3.78202 8.39175 3.55534 8.56806 3.39203 8.78886C3.24737 8.98444 3.1396 9.20478 3.07403 9.43905C3 9.70352 3 9.9907 3 10.5651V17.8C3 18.9201 3 19.4801 3.21799 19.908C3.40973 20.2843 3.71569 20.5903 4.09202 20.782C4.51984 21 5.07989 21 6.2 21H17.8C18.9201 21 19.4802 21 19.908 20.782C20.2843 20.5903 20.5903 20.2843 20.782 19.908C21 19.4801 21 18.9201 21 17.8V10.5651C21 9.9907 21 9.70352 20.926 9.43905C20.8604 9.20478 20.7526 8.98444 20.608 8.78886C20.4447 8.56806 20.218 8.39175 19.7646 8.03913L12.9823 2.764C12.631 2.49075 12.4553 2.35412 12.2613 2.3016C12.0902 2.25526 11.9098 2.25526 11.7387 2.3016C11.5447 2.35412 11.369 2.49075 11.0177 2.764Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'license-m': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M6.5 20H5C3.89543 20 3 19.1046 3 18V4C3 2.89543 3.89543 2 5 2H19C20.1046 2 21 2.89543 21 4V18C21 19.1046 20.1046 20 19 20H17.5M12 19L12.0214 18.9998L8.82867 22.1926L6.00024 19.3641L9.01965 16.3447M12 19L15.1928 22.1926L18.0212 19.3641L15.0018 16.3447M9 6H15M7 9.5H17M12 19C13.6569 19 15 17.6569 15 16C15 14.3431 13.6569 13 12 13C10.3431 13 9 14.3431 9 16C9 17.6569 10.3431 19 12 19Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'link-external-m': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M21 9.00001V3.00001M21 3.00001H15M21 3.00001L12 12M10 3H7.8C6.11984 3 5.27976 3 4.63803 3.32698C4.07354 3.6146 3.6146 4.07354 3.32698 4.63803C3 5.27976 3 6.11984 3 7.8V16.2C3 17.8802 3 18.7202 3.32698 19.362C3.6146 19.9265 4.07354 20.3854 4.63803 20.673C5.27976 21 6.11984 21 7.8 21H16.2C17.8802 21 18.7202 21 19.362 20.673C19.9265 20.3854 20.3854 19.9265 20.673 19.362C21 18.7202 21 17.8802 21 16.2V14" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'list': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M14 7.99992H6M14 3.99992H6M14 11.9999H6M3.33333 7.99992C3.33333 8.36812 3.03485 8.66658 2.66667 8.66658C2.29848 8.66658 2 8.36812 2 7.99992C2 7.63172 2.29848 7.33325 2.66667 7.33325C3.03485 7.33325 3.33333 7.63172 3.33333 7.99992ZM3.33333 3.99992C3.33333 4.36811 3.03485 4.66659 2.66667 4.66659C2.29848 4.66659 2 4.36811 2 3.99992C2 3.63173 2.29848 3.33325 2.66667 3.33325C3.03485 3.33325 3.33333 3.63173 3.33333 3.99992ZM3.33333 11.9999C3.33333 12.3681 3.03485 12.6666 2.66667 12.6666C2.29848 12.6666 2 12.3681 2 11.9999C2 11.6317 2.29848 11.3333 2.66667 11.3333C3.03485 11.3333 3.33333 11.6317 3.33333 11.9999Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'mail': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M1.33398 4.66699L6.77725 8.47726C7.21805 8.78586 7.43845 8.94013 7.67818 8.99986C7.88992 9.05266 8.11138 9.05266 8.32312 8.99986C8.56285 8.94013 8.78325 8.78586 9.22405 8.47726L14.6673 4.66699M4.53398 13.3337H11.4673C12.5875 13.3337 13.1475 13.3337 13.5753 13.1157C13.9516 12.9239 14.2576 12.618 14.4493 12.2417C14.6673 11.8138 14.6673 11.2538 14.6673 10.1337V5.86699C14.6673 4.74689 14.6673 4.18683 14.4493 3.75901C14.2576 3.38269 13.9516 3.07673 13.5753 2.88498C13.1475 2.66699 12.5875 2.66699 11.4673 2.66699H4.53398C3.41388 2.66699 2.85382 2.66699 2.426 2.88498C2.04968 3.07673 1.74372 3.38269 1.55197 3.75901C1.33398 4.18683 1.33398 4.74689 1.33398 5.86699V10.1337C1.33398 11.2538 1.33398 11.8138 1.55197 12.2417C1.74372 12.618 2.04968 12.9239 2.426 13.1157C2.85382 13.3337 3.41388 13.3337 4.53398 13.3337Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'menu': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M3 12H21M3 6H21M3 18H21" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'no-websites': /* html */`
    <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M4 4L28 28" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M28.2913 12.3125H17.083M3.70801 12.3125H11.8748M26.278 26.6606C25.4891 27.0625 24.4566 27.0625 22.3913 27.0625H9.60801C7.54281 27.0625 6.51021 27.0625 5.72142 26.6606C5.02757 26.3071 4.46345 25.743 4.10992 25.0491C3.70801 24.2602 3.70801 23.2277 3.70801 21.1625V10.8375C3.70801 8.7723 3.70801 7.7397 4.10992 6.95091C4.37943 6.42197 4.77131 5.96843 5.24976 5.62609M9.37476 4.9375H22.3913C24.4566 4.9375 25.4891 4.9375 26.278 5.33941C26.9718 5.69295 27.5359 6.25706 27.8894 6.95091C28.2913 7.73972 28.2913 8.7723 28.2913 10.8375V21.1625C28.2913 21.5617 28.2913 22.4223 28.2884 22.75" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'onboarding-adblocking': /* html */`
    <svg width="33" height="32" viewBox="0 0 33 32" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M5.66667 17.4868L7.7662 25.885C7.82524 26.1211 7.85476 26.2392 7.88969 26.3423C8.23089 27.3496 9.13803 28.0579 10.198 28.1447C10.3065 28.1535 10.4283 28.1535 10.6717 28.1535C10.9766 28.1535 11.129 28.1535 11.2574 28.1411C12.5267 28.0179 13.5311 27.0135 13.6542 25.7443C13.6667 25.6159 13.6667 25.4634 13.6667 25.1586V6.15353M25 16.8202C27.5773 16.8202 29.6667 14.7308 29.6667 12.1535C29.6667 9.57619 27.5773 7.48686 25 7.48686M14 6.15353H9C5.68629 6.15353 3 8.83982 3 12.1535C3 15.4672 5.68629 18.1535 9 18.1535H14C16.3552 18.1535 19.2363 19.416 21.4591 20.6278C22.7557 21.3346 23.4041 21.688 23.8288 21.636C24.2225 21.5878 24.5203 21.411 24.7511 21.0883C25 20.7404 25 20.0442 25 18.6518V5.65525C25 4.26286 25 3.56666 24.7511 3.21871C24.5203 2.89606 24.2225 2.71926 23.8288 2.67103C23.4041 2.61902 22.7557 2.97246 21.4591 3.67934C19.2363 4.89101 16.3552 6.15353 14 6.15353Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'onboarding-anti-tracking': /* html */`
    <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M11.9997 15.3339L14.6663 18.0005L20.6663 12.0005M26.6663 16.0005C26.6663 22.5451 19.5277 27.3051 16.9303 28.8203C16.6351 28.9925 16.4875 29.0787 16.2793 29.1233C16.1175 29.158 15.8818 29.158 15.7201 29.1233C15.5118 29.0787 15.3642 28.9925 15.069 28.8203C12.4716 27.3051 5.33301 22.5451 5.33301 16.0005V9.62395C5.33301 8.55794 5.33301 8.02492 5.50735 7.56675C5.66137 7.162 5.91165 6.80086 6.23655 6.51452C6.60434 6.1904 7.10341 6.00326 8.10154 5.62895L15.2506 2.94804C15.5278 2.8441 15.6663 2.79212 15.809 2.77152C15.9354 2.75324 16.0639 2.75324 16.1903 2.77152C16.333 2.79212 16.4715 2.8441 16.7487 2.94804L23.8978 5.62895C24.8959 6.00326 25.395 6.1904 25.7627 6.51452C26.0877 6.80086 26.3379 7.162 26.4919 7.56675C26.6663 8.02492 26.6663 8.55794 26.6663 9.62395V16.0005Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'onboarding-never-consent': /* html */`
    <svg width="33" height="32" viewBox="0 0 33 32" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M16.6667 15V20M16.6667 25V25.02" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M6.66675 6L26.6667 6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M10.6667 2L22.6667 2" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      <rect x="2.66675" y="10" width="28" height="20" rx="1" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'open-book': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M7.99999 4.66667V14M7.99999 4.66667C7.99999 3.95942 7.71904 3.28115 7.21895 2.78105C6.71885 2.28095 6.04057 2 5.33333 2H1.99999C1.82318 2 1.65361 2.07024 1.52859 2.19526C1.40357 2.32029 1.33333 2.48986 1.33333 2.66667V11.3333C1.33333 11.5101 1.40357 11.6797 1.52859 11.8047C1.65361 11.9298 1.82318 12 1.99999 12H5.99999C6.53043 12 7.03914 12.2107 7.41421 12.5858C7.78928 12.9609 7.99999 13.4696 7.99999 14M7.99999 4.66667C7.99999 3.95942 8.28095 3.28115 8.78104 2.78105C9.28114 2.28095 9.95942 2 10.6667 2H14C14.1768 2 14.3464 2.07024 14.4714 2.19526C14.5964 2.32029 14.6667 2.48986 14.6667 2.66667V11.3333C14.6667 11.5101 14.5964 11.6797 14.4714 11.8047C14.3464 11.9298 14.1768 12 14 12H9.99999C9.46956 12 8.96085 12.2107 8.58578 12.5858C8.21071 12.9609 7.99999 13.4696 7.99999 14M10.6667 8H12M10.6667 5.33333H12M3.99999 8H5.33333M3.99999 5.33333H5.33333" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'pause': /* html */`
    <svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M6.83398 9.99992V5.99992M10.1673 9.99992V5.99992M15.1673 7.99992C15.1673 11.6818 12.1825 14.6666 8.50065 14.6666C4.81875 14.6666 1.83398 11.6818 1.83398 7.99992C1.83398 4.31802 4.81875 1.33325 8.50065 1.33325C12.1825 1.33325 15.1673 4.31802 15.1673 7.99992Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'pause-l': /* html */`
  <svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M20 29.9998V17.9998M28 29.9998V17.9998M44 23.9998C44 35.0455 35.0457 43.9998 24 43.9998C12.9543 43.9998 4 35.0455 4 23.9998C4 12.9541 12.9543 3.99976 24 3.99976C35.0457 3.99976 44 12.9541 44 23.9998Z" stroke="currentColor" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/>
  </svg>
  `,
  'pin': /* html */`
    <svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M8.17969 8.66669C9.28429 8.66669 10.1797 7.77129 10.1797 6.66669C10.1797 5.56212 9.28429 4.66669 8.17969 4.66669C7.07509 4.66669 6.17969 5.56212 6.17969 6.66669C6.17969 7.77129 7.07509 8.66669 8.17969 8.66669Z" stroke="currentColor" stroke-width="1.33333" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M8.17904 14.6666C10.8457 12 13.5124 9.61218 13.5124 6.66665C13.5124 3.72113 11.1246 1.33331 8.17904 1.33331C5.23352 1.33331 2.8457 3.72113 2.8457 6.66665C2.8457 9.61218 5.51237 12 8.17904 14.6666Z" stroke="currentColor" stroke-width="1.33333" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
`,
  'play': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <g clip-path="url(#clip0_1853_2720)">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M2.08398 8.00016C2.08398 4.73248 4.73296 2.0835 8.00065 2.0835C11.2683 2.0835 13.9173 4.73248 13.9173 8.00016C13.9173 11.2678 11.2683 13.9168 8.00065 13.9168C4.73297 13.9168 2.08398 11.2678 2.08398 8.00016ZM8.00065 0.583496C3.90454 0.583496 0.583984 3.90405 0.583984 8.00016C0.583984 12.0962 3.90454 15.4168 8.00065 15.4168C12.0967 15.4168 15.4173 12.0962 15.4173 8.00016C15.4173 3.90405 12.0967 0.583496 8.00065 0.583496ZM6.40048 5.41094C6.33398 5.49976 6.33398 5.65886 6.33398 5.97704V10.0233C6.33398 10.3415 6.33398 10.5006 6.40048 10.5894C6.45842 10.6668 6.54712 10.7152 6.64357 10.7221C6.75417 10.73 6.88786 10.6441 7.15516 10.4723L7.15572 10.4719L10.3028 8.44876C10.5351 8.29949 10.6512 8.22482 10.6913 8.12989C10.7263 8.04696 10.7263 7.95336 10.6913 7.87042C10.6512 7.77549 10.5351 7.70082 10.3028 7.55156L7.15572 5.52842L7.15557 5.52832C6.888 5.35632 6.75423 5.27033 6.64357 5.27822C6.54712 5.28512 6.45842 5.33354 6.40048 5.41094Z" fill="currentColor"/>
      </g>
      <defs>
        <clipPath id="clip0_1853_2720">
          <rect width="16" height="16" fill="currentColor"/>
        </clipPath>
      </defs>
    </svg>
  `,
  'privacy': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M13.3327 6.33301V4.53301C13.3327 3.4129 13.3327 2.85285 13.1147 2.42503C12.9229 2.0487 12.617 1.74274 12.2407 1.55099C11.8128 1.33301 11.2528 1.33301 10.1327 1.33301H5.86602C4.74591 1.33301 4.18586 1.33301 3.75804 1.55099C3.38171 1.74274 3.07575 2.0487 2.884 2.42503C2.66602 2.85285 2.66602 3.4129 2.66602 4.53301V11.4663C2.66602 12.5865 2.66602 13.1465 2.884 13.5743C3.07575 13.9507 3.38171 14.2566 3.75804 14.4483C4.18586 14.6663 4.74591 14.6663 5.86602 14.6663H9.33268M9.33268 7.33301H5.33268M6.66602 9.99967H5.33268M10.666 4.66634H5.33268M10.9993 10.0011C11.1168 9.66727 11.3487 9.38567 11.6538 9.20634C11.959 9.02694 12.3178 8.96141 12.6667 9.02127C13.0155 9.08107 13.332 9.26247 13.5599 9.53327C13.7879 9.80407 13.9127 10.1468 13.9121 10.5008C13.9121 11.5001 12.4133 11.9997 12.4133 11.9997M12.4326 13.9997H12.4393" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
    `,
  'privacy-m': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M14 11H8M10 15H8M16 7H8M20 10V6.8C20 5.11984 20 4.27976 19.673 3.63803C19.3854 3.07354 18.9265 2.6146 18.362 2.32698C17.7202 2 16.8802 2 15.2 2H8.8C7.11984 2 6.27976 2 5.63803 2.32698C5.07354 2.6146 4.6146 3.07354 4.32698 3.63803C4 4.27976 4 5.11984 4 6.8V17.2C4 18.8802 4 19.7202 4.32698 20.362C4.6146 20.9265 5.07354 21.3854 5.63803 21.673C6.27976 22 7.11984 22 8.8 22H12.5M18 21C18 21 21 19.5701 21 17.4252V14.9229L18.8124 14.1412C18.2868 13.9529 17.712 13.9529 17.1864 14.1412L15 14.9229V17.4252C15 19.5701 18 21 18 21Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'protection-l': /* html */`
    <svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M18 22.9998L22 26.9998L31 17.9997M40 23.9998C40 33.8166 29.292 40.9566 25.396 43.2294C24.9532 43.4878 24.7318 43.617 24.4194 43.684C24.1768 43.736 23.8232 43.736 23.5806 43.684C23.2682 43.617 23.0468 43.4878 22.604 43.2294C18.7079 40.9566 8 33.8166 8 23.9998V14.4349C8 12.8359 8 12.0364 8.26152 11.3491C8.49254 10.742 8.86796 10.2003 9.35532 9.77081C9.907 9.28463 10.6556 9.00391 12.1528 8.44245L22.8764 4.42109C23.2922 4.26517 23.5 4.18721 23.714 4.15631C23.9036 4.12889 24.0964 4.12889 24.286 4.15631C24.5 4.18721 24.7078 4.26517 25.1236 4.42109L35.8472 8.44245C37.3444 9.00391 38.093 9.28463 38.6446 9.77081C39.132 10.2003 39.5074 10.742 39.7384 11.3491C40 12.0364 40 12.8359 40 14.4349V23.9998Z" stroke="currentColor" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'tracking': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M5.33333 2H5.2C4.07989 2 3.51984 2 3.09202 2.21799C2.71569 2.40973 2.40973 2.71569 2.21799 3.09202C2 3.51984 2 4.07989 2 5.2V5.33333M5.33333 14H5.2C4.07989 14 3.51984 14 3.09202 13.782C2.71569 13.5903 2.40973 13.2843 2.21799 12.908C2 12.4801 2 11.9201 2 10.8V10.6667M14 5.33333V5.2C14 4.07989 14 3.51984 13.782 3.09202C13.5903 2.71569 13.2843 2.40973 12.908 2.21799C12.4801 2 11.9201 2 10.8 2H10.6667M14 10.6667V10.8C14 11.9201 14 12.4801 13.782 12.908C13.5903 13.2843 13.2843 13.5903 12.908 13.782C12.4801 14 11.9201 14 10.8 14H10.6667M2 8H2.00667M5 8H5.00667M11 8H11.0067M8 8H8.00667M14 8H14.0067" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'triangle': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M11.9998 9.00023V13.0002M11.9998 17.0002H12.0098M10.6151 3.89195L2.39019 18.0985C1.93398 18.8865 1.70588 19.2805 1.73959 19.6039C1.769 19.8859 1.91677 20.1422 2.14613 20.309C2.40908 20.5002 2.86435 20.5002 3.77487 20.5002H20.2246C21.1352 20.5002 21.5904 20.5002 21.8534 20.309C22.0827 20.1422 22.2305 19.8859 22.2599 19.6039C22.2936 19.2805 22.0655 18.8865 21.6093 18.0985L13.3844 3.89195C12.9299 3.10678 12.7026 2.7142 12.4061 2.58235C12.1474 2.46734 11.8521 2.46734 11.5935 2.58235C11.2969 2.7142 11.0696 3.10679 10.6151 3.89195Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'refresh': /* html */`
    <svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M14.5007 6.66667C14.5007 6.66667 13.164 4.84548 12.0781 3.75883C10.9922 2.67218 9.49158 2 7.83398 2C4.52028 2 1.83398 4.68629 1.83398 8C1.83398 11.3137 4.52028 14 7.83398 14C10.5694 14 12.8773 12.1695 13.5995 9.66667M14.5007 6.66667V2.66667M14.5007 6.66667H10.5007" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'report': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M12 8V12M12 16H12.01M2 8.52274V15.4773C2 15.7218 2 15.8441 2.02763 15.9592C2.05213 16.0613 2.09253 16.1588 2.14736 16.2483C2.2092 16.3492 2.29568 16.4357 2.46863 16.6086L7.39137 21.5314C7.56432 21.7043 7.6508 21.7908 7.75172 21.8526C7.84119 21.9075 7.93873 21.9479 8.04077 21.9724C8.15586 22 8.27815 22 8.52274 22H15.4773C15.7218 22 15.8441 22 15.9592 21.9724C16.0613 21.9479 16.1588 21.9075 16.2483 21.8526C16.3492 21.7908 16.4357 21.7043 16.6086 21.5314L21.5314 16.6086C21.7043 16.4357 21.7908 16.3492 21.8526 16.2483C21.9075 16.1588 21.9479 16.0613 21.9724 15.9592C22 15.8441 22 15.7218 22 15.4773V8.52274C22 8.27815 22 8.15586 21.9724 8.04077C21.9479 7.93873 21.9075 7.84119 21.8526 7.75172C21.7908 7.6508 21.7043 7.56432 21.5314 7.39137L16.6086 2.46863C16.4357 2.29568 16.3492 2.2092 16.2483 2.14736C16.1588 2.09253 16.0613 2.05213 15.9592 2.02763C15.8441 2 15.7218 2 15.4773 2H8.52274C8.27815 2 8.15586 2 8.04077 2.02763C7.93873 2.05213 7.84119 2.09253 7.75172 2.14736C7.6508 2.2092 7.56432 2.29568 7.39137 2.46863L2.46863 7.39137C2.29568 7.56432 2.2092 7.6508 2.14736 7.75172C2.09253 7.84119 2.05213 7.93873 2.02763 8.04077C2 8.15586 2 8.27815 2 8.52274Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'send': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M10.4995 13.5002L20.9995 3.00017M10.6271 13.8282L13.2552 20.5862C13.4867 21.1816 13.6025 21.4792 13.7693 21.5661C13.9139 21.6415 14.0862 21.6416 14.2308 21.5664C14.3977 21.4797 14.5139 21.1822 14.7461 20.5871L21.3364 3.69937C21.5461 3.16219 21.6509 2.8936 21.5935 2.72197C21.5437 2.57292 21.4268 2.45595 21.2777 2.40616C21.1061 2.34883 20.8375 2.45364 20.3003 2.66327L3.41258 9.25361C2.8175 9.48584 2.51997 9.60195 2.43326 9.76885C2.35809 9.91354 2.35819 10.0858 2.43353 10.2304C2.52043 10.3972 2.81811 10.5129 3.41345 10.7445L10.1715 13.3726C10.2923 13.4196 10.3527 13.4431 10.4036 13.4794C10.4487 13.5115 10.4881 13.551 10.5203 13.5961C10.5566 13.6469 10.5801 13.7074 10.6271 13.8282Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'settings': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M12 15C13.6569 15 15 13.6569 15 12C15 10.3431 13.6569 9 12 9C10.3431 9 9 10.3431 9 12C9 13.6569 10.3431 15 12 15Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M18.7273 14.7273C18.6063 15.0015 18.5702 15.3056 18.6236 15.6005C18.6771 15.8954 18.8177 16.1676 19.0273 16.3818L19.0818 16.4364C19.2509 16.6052 19.385 16.8057 19.4765 17.0265C19.568 17.2472 19.6151 17.4838 19.6151 17.7227C19.6151 17.9617 19.568 18.1983 19.4765 18.419C19.385 18.6397 19.2509 18.8402 19.0818 19.0091C18.913 19.1781 18.7124 19.3122 18.4917 19.4037C18.271 19.4952 18.0344 19.5423 17.7955 19.5423C17.5565 19.5423 17.3199 19.4952 17.0992 19.4037C16.8785 19.3122 16.678 19.1781 16.5091 19.0091L16.4545 18.9545C16.2403 18.745 15.9682 18.6044 15.6733 18.5509C15.3784 18.4974 15.0742 18.5335 14.8 18.6545C14.5311 18.7698 14.3018 18.9611 14.1403 19.205C13.9788 19.4489 13.8921 19.7347 13.8909 20.0273V20.1818C13.8909 20.664 13.6994 21.1265 13.3584 21.4675C13.0174 21.8084 12.5549 22 12.0727 22C11.5905 22 11.1281 21.8084 10.7871 21.4675C10.4461 21.1265 10.2545 20.664 10.2545 20.1818V20.1C10.2475 19.7991 10.1501 19.5073 9.97501 19.2625C9.79991 19.0176 9.55521 18.8312 9.27273 18.7273C8.99853 18.6063 8.69437 18.5702 8.39947 18.6236C8.10456 18.6771 7.83244 18.8177 7.61818 19.0273L7.56364 19.0818C7.39478 19.2509 7.19425 19.385 6.97353 19.4765C6.7528 19.568 6.51621 19.6151 6.27727 19.6151C6.03834 19.6151 5.80174 19.568 5.58102 19.4765C5.36029 19.385 5.15977 19.2509 4.99091 19.0818C4.82186 18.913 4.68775 18.7124 4.59626 18.4917C4.50476 18.271 4.45766 18.0344 4.45766 17.7955C4.45766 17.5565 4.50476 17.3199 4.59626 17.0992C4.68775 16.8785 4.82186 16.678 4.99091 16.5091L5.04545 16.4545C5.25503 16.2403 5.39562 15.9682 5.4491 15.6733C5.50257 15.3784 5.46647 15.0742 5.34545 14.8C5.23022 14.5311 5.03887 14.3018 4.79497 14.1403C4.55107 13.9788 4.26526 13.8921 3.97273 13.8909H3.81818C3.33597 13.8909 2.87351 13.6994 2.53253 13.3584C2.19156 13.0174 2 12.5549 2 12.0727C2 11.5905 2.19156 11.1281 2.53253 10.7871C2.87351 10.4461 3.33597 10.2545 3.81818 10.2545H3.9C4.2009 10.2475 4.49273 10.1501 4.73754 9.97501C4.98236 9.79991 5.16883 9.55521 5.27273 9.27273C5.39374 8.99853 5.42984 8.69437 5.37637 8.39947C5.3229 8.10456 5.18231 7.83244 4.97273 7.61818L4.91818 7.56364C4.74913 7.39478 4.61503 7.19425 4.52353 6.97353C4.43203 6.7528 4.38493 6.51621 4.38493 6.27727C4.38493 6.03834 4.43203 5.80174 4.52353 5.58102C4.61503 5.36029 4.74913 5.15977 4.91818 4.99091C5.08704 4.82186 5.28757 4.68775 5.50829 4.59626C5.72901 4.50476 5.96561 4.45766 6.20455 4.45766C6.44348 4.45766 6.68008 4.50476 6.9008 4.59626C7.12152 4.68775 7.32205 4.82186 7.49091 4.99091L7.54545 5.04545C7.75971 5.25503 8.03183 5.39562 8.32674 5.4491C8.62164 5.50257 8.9258 5.46647 9.2 5.34545H9.27273C9.54161 5.23022 9.77093 5.03887 9.93245 4.79497C10.094 4.55107 10.1807 4.26526 10.1818 3.97273V3.81818C10.1818 3.33597 10.3734 2.87351 10.7144 2.53253C11.0553 2.19156 11.5178 2 12 2C12.4822 2 12.9447 2.19156 13.2856 2.53253C13.6266 2.87351 13.8182 3.33597 13.8182 3.81818V3.9C13.8193 4.19253 13.906 4.47834 14.0676 4.72224C14.2291 4.96614 14.4584 5.15749 14.7273 5.27273C15.0015 5.39374 15.3056 5.42984 15.6005 5.37637C15.8954 5.3229 16.1676 5.18231 16.3818 4.97273L16.4364 4.91818C16.6052 4.74913 16.8057 4.61503 17.0265 4.52353C17.2472 4.43203 17.4838 4.38493 17.7227 4.38493C17.9617 4.38493 18.1983 4.43203 18.419 4.52353C18.6397 4.61503 18.8402 4.74913 19.0091 4.91818C19.1781 5.08704 19.3122 5.28757 19.4037 5.50829C19.4952 5.72901 19.5423 5.96561 19.5423 6.20455C19.5423 6.44348 19.4952 6.68008 19.4037 6.9008C19.3122 7.12152 19.1781 7.32205 19.0091 7.49091L18.9545 7.54545C18.745 7.75971 18.6044 8.03183 18.5509 8.32674C18.4974 8.62164 18.5335 8.9258 18.6545 9.2V9.27273C18.7698 9.54161 18.9611 9.77093 19.205 9.93245C19.4489 10.094 19.7347 10.1807 20.0273 10.1818H20.1818C20.664 10.1818 21.1265 10.3734 21.4675 10.7144C21.8084 11.0553 22 11.5178 22 12C22 12.4822 21.8084 12.9447 21.4675 13.2856C21.1265 13.6266 20.664 13.8182 20.1818 13.8182H20.1C19.8075 13.8193 19.5217 13.906 19.2778 14.0676C19.0339 14.2291 18.8425 14.4584 18.7273 14.7273Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'settings-m': /* html */`
    <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M12.1797 15C13.8365 15 15.1797 13.6569 15.1797 12C15.1797 10.3431 13.8365 9 12.1797 9C10.5228 9 9.17969 10.3431 9.17969 12C9.17969 13.6569 10.5228 15 12.1797 15Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
      <path d="M9.46926 19.3711L10.0537 20.6856C10.2275 21.0768 10.511 21.4093 10.8699 21.6426C11.2289 21.8759 11.6478 22.0001 12.0759 22C12.5041 22.0001 12.923 21.8759 13.2819 21.6426C13.6409 21.4093 13.9244 21.0768 14.0982 20.6856L14.6826 19.3711C14.8907 18.9047 15.2406 18.5159 15.6826 18.26C16.1274 18.0034 16.6419 17.8941 17.1526 17.9478L18.5826 18.1C19.0083 18.145 19.4379 18.0656 19.8193 17.8713C20.2007 17.6771 20.5176 17.3763 20.7315 17.0056C20.9457 16.635 21.0477 16.2103 21.0252 15.7829C21.0027 15.3555 20.8567 14.9438 20.6048 14.5978L19.7582 13.4344C19.4567 13.0171 19.2956 12.5148 19.2982 12C19.2981 11.4866 19.4607 10.9864 19.7626 10.5711L20.6093 9.40778C20.8611 9.06175 21.0072 8.65007 21.0297 8.22267C21.0522 7.79528 20.9501 7.37054 20.7359 7C20.522 6.62923 20.2052 6.32849 19.8237 6.13423C19.4423 5.93997 19.0127 5.86053 18.5871 5.90556L17.1571 6.05778C16.6464 6.11141 16.1318 6.00212 15.6871 5.74556C15.2442 5.48825 14.8941 5.09736 14.6871 4.62889L14.0982 3.31444C13.9244 2.92317 13.6409 2.59072 13.2819 2.3574C12.923 2.12408 12.5041 1.99993 12.0759 2C11.6478 1.99993 11.2289 2.12408 10.8699 2.3574C10.511 2.59072 10.2275 2.92317 10.0537 3.31444L9.46926 4.62889C9.26219 5.09736 8.91214 5.48825 8.46926 5.74556C8.02448 6.00212 7.50993 6.11141 6.99926 6.05778L5.56482 5.90556C5.13915 5.86053 4.70956 5.93997 4.32813 6.13423C3.94671 6.32849 3.62983 6.62923 3.41593 7C3.20175 7.37054 3.09971 7.79528 3.1222 8.22267C3.14468 8.65007 3.29072 9.06175 3.5426 9.40778L4.38926 10.5711C4.6912 10.9864 4.8538 11.4866 4.85371 12C4.8538 12.5134 4.6912 13.0137 4.38926 13.4289L3.5426 14.5922C3.29072 14.9382 3.14468 15.3499 3.1222 15.7773C3.09971 16.2047 3.20175 16.6295 3.41593 17C3.63005 17.3706 3.94696 17.6712 4.32833 17.8654C4.7097 18.0596 5.13918 18.1392 5.56482 18.0944L6.99482 17.9422C7.50549 17.8886 8.02003 17.9979 8.46482 18.2544C8.90935 18.511 9.26103 18.902 9.46926 19.3711Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'shield': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M13.3327 8.00026C13.3327 11.2725 9.76335 13.6525 8.46468 14.4101C8.31708 14.4963 8.24328 14.5393 8.13915 14.5617C8.05828 14.579 7.94042 14.579 7.85955 14.5617C7.75542 14.5393 7.68162 14.4963 7.53402 14.4101C6.23532 13.6525 2.66602 11.2725 2.66602 8.00026V4.81197C2.66602 4.27897 2.66602 4.01246 2.75319 3.78337C2.8302 3.581 2.95534 3.40043 3.11779 3.25726C3.30168 3.0952 3.55122 3.00163 4.05028 2.81447L7.62482 1.47402C7.76342 1.42205 7.83268 1.39606 7.90402 1.38576C7.96722 1.37662 8.03148 1.37662 8.09468 1.38576C8.16602 1.39606 8.23528 1.42205 8.37388 1.47402L11.9484 2.81447C12.4475 3.00163 12.697 3.0952 12.8809 3.25726C13.0433 3.40043 13.1685 3.581 13.2455 3.78337C13.3327 4.01246 13.3327 4.27897 13.3327 4.81197V8.00026Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'shield-menu': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M9 11.4999L11 13.4999L15.5 8.99987M20 11.9999C20 16.9083 14.646 20.4783 12.698 21.6147C12.4766 21.7439 12.3659 21.8085 12.2097 21.842C12.0884 21.868 11.9116 21.868 11.7903 21.842C11.6341 21.8085 11.5234 21.7439 11.302 21.6147C9.35396 20.4783 4 16.9083 4 11.9999V7.21747C4 6.41796 4 6.0182 4.13076 5.67457C4.24627 5.37101 4.43398 5.10015 4.67766 4.8854C4.9535 4.64231 5.3278 4.50195 6.0764 4.22122L11.4382 2.21054C11.6461 2.13258 11.75 2.0936 11.857 2.07815C11.9518 2.06444 12.0482 2.06444 12.143 2.07815C12.25 2.0936 12.3539 2.13258 12.5618 2.21054L17.9236 4.22122C18.6722 4.50195 19.0465 4.64231 19.3223 4.8854C19.566 5.10015 19.7537 5.37101 19.8692 5.67457C20 6.0182 20 6.41796 20 7.21747V11.9999Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
    `,
  'stats-report': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M12 3H16.2C17.8802 3 18.7202 3 19.362 3.32698C19.9265 3.6146 20.3854 4.07354 20.673 4.63803C21 5.27976 21 6.11984 21 7.8V16.2C21 17.8802 21 18.7202 20.673 19.362C20.3854 19.9265 19.9265 20.3854 19.362 20.673C18.7202 21 17.8802 21 16.2 21H7.8C6.11984 21 5.27976 21 4.63803 20.673C4.07354 20.3854 3.6146 19.9265 3.32698 19.362C3 18.7202 3 17.8802 3 16.2V12M8 13V17M16 11V17M12 7V17M2 5L5 2M5 2L8 5M5 2V8" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'user': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M5.3163 19.4384C5.92462 18.0052 7.34492 17 9 17H15C16.6551 17 18.0754 18.0052 18.6837 19.4384M16 9.5C16 11.7091 14.2091 13.5 12 13.5C9.79086 13.5 8 11.7091 8 9.5C8 7.29086 9.79086 5.5 12 5.5C14.2091 5.5 16 7.29086 16 9.5ZM22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'websites': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M22 9H2M2 7.8V16.2C2 17.8802 2 18.7202 2.32698 19.362C2.6146 19.9265 3.07354 20.3854 3.63803 20.673C4.27976 21 5.11984 21 6.8 21H17.2C18.8802 21 19.7202 21 20.362 20.673C20.9265 20.3854 21.3854 19.9265 21.673 19.362C22 18.7202 22 17.8802 22 16.2V7.8C22 6.11984 22 5.27977 21.673 4.63803C21.3854 4.07354 20.9265 3.6146 20.362 3.32698C19.7202 3 18.8802 3 17.2 3H6.8C5.11984 3 4.27976 3 3.63803 3.32698C3.07354 3.6146 2.6146 4.07354 2.32698 4.63803C2 5.27976 2 6.11984 2 7.8Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'whotracksme': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M9.33268 7.33325H5.33268M6.66602 9.99992H5.33268M10.666 4.66659H5.33268M13.3327 6.99992V4.53325C13.3327 3.41315 13.3327 2.85309 13.1147 2.42527C12.9229 2.04895 12.617 1.74299 12.2407 1.55124C11.8128 1.33325 11.2528 1.33325 10.1327 1.33325H5.86602C4.74591 1.33325 4.18586 1.33325 3.75804 1.55124C3.38171 1.74299 3.07575 2.04895 2.884 2.42527C2.66602 2.85309 2.66602 3.41315 2.66602 4.53325V11.4666C2.66602 12.5867 2.66602 13.1467 2.884 13.5746C3.07575 13.9509 3.38171 14.2569 3.75804 14.4486C4.18586 14.6666 4.74591 14.6666 5.86602 14.6666H7.66602M14.666 14.6666L13.666 13.6666M14.3327 11.9999C14.3327 13.2886 13.288 14.3333 11.9993 14.3333C10.7107 14.3333 9.66602 13.2886 9.66602 11.9999C9.66602 10.7113 10.7107 9.66658 11.9993 9.66658C13.288 9.66658 14.3327 10.7113 14.3327 11.9999Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'thumb-up': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M7 22V11M2 13V20C2 21.1046 2.89543 22 4 22H17.4262C18.907 22 20.1662 20.9197 20.3914 19.4562L21.4683 12.4562C21.7479 10.6389 20.3418 9 18.5032 9H15C14.4477 9 14 8.55228 14 8V4.46584C14 3.10399 12.896 2 11.5342 2C11.2093 2 10.915 2.1913 10.7831 2.48812L7.26394 10.4061C7.10344 10.7673 6.74532 11 6.35013 11H4C2.89543 11 2 11.8954 2 13Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'trash': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M16 6V5.2C16 4.0799 16 3.51984 15.782 3.09202C15.5903 2.71569 15.2843 2.40973 14.908 2.21799C14.4802 2 13.9201 2 12.8 2H11.2C10.0799 2 9.51984 2 9.09202 2.21799C8.71569 2.40973 8.40973 2.71569 8.21799 3.09202C8 3.51984 8 4.0799 8 5.2V6M3 6H21M19 6V17.2C19 18.8802 19 19.7202 18.673 20.362C18.3854 20.9265 17.9265 21.3854 17.362 21.673C16.7202 22 15.8802 22 14.2 22H9.8C8.11984 22 7.27976 22 6.63803 21.673C6.07354 21.3854 5.6146 20.9265 5.32698 20.362C5 19.7202 5 18.8802 5 17.2V6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'trust-s': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M5.00065 7.99943L7.00065 9.99943L11.0007 5.99943M14.6673 7.99943C14.6673 11.6813 11.6825 14.6661 8.00065 14.6661C4.31875 14.6661 1.33398 11.6813 1.33398 7.99943C1.33398 4.31753 4.31875 1.33276 8.00065 1.33276C11.6825 1.33276 14.6673 4.31753 14.6673 7.99943Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'trust-m': /* html */`
    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
      <path d="M7.50049 11.9992L10.5005 14.9992L16.5005 8.99922M22.0005 11.9992C22.0005 17.522 17.5233 21.9992 12.0005 21.9992C6.47764 21.9992 2.00049 17.522 2.00049 11.9992C2.00049 6.47637 6.47764 1.99922 12.0005 1.99922C17.5233 1.99922 22.0005 6.47637 22.0005 11.9992Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'slogan': /* html */`
    <svg id="slogan" width="117" height="40" viewBox="0 0 117 40" fill="none" xmlns="http://www.w3.org/2000/svg">
      <rect width="2" height="40" fill="currentColor" />
      <path d="M13.2422 15.2969L15.0625 5.625H16.2656L16.625 7.125L14.6719 17H13.3672L13.2422 15.2969ZM12.6172 5.625L14.0859 15.3203L13.8359 17H12.3984L10.3594 5.625H12.6172ZM17.9453 15.2812L19.4062 5.625H21.6562L19.6328 17H18.1875L17.9453 15.2812ZM16.9609 5.625L18.7969 15.3516L18.6484 17H17.3438L15.3984 7.10938L15.7656 5.625H16.9609ZM29.4453 15.1094V17H24.5V15.1094H29.4453ZM25.2109 5.625V17H22.9219V5.625H25.2109ZM28.7812 10.2344V12.0703H24.5V10.2344H28.7812ZM29.4297 5.625V7.52344H24.5V5.625H29.4297ZM35.2812 5.625H37.2891L39.6094 13.4062L41.9219 5.625H43.6953L40.4609 17H38.75L35.2812 5.625ZM34.4688 5.625H36.3828L36.6797 13.125V17H34.4688V5.625ZM42.8203 5.625H44.7422V17H42.5391V13.125L42.8203 5.625ZM50.8672 7.65625L48.4219 17H46.0078L49.5625 5.625H51.0703L50.8672 7.65625ZM52.7969 17L50.3359 7.65625L50.1094 5.625H51.6406L55.2266 17H52.7969ZM52.8828 12.7578V14.6562H47.75V12.7578H52.8828ZM58.6016 5.625V17H56.3125V5.625H58.6016ZM64.25 5.625L60.5625 11.2734L58.3047 14.0859L57.8672 11.7969L59.3281 9.35938L61.4688 5.625H64.25ZM61.6094 17L59.125 11.7734L60.8047 10.2891L64.3047 17H61.6094ZM71.6953 15.1094V17H66.75V15.1094H71.6953ZM67.4609 5.625V17H65.1719V5.625H67.4609ZM71.0312 10.2344V12.0703H66.75V10.2344H71.0312ZM71.6797 5.625V7.52344H66.75V5.625H71.6797ZM14.7969 28.9922H12.4688V27.0938H14.7969C15.1198 27.0938 15.3828 27.0208 15.5859 26.875C15.7943 26.7292 15.9453 26.5286 16.0391 26.2734C16.1328 26.013 16.1797 25.7214 16.1797 25.3984C16.1797 25.0703 16.1302 24.7656 16.0312 24.4844C15.9375 24.1979 15.7891 23.9661 15.5859 23.7891C15.388 23.612 15.125 23.5234 14.7969 23.5234H13.2031V33H10.9219V21.625H14.7969C15.5625 21.625 16.2214 21.7865 16.7734 22.1094C17.3255 22.4323 17.7474 22.8776 18.0391 23.4453C18.3359 24.0078 18.4844 24.6536 18.4844 25.3828C18.4844 26.1172 18.3359 26.7552 18.0391 27.2969C17.7474 27.8333 17.3255 28.25 16.7734 28.5469C16.2214 28.8438 15.5625 28.9922 14.7969 28.9922ZM20.0234 21.625H23.6719C24.4323 21.625 25.0807 21.7552 25.6172 22.0156C26.1536 22.276 26.5651 22.6615 26.8516 23.1719C27.138 23.6823 27.2812 24.3125 27.2812 25.0625C27.2812 25.6771 27.1979 26.2031 27.0312 26.6406C26.8646 27.0729 26.6276 27.4349 26.3203 27.7266C26.013 28.013 25.6458 28.2422 25.2188 28.4141L24.5234 28.8281H21.5625L21.5547 26.9297H23.6094C23.9219 26.9297 24.1797 26.862 24.3828 26.7266C24.5911 26.5859 24.7448 26.3906 24.8438 26.1406C24.9479 25.8854 25 25.5885 25 25.25C25 24.8906 24.9531 24.5833 24.8594 24.3281C24.7708 24.0677 24.6276 23.8698 24.4297 23.7344C24.237 23.5938 23.9844 23.5234 23.6719 23.5234H22.3125V33H20.0234V21.625ZM25.1875 33L23.1016 27.9297L25.5 27.9219L27.6328 32.8906V33H25.1875ZM31.25 21.625V33H28.9766V21.625H31.25ZM36.7422 30.5703L38.8984 21.625H41.3672L38.0703 33H36.4062L36.7422 30.5703ZM34.8984 21.625L37.0469 30.5703L37.3984 33H35.7266L32.4531 21.625H34.8984ZM45.9766 23.6562L43.5312 33H41.1172L44.6719 21.625H46.1797L45.9766 23.6562ZM47.9062 33L45.4453 23.6562L45.2188 21.625H46.75L50.3359 33H47.9062ZM47.9922 28.7578V30.6562H42.8594V28.7578H47.9922ZM56.6719 29.2109H58.9453C58.9141 30.0651 58.7422 30.7865 58.4297 31.375C58.1172 31.9583 57.6719 32.401 57.0938 32.7031C56.5208 33.0052 55.8281 33.1562 55.0156 33.1562C54.3854 33.1562 53.8255 33.0521 53.3359 32.8438C52.8464 32.6302 52.4297 32.3177 52.0859 31.9062C51.7422 31.4948 51.4818 30.987 51.3047 30.3828C51.1328 29.7734 51.0469 29.0729 51.0469 28.2812V26.3516C51.0469 25.5599 51.138 24.8594 51.3203 24.25C51.5078 23.6406 51.7734 23.1302 52.1172 22.7188C52.4661 22.3021 52.8854 21.9896 53.375 21.7812C53.8698 21.5677 54.4271 21.4609 55.0469 21.4609C55.875 21.4609 56.5677 21.6172 57.125 21.9297C57.6823 22.2422 58.112 22.6979 58.4141 23.2969C58.7214 23.8906 58.9062 24.6172 58.9688 25.4766H56.6875C56.6719 24.9349 56.6094 24.5104 56.5 24.2031C56.3958 23.8906 56.2292 23.6719 56 23.5469C55.7708 23.4167 55.4531 23.3516 55.0469 23.3516C54.7448 23.3516 54.4844 23.4062 54.2656 23.5156C54.0469 23.6198 53.8672 23.7891 53.7266 24.0234C53.5859 24.2578 53.4818 24.5651 53.4141 24.9453C53.3516 25.3255 53.3203 25.7891 53.3203 26.3359V28.2812C53.3203 28.8177 53.349 29.276 53.4062 29.6562C53.4635 30.0312 53.5547 30.3385 53.6797 30.5781C53.8047 30.8177 53.974 30.9922 54.1875 31.1016C54.4062 31.2109 54.6823 31.2656 55.0156 31.2656C55.401 31.2656 55.7109 31.2083 55.9453 31.0938C56.1849 30.9792 56.362 30.7734 56.4766 30.4766C56.5911 30.1797 56.6562 29.7578 56.6719 29.2109ZM62.0625 21.625L63.7969 26.75L65.5156 21.625H68.0078L64.9453 28.8672V33H62.6406V28.8672L59.5781 21.625H62.0625ZM79.2734 31.1094V33H74.3281V31.1094H79.2734ZM75.0391 21.625V33H72.75V21.625H75.0391ZM78.6094 26.2344V28.0703H74.3281V26.2344H78.6094ZM79.2578 21.625V23.5234H74.3281V21.625H79.2578ZM84.7266 23.6562L82.2812 33H79.8672L83.4219 21.625H84.9297L84.7266 23.6562ZM86.6562 33L84.1953 23.6562L83.9688 21.625H85.5L89.0859 33H86.6562ZM86.7422 28.7578V30.6562H81.6094V28.7578H86.7422ZM94.9844 30.0078C94.9844 29.8047 94.9661 29.6198 94.9297 29.4531C94.8932 29.2865 94.8151 29.1328 94.6953 28.9922C94.5807 28.8516 94.4115 28.7109 94.1875 28.5703C93.9688 28.4297 93.6823 28.2839 93.3281 28.1328C92.9062 27.9557 92.4974 27.7682 92.1016 27.5703C91.7057 27.3672 91.349 27.1328 91.0312 26.8672C90.7135 26.6016 90.4609 26.2891 90.2734 25.9297C90.0911 25.5651 90 25.138 90 24.6484C90 24.1693 90.0859 23.7344 90.2578 23.3438C90.4349 22.9531 90.6849 22.6198 91.0078 22.3438C91.3307 22.0625 91.7083 21.8464 92.1406 21.6953C92.5781 21.5443 93.0651 21.4688 93.6016 21.4688C94.3307 21.4688 94.9609 21.6198 95.4922 21.9219C96.0286 22.224 96.4427 22.638 96.7344 23.1641C97.0312 23.6901 97.1797 24.2943 97.1797 24.9766H94.8984C94.8984 24.6536 94.8516 24.3698 94.7578 24.125C94.6693 23.875 94.526 23.6797 94.3281 23.5391C94.1302 23.3984 93.875 23.3281 93.5625 23.3281C93.2708 23.3281 93.0286 23.388 92.8359 23.5078C92.6484 23.6224 92.5078 23.7812 92.4141 23.9844C92.3255 24.1823 92.2812 24.4062 92.2812 24.6562C92.2812 24.8438 92.3255 25.013 92.4141 25.1641C92.5078 25.3099 92.6354 25.4427 92.7969 25.5625C92.9583 25.6771 93.1484 25.7891 93.3672 25.8984C93.5911 26.0078 93.8359 26.1146 94.1016 26.2188C94.6172 26.4219 95.0729 26.6458 95.4688 26.8906C95.8646 27.1302 96.1953 27.401 96.4609 27.7031C96.7266 28 96.9271 28.3359 97.0625 28.7109C97.1979 29.0859 97.2656 29.513 97.2656 29.9922C97.2656 30.4661 97.1823 30.8984 97.0156 31.2891C96.8542 31.6745 96.6172 32.0078 96.3047 32.2891C95.9922 32.5651 95.6146 32.7786 95.1719 32.9297C94.7344 33.0807 94.2448 33.1562 93.7031 33.1562C93.1771 33.1562 92.6797 33.0833 92.2109 32.9375C91.7422 32.7865 91.3281 32.5599 90.9688 32.2578C90.6146 31.9505 90.3359 31.5625 90.1328 31.0938C89.9297 30.6198 89.8281 30.0599 89.8281 29.4141H92.1172C92.1172 29.7578 92.151 30.0521 92.2188 30.2969C92.2865 30.5365 92.3906 30.7292 92.5312 30.875C92.6719 31.0156 92.8438 31.1224 93.0469 31.1953C93.2552 31.263 93.4922 31.2969 93.7578 31.2969C94.0599 31.2969 94.2995 31.2396 94.4766 31.125C94.6589 31.0104 94.7891 30.8568 94.8672 30.6641C94.9453 30.4714 94.9844 30.2526 94.9844 30.0078ZM100.5 21.625L102.234 26.75L103.953 21.625H106.445L103.383 28.8672V33H101.078V28.8672L98.0156 21.625H100.5ZM105.773 31.8828C105.773 31.5391 105.888 31.2526 106.117 31.0234C106.346 30.7891 106.656 30.6719 107.047 30.6719C107.438 30.6719 107.747 30.7891 107.977 31.0234C108.206 31.2526 108.32 31.5391 108.32 31.8828C108.32 32.2266 108.206 32.513 107.977 32.7422C107.747 32.9714 107.438 33.0859 107.047 33.0859C106.656 33.0859 106.346 32.9714 106.117 32.7422C105.888 32.513 105.773 32.2266 105.773 31.8828Z" fill="currentColor" />
    </svg>
  `,
  'search': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M21 21L15.0001 15M17 10C17 13.866 13.866 17 10 17C6.13401 17 3 13.866 3 10C3 6.13401 6.13401 3 10 3C13.866 3 17 6.13401 17 10Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
  'warning': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M12 6.75C12.4142 6.75 12.75 7.08579 12.75 7.5V12.75C12.75 13.1642 12.4142 13.5 12 13.5C11.5858 13.5 11.25 13.1642 11.25 12.75V7.5C11.25 7.08579 11.5858 6.75 12 6.75Z" fill="currentColor"/>
      <path d="M13.125 16.125C13.125 16.7463 12.6213 17.25 12 17.25C11.3787 17.25 10.875 16.7463 10.875 16.125C10.875 15.5037 11.3787 15 12 15C12.6213 15 13.125 15.5037 13.125 16.125Z" fill="currentColor"/>
      <path fill-rule="evenodd" clip-rule="evenodd" d="M2.25 12C2.25 6.61522 6.61522 2.25 12 2.25C17.3848 2.25 21.75 6.61522 21.75 12C21.75 17.3848 17.3848 21.75 12 21.75C6.61522 21.75 2.25 17.3848 2.25 12ZM12 3.75C7.44365 3.75 3.75 7.44365 3.75 12C3.75 16.5563 7.44365 20.25 12 20.25C16.5563 20.25 20.25 16.5563 20.25 12C20.25 7.44365 16.5563 3.75 12 3.75Z" fill="currentColor"/>
    </svg>
  `,
  'wtm': /* html */`
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M2.5 6V12.5H1.5V4.5H22.5V19.5H1.5V16.5H2.5V18V18.5H3H21H21.5V18V6V5.5H21H3H2.5V6Z" fill="black" stroke="currentColor"/>
    </svg>
  `,
  'wtm-border': /* html */`
    <svg width="56" height="56" viewBox="0 0 56 56" fill="none" xmlns="http://www.w3.org/2000/svg">
      <g filter="url(#filter0_i_1558_1884)">
      <rect width="56" height="56" rx="12" fill="white"/>
      <rect x="0.5" y="0.5" width="55" height="55" rx="11.5" stroke="#E0E2E6"/>
      <mask id="path-3-outside-1_1558_1884" maskUnits="userSpaceOnUse" x="14.8" y="13.2002" width="26" height="29" fill="black">
      <rect fill="white" x="14.8" y="13.2002" width="26" height="29"/>
      <path fill-rule="evenodd" clip-rule="evenodd" d="M38.5666 36.459C37.505 34.0178 37.3222 31.9493 37.2937 31.1365V24.4495C37.2937 19.3411 33.1319 15.2002 27.9984 15.2002C22.8643 15.2002 18.7024 19.3411 18.7024 24.4495V31.2332C18.6627 32.1076 18.4541 34.1129 17.4334 36.459C16.0615 39.6117 17.1969 39.2359 18.2139 38.9766C19.2307 38.7183 21.5016 37.7057 22.211 38.9531C22.9201 40.1999 23.5117 41.2827 25.1673 40.5766C26.8229 39.8709 27.6031 39.6357 27.8395 39.6357H28.161C28.3971 39.6357 29.1776 39.8709 30.8331 40.5766C32.4886 41.2827 33.0799 40.1999 33.7895 38.9531C34.4986 37.7057 36.7694 38.7183 37.7865 38.9766C38.8034 39.2359 39.9382 39.6117 38.5666 36.459Z"/>
      </mask>
      <path fill-rule="evenodd" clip-rule="evenodd" d="M38.5666 36.459C37.505 34.0178 37.3222 31.9493 37.2937 31.1365V24.4495C37.2937 19.3411 33.1319 15.2002 27.9984 15.2002C22.8643 15.2002 18.7024 19.3411 18.7024 24.4495V31.2332C18.6627 32.1076 18.4541 34.1129 17.4334 36.459C16.0615 39.6117 17.1969 39.2359 18.2139 38.9766C19.2307 38.7183 21.5016 37.7057 22.211 38.9531C22.9201 40.1999 23.5117 41.2827 25.1673 40.5766C26.8229 39.8709 27.6031 39.6357 27.8395 39.6357H28.161C28.3971 39.6357 29.1776 39.8709 30.8331 40.5766C32.4886 41.2827 33.0799 40.1999 33.7895 38.9531C34.4986 37.7057 36.7694 38.7183 37.7865 38.9766C38.8034 39.2359 39.9382 39.6117 38.5666 36.459Z" fill="url(#paint0_linear_1558_1884)"/>
      <path fill-rule="evenodd" clip-rule="evenodd" d="M38.5666 36.459C37.505 34.0178 37.3222 31.9493 37.2937 31.1365V24.4495C37.2937 19.3411 33.1319 15.2002 27.9984 15.2002C22.8643 15.2002 18.7024 19.3411 18.7024 24.4495V31.2332C18.6627 32.1076 18.4541 34.1129 17.4334 36.459C16.0615 39.6117 17.1969 39.2359 18.2139 38.9766C19.2307 38.7183 21.5016 37.7057 22.211 38.9531C22.9201 40.1999 23.5117 41.2827 25.1673 40.5766C26.8229 39.8709 27.6031 39.6357 27.8395 39.6357H28.161C28.3971 39.6357 29.1776 39.8709 30.8331 40.5766C32.4886 41.2827 33.0799 40.1999 33.7895 38.9531C34.4986 37.7057 36.7694 38.7183 37.7865 38.9766C38.8034 39.2359 39.9382 39.6117 38.5666 36.459Z" fill="url(#paint1_linear_1558_1884)"/>
      <path d="M37.2937 31.1365H36.0937V31.1575L36.0944 31.1786L37.2937 31.1365ZM18.7024 31.2332L19.9011 31.2876L19.9024 31.2604V31.2332H18.7024ZM17.4334 36.459L18.5338 36.9379L18.5338 36.9378L17.4334 36.459ZM18.2139 38.9766L17.9184 37.8136L17.9173 37.8138L18.2139 38.9766ZM22.211 38.9531L21.1679 39.5463L21.1679 39.5463L22.211 38.9531ZM25.1673 40.5766L24.6967 39.4727L24.6965 39.4728L25.1673 40.5766ZM30.8331 40.5766L31.3038 39.4728L31.3037 39.4728L30.8331 40.5766ZM33.7895 38.9531L34.8324 39.5466L34.8327 39.5461L33.7895 38.9531ZM37.7865 38.9766L38.083 37.8138L38.0819 37.8135L37.7865 38.9766ZM39.6671 35.9805C38.6824 33.7162 38.5179 31.806 38.4929 31.0945L36.0944 31.1786C36.1265 32.0925 36.3276 34.3194 37.4662 36.9376L39.6671 35.9805ZM38.4937 31.1365V24.4495H36.0937V31.1365H38.4937ZM38.4937 24.4495C38.4937 18.6727 33.789 14.0002 27.9984 14.0002V16.4002C32.4748 16.4002 36.0937 20.0094 36.0937 24.4495H38.4937ZM27.9984 14.0002C22.2073 14.0002 17.5024 18.6726 17.5024 24.4495H19.9024C19.9024 20.0095 23.5213 16.4002 27.9984 16.4002V14.0002ZM17.5024 24.4495V31.2332H19.9024V24.4495H17.5024ZM17.5036 31.1788C17.4685 31.9527 17.2795 33.8048 16.333 35.9803L18.5338 36.9378C19.6287 34.4209 19.8569 32.2624 19.9011 31.2876L17.5036 31.1788ZM16.3331 35.9802C15.9771 36.7982 15.7465 37.4684 15.6515 38.0124C15.5675 38.4929 15.5252 39.2292 16.0334 39.7974C16.5605 40.3866 17.2848 40.36 17.5875 40.3302C17.9306 40.2965 18.3069 40.1913 18.5104 40.1394L17.9173 37.8138C17.6124 37.8916 17.4653 37.9307 17.3525 37.9418C17.307 37.9462 17.342 37.9366 17.422 37.9546C17.5172 37.976 17.6807 38.0391 17.8222 38.1973C17.96 38.3514 17.992 38.501 17.9983 38.5469C18.0033 38.5836 17.993 38.555 18.0157 38.4254C18.0618 38.1613 18.2037 37.6962 18.5338 36.9379L16.3331 35.9802ZM18.5093 40.1397C18.7988 40.0661 19.2046 39.9317 19.5172 39.8365C19.8714 39.7286 20.2118 39.6357 20.5234 39.5841C20.8471 39.5306 21.0505 39.5379 21.1582 39.563C21.2028 39.5733 21.2084 39.5818 21.1951 39.5726C21.1779 39.5607 21.1679 39.5463 21.1679 39.5463L23.2541 38.3598C22.881 37.7038 22.292 37.3627 21.7021 37.2254C21.1527 37.0976 20.5918 37.1403 20.132 37.2163C19.6601 37.2943 19.1978 37.4249 18.818 37.5406C18.3967 37.6689 18.1373 37.7579 17.9184 37.8136L18.5093 40.1397ZM21.1679 39.5463C21.4769 40.0895 21.925 40.9314 22.6064 41.4513C22.9912 41.7448 23.4611 41.9525 24.0198 41.993C24.5614 42.0323 25.1031 41.9086 25.638 41.6805L24.6965 39.4728C24.4036 39.5977 24.2505 39.6034 24.1934 39.5993C24.1535 39.5964 24.1207 39.5878 24.062 39.5431C23.9853 39.4845 23.8776 39.3717 23.7311 39.1565C23.5832 38.9394 23.4393 38.6854 23.2541 38.3598L21.1679 39.5463ZM25.6378 41.6805C26.4507 41.334 27.0297 41.1112 27.4226 40.9774C27.6196 40.9103 27.7571 40.8699 27.8462 40.8476C27.959 40.8194 27.9341 40.8357 27.8395 40.8357V38.4357C27.6266 38.4357 27.4156 38.4814 27.2639 38.5193C27.0884 38.5632 26.8832 38.6257 26.6486 38.7056C26.1784 38.8658 25.5395 39.1135 24.6967 39.4727L25.6378 41.6805ZM27.8395 40.8357H28.161V38.4357H27.8395V40.8357ZM28.161 40.8357C28.0662 40.8357 28.0413 40.8194 28.1541 40.8476C28.2432 40.8699 28.3808 40.9103 28.5778 40.9774C28.9707 41.1112 29.5497 41.334 30.3625 41.6805L31.3037 39.4728C30.4609 39.1135 29.822 38.8658 29.3517 38.7056C29.1172 38.6257 28.9119 38.5632 28.7365 38.5193C28.5849 38.4814 28.3739 38.4357 28.161 38.4357V40.8357ZM30.3623 41.6805C30.8972 41.9086 31.4389 42.0323 31.9805 41.993C32.5392 41.9525 33.0091 41.7448 33.3938 41.4512C34.0752 40.9315 34.5234 40.0896 34.8324 39.5466L32.7466 38.3595C32.5612 38.6852 32.4172 38.9392 32.2693 39.1564C32.1226 39.3717 32.015 39.4845 31.9382 39.5431C31.8795 39.5879 31.8468 39.5964 31.8069 39.5993C31.7498 39.6034 31.5967 39.5977 31.3038 39.4728L30.3623 41.6805ZM34.8327 39.5461C34.834 39.5438 34.832 39.5478 34.8255 39.5549C34.819 39.562 34.8118 39.5681 34.8054 39.5725C34.7921 39.5817 34.7976 39.5733 34.8421 39.563C34.9497 39.5379 35.1531 39.5306 35.4768 39.5841C35.7884 39.6357 36.1288 39.7286 36.483 39.8365C36.7957 39.9317 37.2015 40.0661 37.4911 40.1397L38.0819 37.8135C37.8629 37.7579 37.6035 37.6689 37.1822 37.5406C36.8024 37.4249 36.3401 37.2943 35.8682 37.2163C35.4084 37.1403 34.8476 37.0976 34.2982 37.2254C33.7083 37.3627 33.1193 37.7039 32.7463 38.36L34.8327 39.5461ZM37.49 40.1394C37.6934 40.1913 38.0696 40.2965 38.4128 40.3302C38.7154 40.36 39.4398 40.3867 39.9669 39.7972C40.4749 39.229 40.4324 38.4928 40.3485 38.0124C40.2534 37.4684 40.0229 36.7983 39.667 35.9803L37.4663 36.9378C37.7962 37.6962 37.9381 38.1613 37.9843 38.4255C38.007 38.5551 37.9967 38.5837 38.0017 38.5471C38.008 38.5012 38.0399 38.3516 38.1777 38.1975C38.3192 38.0393 38.4828 37.9761 38.5781 37.9546C38.6582 37.9366 38.6933 37.9462 38.6478 37.9418C38.535 37.9307 38.388 37.8916 38.083 37.8138L37.49 40.1394Z" fill="white" mask="url(#path-3-outside-1_1558_1884)"/>
      <path fill-rule="evenodd" clip-rule="evenodd" d="M27.7231 21.6001C27.7265 21.6001 27.73 21.6001 27.7333 21.6001H28.8C28.8034 21.6001 28.8068 21.6001 28.8103 21.6001C28.8632 21.6001 28.9264 21.6001 28.9821 21.6046C29.0467 21.6099 29.1391 21.6234 29.236 21.6728C29.3614 21.7367 29.4634 21.8387 29.5273 21.9641C29.5767 22.061 29.5902 22.1534 29.5955 22.218C29.6 22.2736 29.6 22.3369 29.6 22.3898C29.6 22.3933 29.6 22.3967 29.6 22.4001V23.4668C29.6 23.4701 29.6 23.4736 29.6 23.477C29.6 23.53 29.6 23.5932 29.5955 23.6489C29.5902 23.7134 29.5767 23.8059 29.5273 23.9028C29.4634 24.0282 29.3614 24.1302 29.236 24.1941C29.1391 24.2435 29.0467 24.257 28.9821 24.2623C28.9264 24.2668 28.8632 24.2668 28.8103 24.2668C28.8068 24.2668 28.8034 24.2668 28.8 24.2668H27.7333C27.73 24.2668 27.7265 24.2668 27.7231 24.2668C27.6701 24.2668 27.6069 24.2668 27.5512 24.2623C27.4866 24.257 27.3942 24.2435 27.2973 24.1941C27.1719 24.1302 27.0699 24.0282 27.006 23.9028C26.9566 23.8059 26.9431 23.7134 26.9378 23.6489C26.9333 23.5932 26.9333 23.53 26.9333 23.477C26.9333 23.4736 26.9333 23.4701 26.9333 23.4668V22.4001C26.9333 22.3967 26.9333 22.3933 26.9333 22.3898C26.9333 22.3369 26.9333 22.2736 26.9378 22.218C26.9431 22.1534 26.9566 22.061 27.006 21.9641C27.0699 21.8387 27.1719 21.7367 27.2973 21.6728C27.3942 21.6234 27.4866 21.6099 27.5512 21.6046C27.6069 21.6001 27.6701 21.6001 27.7231 21.6001Z" fill="white"/>
      <path fill-rule="evenodd" clip-rule="evenodd" d="M24.5231 24.7998C24.5265 24.7998 24.53 24.7998 24.5333 24.7998H25.6C25.6034 24.7998 25.6068 24.7998 25.6103 24.7998C25.6632 24.7998 25.7264 24.7998 25.7821 24.8043C25.8467 24.8096 25.9391 24.8231 26.036 24.8725C26.1614 24.9364 26.2634 25.0384 26.3273 25.1638C26.3767 25.2607 26.3902 25.3531 26.3955 25.4177C26.4 25.4734 26.4 25.5366 26.4 25.5895C26.4 25.593 26.4 25.5964 26.4 25.5998V26.6665C26.4 26.6698 26.4 26.6733 26.4 26.6768C26.4 26.7297 26.4 26.7929 26.3955 26.8486C26.3902 26.9132 26.3767 27.0056 26.3273 27.1025C26.2634 27.2279 26.1614 27.3299 26.036 27.3938C25.9391 27.4432 25.8467 27.4567 25.7821 27.462C25.7264 27.4665 25.6632 27.4665 25.6103 27.4665C25.6068 27.4665 25.6034 27.4665 25.6 27.4665H24.5333C24.53 27.4665 24.5265 27.4665 24.5231 27.4665C24.4701 27.4665 24.4069 27.4665 24.3512 27.462C24.2866 27.4567 24.1942 27.4432 24.0973 27.3938C23.9719 27.3299 23.8699 27.2279 23.806 27.1025C23.7566 27.0056 23.7431 26.9132 23.7378 26.8486C23.7333 26.7929 23.7333 26.7297 23.7333 26.6768C23.7333 26.6733 23.7333 26.6698 23.7333 26.6665V25.5998C23.7333 25.5964 23.7333 25.593 23.7333 25.5895C23.7333 25.5366 23.7333 25.4734 23.7378 25.4177C23.7431 25.3531 23.7566 25.2607 23.806 25.1638C23.8699 25.0384 23.9719 24.9364 24.0973 24.8725C24.1942 24.8231 24.2866 24.8096 24.3512 24.8043C24.4069 24.7998 24.4701 24.7998 24.5231 24.7998Z" fill="white"/>
      <path fill-rule="evenodd" clip-rule="evenodd" d="M23.4564 20.5332C23.4599 20.5332 23.4634 20.5332 23.4667 20.5332H24.5334C24.5368 20.5332 24.5402 20.5332 24.5437 20.5332C24.5966 20.5332 24.6598 20.5332 24.7155 20.5377C24.7801 20.543 24.8725 20.5565 24.9694 20.6059C25.0948 20.6698 25.1968 20.7718 25.2607 20.8972C25.3101 20.9941 25.3236 21.0865 25.3289 21.1511C25.3334 21.2068 25.3334 21.27 25.3334 21.3229C25.3334 21.3264 25.3334 21.3298 25.3334 21.3332V22.3999C25.3334 22.4032 25.3334 22.4067 25.3334 22.4102C25.3334 22.4631 25.3334 22.5263 25.3289 22.582C25.3236 22.6466 25.3101 22.739 25.2607 22.8359C25.1968 22.9613 25.0948 23.0633 24.9694 23.1272C24.8725 23.1766 24.7801 23.1901 24.7155 23.1954C24.6598 23.1999 24.5966 23.1999 24.5437 23.1999C24.5402 23.1999 24.5368 23.1999 24.5334 23.1999H23.4667C23.4634 23.1999 23.4599 23.1999 23.4564 23.1999C23.4035 23.1999 23.3403 23.1999 23.2846 23.1954C23.22 23.1901 23.1276 23.1766 23.0307 23.1272C22.9053 23.0633 22.8033 22.9613 22.7394 22.8359C22.69 22.739 22.6765 22.6466 22.6712 22.582C22.6667 22.5263 22.6667 22.4631 22.6667 22.4102C22.6667 22.4067 22.6667 22.4032 22.6667 22.3999V21.3332C22.6667 21.3298 22.6667 21.3264 22.6667 21.3229C22.6667 21.27 22.6667 21.2068 22.6712 21.1511C22.6765 21.0865 22.69 20.9941 22.7394 20.8972C22.8033 20.7718 22.9053 20.6698 23.0307 20.6059C23.1276 20.5565 23.22 20.543 23.2846 20.5377C23.3403 20.5332 23.4035 20.5332 23.4564 20.5332Z" fill="white"/>
      <path d="M33.8667 23.7335C33.8667 23.439 33.6279 23.2002 33.3333 23.2002H31.2C30.9054 23.2002 30.6667 23.439 30.6667 23.7335V25.6002C30.6667 25.7475 30.5473 25.8669 30.4 25.8669H28.5333C28.2388 25.8669 28 26.1056 28 26.4002V28.2669C28 28.4141 27.8806 28.5335 27.7333 28.5335H25.8667C25.5721 28.5335 25.3333 28.7723 25.3333 29.0669V31.2002C25.3333 31.4947 25.5721 31.7335 25.8667 31.7335H33.3333C33.6279 31.7335 33.8667 31.4947 33.8667 31.2002V23.7335Z" fill="white"/>
      </g>
      <defs>
      <filter id="filter0_i_1558_1884" x="0" y="0" width="56" height="56" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
      <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
      <feOffset/>
      <feGaussianBlur stdDeviation="4"/>
      <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1"/>
      <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.07 0"/>
      <feBlend mode="normal" in2="shape" result="effect1_innerShadow_1558_1884"/>
      </filter>
      <linearGradient id="paint0_linear_1558_1884" x1="22.0822" y1="17.3339" x2="35.9269" y2="32.5915" gradientUnits="userSpaceOnUse">
      <stop stop-color="#67A73A"/>
      <stop offset="1" stop-color="#00AEF0"/>
      </linearGradient>
      <linearGradient id="paint1_linear_1558_1884" x1="18.7526" y1="21.402" x2="37.0444" y2="39.5674" gradientUnits="userSpaceOnUse">
      <stop offset="0.0978647" stop-color="#503FBB"/>
      <stop offset="1" stop-color="#01AEF1"/>
      </linearGradient>
      </defs>
    </svg>
  `,
  'wtm-logo': /* html */`
    <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path fill-rule="evenodd" clip-rule="evenodd" d="M29.2083 26.5736C27.8812 23.522 27.6527 20.9363 27.6171 19.9204V11.5616C27.6171 5.17607 22.4149 0 15.998 0C9.58037 0 4.37796 5.17607 4.37796 11.5616V20.0412C4.32838 21.1342 4.06763 23.6408 2.79177 26.5736C1.0769 30.5144 2.49611 30.0447 3.76732 29.7205C5.03835 29.3976 7.87696 28.1319 8.76374 29.6911C9.65017 31.2496 10.3897 32.6031 12.4591 31.7206C14.5286 30.8384 15.5038 30.5444 15.7993 30.5444H16.2013C16.4964 30.5444 17.472 30.8384 19.5414 31.7206C21.6108 32.6031 22.3499 31.2496 23.2369 29.6911C24.1233 28.1319 26.9617 29.3976 28.2331 29.7205C29.5043 30.0447 30.9228 30.5144 29.2083 26.5736Z" fill="url(#paint0_linear_289_22287)"/>
      <path fill-rule="evenodd" clip-rule="evenodd" d="M15.6532 8C15.6575 8 15.6618 8 15.666 8H16.9993C17.0036 8 17.0079 8 17.0122 8C17.0784 7.99998 17.1574 7.99995 17.227 8.00564C17.3077 8.01223 17.4233 8.02914 17.5443 8.09083C17.7011 8.17073 17.8286 8.29821 17.9085 8.45501C17.9702 8.57609 17.9871 8.69164 17.9937 8.77232C17.9994 8.84194 17.9994 8.92097 17.9993 8.98714C17.9993 8.99149 17.9993 8.99578 17.9993 9V10.3333C17.9993 10.3376 17.9993 10.3418 17.9993 10.3462C17.9994 10.4124 17.9994 10.4914 17.9937 10.561C17.9871 10.6417 17.9702 10.7572 17.9085 10.8783C17.8286 11.0351 17.7011 11.1626 17.5443 11.2425C17.4233 11.3042 17.3077 11.3211 17.227 11.3277C17.1574 11.3334 17.0784 11.3334 17.0122 11.3333C17.0079 11.3333 17.0036 11.3333 16.9993 11.3333H15.666C15.6618 11.3333 15.6575 11.3333 15.6532 11.3333C15.587 11.3334 15.508 11.3334 15.4383 11.3277C15.3577 11.3211 15.2421 11.3042 15.121 11.2425C14.9642 11.1626 14.8367 11.0351 14.7568 10.8783C14.6952 10.7572 14.6782 10.6417 14.6717 10.561C14.666 10.4914 14.666 10.4124 14.666 10.3462C14.666 10.3418 14.666 10.3376 14.666 10.3333V9C14.666 8.99578 14.666 8.99149 14.666 8.98714C14.666 8.92097 14.666 8.84194 14.6717 8.77232C14.6782 8.69164 14.6952 8.57609 14.7568 8.45501C14.8367 8.29821 14.9642 8.17073 15.121 8.09083C15.2421 8.02914 15.3577 8.01223 15.4383 8.00564C15.508 7.99995 15.587 7.99998 15.6532 8Z" fill="white"/>
      <path fill-rule="evenodd" clip-rule="evenodd" d="M11.6532 12C11.6575 12 11.6618 12 11.666 12H12.9993C13.0036 12 13.0079 12 13.0122 12C13.0784 12 13.1574 11.9999 13.227 12.0056C13.3077 12.0122 13.4233 12.0291 13.5443 12.0908C13.7011 12.1707 13.8286 12.2982 13.9085 12.455C13.9702 12.5761 13.9871 12.6916 13.9937 12.7723C13.9994 12.8419 13.9994 12.921 13.9993 12.9871C13.9993 12.9915 13.9993 12.9958 13.9993 13V14.3333C13.9993 14.3376 13.9993 14.3418 13.9993 14.3462C13.9994 14.4124 13.9994 14.4914 13.9937 14.561C13.9871 14.6417 13.9702 14.7572 13.9085 14.8783C13.8286 15.0351 13.7011 15.1626 13.5443 15.2425C13.4233 15.3042 13.3077 15.3211 13.227 15.3277C13.1574 15.3334 13.0784 15.3334 13.0122 15.3333C13.0079 15.3333 13.0036 15.3333 12.9993 15.3333H11.666C11.6618 15.3333 11.6575 15.3333 11.6532 15.3333C11.587 15.3334 11.508 15.3334 11.4383 15.3277C11.3577 15.3211 11.2421 15.3042 11.121 15.2425C10.9642 15.1626 10.8367 15.0351 10.7568 14.8783C10.6952 14.7572 10.6782 14.6417 10.6717 14.561C10.666 14.4914 10.666 14.4124 10.666 14.3462C10.666 14.3418 10.666 14.3376 10.666 14.3333V13C10.666 12.9958 10.666 12.9915 10.666 12.9871C10.666 12.921 10.666 12.8419 10.6717 12.7723C10.6782 12.6916 10.6952 12.5761 10.7568 12.455C10.8367 12.2982 10.9642 12.1707 11.121 12.0908C11.2421 12.0291 11.3577 12.0122 11.4383 12.0056C11.508 11.9999 11.587 12 11.6532 12Z" fill="white"/>
      <path fill-rule="evenodd" clip-rule="evenodd" d="M10.3211 6.66675C10.3255 6.66675 10.3298 6.66675 10.334 6.66675H11.6673C11.6715 6.66675 11.6758 6.66675 11.6802 6.66675C11.7463 6.66672 11.8254 6.66669 11.895 6.67239C11.9757 6.67897 12.0912 6.69589 12.2123 6.75758C12.3691 6.83747 12.4966 6.96496 12.5765 7.12176C12.6382 7.24284 12.6551 7.35839 12.6617 7.43907C12.6674 7.50869 12.6673 7.58772 12.6673 7.65389C12.6673 7.65824 12.6673 7.66253 12.6673 7.66675V9.00008C12.6673 9.0043 12.6673 9.00859 12.6673 9.01293C12.6673 9.07911 12.6674 9.15814 12.6617 9.22776C12.6551 9.30844 12.6382 9.42399 12.5765 9.54507C12.4966 9.70187 12.3691 9.82935 12.2123 9.90925C12.0912 9.97094 11.9757 9.98785 11.895 9.99445C11.8254 10.0001 11.7463 10.0001 11.6802 10.0001C11.6758 10.0001 11.6715 10.0001 11.6673 10.0001H10.334C10.3298 10.0001 10.3255 10.0001 10.3211 10.0001C10.255 10.0001 10.1759 10.0001 10.1063 9.99445C10.0256 9.98785 9.91008 9.97094 9.789 9.90925C9.63219 9.82935 9.50471 9.70187 9.42482 9.54507C9.36312 9.42399 9.34621 9.30844 9.33962 9.22776C9.33393 9.15814 9.33396 9.07911 9.33399 9.01293C9.33399 9.00859 9.33399 9.0043 9.33399 9.00008V7.66675C9.33399 7.66253 9.33399 7.65824 9.33399 7.65389C9.33396 7.58772 9.33393 7.50869 9.33962 7.43907C9.34621 7.35839 9.36312 7.24284 9.42482 7.12176C9.50471 6.96496 9.63219 6.83747 9.789 6.75758C9.91008 6.69589 10.0256 6.67897 10.1063 6.67239C10.1759 6.66669 10.255 6.66672 10.3211 6.66675Z" fill="white"/>
      <path d="M23.3327 10.6667C23.3327 10.2985 23.0342 10 22.666 10H19.9993C19.6312 10 19.3327 10.2985 19.3327 10.6667V13C19.3327 13.1841 19.1834 13.3333 18.9993 13.3333H16.666C16.2978 13.3333 15.9993 13.6318 15.9993 14V16.3333C15.9993 16.5174 15.8501 16.6667 15.666 16.6667H13.3327C12.9645 16.6667 12.666 16.9651 12.666 17.3333V20C12.666 20.3682 12.9645 20.6667 13.3327 20.6667H22.666C23.0342 20.6667 23.3327 20.3682 23.3327 20V10.6667Z" fill="white"/>
      <defs>
        <linearGradient id="paint0_linear_289_22287" x1="4.44077" y1="7.75222" x2="27.3055" y2="30.459" gradientUnits="userSpaceOnUse">
          <stop offset="0.0978647" stop-color="#503FBB"/>
          <stop offset="1" stop-color="#01AEF1"/>
        </linearGradient>
      </defs>
    </svg>
  `,
  'zoom-in': /* html */`
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M13 13L9.66672 9.66667M10.7778 6.88889C10.7778 9.03667 9.03667 10.7778 6.88889 10.7778C4.74112 10.7778 3 9.03667 3 6.88889C3 4.74112 4.74112 3 6.88889 3C9.03667 3 10.7778 4.74112 10.7778 6.88889Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  `,
 };

export { __vite_glob_0_8 as default };
