import { convertToSafariFormat } from './dnr-converter-safari.js';

const DOCUMENT_PATH = "pages/dnr-converter/index.html";
async function convert(filters) {
  let result;
  try {
    if (true) {
      await setupOffscreenDocument();
      result = await chrome.runtime.sendMessage({
        action: "dnr-converter:convert",
        filters
      });
    }
  } catch (e) {
    return { errors: [e.message], rules: [] };
  } finally {
    closeOffscreenDocument();
  }
  for (const [index, rule] of result.rules.entries()) {
    if (rule.condition.regexFilter) {
      const { isSupported, reason } = await chrome.declarativeNetRequest.isRegexSupported({
        regex: rule.condition.regexFilter
      });
      if (!isSupported) {
        result.errors.push(
          `Could not apply a custom filter as "${rule.condition.regexFilter}" is a not supported regexp due to: ${reason}`
        );
        result.rules.splice(index, 1);
      }
    }
  }
  return result;
}
let offscreenTimeout = null;
function closeOffscreenDocument() {
  if (offscreenTimeout) {
    clearTimeout(offscreenTimeout);
  }
  offscreenTimeout = setTimeout(() => {
    chrome.offscreen.closeDocument();
    offscreenTimeout = null;
  }, 1e3);
}
async function setupOffscreenDocument() {
  if (offscreenTimeout) clearTimeout(offscreenTimeout);
  const offscreenUrl = chrome.runtime.getURL(DOCUMENT_PATH);
  const existingContexts = await chrome.runtime.getContexts({
    contextTypes: ["OFFSCREEN_DOCUMENT"],
    documentUrls: [offscreenUrl]
  });
  if (!existingContexts.length) {
    await chrome.offscreen.createDocument({
      url: DOCUMENT_PATH,
      reasons: [chrome.offscreen.Reason.IFRAME_SCRIPTING],
      justification: "Convert network filters to DeclarativeNetRequest format."
    });
  }
}

export { convert as default };
