import { isOpera, isEdge } from './browser-info.js';
import { debugMode } from './debug.js';

const GHOSTERY_DOMAIN = debugMode ? "ghosterystage.com" : "ghostery.com";
const HOME_PAGE_URL = `https://www.${GHOSTERY_DOMAIN}/`;
const SIGNON_PAGE_URL = `https://www.${GHOSTERY_DOMAIN}/signin`;
const CREATE_ACCOUNT_PAGE_URL = `https://www.${GHOSTERY_DOMAIN}/register`;
const ACCOUNT_PAGE_URL = `https://www.${GHOSTERY_DOMAIN}/account`;
const WTM_PAGE_URL = `https://www.${GHOSTERY_DOMAIN}/whotracksme`;
const SUPPORT_PAGE_URL = `https://www.${GHOSTERY_DOMAIN}/support`;
const WHATS_NEW_PAGE_URL = `https://www.${GHOSTERY_DOMAIN}/blog/ghostery-extension-v10-5?embed=1&utm_campaign=whatsnew`;
const REVIEW_PAGE_URL = (() => {
  if (isOpera()) return "https://mygho.st/ReviewOperaPanel";
  if (isEdge()) return "https://mygho.st/ReviewEdgePanel";
  return "https://mygho.st/ReviewChromePanel";
})();
const BECOME_A_CONTRIBUTOR_PAGE_URL = "https://www.ghostery.com/become-a-contributor";
const ENGINE_CONFIGS_ROOT_URL = `https://${debugMode ? "staging-" : ""}cdn.ghostery.com/adblocker/configs`;

export { ACCOUNT_PAGE_URL, BECOME_A_CONTRIBUTOR_PAGE_URL, CREATE_ACCOUNT_PAGE_URL, ENGINE_CONFIGS_ROOT_URL, GHOSTERY_DOMAIN, HOME_PAGE_URL, REVIEW_PAGE_URL, SIGNON_PAGE_URL, SUPPORT_PAGE_URL, WHATS_NEW_PAGE_URL, WTM_PAGE_URL };
